local CCOS = require("camera.camera_oneshot")
local LD = require("design.LevelDesignLibrary")
local thisInteractObject, cam_SonLookAt, fActiveCameraTime, thisObj, thisLevel, lookAtStartEvents, Event_LookAtEnded
IsParent = true
function OnScriptLoaded(level, obj)
  thisInteractObject = obj:FindSingleGOByName("pGenericSonInteract")
  thisLevel = level
  thisObj = obj
  if thisObj:FindLuaTableAttribute("Event_LookAtStart") ~= "" or thisObj:FindLuaTableAttribute("Event_LookAtStart") ~= nil then
    lookAtStartEvents = LD.ExtractCallbacksForEvent(level, thisObj, thisObj:FindLuaTableAttribute("Event_LookAtStart"))
  end
  if thisObj:FindLuaTableAttribute("Event_LookAtEnded") ~= "" or thisObj:FindLuaTableAttribute("Event_LookAtEnded") ~= nil then
    Event_LookAtEnded = LD.ExtractCallbacksForEvent(level, thisObj, thisObj:FindLuaTableAttribute("Event_LookAtEnded"))
  end
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  thisInteractObject.LuaObjectScript.SetUpdateDisableDistance(50)
end
function OnUpdate(level, obj)
  if cam_SonLookAt ~= nil then
    cam_SonLookAt:Update()
  end
end
function SetLookAtStart()
  print("LookatInteractStarted")
  if lookAtStartEvents ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, lookAtStartEvents, "Look At Started")
  end
end
function SetLookAtEnd()
  if Event_LookAtEnded ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, Event_LookAtEnded, "Look At Ended")
  end
end
function Enable()
  thisInteractObject.LuaObjectScript.Enable()
end
function Disable()
  thisInteractObject.LuaObjectScript.Disable()
end
function GetInteractZone()
  return thisInteractObject.LuaObjectScript.GetInteractZone()
end
function StartOneShotCamera()
  game.SubObject.Wake(thisObj)
  cam_SonLookAt = CCOS.OneShotCamera.New("PLYR_Interact_Son_RuneBowl", fActiveCameraTime)
  cam_SonLookAt:SetCallback(DisableOneShotCamera)
  cam_SonLookAt:Start()
end
function DisableOneShotCamera()
  if cam_SonLookAt ~= nil then
    cam_SonLookAt = nil
  end
  if thisObj ~= nil then
    game.SubObject.Sleep(thisObj)
  end
end
