local LD = require("design.LevelDesignLibrary")
local embedCallbacks = {}
local thisObj, embedCollision, reflectCollision
function OnScriptLoaded(level, obj)
  thisObj = obj
  SoundInit()
  embedCollision = thisObj:FindSingleGOByName("EmbedCollision")
  reflectCollision = thisObj:FindSingleGOByName("ReflectCollision")
  reflectCollision.LuaObjectScript.RegisterOnHitByWeapon(OnHitByWeapon)
  game.SubObject.Sleep(obj)
end
function RegisterEmbedCallback(fn)
  embedCollision.LuaObjectScript.RegisterOnWeaponEmbed(fn)
end
local convertDistanceToFX = function(dist)
  if dist < 4 then
    return {
      EffectName = "FSE_SHAKE_GENERIC_SMALL",
      Duration = 0.75
    }, {EffectName = "FFB_SMALL", Duration = 0.1}
  elseif dist < 15 then
    return {
      EffectName = "FSE_SHAKE_GENERIC_VERYSMALL",
      Duration = 0.75
    }, {
      EffectName = "FFB_SMALLER",
      Duration = 0.1
    }
  else
    return nil, {
      EffectName = "FFB_SMALLER",
      Duration = 0.75
    }
  end
end
function OnHitByWeapon(level, go, weapon, attacker)
  if weapon:GetName() ~= "axe00" then
    return
  end
  local camShake, conRumble = convertDistanceToFX(LD.GetDistanceBetweenTwoObjects(game.Player.FindPlayer(), thisObj))
  if camShake then
    game.FX.SubmitEffect(camShake)
  end
  if conRumble then
    game.FX.SubmitEffect(conRumble)
  end
end
local soundEvents = {
  SoundEmitter = nil,
  OnSpinForward = "SND_MECH_Spike_Ceiling_Spindle_Raise_Creak_LP",
  OnSpinBackward = "SND_MECH_Spike_Ceiling_Spindle_Lower_Creak_LP",
  OnReachStart = "",
  OnReachEnd = "",
  OnEmbed = "SND_MECH_Spike_Ceiling_Spindle_Hit_Success"
}
function SoundSetup(events)
  if events ~= nil then
    for key, value in pairs(soundEvents) do
      for newKey, _ in pairs(events) do
        if newKey == key and events[newKey] ~= nil and events[newKey] ~= "" then
          soundEvents[key] = events[newKey]
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(value))
    end
  end
end
local lastFrameAngVel = 0
local currentFrameAngVel = 0
local angularVelocity = 0
local angVelJointIndex
function SoundInit()
  lastFrameAngVel = engine.Vector.New(-0.707, 0, -0.707)
  currentFrameAngVel = lastFrameAngVel
  angVelJointIndex = thisObj:FindJointIndex("JOSpinnable") or 1
  soundEvents.SoundEmitter = thisObj:FindSingleSoundEmitterByName("SNDSpinnable")
end
function PlaySpinningForwardSound()
  if soundEvents.OnSpinForward and soundEvents.OnSpinForward ~= "" then
    LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnSpinForward, true)
  end
end
function StopSpinningForwardSound()
  LD.StopSound(soundEvents.SoundEmitter, soundEvents.OnSpinForward)
end
function PlaySpinningBackwardSound()
  if soundEvents.OnSpinBackward and soundEvents.OnSpinBackward ~= "" then
    LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnSpinBackward, true)
  end
end
function StopSpinningBackwardSound()
  LD.StopSound(soundEvents.SoundEmitter, soundEvents.OnSpinBackward)
end
function PlayOnEmbedSound()
  if soundEvents.OnEmbed and soundEvents.OnEmbed ~= "" then
    LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnEmbed)
  end
end
function PlayOnReachStartSound()
  if soundEvents.OnReachStart and soundEvents.OnReachStart ~= "" then
    LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnReachStart)
  end
end
function PlayOnReachEndSound()
  if soundEvents.OnReachEnd and soundEvents.OnReachEnd ~= "" then
    LD.PlaySound(soundEvents.SoundEmitter, soundEvents.OnReachEnd)
  end
  LD.StopSound(soundEvents.SoundEmitter, soundEvents.OnEmbed, true)
end
function GetSpinnableAngularVelocity()
  currentFrameAngVel = thisObj:GetWorldJointForward(angVelJointIndex)
  angularVelocity = math.floor((lastFrameAngVel - currentFrameAngVel):Length() * 10000) / 100
  lastFrameAngVel = currentFrameAngVel
  return angularVelocity
end
