local LD = require("design.LevelDesignLibrary")
local thisObj, gearObject, backGear, extraGears
function OnScriptLoaded(level, obj)
  thisObj = obj
  gearObject = thisObj:FindSingleGOByName("Front_Gear")
  backGear = thisObj:FindSingleGOByName("Back_Gear")
  extraGears = thisObj:FindSingleGOByName("ExtraGears")
  gearObject.LuaObjectScript.BuildInterface(thisObj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  SoundInit()
end
function OnStart(level, obj)
  if backGear then
    backGear.LuaObjectScript.RegisterEmbedCallback(thisObj.LuaObjectScript.FireEmbedCallbacks)
    backGear.LuaObjectScript.RegisterUnembedCallback(thisObj.LuaObjectScript.FireUnembedCallbacks)
  end
end
function FindBackGear()
  return backGear
end
function FindExtraGears()
  return extraGears
end
function IsAnyGearPinned()
  if gearObject and gearObject.Child:IsAxeEmbedded() then
    return true
  end
  if backGear and backGear.Child:IsAxeEmbedded() then
    return true
  end
  return false
end
local soundEmitter
local soundEvents = {
  OnWeaponEmbed = "",
  OnWeaponUnembed = "",
  OnCWRotate = "",
  OnCCWRotate = ""
}
local lastFrameAngVel = 0
local currentFrameAngVel = 0
local angularVelocity = 0
local angVelJointIndex
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDSpinnableGears")
  soundEvents.OnWeaponEmbed = thisObj:FindLuaTableAttribute("soundOnWeaponEmbed")
  soundEvents.OnWeaponUnembed = thisObj:FindLuaTableAttribute("soundOnWeaponUnembed")
  soundEvents.OnCWRotate = thisObj:FindLuaTableAttribute("soundOnCWRotate")
  soundEvents.OnCCWRotate = thisObj:FindLuaTableAttribute("soundOnCCWRotate")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    for k in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == k and newValue ~= nil and newValue ~= "" then
          soundEvents[k] = newValue
          LD.SoundDebug(tostring(k) .. ": " .. tostring(soundEvents[k]) .. " | " .. tostring(newKey) .. ": " .. tostring(newValue))
        end
      end
    end
  end
end
function PlayOnCWRotateSound()
  LD.PlaySound(soundEmitter, soundEvents.OnCWRotate)
end
function StopOnCWRotateSound()
  LD.StopSound(soundEmitter, soundEvents.OnCWRotate)
end
function PlayOnCCWRotateSound()
  LD.PlaySound(soundEmitter, soundEvents.OnCCWRotate)
end
function StopOnCCWRotateSound()
  LD.StopSound(soundEmitter, soundEvents.OnCCWRotate)
end
function PlayOnWeaponEmbedSound()
  LD.PlaySound(soundEmitter, soundEvents.OnWeaponEmbed)
end
function PlayOnWeaponUnembedSound()
  LD.PlaySound(soundEmitter, soundEvents.OnWeaponUnembed)
end
function GetGearAngularVelocity()
  return angularVelocity
end
