local thisObj, thisLevel, vehicleToSpawn, spawnInitially, spawnedVehicle, spawnBranch, visualConfig
local awarenessTable = {lookAt = nil, pointEvent = nil}
local discoveredDock = false
function OnScriptLoaded(level, obj)
  thisObj, thisLevel = obj, level
  vehicleToSpawn = "CRT_" .. obj:GetLuaTableAttribute("vehicle")
  spawnInitially = obj:GetLuaTableAttribute("spawnInitially")
  spawnBranch = obj:GetLuaTableAttribute("spawnBranch")
  visualConfig = obj:FindLuaTableAttribute("visualConfig") or "Default"
  if spawnInitially then
    SpawnVehicle()
  end
  obj:HideJoint(obj:GetJointIndex("boatMesh"))
  awarenessTable.lookAt = thisObj:FindSingleGOByName("_LookAtEmitter")
  awarenessTable.pointEvent = thisObj:FindSingleGOByName("_PointEvent")
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {discoveredDock = discoveredDock}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  discoveredDock = savedInfo.discoveredDock
end
function SpawnVehicle(spawnWad, pos, dir)
  spawnWad = spawnWad or thisLevel
  pos = pos or thisObj:GetWorldPosition()
  dir = dir or thisObj:GetWorldForward()
  if spawnedVehicle == nil then
    if game.AI.PoolCount(spawnWad, vehicleToSpawn) <= 0 then
      engine.Error("Pool capacity exceeded for " .. vehicleToSpawn .. ". A new " .. vehicleToSpawn .. " will not be spawned. Try increasing the memory allocation in your .dcs file")
    end
    spawnedVehicle = game.AI.Spawn(spawnWad, pos, dir, vehicleToSpawn, spawnBranch)
  end
  SetVehicleConfiguration(visualConfig)
  return spawnedVehicle
end
local Spawning = false
local SpawnVehicleCallback
function SpawnVehicleHandler(level, obj, vehicle)
  spawnedVehicle = vehicle
  SetVehicleConfiguration(visualConfig)
  Spawning = false
  if SpawnVehicleCallback then
    local callback = SpawnVehicleCallback
    SpawnVehicleCallback = nil
    callback(vehicle)
  end
end
function SpawnVehicleAsync(argT)
  local willSpawn
  if spawnedVehicle == nil and Spawning == false then
    local spawnWad = argT.spawnWad or thisLevel
    if game.AI.PoolCount(spawnWad, vehicleToSpawn) <= 0 then
      engine.Error("Pool capacity exceeded for " .. vehicleToSpawn .. ". A new " .. vehicleToSpawn .. " will not be spawned. Try increasing the memory allocation in your .dcs file")
    end
    local pos = argT.pos or thisObj:GetWorldPosition()
    local dir = argT.dir or thisObj:GetWorldForward()
    local callback = argT.callback
    Spawning = true
    SpawnVehicleCallback = callback
    if false then
      willSpawn = game.AI.AsyncSpawn(spawnWad, "SpawnVehicleHandler", pos, dir, vehicleToSpawn, {branchName = spawnBranch, callbackTarget = thisObj})
    else
      willSpawn = true
      local vehicle = game.AI.Spawn(spawnWad, pos, dir, vehicleToSpawn, spawnBranch)
      engine.SendHook("SpawnVehicleHandler", thisLevel, vehicle)
    end
  end
  return willSpawn
end
function DestroyVehicle()
  if spawnedVehicle ~= nil then
    spawnedVehicle:Destroy()
    spawnedVehicle = nil
  end
end
function SetVehicleConfiguration(visualConfig)
  if spawnedVehicle ~= nil and visualConfig ~= nil and visualConfig ~= "" then
    local deferVisibility = false
    if spawnBranch == "BRA_BoatBeachIdle" then
      deferVisibility = true
    end
    spawnedVehicle:FindSingleGOByName("puppeteerHelper"):CallScript("SetVehicleConfiguration", spawnedVehicle, visualConfig, deferVisibility)
  end
end
function GetSpawnedVehicle()
  return spawnedVehicle
end
function GetVisualConfig()
  return visualConfig
end
function SetVehicleReference(obj)
  spawnedVehicle = obj
end
function ClearVehicleReference()
  spawnedVehicle = nil
end
function DisableAllSonAwareness()
  awarenessTable.lookAt.LuaObjectScript.DisableEventEmitter()
end
function EnableEventEmitter()
  if not discoveredDock then
    awarenessTable.lookAt.LuaObjectScript.EnableEventEmitter()
  else
    DisableAllSonAwareness()
  end
end
function HasDiscoveredDock()
  discoveredDock = true
  DisableAllSonAwareness()
end
function OnAwarenessZoneEnter()
  if not discoveredDock then
    local keepBanterOnCooldown = math.random(0, 10) <= 3
    if keepBanterOnCooldown then
      game.Audio.SetBanterFact("boatDockCooldown", keepBanterOnCooldown, 35)
    end
    local btrName = "ca_dock_notice"
    if spawnBranch == "BRA_BoatBeachIdle" then
      btrName = "ca_beach_notice"
    end
    game.Audio.PlayBanterNonCritical(btrName, nil, nil, false, function()
      thisObj:FindSingleGOByName("_PointEvent").LuaObjectScript.Trigger()
      awarenessTable.lookAt.LuaObjectScript.DisableEventEmitter()
      discoveredDock = true
    end)
  end
end
