local morningObjects, foggyObjects, sunnyObjects, stormyObjects, snowyObjects, dragonObjects, LightingMonitor, LightingCineMonitor
function OnScriptLoaded(level, obj)
  local ErrorChecks = function()
    if _G.SkyFxManager == nil then
      _G.SkyFxManager = obj
    else
      local LD = require("design.LevelDesignLibrary")
      error("\t\t\t\t\tAttempting to add multiple SkyFXManagers to level: " .. level.Name .. "\t\t\t\t\tRegistered SkyFxManager: " .. LD.GetParentTrace(_G.SkyFxManager) .. "\t\t\t\t\tAttempting to Register: " .. LD.GetParentTrace(obj) .. [[
					Only one SkyFxManager may be included per wad.
				]])
    end
  end
  ErrorChecks()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  if level.GetSkyFxManagerObjects then
    morningObjects = level:GetSkyFxManagerObjects("FXMorning")
    foggyObjects = level:GetSkyFxManagerObjects("FXFog")
    sunnyObjects = level:GetSkyFxManagerObjects("FXSunny")
    stormyObjects = level:GetSkyFxManagerObjects("FXStorm")
    snowyObjects = level:GetSkyFxManagerObjects("FXSnow")
    dragonObjects = level:GetSkyFxManagerObjects("FXDragon")
  else
    morningObjects = level:FindGameObjects("CalMorning*")
    for _, v in ipairs(level:FindGameObjects("FXMorning*")) do
      morningObjects[#morningObjects + 1] = v
    end
    foggyObjects = level:FindGameObjects("CalFog*")
    for _, v in ipairs(level:FindGameObjects("FXFog*")) do
      foggyObjects[#foggyObjects + 1] = v
    end
    sunnyObjects = level:FindGameObjects("CalSun*")
    for _, v in ipairs(level:FindGameObjects("FXSunny*")) do
      sunnyObjects[#sunnyObjects + 1] = v
    end
    stormyObjects = level:FindGameObjects("CalStorm*")
    for _, v in ipairs(level:FindGameObjects("FXStorm*")) do
      stormyObjects[#stormyObjects + 1] = v
    end
    snowyObjects = level:FindGameObjects("CalSnow*")
    for _, v in ipairs(level:FindGameObjects("FXSnow*")) do
      snowyObjects[#snowyObjects + 1] = v
    end
    dragonObjects = level:FindGameObjects("CalDragonSky*")
    for _, v in ipairs(level:FindGameObjects("FXDragon*")) do
      dragonObjects[#dragonObjects + 1] = v
    end
  end
  if not foggyObjects[1] then
    FoggySky = SunnySky
  end
  if not morningObjects[1] then
    MorningSky = FoggySky
  end
  if not dragonObjects[1] then
    DragonSky = SunnySky
  end
end
function OnPreStart(level, obj)
  local monitors = require("level.MonitorLibrary")
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 610 <= cineNumber then
    SnowySky()
  elseif 492 <= cineNumber then
    SunnySky()
  elseif 470 <= cineNumber then
    DragonSky()
  elseif 450 <= cineNumber then
    StormySky()
  elseif 390 <= cineNumber then
    SunnySky()
  elseif 365 <= cineNumber then
    StormySky()
  elseif 263 <= cineNumber then
    SunnySky()
  elseif 111 <= cineNumber then
    FoggySky()
  else
    MorningSky()
  end
  if cineNumber < 610 then
    LightingCineMonitor = monitors.CreateEntityVariableMonitor("CompletedCineNumber")
    LightingCineMonitor:OnValue(610, function()
      SnowySky()
      LightingCineMonitor:Stop()
      LightingCineMonitor:Terminate()
      LightingCineMonitor = nil
    end)
    if cineNumber < 492 then
      LightingCineMonitor:OnValue(492, SunnySky)
    end
    if cineNumber < 470 then
      LightingCineMonitor:OnValue(470, DragonSky)
    end
    if cineNumber < 450 then
      LightingCineMonitor:OnValue(450, StormySky)
    end
    if cineNumber < 390 then
      LightingCineMonitor:OnValue(390, SunnySky)
    end
    if cineNumber < 364 then
      LightingCineMonitor:OnValue(364, StormySky)
    end
    if cineNumber < 263 then
      LightingCineMonitor:OnValue(263, SunnySky)
    end
    if cineNumber < 111 then
      LightingCineMonitor:OnValue(111, FoggySky)
    end
  end
  LightingMonitor = monitors.CreateEntityVariableMonitor("CAL_LightingState")
  LightingMonitor:OnValue(0, MorningSky)
  LightingMonitor:OnValue(1, FoggySky)
  LightingMonitor:OnValue(2, SunnySky)
  LightingMonitor:OnValue(3, StormySky)
  LightingMonitor:OnValue(4, DragonSky)
  LightingMonitor:OnValue(5, SnowySky)
end
local Map = function(t, fn)
  for _, v in ipairs(t) do
    fn(v)
  end
end
local ObjHide = function(obj)
  obj:Hide()
  if not obj.Children then
    return
  end
  for _, d in pairs(obj.Children) do
    d:Hide()
  end
end
local ObjShow = function(obj)
  obj:Show()
  if not obj.Children then
    return
  end
  for _, d in pairs(obj.Children) do
    d:Show()
  end
end
function MorningSky()
  Map(foggyObjects, ObjHide)
  Map(sunnyObjects, ObjHide)
  Map(stormyObjects, ObjHide)
  Map(snowyObjects, ObjHide)
  Map(dragonObjects, ObjHide)
  Map(morningObjects, ObjShow)
end
function FoggySky()
  Map(morningObjects, ObjHide)
  Map(sunnyObjects, ObjHide)
  Map(stormyObjects, ObjHide)
  Map(snowyObjects, ObjHide)
  Map(dragonObjects, ObjHide)
  Map(foggyObjects, ObjShow)
end
function SunnySky()
  Map(morningObjects, ObjHide)
  Map(foggyObjects, ObjHide)
  Map(stormyObjects, ObjHide)
  Map(snowyObjects, ObjHide)
  Map(dragonObjects, ObjHide)
  Map(sunnyObjects, ObjShow)
end
function StormySky()
  Map(morningObjects, ObjHide)
  Map(foggyObjects, ObjHide)
  Map(sunnyObjects, ObjHide)
  Map(snowyObjects, ObjHide)
  Map(dragonObjects, ObjHide)
  Map(stormyObjects, ObjShow)
end
function SnowySky()
  Map(morningObjects, ObjHide)
  Map(foggyObjects, ObjHide)
  Map(sunnyObjects, ObjHide)
  Map(stormyObjects, ObjHide)
  Map(dragonObjects, ObjHide)
  Map(snowyObjects, ObjShow)
end
function DragonSky()
  Map(morningObjects, ObjHide)
  Map(foggyObjects, ObjHide)
  Map(sunnyObjects, ObjHide)
  Map(stormyObjects, ObjHide)
  Map(snowyObjects, ObjHide)
  Map(dragonObjects, ObjShow)
end
