local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisObj
local calmIdle = "navIdle"
local awareEnter = "navAwareEnter"
local awareLoop = "navAwareLoop"
local awareExit = "navAwareExit"
local behavior
function OnScriptLoaded(level, obj)
  thisObj = obj
  behavior = obj:GetLuaTableAttribute("AwarenessBehavior")
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  SoundInit()
end
function OnStart(level, obj)
  if behavior == "Random" then
    StartRandomSequence()
  else
    EagleCalm_Idle()
  end
end
function EagleCalm_Idle()
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(calmIdle)
  thisObj:PlayAnimCycle()
  soundCalmIdle()
end
function EagleAware_Start(level, obj)
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareEnter, 0.5)
  thisObj:OnAnimDone(thisObj, "EagleAware_Loop")
  soundAwareEnter()
end
function EagleAware_Loop()
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareLoop)
  thisObj:OnAnimDone(thisObj, "EagleAware_Loop")
  soundAwareLoop()
end
function EagleAware_LoopEnd()
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareLoop)
  thisObj:JumpAnimToPercent(0.5)
  thisObj:PlayAnimToEnd()
  thisObj:OnAnimDone(thisObj, "EagleAware_Exit")
  soundAwareLoop()
end
function EagleAware_Exit(level)
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareExit)
  thisObj:OnAnimDone(thisObj, "EagleCalm_Idle")
  soundAwareExit()
end
local rand_IdleDuration = {30, 60}
local rand_AwareDuration = {15, 20}
local returnToIdle = false
function StartRandomSequence()
  local randomIdle = math.random(rand_IdleDuration[1], rand_IdleDuration[2])
  LD.CallFunctionAfterDelay(EagleAware_RandomStart, randomIdle)
end
function EagleAware_RandomStart(level, obj)
  local tweenTime = 0.5
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareEnter, tweenTime)
  soundAwareEnter()
  LD.CallFunctionAfterDelay(function()
    thisObj:OnAnimDone(thisObj, "EagleAware_RandomLoop")
  end, 1)
  local randomAware = math.random(rand_AwareDuration[1], rand_AwareDuration[2])
  LD.CallFunctionAfterDelay(ReturnToIdle, randomAware)
end
function ReturnToIdle()
  returnToIdle = true
end
function EagleAware_RandomLoop(level, obj)
  if returnToIdle then
    EagleAware_RandomExit()
    returnToIdle = false
  else
    thisObj:ClearAllAnimCallbacks()
    thisObj:StartAnim(awareLoop)
    thisObj:JumpAnimToFrame(0)
    thisObj:OnAnimDone(thisObj, "EagleAware_RandomLoop")
    soundAwareLoop()
  end
end
function EagleAware_RandomExit(level, obj)
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareExit)
  thisObj:OnAnimDone(thisObj, "EagleCalm_Idle")
  soundAwareExit()
end
function CycleIdleLoop()
  behavior = "Custom"
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(calmIdle)
  thisObj:PlayAnimCycle()
  soundCalmIdle()
end
function CycleAwareLoop()
  behavior = "Custom"
  thisObj:ClearAllAnimCallbacks()
  thisObj:StartAnim(awareLoop)
  thisObj:PlayAnimCycle()
  soundAwareLoop()
end
local soundEmitter
local soundEvents = {
  isLooping = false,
  OnCalmIdle = "SND_CHR_Helheim_Eagle_Idle",
  OnAwareEnter = "SND_CHR_Helheim_Eagle_AwareEnter",
  OnAwareLoop = "SND_CHR_Helheim_Eagle_AwareLoop",
  OnAwareExit = "SND_CHR_Helheim_Eagle_AwareExit"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDHelEagle")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
    end
  end
end
function soundCalmIdle()
  if game.Level.GetVariable("CompletedCineNumber") < 498 then
    LD.PlaySound(soundEmitter, soundEvents.OnCalmIdle)
  end
end
function soundAwareEnter()
  if game.Level.GetVariable("CompletedCineNumber") < 498 then
    LD.PlaySound(soundEmitter, soundEvents.OnAwareEnter)
  end
end
function soundAwareLoop()
  if game.Level.GetVariable("CompletedCineNumber") < 498 then
    LD.PlaySound(soundEmitter, soundEvents.OnAwareLoop)
  end
end
function soundAwareExit()
  if game.Level.GetVariable("CompletedCineNumber") < 498 then
    LD.PlaySound(soundEmitter, soundEvents.OnAwareExit)
  end
end
function OnSaveCheckpoint(level, obj)
  return {behavior = behavior}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  behavior = savedInfo.behavior
end
