local LD = require("design.LevelDesignLibrary")
local isHelheimRevisitExploreMusicActive = false
function OnScriptLoaded(level)
  game.Audio.StartMusicMaster("SND_MX_HEL_start_master")
end
function OnStart(level)
  if isHelheimRevisitExploreMusicActive and game.Level.GetVariable("CompletedCineNumber") >= 390 then
    game.Audio.StartCheckpointedMusic("SND_MX_HEL_revisit_explore_in")
  end
end
function caveExitMusic()
  game.Audio.StartMusic("SND_MX_HEL_drain_puzzle_out")
end
function revisitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 390 and not game.FindLevel("Hel350_ChiselArena") then
    game.Audio.StartMusic("SND_MX_HEL_revisit_explore_in")
  end
end
function musicRevisitOut(level)
  game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
  isHelheimRevisitExploreMusicActive = false
end
function musicRevisitIn()
  if game.Level.GetVariable("CompletedCineNumber") >= 390 then
    game.Audio.StartCheckpointedMusic("SND_MX_HEL_revisit_explore_in")
    isHelheimRevisitExploreMusicActive = true
  end
end
function OnSaveCheckpoint(level)
  return {isHelheimRevisitExploreMusicActive = isHelheimRevisitExploreMusicActive}
end
function OnRestoreCheckpoint(level, savedInfo)
  isHelheimRevisitExploreMusicActive = savedInfo.isHelheimRevisitExploreMusicActive
end
