local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EagleWindOFF = true
local eagleSoundFading, windStarting
local helheimDead_AnimSections = {
  "CAL_anim_Section1_Slow_Delay1",
  "CAL_anim_Section1_Slow_Delay2",
  "CAL_anim_Section1_Slow_Delay3",
  "CAL_anim_Section1_Slow_Delay4",
  "CAL_anim_Section1_Slow_Delay5",
  "CAL_anim_Section1_Slow_Delay6",
  "CAL_anim_Section1_Slow_Delay7",
  "CAL_anim_Section1_Slow_Delay8",
  "CAL_anim_Section1_Slow_Delay9",
  "CAL_anim_Section1_Slow_Delay10",
  "CAL_anim_Section1_Slow_Delay11",
  "CAL_anim_Section1_Slow_Delay12",
  "CAL_anim_Section1_Slow_Delay13",
  "CAL_anim_Section1_Slow"
}
local helheimDead_SectionAnimMonitors = {}
function OnScriptLoaded(level)
  GameObjects.TempFX:Hide()
  EagleWindOFF = engine.VFSBool.New("EagleWindOFF")
  GameObjects.TempFX:HideTriggerVolume()
  GameObjects.TempFX:HideParticleEmitter()
  GameObjects.TempFX:HideParticles()
  GameObjects.TempFX:PlayAnimToFrame(0, -1)
end
function OnFirstStart(level)
  HideCalderaGhosts()
  GameObjects.anim_Section3_Slow1:Hide()
end
function OnStart(level)
  Setup_OnAnimDone_HideGhostSection(level)
end
function OnUpdate(level)
  if eagleSoundFading == true then
    UpdateEagleWindRTPC()
  end
end
function Hide600Ghosts()
  GameObjects.anim_Section4_Slow:Hide()
  GameObjects.anim_Section4_SlowDelay:Hide()
  GameObjects.anim_Section4_SlowDelay1:Hide()
  GameObjects.anim_Section4_SlowDelay2:Hide()
  GameObjects.anim_Section4_SlowDelay3:Hide()
  GameObjects.anim_Section4_SlowDelay4:Hide()
  GameObjects.anim_Section4_SlowDelay5:Hide()
  GameObjects.anim_Section4_SlowDelay6:Hide()
  GameObjects.anim_Section4_Fast:Hide()
end
function Hide300Ghosts()
  GameObjects.anim_Section1_Slow:Hide()
  GameObjects.anim_Section1_SlowDelay1:Hide()
  GameObjects.anim_Section1_SlowDelay2:Hide()
  GameObjects.anim_Section2_Slow:Hide()
  GameObjects.anim_Section3_Slow:Hide()
  GameObjects.anim_Section1_Fast:Hide()
  GameObjects.anim_Section2_Fast:Hide()
  GameObjects.anim_Section3_Fast:Hide()
end
function HideCalderaGhosts()
  GameObjects.CAL_anim_Section1_Slow_Delay1:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay2:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay3:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay4:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay5:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay6:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay7:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay8:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay9:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay10:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay11:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay12:Hide()
  GameObjects.CAL_anim_Section1_Slow_Delay13:Hide()
  GameObjects.CAL_anim_Section1_FAST:Hide()
end
function Show300Ghosts()
end
function Show600Ghosts()
  GameObjects.anim_Section1_Slow:PlayAnimCycle()
  GameObjects.anim_Section1_SlowDelay:Show()
  GameObjects.anim_Section1_SlowDelay:JumpAnimToFrame(100)
  GameObjects.anim_Section1_SlowDelay:PlayAnimCycle()
  print("Play delayed ghosts ")
  GameObjects.anim_Section1_SlowDelay1:Show()
  GameObjects.anim_Section1_SlowDelay1:JumpAnimToFrame(200)
  GameObjects.anim_Section1_SlowDelay1:PlayAnimCycle()
  print("Play delayed ghosts 1")
  GameObjects.anim_Section1_SlowDelay2:Show()
  GameObjects.anim_Section1_SlowDelay2:JumpAnimToFrame(400)
  GameObjects.anim_Section1_SlowDelay2:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.anim_Section2_Slow:Show()
  GameObjects.anim_Section2_Slow:PlayAnimCycle()
  GameObjects.anim_Section3_Slow:Show()
  GameObjects.anim_Section3_Slow:PlayAnimCycle()
  GameObjects.anim_Section4_Slow:Show()
  GameObjects.anim_Section4_Slow:PlayAnimCycle()
  GameObjects.anim_Section4_SlowDelay:Show()
  GameObjects.anim_Section4_SlowDelay:JumpAnimToFrame(500)
  GameObjects.anim_Section4_SlowDelay:PlayAnimCycle()
  print("Play delayed ghosts section 4")
  GameObjects.anim_Section4_SlowDelay1:Show()
  GameObjects.anim_Section4_SlowDelay1:JumpAnimToFrame(1000)
  GameObjects.anim_Section4_SlowDelay1:PlayAnimCycle()
  print("Play delayed ghosts section 4 1")
  GameObjects.anim_Section4_SlowDelay2:Show()
  GameObjects.anim_Section4_SlowDelay2:JumpAnimToFrame(1500)
  GameObjects.anim_Section4_SlowDelay2:PlayAnimCycle()
  print("Play delayed ghosts section 4 2")
  GameObjects.anim_Section4_SlowDelay3:Show()
  GameObjects.anim_Section4_SlowDelay3:JumpAnimToFrame(2000)
  GameObjects.anim_Section4_SlowDelay3:PlayAnimCycle()
  print("Play delayed ghosts section 4 3")
  GameObjects.anim_Section4_SlowDelay4:Show()
  GameObjects.anim_Section4_SlowDelay4:JumpAnimToFrame(2500)
  GameObjects.anim_Section4_SlowDelay4:PlayAnimCycle()
  print("Play delayed ghosts section 4 4")
  GameObjects.anim_Section4_SlowDelay5:Show()
  GameObjects.anim_Section4_SlowDelay5:JumpAnimToFrame(3000)
  GameObjects.anim_Section4_SlowDelay5:PlayAnimCycle()
  print("Play delayed ghosts section 4 5")
  GameObjects.anim_Section4_SlowDelay6:Show()
  GameObjects.anim_Section4_SlowDelay6:JumpAnimToFrame(3500)
  GameObjects.anim_Section4_SlowDelay6:PlayAnimCycle()
  print("Play delayed ghosts section 4 6")
  GameObjects.anim_Section1_Fast:Show()
  GameObjects.anim_Section1_Fast:PlayAnimCycle()
  GameObjects.anim_Section2_Fast:Show()
  GameObjects.anim_Section2_Fast:PlayAnimCycle()
  GameObjects.anim_Section3_Fast:Show()
  GameObjects.anim_Section3_Fast:PlayAnimCycle()
  GameObjects.anim_Section4_Fast:Show()
  GameObjects.anim_Section4_Fast:PlayAnimCycle()
  LD.CallFunctionAfterDelay(function()
    GameObjects.anim_Section1_FastDelay:Show()
    GameObjects.anim_Section1_FastDelay:PlayAnimCycle()
    print("Play delayed fast ghosts ")
  end, 15)
end
function ShowCalderaGhosts()
  GameObjects.CAL_anim_Section1_Slow:PlayAnimCycle()
  GameObjects.CAL_anim_Section1_Slow_Delay1:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay1:JumpAnimToFrame(1000)
  GameObjects.CAL_anim_Section1_Slow_Delay1:PlayAnimCycle()
  print("Play delayed Caldera ghosts ")
  GameObjects.CAL_anim_Section1_Slow_Delay2:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay2:JumpAnimToFrame(1500)
  GameObjects.CAL_anim_Section1_Slow_Delay2:PlayAnimCycle()
  print("Play delayed ghosts 1")
  GameObjects.CAL_anim_Section1_Slow_Delay3:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay3:JumpAnimToFrame(1600)
  GameObjects.CAL_anim_Section1_Slow_Delay3:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay4:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay4:JumpAnimToFrame(2000)
  GameObjects.CAL_anim_Section1_Slow_Delay4:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay5:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay5:JumpAnimToFrame(3000)
  GameObjects.CAL_anim_Section1_Slow_Delay5:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay6:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay6:JumpAnimToFrame(4000)
  GameObjects.CAL_anim_Section1_Slow_Delay6:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay7:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay7:JumpAnimToFrame(5000)
  GameObjects.CAL_anim_Section1_Slow_Delay7:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay8:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay8:JumpAnimToFrame(6000)
  GameObjects.CAL_anim_Section1_Slow_Delay8:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay9:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay9:JumpAnimToFrame(7000)
  GameObjects.CAL_anim_Section1_Slow_Delay9:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay10:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay10:JumpAnimToFrame(8000)
  GameObjects.CAL_anim_Section1_Slow_Delay10:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay11:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay11:JumpAnimToFrame(8500)
  GameObjects.CAL_anim_Section1_Slow_Delay11:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay12:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay12:JumpAnimToFrame(9000)
  GameObjects.CAL_anim_Section1_Slow_Delay12:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_Slow_Delay13:Show()
  GameObjects.CAL_anim_Section1_Slow_Delay13:JumpAnimToFrame(9500)
  GameObjects.CAL_anim_Section1_Slow_Delay13:PlayAnimCycle()
  print("Play delayed ghosts 2")
  GameObjects.CAL_anim_Section1_FAST:Show()
  GameObjects.CAL_anim_Section1_FAST:PlayAnimCycle()
end
function ShowClimbGhosts()
  GameObjects.anim_Section3_Slow1:Show()
  GameObjects.anim_Section3_Slow1:PlayAnimToEnd()
end
function HideClimbGhosts()
  GameObjects.anim_Section3_Slow1:Hide()
end
function StormParticleOn()
  eagleSoundFading = true
  windStarting = true
  GameObjects.TempFX:ShowTriggerVolume()
  GameObjects.TempFX:ShowParticleEmitter()
  GameObjects.TempFX:ShowParticles()
  GameObjects.TempFX:PlayAnimToEnd()
  LD.PlaySound(GameObjects.SNDHelEagle:FindSingleSoundEmitterByName("SNDHelEagle"), "SND_AMB_EMIT_Helheim_EagleWind_LP")
end
function StormParticleOff()
  _G.StartLevelTimer(10, function()
    GameObjects.TempFX:HideTriggerVolume()
    GameObjects.TempFX:HideParticleEmitter()
    GameObjects.TempFX:HideParticles()
  end)
  GameObjects.TempFX:PlayAnimToFrame(0, -1)
  StopEagleWindSound()
  LD.StopSound(GameObjects.SNDHelEagle:FindSingleSoundEmitterByName("SNDHelEagle"), "SND_AMB_EMIT_Helheim_EagleWind_LP")
end
function EagleWind()
  if EagleWindOFF.value == false then
    local Hel010 = game.FindLevel("Hel010_Vista")
    local helEagle = Hel010:FindSingleGameObject("helheimEagle00")
    if helEagle then
      helEagle:CallScript("EagleAware_Start")
    end
    LD.CallFunctionAfterDelay(function()
      if helEagle then
        helEagle:CallScript("EagleAware_LoopEnd")
      end
    end, 10)
  end
end
function UpdateEagleWindRTPC()
  if windStarting == true then
    EagleWindFadeIn()
  elseif windStarting == false then
    EagleWindFadeOut()
  end
end
function StopEagleWindSound()
  eagleSoundFading = true
  windStarting = false
end
function EagleWindFadeIn()
  local animPerc = GameObjects.TempFX.AnimPercent * 100
  if animPerc < 99.99 then
    game.Audio.SetBusLevelRTPCValue("WIND_EagleWind", animPerc)
  else
    eagleSoundFading = false
  end
end
function EagleWindFadeOut()
  local animPerc = GameObjects.TempFX.AnimPercent * 100
  if 0.99 < animPerc then
    game.Audio.SetBusLevelRTPCValue("WIND_EagleWind", animPerc)
  else
    eagleSoundFading = false
  end
end
function RepeatFanatics()
  local hel300 = game.FindLevel("Hel300_MainBridge")
  if hel300 ~= nil then
    hel300:CallScript("TriggerFanaticRepeat")
  end
end
function DisallowHelheimDeadToAppear(listOfHelDead)
  for i = 1, #listOfHelDead do
    listOfHelDead[i].LuaObjectScript.DisableZoneObjectCount()
    listOfHelDead[i].LuaObjectScript.Disappear()
  end
end
function AllowHelheimDeadToAppear(listOfHelDead)
  for i = 1, #listOfHelDead do
    listOfHelDead[i].LuaObjectScript.Appear()
    listOfHelDead[i].LuaObjectScript.EnableZoneObjectCount()
  end
end
function Setup_OnAnimDone_HideGhostSection(level)
  for i = 1, #helheimDead_AnimSections do
    helheimDead_SectionAnimMonitors[i] = monitors.CreateAnimFrameMonitor(GameObjects[helheimDead_AnimSections[i]])
    helheimDead_AnimSections[i] = GameObjects[helheimDead_AnimSections[i]]:FindGOsByName("helDead_root")
    if helheimDead_AnimSections[i] ~= nil and helheimDead_AnimSections[i] ~= "" and type("table") and 0 < #helheimDead_AnimSections[i] then
      helheimDead_SectionAnimMonitors[i]:OnFrameForward(9500, function()
        DisallowHelheimDeadToAppear(helheimDead_AnimSections[i])
      end)
      helheimDead_SectionAnimMonitors[i]:OnFrameForward(20, function()
        AllowHelheimDeadToAppear(helheimDead_AnimSections[i])
      end)
    end
  end
  helheimDead_SectionAnimMonitors[#helheimDead_SectionAnimMonitors + 1] = monitors.CreateAnimFrameMonitor(GameObjects.CAL_anim_Section1_Fast)
  helheimDead_AnimSections[#helheimDead_AnimSections + 1] = GameObjects.CAL_anim_Section1_Fast:FindGOsByName("helDead_root")
  helheimDead_SectionAnimMonitors[#helheimDead_SectionAnimMonitors]:OnFrameForward(4700, function()
    DisallowHelheimDeadToAppear(helheimDead_AnimSections[#helheimDead_AnimSections])
  end)
  helheimDead_SectionAnimMonitors[#helheimDead_SectionAnimMonitors]:OnFrameForward(20, function()
    AllowHelheimDeadToAppear(helheimDead_AnimSections[#helheimDead_AnimSections])
  end)
end
