local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local gemEquipTimer, player
local firstVisitToHel = true
function OnScriptLoaded(level)
  HideFoliageAndWater()
  GameObjects.SpawnGemFight_Zone:HideEntityVolume()
  player = game.Player.FindPlayer()
end
function OnFirstStart(level)
  GameObjects.Playtest_Questionare:Hide()
  LD.HideFX(GameObjects.DoorWindFx)
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") >= 498 and game.Level.GetVariable("Hel_MapState") ~= 5 then
    game.Level.SetVariable("Hel_MapState", 5)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    firstVisitToHel = firstVisitToHel
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstVisitToHel = savedInfo.firstVisitToHel
end
function Cal120_DoorStartSync_SideA()
  GameObjects.LeadTheWay_100.LuaObjectScript.Disable()
end
function Cal120_DoorStartSync_SideB()
  OnFirstDoorOpenToHel100()
  GameObjects.LeadTheWay_100.LuaObjectScript.Enable()
end
function OnFirstDoorOpenToHel100()
  if firstVisitToHel then
    firstVisitToHel = false
    LD.ShowFX(GameObjects.DoorWindFx)
  end
end
function HelheimCalderaDoorCheck()
  game.UI.LoadCheck("Cal120_Airlock")
end
function Hel100_RemoveBurnable2()
  GameObjects.chest_common_tier4_hel100_1.LuaObjectScript.Enable()
end
function Hel100_ChestOpened()
  if gemEquipTimer == nil then
    gemEquipTimer = timer.StartLevelTimer(1, CheckForGemEquip)
  else
    gemEquipTimer:Restart()
  end
end
function CheckForGemEquip()
  local gemEquipped = player:PickupIsAcquired("BladeSpecialSpin")
  if gemEquipped == true then
    GameObjects.SpawnGemFight_Zone:ShowEntityVolume()
    print("helwakers spawned by blade special equip")
    gemEquipTimer:Stop()
    gemEquipTimer = nil
    GameObjects.CBT_CalderaHelDressing_Script.LuaObjectScript.StartGemFight()
  else
    gemEquipTimer:Restart()
  end
end
function TriggerEagleWind()
  local hel080 = game.FindLevel("Hel080_Global")
  if hel080 ~= nil then
    hel080:CallScript("EagleWind")
  end
end
local bushBurned = false
function TurnOnBurnMsg()
  if not bushBurned then
    GameObjects.Btr_HeIsBramble:ShowEntityVolume()
  end
end
function RemoveBurnMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  game.Audio.PlaySound("SND_UX_Screen_Prompt_Exit")
  game.Audio.PlayBanter("hel_HeIsBramble_Success")
  bushBurned = true
end
function ZoneReportHelheimStart()
  uiCalls.UI_Event_DiscoverLocation("Helheim")
  game.Audio.StartMusic("SND_MX_HEL_helheim_entrance")
  LD.SetMarkerState("CALT_120_HELHEIM_FT", 1)
end
function HideFakeDoor()
  GameObjects.FakeAirlockDoor:Hide()
end
function ShowFakeDoor()
  GameObjects.FakeAirlockDoor:Show()
end
function HideFoliageAndWater()
end
function HideIceCage1()
  GameObjects.iceCage1:Hide()
  AddScreenShake()
end
function HideIceCage2()
  GameObjects.iceCage2:Hide()
  AddScreenShake()
end
function CheckPoint_Bridge()
  game.World.StoreCheckpoint()
end
function AddScreenShake()
  local shakeParams = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 0.5
  }
  game.FX.SubmitEffect(shakeParams)
end
function Hel100_AutoCompleteFights()
  GameObjects.CBT_CalderaHelDressing_Script.LuaObjectScript.DisableFights()
end
local burnMusic = false
function bridgeBurnMusic()
  if burnMusic == false then
    game.Audio.StartMusic("SND_MX_HEL_bridge_of_dead_1")
    burnMusic = true
  end
end
