local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local TUT = require("game.GlobalTutorials")
uiCalls = require("ui.uicalls")
local thisLevel, player, BridgeStartFight, FrontBridgeFight, RearBridgeFight, RearBridgeFightFog, RBFFWave2ZoneMonitor, Area_5_Encounter_1, Return_PopcornFight1, Return_BridgeFight1A, Return_BridgeFight1B, ZM_RF1, Return_BridgeFight2, Return_Gem_Fight, BridgeFight1AlertZoneMonitor, BridgeFight2AlertZoneMonitor, Repop_BridgeStartFight, Repop_FrontBridgeFight, Repop_RearBridgeFightFog, RPRBFFWave2ZoneMonitor, Traveler_HealthMonitor
msgBurn = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  HelBridge_Fight_00()
  HelBridge_Fight_01()
  HelBridge_Fight_02_Fog()
  Area_5_Fight_1()
  HelBridge_Return_Popcorn_Fight_01()
  HelBridge_Return_Fight_01A()
  HelBridge_Return_Fight_01B()
  HelBridge_Return_Fight_02()
  HelBridge_Gem_Fight()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 400 <= cineNumber then
    Repop_HelBridge_Fight_00()
    Repop_HelBridge_Fight_01()
    Repop_HelBridge_Fight_02_Fog()
  end
end
function HelBridge_Fight_00()
  BridgeStartFight = EC.NewEncounter(thisLevel, "Bridge Start Fight", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_BridgeStart",
    LodLow = 38,
    LodHigh = 48
  })
  BridgeStartFight:AddWave({
    {
      spawners = "Helwalker_S_PATROL0",
      spawnLocators = "A0_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_S_Unaware",
      spawnLocators = "A0_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Helwalker_S_IDLE",
      spawnLocators = "A0_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_S_IDLE",
      spawnLocators = "A0_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_HA_SRFC",
      spawnLocators = "A0_O_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  BridgeStartFight:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Armor")
    _G.TurnOnBurnMsg()
  end)
  if game.Level.GetVariable("HEL_guardianKilled") == false then
    BridgeStartFight:SetStartZone(GameObjects.BridgeStartFightZone)
    BridgeStartFight:SetAlertZone(GameObjects.BridgeStartAlertZone)
  end
  BridgeStartFight:OnCombatStart(function()
    game.Audio.StartCheckpointedMusic("SND_MX_HEL_bridge_entrance_fight_in")
  end)
end
function HelBridge_Fight_01()
  FrontBridgeFight = EC.NewEncounter(thisLevel, "FrontBridgeFight", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_Projections",
    LodLow = 32,
    LodHigh = 45
  })
  FrontBridgeFight:AddWave({
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A1_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A1_P_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A1_O_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A1_O_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  FrontBridgeFight:AddWave({
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A1_O_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A1_O_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "T4_Projection_S_SPIC",
      spawnLocators = "A1_O_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  if game.Level.GetVariable("HEL_guardianKilled") == false then
    FrontBridgeFight:SetStartZone(GameObjects.FrontBridgeFightZone)
  end
  FrontBridgeFight:OnComplete(BridgeEncounters1Checkpoint)
  FrontBridgeFight:OnEnemySpawn(function()
    FrontBridgeFight:StartWave()
  end, {markerID = "Look@"})
  FrontBridgeFight:OnEnemyDeath(function()
    FrontBridgeFight:StartWave()
  end, {count = 3})
end
function HelBridge_Fight_02_Fog()
  RearBridgeFightFog = EC.NewEncounter(thisLevel, "RearBridgeFight Fog", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_RearBridge",
    LodLow = 38,
    LodHigh = 48
  })
  RearBridgeFightFog:AddWave({
    {
      spawners = "Fanatic_HA_Cloudburst",
      spawnLocators = "A2_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.7
    },
    {
      spawners = "Fanatic_HA_Cloudburst",
      spawnLocators = "A2_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A2_O_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Projection_S_SPIC",
      spawnLocators = "A2_O_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  RearBridgeFightFog:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Projection_S_SPRINT",
      spawnLocators = "A2_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Projection_S_SPIC",
      spawnLocators = "A2_P_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "T4_Projection_S_SPIC",
      spawnLocators = "A2_P_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  if game.Level.GetVariable("HEL_guardianKilled") == false then
    RearBridgeFightFog:SetStartZone(GameObjects.RearBridgeFightZone)
  end
  RearBridgeFightFog:OnEnemyDeath(function()
    RearBridgeFightFog:StartWave(2)
  end, {count = 4})
  RearBridgeFightFog:OnComplete(BridgeEncounters1Checkpoint)
  RearBridgeFightFog:OnComplete(function()
    game.Audio.StartMusic("SND_MX_HEL_bridge_entrance_fight_out")
  end)
  RBFFWave2ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("RBFF_Wave2"))
  RBFFWave2ZoneMonitor:OnEnter(function()
    RearBridgeFightFog:StartWave(2)
  end)
  RBFFWave2ZoneMonitor:SetTriggerCountLimit(1)
end
function BridgeEncounters1Checkpoint()
  if FrontBridgeFight:IsComplete() and RearBridgeFightFog:IsComplete() then
    game.World.StoreCheckpoint()
    GameObjects.Hel100_Banter.LuaObjectScript.PostBridgeEncounters1()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Archer")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Projection_HelBrood")
  end
end
function Area_5_Fight_1()
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 5]EC:1 Traveler Fight Hel300", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_Traveler",
    LodLow = 42,
    LodHigh = 55,
    StartMusic = "SND_MX_HEL_bridge_exit_middle_fight_in",
    StopMusic = "SND_MX_HEL_bridge_exit_middle_fight_out"
  })
  Area_5_Encounter_1:AddWave({
    {
      spawners = "Traveler_2_IDLE",
      markerID = "Shy_Traveler",
      spawnLocators = "A5_U_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_5_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Traveler")
  end)
  if game.Level.GetVariable("HEL_guardianKilled") == true then
    Area_5_Encounter_1:SetStartZone(GameObjects.EntZn_Area_5_Attack)
    Area_5_Encounter_1:SetAlertZone(GameObjects.EntZn_AlertTraveler)
    Area_5_Encounter_1:OnEnemySpawn(Traveler_Health_Encounter, {
      markerID = "Shy_Traveler"
    })
  end
end
local Traveler_Alert = function()
  Area_5_Encounter_1:AlertEnemies()
end
function Traveler_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Traveler_Health = Enemy:GetHitPoints()
    Traveler_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Traveler_Health * 0.99
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_1, Traveler_Alert)
  end
end
function HelBridge_Return_Popcorn_Fight_01()
  Return_PopcornFight1 = EC.NewEncounter(thisLevel, "Return_Bridge_PopcornFight1", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_RearBridge",
    LodLow = 35,
    LodHigh = 48,
    StartMusic = "SND_MX_HEL_bridge_exit_end_fight_in",
    StopMusic = "SND_MX_HEL_bridge_exit_end_fight_out"
  })
  Return_PopcornFight1:AddWave({
    {
      spawners = "Flyer00_Ice_SPAG",
      spawnLocators = "A2_R_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer00_Ice_SPAG",
      spawnLocators = "A2_R_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A2_R_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "T4_Helwalker_N_SFG",
      spawnLocators = "A2_R_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.2
    }
  })
  Return_PopcornFight1:AddWave({
    {
      spawners = "T4_Helwalker_N_SFG",
      spawnLocators = "A2_R_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Return_PopcornFight1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Ice")
  end)
  if game.Level.GetVariable("HEL_guardianKilled") == true then
    Return_PopcornFight1:SetStartZone(GameObjects.EntZnReturnBridgePopcorn)
    Return_PopcornFight1:OnStart(function()
      LD.CallFunctionAfterDelay(function()
        TUT.WeaponizeNightmareBlades_Tutorial()
      end, 1)
    end)
    Return_PopcornFight1:OnEnemyDeath(function()
      Return_PopcornFight1:StartWave(2)
    end, {count = 2})
  end
end
function HelBridge_Return_Fight_01A()
  Return_BridgeFight1A = EC.NewEncounter(thisLevel, "Return_BridgeFight1A", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_Projections",
    LodLow = 35,
    LodHigh = 48
  })
  Return_BridgeFight1A:AddWave({
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A3_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Helwalker_N_SFG",
      spawnLocators = "A3_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    },
    {
      spawners = "T4_Helwalker_N_SFG",
      spawnLocators = "A3_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.6
    }
  })
  if game.Level.GetVariable("HEL_guardianKilled") == true then
    Return_BridgeFight1A:SetStartZone(GameObjects.Return_BridgeFightZone1)
  end
end
function HelBridge_Return_Fight_01B()
  Return_BridgeFight1B = EC.NewEncounter(thisLevel, "Return_BridgeFight1B", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_BridgeStart",
    LodLow = 35,
    LodHigh = 48
  })
  Return_BridgeFight1B:AddWave({
    {
      spawners = "Projection_S_SPIC",
      spawnLocators = "A0_R_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_S_SPIC",
      spawnLocators = "A0_R_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "T4_Projection_S_SPIC",
      spawnLocators = "A0_R_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_S_SPIC",
      spawnLocators = "A0_R_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Return_BridgeFight1B:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Projection_HelBrood")
  end)
  if game.Level.GetVariable("HEL_guardianKilled") == true then
    Return_BridgeFight1B:SetStartZone(GameObjects.EntZn_BridgeFight1_Wave2)
  end
end
function HelBridge_Return_Fight_02()
  Return_BridgeFight2 = EC.NewEncounter(thisLevel, "Return_BridgeFight2", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_BridgeStart",
    LodLow = 35,
    LodHigh = 48
  })
  Return_BridgeFight2:AddWave({
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A4_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Helwalker_N_SRFC",
      spawnLocators = "A4_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    },
    {
      spawners = "Flyer00_Ice_SPAG",
      spawnLocators = "A4_O_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    },
    {
      spawners = "Flyer00_Ice_SPAG",
      spawnLocators = "A4_O_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    }
  })
  if game.Level.GetVariable("HEL_guardianKilled") == true then
    Return_BridgeFight2:SetStartZone(GameObjects.Return_BridgeFightZone2)
  end
end
function HelBridge_Gem_Fight()
  Return_Gem_Fight = EC.NewEncounter(thisLevel, "Return_SurpriseFight", {
    CheckpointOnComplete = false,
    LodLow = 35,
    LodHigh = 48
  })
  Return_Gem_Fight:AddWave({
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A4_W_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A4_W_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    }
  })
end
function Repop_HelBridge_Fight_00()
  Repop_BridgeStartFight = EC.NewEncounter(thisLevel, "Repop Bridge Start Fight", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_BridgeStart",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "Bridge Start Fight",
      "Return_BridgeFight2",
      LodLow = 32,
      LodHigh = 45
    }
  })
  Repop_BridgeStartFight:AddWave({
    {
      spawners = "L5_Flyer00_Ice_SPAG",
      spawnLocators = "A0_S_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "L5_Flyer00_Ice_SPAG",
      spawnLocators = "A0_S_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "L5_Helwalker_SFG_A",
      spawnLocators = "A0_R_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "L6_Helwalker_SFG_A",
      spawnLocators = "A0_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "L6_Helwalker_SFG_A",
      spawnLocators = "A0_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    }
  })
  Repop_BridgeStartFight:SetStartZone(GameObjects.EntZn_Repop_BridgeStart)
end
function Repop_HelBridge_Fight_01()
  Repop_FrontBridgeFight = EC.NewEncounter(thisLevel, "Repop FrontBridgeFight", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_Projections",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "FrontBridgeFight",
      "Return_BridgeFight2",
      LodLow = 32,
      LodHigh = 45
    }
  })
  Repop_FrontBridgeFight:AddWave({
    {
      spawners = "L5_Helwalker_SFG_A",
      spawnLocators = "A3_R_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "L6_Helwalker_SFG_A",
      spawnLocators = "A3_R_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Repop_FrontBridgeFight:AddWave({
    {
      spawners = "L5_Projection_S_SFT",
      spawnLocators = "A1_P_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "L5_Projection_S_SFT",
      spawnLocators = "A1_P_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Repop_FrontBridgeFight:SetStartZone(GameObjects.FrontBridgeFightZone)
  Repop_FrontBridgeFight:OnEnemyDeath(function()
    Repop_FrontBridgeFight:StartWave()
  end, {count = 1})
end
function Repop_HelBridge_Fight_02_Fog()
  Repop_RearBridgeFightFog = EC.NewEncounter(thisLevel, "Repop RearBridgeFight Fog", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    LeashZone = "NavLeash_Repop_RearBridge",
    MustHaveCompletedList = {
      "RearBridgeFight Fog",
      "Return_BridgeFight2",
      LodLow = 32,
      LodHigh = 45
    }
  })
  Repop_RearBridgeFightFog:AddWave({
    {
      spawners = "L5_Projection_S_SFT",
      spawnLocators = "A2_P_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "L5_Projection_S_SFT",
      spawnLocators = "A2_R_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "L5_Projection_S_SFT",
      spawnLocators = "A2_P_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "L5_Projection_S_SFT",
      spawnLocators = "A2_P_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  Repop_RearBridgeFightFog:SetStartZone(GameObjects.EntZn_Repop_RearBridge)
end
function DisableFights()
  Return_BridgeFight2:SetComplete()
  Return_BridgeFight1A:SetComplete()
  Return_BridgeFight1B:SetComplete()
end
function OnStart(level, obj)
  if Area_5_Encounter_1:WasRunning() then
    Area_5_Encounter_1:Start()
  end
  if Return_BridgeFight1B:WasRunning() then
    Return_BridgeFight1B:Start()
  end
  if Return_BridgeFight2:WasRunning() then
    Return_BridgeFight2:Start()
  end
end
function MessageBurnables()
  if msgBurn == false then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    TUT.Burnables_Tutorial()
    game.Audio.PlaySound("SND_UX_Screen_Prompt_Enter")
    msgBurn = true
  end
end
function StartGemFight()
  Return_Gem_Fight:Start()
end
