LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
uiCalls = require("ui.uicalls")
local CCOS = require("camera.camera_oneshot")
local cameraOneShot_GhostsReturn_000, cameraOneShot_GhostsReturn_010
L_DoorActive = true
R_DoorActive = true
MechanismLocked = false
local Hel200EntranceScript
function OnScriptLoaded(level)
  Hel200EntranceScript = GameObjects.HingeDoor_Hel200Entrance:FindSingleGOByName("hel200EntranceScript").LuaObjectScript
end
function OnStart(level)
  if game.Level.GetVariable("HEL_guardianKilled") == true then
    game.Compass.SetGatewayMarkerIsOpen("HEL_200_Helper1", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HEL_200_Helper1", false)
  end
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.Hel200_WallPress:HideTraversePath()
end
function OnUpdate(level)
  if cameraOneShot_GhostsReturn_000 ~= nil then
    cameraOneShot_GhostsReturn_000:Update()
  end
  if cameraOneShot_GhostsReturn_010 ~= nil then
    cameraOneShot_GhostsReturn_010:Update()
  end
end
function OnUseWorld(level)
end
function StartOneShot_GhostsReturn()
  cameraOneShot_GhostsReturn_000 = CCOS.OneShotCamera.New("ENV_Vista_Door_Ghosts_Return_000", 4, nil)
  cameraOneShot_GhostsReturn_000:Start()
  timer.StartLevelTimer(3, function()
    cameraOneShot_GhostsReturn_010 = CCOS.OneShotCamera.New("ENV_Vista_Door_Ghosts_Return_010", 4, nil)
    cameraOneShot_GhostsReturn_010:SetCallback(DestroyOneShot_GhostsReturn)
    cameraOneShot_GhostsReturn_010:Start()
  end)
end
function DestroyOneShot_GhostsReturn()
  cameraOneShot_GhostsReturn_000 = nil
  cameraOneShot_GhostsReturn_010 = nil
end
function DisableSonLTW()
  GameObjects.LTW_FirstPlatform.LuaObjectScript.Disable()
end
function ExitWallPress()
  GameObjects.LTW_FirstPlatform.LuaObjectScript.Enable()
end
function EnterWallPress()
  GameObjects.LTW_FirstPlatform.LuaObjectScript.Disable()
end
function Hel200_BurnWallPress()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  game.Audio.PlaySound("SND_UX_Screen_Prompt_Exit")
  GameObjects.Hel200_WallPress:ShowTraversePath()
end
function Helheim200DoorCheck()
  game.UI.LoadCheck("Hel100_CalderaHelDressing", "Hel300_MainBridge")
end
function Helheim200WindExitDoorOn()
  GameObjects.BifrostDrain_L.LuaObjectScript.SetActive(true)
end
function Hel200_BookmarkDrainDoor()
  Hel200EntranceScript.DoorSolved()
  GameObjects.BifrostExtra.LuaObjectScript.SetActive(false)
end
local EntranceDoorOverrideSoundEvents = {
  OnInteractForward_Left = "",
  OnInteractForward_Right = "",
  LockLeftOpen = "SND_DOOR_Hel_Exit_Latch_01",
  LockLeftClose = "SND_DOOR_Hel_Exit_Latch_01",
  LockRightOpen = "SND_DOOR_Hel_Exit_Latch_02",
  LockRightClose = "SND_DOOR_Hel_Exit_Latch_02"
}
local EntranceDoorLeftSoundEmitter, EntranceDoorRightSoundEmitter
function SoundInit()
  Hel200EntranceScript.SoundSetup(EntranceDoorOverrideSoundEvents)
  GameObjects.HingeDoor_Hel200Entrance.LuaObjectScript.SoundSetup(EntranceDoorOverrideSoundEvents)
  EntranceDoorLeftSoundEmitter = GameObjects.HingeDoor_Hel200Entrance.Child:FindSingleSoundEmitterByName("SNDDoorLeft")
  EntranceDoorRightSoundEmitter = GameObjects.HingeDoor_Hel200Entrance.Child:FindSingleSoundEmitterByName("SNDDoorRight")
end
function hel200DoorOnInteract()
  LD.PlaySoundOnFrame(EntranceDoorLeftSoundEmitter, GameObjects.HingeDoor_Hel200Entrance.Child, "SND_DOOR_Hel_Guardian_Open_L_01", 1)
  LD.PlaySoundOnFrame(EntranceDoorRightSoundEmitter, GameObjects.HingeDoor_Hel200Entrance.Child, "SND_DOOR_Hel_Guardian_Open_R_01", 1)
end
function hel200DoorOpenMusic()
  game.Audio.StartMusic("SND_MX_HEL_bridge_of_dead_2")
end
