LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
uiCalls = require("ui.uicalls")
monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local TUT = require("game.GlobalTutorials")
checkpoint = require("level.checkpoint")
buttonMonitor = nil
buttonMonitorOne = nil
player = nil
DSpawnDid = false
thisLevel = nil
msg3 = false
son = nil
local Encounter01
playerTriggerPlatform = false
FiresLit = 0
HalfSolved = false
HelChestFall = nil
PillarFall = nil
LeadTheWay1Triggered = false
RopeDrop = false
Message2_300Cancel = false
pitFightDone = false
pillarBurned = false
local guardianKilledCineNum = 387
local ScareDespawnZoneMonitor, PatrolDespawnZoneMonitor, FanaticDespawnZoneMonitor, Area_1_Scare_1, Area_1_Patrol_1, Area_1_Encounter_1, ZM_A1_E1_Alert
local fanaticRepeatComplete = false
local Area_2_Encounter_1, Area_3_Encounter_1, Brawler_HealthMonitor, Area_3_Encounter_2, ZM_A1_E1_Start, Area_4_Encounter_1, Area_4_Encounter_2, ZM_A4_E2_Alert, Repop_A4E1, Repop_A4E2
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  HelChestFall = level:GetGameObject("HelChestFall")
  PillarFall = thisLevel:GetGameObject("hel300_pillar_fall_break")
  GameObjects.GreenLazor:Hide()
  GameObjects.EntZn_Area_2_Attack:Hide()
  HideFake200()
  Area_1_Scare()
  Area_1_Patrol()
  Area_1_Fight_1()
  Area_2_Fight_1()
  Area_3_Fight_1()
  Area_3_Fight_2()
  Area_4_Fight_1()
  Area_4_Fight_2()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 400 <= cineNumber then
    Repop_Area_4_Fight_1()
  end
  local drainDoor = GameObjects.HingeDoor_HelArena1
  local doorDrainCrystal = drainDoor:FindSingleGOByName("BifrostDrain_C")
  doorDrainCrystal.LuaObjectScript.OnBladeEmbedActivateCallbacks(GuardianDoorLit)
end
function OnFirstStart(level)
  GameObjects.T_ReturnPath:HideTraversePath()
  GameObjects.TallCrackClimb:HideTraversePath()
  GameObjects.coffin_tier4_hel300_1.LuaObjectScript.Disable()
  GameObjects.TraverseLink_ClimbUp1:HideTraversePath()
  DeactivateCrawl()
  GameObjects.FallingPlatformCollision:HideCollision()
  GameObjects.RetraversalDebris:Hide()
  DisableSonEntityZones()
  FindArtifactBrooch04().LuaObjectScript.Disable()
  GameObjects.ArtifactBrooch05_Refnode.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_ShortClimb.LuaObjectScript.Disable()
end
function OnStart(level)
  if Area_2_Encounter_1:WasRunning() then
    Area_2_Encounter_1:Start()
  end
  GameObjects.LootDrop_Flat:OnAnimationDone(thisLevel, "EnablePillarArtifact", {Force = true})
  GameObjects.LootDrop_BurnBridge:OnAnimationDone(thisLevel, "EnableBridgeArtifact", {Force = true})
end
function OnUpdate(level)
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_HelClimb_GhostBridge_020") then
    game.Camera.SubmitCameraByName("PLYR_HEL300_GhostBridge_Tower_20")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_HelClimb_GhostBridge_040") then
    game.Camera.SubmitCameraByName("PLYR_HEL300_GhostBridge_Tower_40")
  end
end
function DropPlatform()
  GameObjects.hel300_floor_fall_break.Child:PlayAnimToEnd(0.85)
  PlaySoundPlatformFall()
  game.Audio.StartMusic("SND_MX_HEL_iceberg_collapse_moment")
  player:TriggerMoveEvent("kLE_StoneMasonFistSlam_Stagger")
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.5}
  })
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_LARGE",
    Duration = 2,
    TweenIn = {Time = 0.2},
    TweenOut = {Time = 2}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = 1.5,
    TweenOut = {Time = 1}
  })
  playerTriggerPlatform = true
  GameObjects.VaultPillar:HideTraverseLink()
  GameObjects.VaultPillar1:HideTraverseLink()
  GameObjects.TraverseLink_ClimbUp:HideTraversePath()
end
function RopeHasDropped()
  RopeDrop = true
end
function DeactivateCrawl()
  GameObjects.wall_face_4:HideTraversePath()
  GameObjects.wall_face_5:HideTraversePath()
end
function ActivateCrawl()
  GameObjects.wall_face_4:ShowTraversePath()
  GameObjects.wall_face_5:ShowTraversePath()
end
function ShowTutorial_Harpoon()
  uiCalls.SendSidebarDesignerMessage({
    Text = 37502,
    MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
    DisplayTime = 10
  })
  LD.CallFunctionAfterDelay(function()
    GameObjects.EntZn_Area_2_Attack:Show()
  end, 5)
end
function Helheim300DoorCheck()
  game.UI.LoadCheck("Hel600_GuardianArena", "Hel300_MainBridge")
end
function ArenaAccessOff()
  print("arena access off")
  GameObjects.TraversePathArena:HideTraversePath()
  GameObjects.RetraversalDebris:Show()
  GameObjects.BifrostDrainCrystal2.LuaObjectScript.SetActive(true)
  GameObjects.BifrostDrainCrystal3.LuaObjectScript.SetActive(false)
end
function CreateOneWay()
  GameObjects.TraversePathArena:HideTraversePath()
  LD.CallFunctionAfterDelay(function()
    GameObjects.RetraversalDebris:Show()
    AddScreenShake()
  end, 0.2)
end
function HideFake200()
  GameObjects.Fake200:Hide()
end
function ShowFake200()
  GameObjects.Fake200:Show()
end
function RopeDrop_Enable()
  GameObjects.RopeDrop.Child.LuaObjectScript.EnablePlayerInteract()
end
function TriggerLTW1()
  if RopeDrop == false then
    GameObjects.LeadTheWay1.LuaObjectScript.Enable()
    GameObjects.LeadTheWay2.LuaObjectScript.Disable()
    GameObjects.CA_Observe_Forward_Bridge.LuaObjectScript.Enable()
  end
end
function TriggerLTW2()
  GameObjects.LeadTheWay2.LuaObjectScript.Enable()
end
function TriggerLTW1_Reverse()
  if RopeDrop == true then
    GameObjects.LeadTheWay1_Reverse.LuaObjectScript.Enable()
    GameObjects.LeadTheWay1.LuaObjectScript.Disable()
  end
end
function SwapCADoor1_Front()
  GameObjects.LeadTheWay1_Reverse.LuaObjectScript.Disable()
  GameObjects.LeadTheWay1.LuaObjectScript.Disable()
  GameObjects.LeadTheWay2.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Bridge.LuaObjectScript.Disable()
end
function SwapCADoor1_Back()
  GameObjects.LeadTheWay2.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Bridge.LuaObjectScript.Disable()
end
function SwapCADoor2_Front()
  GameObjects.LeadTheWay2.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Chisel.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Bridge.LuaObjectScript.Disable()
  GameObjects.LeadTheWay1.LuaObjectScript.Disable()
end
function SwapCADoor2_Back()
  GameObjects.LeadTheWay2.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Chisel.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Bridge.LuaObjectScript.Disable()
  GameObjects.LeadTheWay1.LuaObjectScript.Disable()
end
function TriggerLowerArea()
  GameObjects.LeadTheWay1.LuaObjectScript.Disable()
  GameObjects.LeadTheWay4.LuaObjectScript.Enable()
end
function TriggerUpperArea()
  GameObjects.LeadTheWay1.LuaObjectScript.Enable()
  GameObjects.LeadTheWay4.LuaObjectScript.Disable()
end
function TriggerReactionDisgusted()
  GameObjects.Reaction_Disgusted.LuaObjectScript.Trigger()
end
function CrawlHallEnter()
  print("crawl hall enter")
  EnableSonEntityZones()
  GameObjects.CA_SyncExitHelper_Hel201.LuaObjectScript.Disable()
  GameObjects.CA_SyncExitHelper_Hel200.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_ExitDoor.LuaObjectScript.Disable()
  if RopeDrop == false then
    GameObjects.LeadTheWay1.LuaObjectScript.Enable()
  end
end
function CrawlHallExit()
  print("crawl hall exit")
  GameObjects.CA_SyncExitHelper_Hel200.LuaObjectScript.Disable()
  GameObjects.CA_SyncExitHelper_Hel201.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_ExitDoor.LuaObjectScript.Enable()
  LD.CallFunctionAfterDelay(function()
    GameObjects.LeadTheWay_ExitDoor.LuaObjectScript.Disable()
  end, 9)
  GameObjects.LeadTheWay1.LuaObjectScript.Disable()
  GameObjects.LeadTheWay2.LuaObjectScript.Disable()
end
function DisableBridgeContexAction()
  GameObjects.CA_Observe_Forward_Bridge.LuaObjectScript.Disable()
end
function DisableChiselContexAction()
end
function DisableSonEntityZones()
  GameObjects.SwapDoor1_Front:HideEntityVolume()
  GameObjects.SwapDoor1_Back:HideEntityVolume()
  GameObjects.TriggerLTW1:HideEntityVolume()
  GameObjects.SwapDoor2_Front:HideEntityVolume()
  GameObjects.SwapDoor2_Back:HideEntityVolume()
  GameObjects.TriggerLowerArea:HideEntityVolume()
  GameObjects.TriggerUpperArea:HideEntityVolume()
end
function EnableSonEntityZones()
  GameObjects.SwapDoor1_Front:ShowEntityVolume()
  GameObjects.SwapDoor1_Back:ShowEntityVolume()
  GameObjects.TriggerLTW1:ShowEntityVolume()
  GameObjects.SwapDoor2_Front:ShowEntityVolume()
  GameObjects.SwapDoor2_Back:ShowEntityVolume()
  GameObjects.TriggerLowerArea:ShowEntityVolume()
  GameObjects.TriggerUpperArea:ShowEntityVolume()
end
function bladesTnF1()
  game.Level.SetVariable("BladeInteract1", true)
end
function FirstWaveDone()
end
function SecondWaveDone()
end
function HideIceCage3()
  GameObjects.iceCage3:Hide()
  AddScreenShake()
end
function AddScreenShake()
  local shakeParams = {
    EffectName = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 0.1
  }
  game.FX.SubmitEffect(shakeParams)
end
function SlidyDoorGo()
  GameObjects.GateCrawl1:FindSingleGOByName("Point_A").Child.LuaObjectScript.Interrupt()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  GameObjects.SlidyDoor:PlayAnimToEnd()
  PlaySlidyDoorSound("Go")
  Message2_300Cancel = true
end
function SlidyDoorNoGo()
  GameObjects.SlidyDoor:PlayAnimToEnd(-3)
  PlaySlidyDoorSound("NoGo")
  if player:InsideZone(GameObjects.TimerBlockZone) and DSpawnDid == false then
    DSpawnDid = true
  end
end
function SlidyDoor1Go()
  GameObjects.GateCrawl:FindSingleGOByName("Point_A").Child.LuaObjectScript.Interrupt()
  GameObjects.SlidyDoor1:PlayAnimToEnd()
  PlaySlidyDoor1Sound("Go")
end
function SlidyDoor1NoGo()
  GameObjects.SlidyDoor1:PlayAnimToEnd(-3)
  PlaySlidyDoor1Sound("NoGo")
end
function SlidyDoor2Go()
  GameObjects.SlidyDoor2:PlayAnimToEnd()
  GameObjects.coffin_tier4_hel300_1.LuaObjectScript.Enable()
  PlaySlidyDoor2Sound("Go")
end
function SlidyDoor2NoGo()
  GameObjects.SlidyDoor2:PlayAnimToEnd(-3)
  GameObjects.coffin_tier4_hel300_1.LuaObjectScript.Disable()
  PlaySlidyDoor2Sound("NoGo")
end
function GuardianDoorLit()
  if game.Level.GetVariable("HEL_FirstDrainTransfered") == false then
    game.Level.SetVariable("HEL_FirstDrainTransfered", true)
    GameObjects.Hel300_Banter.LuaObjectScript.GuardianDoorLit()
    uiCalls.UI_Event_TurnOffDesignerMessage()
    game.Compass.SetDesignerForcedHide(false)
    LD.CompleteQuest("Quest_Helheim_Objective015")
    LD.CallFunctionAfterDelay(function()
      CheckPoint()
    end, 0.5)
  end
end
function bladesTnF2()
  game.Level.SetVariable("BladeInteract2", true)
end
function CheckPoint()
  game.World.StoreCheckpoint()
end
function Hel600_GuardianPullDrain()
  LD.CallFunctionAfterDelay(function()
    GameObjects.GreenLazor:Show()
  end, 10)
  LD.CallFunctionAfterDelay(function()
    GameObjects.BifrostDrain_C.LuaObjectScript.ForceDrainCrystal()
  end, 11)
  LD.CallFunctionAfterDelay(function()
    GameObjects.GreenLazor:Hide()
    GameObjects.BlockDrain:Hide()
  end, 13)
end
function BurnWall()
  print("show path")
  pillarBurned = true
  PlaySoundPillarFall()
  LD.BreakObject(GameObjects.FightPitPillarObj)
  GameObjects.CollisionHelper:PlayAnimToEnd()
  local camerashakeeffect_pillarland = {
    EffectName = "FSE_SHAKE_SWITCH_CLUNK",
    Duration = 0.06,
    TweenInTime = 0,
    TweenOutTime = 0.3
  }
  timer.StartLevelTimer(1.55, function()
    game.FX.SubmitEffect(camerashakeeffect_pillarland)
  end)
  local camerashakeeffect_pillarsliding = {
    EffectName = "FSE_SHAKE_GROUND_IMPACT",
    Duration = 1.69,
    TweenInTime = 0,
    TweenOutTime = 0.7
  }
  timer.StartLevelTimer(1.55, function()
    game.FX.SubmitEffect(camerashakeeffect_pillarsliding)
  end)
  GameObjects.Hel300_Banter.LuaObjectScript.SkipClimbReminder()
  LD.CallFunctionAfterDelay(function()
    BurnWall_TLinks()
  end, 3)
end
function BurnWall_TLinks()
  if pitFightDone == true and pillarBurned == true then
    GameObjects.VaultPillar:ShowTraverseLink()
    GameObjects.VaultPillar1:ShowTraverseLink()
    GameObjects.TraverseLink_ClimbUp:ShowTraversePath()
  end
end
function BurnReturnWall()
  GameObjects.T_ReturnPath:ShowTraversePath()
end
function FindArtifactBrooch04()
  return thisLevel:FindGameObjects("ArtifactBrooch04*")[1]
end
function EnablePillarArtifact()
  FindArtifactBrooch04().LuaObjectScript.Enable()
end
function EnableBridgeArtifact()
  GameObjects.ArtifactBrooch05_Refnode.LuaObjectScript.Enable()
end
function HangBurn_Flat_Burned()
  GameObjects.LootDrop_Flat:PlayAnimToEnd()
end
function HangBurn_4by8_Burned()
  GameObjects.LootDrop_4by8:PlayAnimToEnd()
end
function HangBurn_2by2_Burned()
  GameObjects.LootDrop_BurnBridge:PlayAnimToEnd()
end
function Hide_BurnLoot()
  GameObjects.ArtifactBrooch05.LuaObjectScript.Disable()
end
function Show_BurnLoot()
  GameObjects.ArtifactBrooch05.LuaObjectScript.Enable()
end
function DropTPathBurnable()
  if HalfSolved == true then
    GameObjects.HelChestFall.Child:PlayAnimToEnd()
    PlaySoundChestPlatformFall()
    LD.CallFunctionAfterDelay(function()
      GameObjects.Rubble:Hide()
    end, 1.2)
    GameObjects.falling_chest.LuaObjectScript.Enable()
  else
    GameObjects.HelChestFall.Child:PlayAnimToFrame(55)
    HalfSolved = true
    PlaySoundChestPlatformRelease()
  end
end
function DropTPathBurnableFront()
  if HalfSolved == true then
    GameObjects.HelChestFall.Child:PlayAnimToEnd()
    PlaySoundChestPlatformFall()
    LD.CallFunctionAfterDelay(function()
      GameObjects.Rubble:Hide()
    end, 1.2)
    GameObjects.falling_chest.LuaObjectScript.Enable()
  else
    GameObjects.HelChestFall.Child:PlayAnimToFrame(55)
    HalfSolved = true
    PlaySoundChestPlatformRelease()
  end
end
function Message3()
  if msg3 == false and LD.GetEntityVariable("CompletedCineNumber") >= guardianKilledCineNum then
    msg3 = true
    LD.CallFunctionAfterDelay(function()
      TUT.Drain_Tutorial_3()
    end, 3)
  end
end
function Message2_300()
  LD.CallFunctionAfterDelay(function()
    if Message2_300Cancel == false and LD.GetEntityVariable("CompletedCineNumber") >= guardianKilledCineNum then
      TUT.Drain_Tutorial_2()
    end
  end, 20)
end
function HideOnDoorWin()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  LD.CallFunctionAfterDelay(function()
    TUT.Drain_Tutorial_3()
  end, 10)
end
function BurnSide_TallClimb()
  GameObjects.TallCrackClimb:ShowTraversePath()
  LD.CallFunctionAfterDelay(function()
    GameObjects.ExtraBurnSides.LuaObjectScript.IgniteObject()
    GameObjects.ExtraBurnSides1.LuaObjectScript.IgniteObject()
  end, 0.2)
  GameObjects.falling_chest.LuaObjectScript.Disable()
  print("show traverse links after burning bramble")
end
function BurnSide_SidePiece()
  LD.CallFunctionAfterDelay(function()
    GameObjects.ExtraBurnSides1.LuaObjectScript.IgniteObject()
    GameObjects.Blade_BurnBarrier4x19.LuaObjectScript.IgniteObject()
  end, 0.2)
end
function BurnSide_SidePiece1()
  LD.CallFunctionAfterDelay(function()
    GameObjects.ExtraBurnSides.LuaObjectScript.IgniteObject()
    GameObjects.Blade_BurnBarrier4x19.LuaObjectScript.IgniteObject()
  end, 0.2)
end
function ChestBrambleBurned()
  GameObjects.Bramble_Chest_Hel300.LuaObjectScript.Enable()
end
function Hel300_AfterBossBookmark()
  GameObjects.T_ReturnPath:ShowTraversePath()
end
function Hel300_EndBookmark()
  GameObjects.BifrostDrainCrystal2.LuaObjectScript.SetActive(true)
end
function Hel300_AutoCompleteFights()
end
function TriggerFanaticRepeat()
  if fanaticRepeatComplete == true then
    Area_2_Encounter_1:Restart()
    fanaticRepeatComplete = false
  elseif fanaticRepeatComplete == false then
    Area_2_Encounter_1:Start()
  end
end
function TriggerFanaticRepeatComplete()
  fanaticRepeatComplete = true
end
function FightHideDeathPlane()
  GameObjects.DeathPlanesControlled:HideCollision()
end
function FightShowDeathPlane()
  GameObjects.DeathPlanesControlled:ShowCollision()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Armor")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Shield")
end
function TriggerWind()
  local hel080 = game.FindLevel("Hel080_Global")
  if hel080 ~= nil then
    hel080:CallScript("EagleWind")
  end
end
function Area_1_Patrol()
  Area_1_Patrol_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Helwalkers and Brawlers Patrolling Hel300", {CheckpointOnComplete = false})
  Area_1_Patrol_1:AddWave({
    {
      spawners = "Helwalker_PATROL01",
      spawnLocators = "A4_P_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_PATROL02",
      spawnLocators = "A4_P_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Patrol_1:SetStartZone(GameObjects.EntZn_Area_1_Patrol_Start)
  PatrolDespawnZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Patrol_End"))
  PatrolDespawnZoneMonitor:OnEnter(function()
    timer.StartLevelTimer(1, function()
      Area_1_Patrol_1:DespawnEnemies()
    end)
  end)
  PatrolDespawnZoneMonitor:SetTriggerCountLimit(1)
end
function Area_1_Scare()
  Area_1_Scare_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Scare Moment Helwalker Hel300", {CheckpointOnComplete = false})
  Area_1_Scare_1:AddWave({
    {
      spawners = "Helwalker_SH_WalkBy",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Scare_1:SetStartZone(GameObjects.EntZn_Area_1_Scare)
  ScareDespawnZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Scare"))
  ScareDespawnZoneMonitor:OnEnter(function()
    timer.StartLevelTimer(8, function()
      Area_1_Scare_1:DespawnEnemies()
    end)
  end)
  ScareDespawnZoneMonitor:SetTriggerCountLimit(1)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Ambush Site Hel300", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_A1E1",
    StartMusic = "SND_MX_HEL_gate_detour_fight_in",
    StopMusic = "SND_MX_HEL_gate_detour_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Helwalker_N_SH_CAUTIOUS",
      spawnLocators = "A1_U_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_N_SH_CAUTIOUS",
      spawnLocators = "A1_E_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Helwalker_S_DROP02",
      spawnLocators = "A1_U_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_S_Cl_Jump",
      spawnLocators = "A1_E_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Helwalker_SH_DROP02",
      spawnLocators = "A1_U_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7
    }
  })
  Area_1_Encounter_1:OnStart(function()
    FightHideDeathPlane()
    ZM_A1_E1_Alert = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_AlertA1E1)
    ZM_A1_E1_Alert:OnEnter(function()
      Area_1_Encounter_1:AlertEnemies(1)
      game.Compass.SetDesignerForcedHide(true)
    end)
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 1})
  Area_1_Encounter_1:OnComplete(FightShowDeathPlane)
  Area_1_Encounter_1:OnComplete(function()
    game.Compass.SetDesignerForcedHide(false)
  end)
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Attack)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Climb Path to Lower Hel300", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_HEL_lower_helheim_first_fight_in",
    StopMusic = "SND_MX_HEL_lower_helheim_first_fight_out",
    LeashZone = "LeashZn_ClimbDown_Fanatics"
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    prioritizeSpawnersInRange = {5, 20},
    {
      spawners = "Fanatic_HB_SRFC",
      spawnLocators = "A2_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_HB_SRFC",
      spawnLocators = "A2_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Fanatic_HB_SRFC",
      spawnLocators = "A2_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_2_Attack)
  Area_2_Encounter_1:OnStart(CheckPoint)
  Area_2_Encounter_1:OnComplete(TriggerFanaticRepeatComplete)
  FanaticDespawnZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Patrol_End"))
  FanaticDespawnZoneMonitor:OnEnter(function()
    Area_2_Encounter_1:DespawnEnemies()
    Area_2_Encounter_1:Stop()
  end)
  FanaticDespawnZoneMonitor:SetTriggerCountLimit(1)
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Platform Fight Hel300", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_HEL_iceberg_collapse_fight_in",
    StopMusic = "SND_MX_HEL_iceberg_collapse_fight_out"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Brawler_2_DROP01",
      spawnLocators = "A3_O_Loc_3",
      useSpawnLocatorsOnly = true,
      markerID = "Brawler_Platform",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Helwalker_N_SLVD",
      spawnLocators = "A3_U_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_HB_DROP01",
      spawnLocators = "A3_U_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Helwalker_S_2_DROP03",
      spawnLocators = "A3_U_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    }
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Fanatic_HB_DROP01",
      spawnLocators = "A3_U_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Fanatic_HB_DROP01",
      spawnLocators = "A3_U_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7
    }
  })
  ZM_A1_E1_Start = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_StartArea3Fight)
  ZM_A1_E1_Start:OnEnter(function()
    timer.StartLevelTimer(0.1, function()
      Area_3_Encounter_1:Start()
    end)
  end)
  Area_3_Encounter_1:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_3_Encounter_1:OnComplete(FirstWaveDone, 1)
  Area_3_Encounter_1:OnComplete(SecondWaveDone, 2)
  Area_3_Encounter_1:OnEnemySpawn(Brawler_Health_Monitor, {
    markerID = "Brawler_Platform"
  })
  Area_3_Encounter_1:OnComplete(ShowClimbUp1)
  Area_3_Encounter_1:OnComplete(function()
    pitFightDone = true
  end)
  Area_3_Encounter_1:OnComplete(BurnWall_TLinks)
  Area_3_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Brawler")
  end)
end
function ShowClimbUp1()
  GameObjects.FallingPlatformCollision:ShowCollision()
  game.Compass.SetDesignerForcedHide(false)
  GameObjects.TraverseLink_ClimbUp1:ShowTraversePath()
  GameObjects.Hel300_Banter.LuaObjectScript.PostPitEncounter()
  game.Audio.SetCheckpointedMusic("SND_MX_HEL_iceberg_collapse_explore_in")
end
function Brawler_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Brawler_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.85
    local Health_Phase_2 = EnemyHealth * 0.3
    Brawler_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_3_Encounter_1:StartWave(2)
    end, TriggerWind)
    Brawler_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_3_Encounter_1:StartWave(3)
    end)
  end
end
function Area_3_Fight_2()
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Flyer Fight Hel300", {CheckpointOnComplete = true})
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Flyer_10_PATROL",
      spawnLocators = "A3_1_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_10_PERCH",
      spawnLocators = "A3_1_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
end
function Area_4_Fight_1()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 4]EC:1 Drain Puzzle Fight Hel300", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_DrainPuzzle1"
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Helwalker_S_SFG",
      spawnLocators = "A4_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_00_SPAG",
      spawnLocators = "A4_O_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Flyer_00_SPAG",
      spawnLocators = "A4_O_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    }
  })
  Area_4_Encounter_1:SetStartZone(GameObjects.EntZn_Area_4_Attack)
end
function Area_4_Fight_2()
  Area_4_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 4]EC:2 Drain Puzzle Fight Part 2", {CheckpointOnComplete = true})
  Area_4_Encounter_2:AddWave({
    timeBeforeNextWave = 2,
    {
      spawners = "Helwalker_N_CAUTIOUS",
      spawnLocators = "A4_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_N_CAUTIOUS",
      spawnLocators = "A4_O_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_4_Encounter_2:AddWave({
    {
      spawners = "Projection_00_SPIC",
      spawnLocators = "A4_U_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Projection_00_SPIC",
      spawnLocators = "A4_U_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Area_4_Encounter_2:SetStartZone(GameObjects.EntZn_DrainPuzz2)
  Area_4_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Ice")
  end)
  Area_4_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Armor")
  end)
end
function Repop_Area_4_Fight_1()
  Repop_A4E1 = EC.NewEncounter(thisLevel, "[Repop Area 4]EC:1 Drain Puzzle Fight Hel300", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 4]EC:1 Drain Puzzle Fight Hel300",
      "Return_BridgeFight2"
    }
  })
  Repop_A4E1:AddWave({
    {
      spawners = "T5_Helwalker_N_SFG",
      spawnLocators = "A4_V_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T5_Flyer_00_SPUG_A",
      spawnLocators = "A4_V_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "T5_Flyer_00_SPUG_A",
      spawnLocators = "A4_V_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Repop_A4E1:SetStartZone(GameObjects.EntZn_Repop_DrainPuzzle)
end
function Repop_Area_4_Fight_2()
  Repop_A4E2 = EC.NewEncounter(thisLevel, "[Repop Area 4]EC:2 Drain Puzzle Fight Hel300 Part 2", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    LeashZone = "NavLeash_DrainPuzzle1",
    MustHaveCompletedList = {
      "[Area 4]EC:1 Drain Puzzle Fight Hel300",
      "Return_BridgeFight2"
    }
  })
  Repop_A4E2:AddWave({
    {
      spawners = "T5_Flyer_00_SPUG_A",
      spawnLocators = "A4_O_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T5_Helwalker_N_SFG",
      spawnLocators = "A4_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "T5_Helwalker_N_SFG",
      spawnLocators = "A4_O_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Repop_A4E2:SetStartZone(GameObjects.EntZn_Repop_DrainPuzzle2)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    temp_RopeDrop = RopeDrop,
    pitFightDone = pitFightDone,
    pillarBurned = pillarBurned,
    msg3 = msg3
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  RopeDrop = savedInfo.temp_RopeDrop
  pitFightDone = savedInfo.pitFightDone
  pillarBurned = savedInfo.pillarBurned
  msg3 = savedInfo.msg3
end
local soundEmitterGuardianDoorL, soundEmitterGuardianDoorR, SNDPillar
local SlidyDoorLeftSound = "SND_DOOR_Helheim_Large_Mvmt_01_LP"
local SlidyDoorRightSound = "SND_DOOR_Helheim_Large_Mvmt_02_LP"
function PlaySlidyDoorSound(movementState)
  local AnimFrameToStop = GameObjects.SlidyDoor.AnimLengthFrames - 3
  if movementState == "Go" and AnimFrameToStop < GameObjects.SlidyDoor.AnimFrame then
    return
  end
  LD.PlayLoopingSoundToAnimFrame(GameObjects.SlidyDoor:FindSingleSoundEmitterByName("SNDDoorRight"), GameObjects.SlidyDoor, SlidyDoorRightSound, 0, AnimFrameToStop)
  LD.PlayLoopingSoundToAnimFrame(GameObjects.SlidyDoor:FindSingleSoundEmitterByName("SNDDoorLeft"), GameObjects.SlidyDoor, SlidyDoorLeftSound, 0, AnimFrameToStop)
end
function PlaySlidyDoor1Sound(movementState)
  local AnimFrameToStop = GameObjects.SlidyDoor1.AnimLengthFrames - 3
  if movementState == "Go" and AnimFrameToStop < GameObjects.SlidyDoor1.AnimFrame then
    return
  end
  LD.PlayLoopingSoundToAnimFrame(GameObjects.SlidyDoor1:FindSingleSoundEmitterByName("SNDDoorRight"), GameObjects.SlidyDoor1, SlidyDoorRightSound, 0, AnimFrameToStop)
  LD.PlayLoopingSoundToAnimFrame(GameObjects.SlidyDoor1:FindSingleSoundEmitterByName("SNDDoorLeft"), GameObjects.SlidyDoor1, SlidyDoorLeftSound, 0, AnimFrameToStop)
end
function PlaySlidyDoor2Sound(movementState)
  local AnimFrameToStop = GameObjects.SlidyDoor2.AnimLengthFrames - 3
  if movementState == "Go" and AnimFrameToStop < GameObjects.SlidyDoor2.AnimFrame then
    return
  end
  LD.PlayLoopingSoundToAnimFrame(GameObjects.SlidyDoor2:FindSingleSoundEmitterByName("SNDDoorRight"), GameObjects.SlidyDoor2, SlidyDoorRightSound, 0, AnimFrameToStop)
  LD.PlayLoopingSoundToAnimFrame(GameObjects.SlidyDoor2:FindSingleSoundEmitterByName("SNDDoorLeft"), GameObjects.SlidyDoor2, SlidyDoorLeftSound, 0, AnimFrameToStop)
end
function PlaySoundPillarFall()
  LD.PlaySound(PillarFall.Child:FindSingleSoundEmitterByName("SNDPillar"), "SND_BRK_Stone_Pillar_Fall_Slide_01")
end
function PlaySoundPlatformFall()
  LD.PlaySound(GameObjects.hel300_floor_fall_break.Child:FindSingleSoundEmitterByName("SNDFloatyPlatform"), "SND_BRK_Ice_Platform_01")
end
function PlaySoundChestPlatformRelease()
  LD.PlaySound(GameObjects.HelChestFall.Child:FindSingleSoundEmitterByName("SNDHelChestFall"), "SND_BRK_Stone_Boulder_Release_p1")
end
function PlaySoundChestPlatformFall()
  LD.PlaySound(GameObjects.HelChestFall.Child:FindSingleSoundEmitterByName("SNDHelChestFall"), "SND_BRK_Stone_Boulder_Release_p2")
end
local trolldoorOpened = false
function TrollArenaExitMusic()
  if trolldoorOpened == false then
    game.Audio.StartCheckpointedMusic("SND_MX_HEL_drain_puzzle_in")
    trolldoorOpened = true
  end
end
function StopExploreMusic()
end
