local LD = require("design.LevelDesignLibrary")
local skipClimbReminderBool = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function PostPitEncounter()
  LD.CallFunctionAfterDelay(PlayMimirOnValhalla, 2)
end
function PlayMimirOnValhalla()
  game.Audio.PlayBanter("hel_MimirOnValhalla", PostMimirOnValhallaBanter)
end
function PostMimirOnValhallaBanter()
  LD.CallFunctionAfterDelay(PlayClimbReminder, 30)
end
function PlayClimbReminder()
  if not skipClimbReminderBool then
    game.Audio.PlayBanter("hel_ClimbReminder")
  end
end
function SkipClimbReminder()
  skipClimbReminderBool = true
end
function GuardianDoorLit()
  local hel600 = game.FindLevel("Hel600_GuardianArena")
  if hel600 ~= nil then
    hel600:GetGameObject("POI_DrainAcquire"):CallScript("HelDrainComplete")
  end
end
