local LD = require("design.LevelDesignLibrary")
uiCalls = require("ui.uicalls")
local thisLevel, player, hel350, ChiselElevator, ElevatorManager, pad
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  SoundInit()
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
end
function OnStart(level)
  SoundOnStart()
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function ClearSlowWalk()
  player:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function LoadCheck_Hel300()
  game.UI.LoadCheck("Hel300_MainBridge")
end
function LoadCheck_Hel350()
  game.UI.LoadCheck("Hel350_ChiselArena")
end
function Hel350_LTW_Enable()
  local hel350 = game.FindLevel("Hel350_ChiselArena")
  if hel350 ~= nil then
    hel350:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
function Hel350_LTW_Disable()
  local hel350 = game.FindLevel("Hel350_ChiselArena")
  if hel350 ~= nil then
    hel350:CallScript("LTW_Lobby_Disable", "CA_Lobby_Disable")
  end
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Helheim Chisel Dungeon")
  ChiselLabor()
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_Hel")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_Hel")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
function EnableChiselMarker()
  LD.SetMarkerState("HEL_300_ChiselEntrance", 1)
  LD.UpdateMap("HEL_300_ChiselEntrance", 0)
  ChiselQuest()
end
function DisableChiselMarker()
  LD.SetMarkerState("HEL_300_ChiselEntrance", 0)
end
function ChiselQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Find_Hel")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Find_Hel")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Find", 1)
  end
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
end
