local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local EC = require("design.Encounter")
local thisLevel, player, Enc_Valkyrie_Fight
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  Fnc_Arena_Valkyrie_Fight()
end
function Fnc_Arena_Valkyrie_Fight()
  Enc_Valkyrie_Fight = EC.NewEncounter(thisLevel, "Hel350 - Chisel Arena]EC: Valkyrie00 Ice", {
    CheckpointOnComplete = false,
    spawnWad = "Hel350_ChiselArena",
    LeashZone = "LshZn_Hel350_Valk"
  })
  Enc_Valkyrie_Fight:AddWave({
    {
      spawners = "Valkyrie_Grappler_SSD",
      markerID = "Valkyrie_Hel350",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Enc_Valkyrie_Fight:SetStartZone(GameObjects.EntZn_Valkyrie_Spawn)
  Enc_Valkyrie_Fight:SetAlertZone(GameObjects.EntZn_Valkyrie_Alert)
  Enc_Valkyrie_Fight:OnComplete(function()
    _G.SetEncounterComplete()
    _G.CA_Arena_Enable()
    _G.LTW_Lobby_Enable()
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
  end)
end
