local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local monitors = require("level.MonitorLibrary")
uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local checkpoint = require("level.checkpoint")
local timers, player
msg1 = false
msg2 = false
UnlockMessage2 = false
local buttonMonitor, thisLevel
isReload = false
cineSet = false
ZoneReport = false
local timers_LoadLibrary = function()
  if timers == nil then
    timers = require("level.timer")
  end
end
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  thisLevel = level
  timers_LoadLibrary()
  timers.StartLevelTimer(1.5, HideGuardianLoot)
end
function OnFirstStart(level)
  print("on first start")
  DisableGuardianDrain()
  GameObjects.TrollCollision:HideCollision()
end
function OnStart(level)
  if game.QuestManager.GetQuestState("Quest_Helheim_Objective015") == "Complete" then
    game.Compass.SetGatewayMarkerIsOpen("HEL_600_Helper", false)
  end
end
function Helheim_Objective010()
  LD.CompleteQuest("Quest_Helheim_Objective010")
end
function Message1()
  if msg1 == false then
    ShowAimTutorial()
    UnlockMessage2 = true
  end
end
function ShowAimTutorial()
  buttonMonitor = monitors.CreateL2ButtonMonitor()
  buttonMonitor:OnButtonDown(HideAimTutorial)
  buttonMonitor:OnButtonUp(BackToAimTutorial)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  TUT.DrainAcquire_Tutorial_2()
end
function BackToAimTutorial()
  buttonMonitor:Stop()
  buttonMonitor = nil
  TUT.DrainAcquire_Tutorial_2()
  buttonMonitor = monitors.CreateL2ButtonMonitor()
  buttonMonitor:OnButtonDown(HideAimTutorial)
end
function HideAimTutorial()
  buttonMonitor:Stop()
  buttonMonitor = nil
  buttonMonitor = monitors.CreateL2ButtonMonitor()
  buttonMonitor:OnButtonUp(BackToAimTutorial)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  TUT.DrainAcquire_Tutorial_3()
end
function Message2()
  if msg2 == false and UnlockMessage2 == true then
    LD.CallFunctionAfterDelay(function()
      uiCalls.UI_Event_TurnOffDesignerMessage()
      TUT.Drain_Tutorial_1()
    end, 1)
    LD.CallFunctionAfterDelay(function()
      TUT.Drain_Tutorial_2()
    end, 3)
    msg1 = true
    msg2 = true
    buttonMonitor:Stop()
    buttonMonitor = nil
  end
end
function ForceEquipBlades(anyObj, callback)
  local heroPuppeteer = game.Puppeteer.NewForce(anyObj, "Equip Blades", player)
  heroPuppeteer:WeaponEquip({weaponMode = "Blades"})
  heroPuppeteer:OnComplete(function()
    heroPuppeteer:Clear()
    heroPuppeteer = nil
    callback()
  end)
end
function ZoneReport_BridgeOfTheDead()
  LD.CallFunctionAfterDelay(function()
    uiCalls.UI_Event_DiscoverLocation("Bridge Of The Damned")
  end, 8)
end
function DisableGuardianDrain()
  local drainGroup = GameObjects.GuardianDrainGroup_Lua
  drainGroup:FindSingleGOByName("helmarkertemp"):Hide()
  drainGroup:FindSingleGOByName("InteractZone_Arena01").LuaObjectScript.Disable()
  GameObjects.BifrostDrainCrystal_Arena01:Hide()
end
function SpawnLoot_600()
  GameObjects.chest_common_tier4_hel600_1.LuaObjectScript.Enable()
end
function Hel600_Bookmark_GuardianArenaStart()
end
function CapsuleOff()
  GameObjects.CollidableCapsule_Guardian:HideCollision()
end
function StopMarkerScanLoop()
  LD.StopSound(GameObjects.SNDGrpTotemScan:FindSingleSoundEmitterByName("SNDGuardianTotemScan"), "SND_CHR_Guardian_Ice_Totem_LP")
  GameObjects.SNDGrpTotemScan:Hide()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  isReload = true
  checkpoint.Restore(savedInfo.levelstate)
end
function ShowGuardianLoot()
  local guardianLoot = thisLevel:FindSingleGameObject("corpse_legendary_tier1_hel600_1")
  guardianLoot:Show()
  if game.Wallets.GetResourceValue("LOST_ITEMS", "BladesReinforcement_Tracker3") < 1 then
    game.Wallets.AddResource("LOST_ITEMS", "BladesReinforcement", 1)
    game.Wallets.AddResource("LOST_ITEMS", "BladesReinforcement_Tracker3", 1)
  end
  local guardianLootChild = thisLevel:FindSingleGameObject("corpse_legendary_tier1_hel600_1").Child
  if guardianLootChild ~= nil then
    guardianLootChild.LuaObjectScript.EnableInteraction()
  end
end
function HideGuardianLoot()
  local guardianLoot = thisLevel:FindSingleGameObject("corpse_legendary_tier1_hel600_1")
  guardianLoot:Hide()
  local guardianLootChild = thisLevel:FindSingleGameObject("corpse_legendary_tier1_hel600_1").Child
  if guardianLootChild ~= nil then
    guardianLootChild.LuaObjectScript.DisableInteraction()
  end
end
