local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local thisObj, thisLevel, kraActor, trollActor, trollHeartObj, zeusObj, cine_lights_387
local retrieveHeartZoneStr = "CineZone_RetrieveHeart"
local synchJointStr = "RetrieveHeart_SynchJoint"
local kraStartJointStr = "Kra_StartJoint"
local trollStartJointStr = "Troll_StartJoint"
local retrieveHeartIdleBranchStr = "BRA_RetrieveHeartCineIdle"
local retrieveHeartBranchStr = "BRA_RetrieveHeartCine"
local miniGamePlaying = false
local exitBanterComplete = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  cine_lights_387 = GameObjects.Cine_Start_387
  HideCineLights()
  InitProps()
  if game.Level.GetVariable("CompletedCineNumber") < 387 then
    SetupActors()
  else
    HideProps()
  end
end
function OnUpdate(level, obj)
  if miniGamePlaying then
    if game.Player.FindPlayer():IsPlayingMove("MOV_RetrieveHeartIntOpenChest") then
      local value = game.Player.FindPlayer():GetActiveMovePercent() * 100
      game.Audio.SetWwiseRTPCValue(game.Player.FindPlayer(), "CINE_RetrieveHeart_Pry_Percent", value)
    elseif game.Player.FindPlayer():IsPlayingMove("MOV_RetrieveHeartCineScene") then
      miniGamePlaying = false
    else
      game.Audio.SetWwiseRTPCValue(game.Player.FindPlayer(), "CINE_RetrieveHeart_Pry_Percent", 0)
    end
  end
end
function OnUseWorld(level, obj)
end
local FindTroll = function()
  local objArray = game.World.FindGameObjectsByMarker("troll30")
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
      return obj:GetCreature():GetAI()
    end
  end
  return nil
end
function InitProps()
  trollHeartObj = GameObjects.TrollHeart.Child
  trollHeartObj:Hide()
  zeusObj = GameObjects.ZeusProp.Child
  zeusObj:AddMarker("Zeus")
  zeusObj:Hide()
end
function PlayProps()
  zeusObj:Show()
  trollHeartObj:Show()
end
function PrepareZeus()
  zeusObj:ShowAudio()
end
function HideProps()
  zeusObj:Hide()
  trollHeartObj:Hide()
end
function SetupActors()
  kraActor = actor.Actor.New("RETRIEVE HEART: Kratos Actor", game.Player.FindPlayer)
  trollActor = actor.Actor.New("RETRIEVE HEART: Troll Actor", FindTroll)
end
function SetupCineSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Retrieve Heart Sequence")
  local slaveTab = {
    {Actor = trollActor},
    {
      Obj = zeusObj,
      Anim = "narHelRetrieveHeart010CineEnter"
    },
    {
      Obj = trollHeartObj,
      Anim = "narHelRetrieveHeart010CineEnter"
    }
  }
  cineSeq:Do(PrepareZeus)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = retrieveHeartBranchStr,
    ReferenceJoint = synchJointStr
  })
  cineSeq:Do(game.Cinematics.EnableCinematicMode)
  cineSeq:Do(StartCineLights)
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_RetrieveHeartIntIdle03")
  end)
  cineSeq:Do(function()
    game.SubObject.Wake(thisObj)
  end)
  cineSeq:Do(StartMiniGameAudio)
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_RetrieveHeartCineScene")
  end)
  cineSeq:Do(function()
    game.SubObject.Sleep(thisObj)
  end)
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_RetrieveHeartCineScene")
  end)
  cineSeq:SetPostSkipMusic("SND_MX_HEL_start_master")
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(PlayCineLights)
  cineSeq:WaitFrames(1)
  cineSeq:Do(PlayProps)
  cineSeq:WaitForActorPuppeteerComplete(kraActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(trollActor)
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:Do(game.Cinematics.DisableCinematicMode)
  cineSeq:Do(HideProps)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(PlayExitBanter)
  cineSeq:Do(function()
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Troll_Helheim_Guardian")
  end)
  cineSeq:Do(ShowTrollCollision)
  cineSeq:SetCompletedCineNumber(387)
  cineSeq:StartPOIMoment(1.5)
  cineSeq:WaitForFunctionTrue(function()
    return exitBanterComplete
  end)
  cineSeq:Do(Objective015_Quest)
  cineSeq:EndPOIMoment()
  cineSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  cineSeq:StartSequence()
end
function Objective015_Quest()
  game.QuestManager.ProposeQuestState("Quest_Helheim_Objective015", "Complete")
  game.Compass.SetDesignerForcedHide(false)
  game.Compass.SetGatewayMarkerIsOpen("HEL_600_Helper", false)
end
function StartCineLights()
  cine_lights_387:Show()
  cine_lights_387:JumpAnimationToFrame(0)
  cine_lights_387:PlayAnimationToFrame(400)
end
function PlayCineLights()
  cine_lights_387:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_387:Hide()
end
function StartMiniGameAudio()
  miniGamePlaying = true
end
function PlayExitBanter()
  game.Audio.PlayBanter("hel_KeeperDown", function()
    exitBanterComplete = true
  end)
end
function ShowTrollCollision()
  GameObjects.TrollCollision:ShowCollision()
end
