local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local timers = require("level.timer")
local thisObj, thisLevel, kraActor, cameraCineEnterArea000, cameraCineEnterArea005, cameraCineEnterArea010
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  cameraCineEnterArea000 = CCEC.CineEnterCamera.New("ENV_Vista_Hel600_AreaAnnounce_000", 8, nil)
  cameraCineEnterArea005 = CCEC.CineEnterCamera.New("ENV_Vista_Hel600_AreaAnnounce_005", 5, nil)
  cameraCineEnterArea010 = CCEC.CineEnterCamera.New("ENV_Vista_Hel600_AreaAnnounce_010", 4, nil)
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
end
function BuildArenaIntroductionSeq()
  CreateActors()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "Arena Introduction - POI")
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(CameraAreaAnnounceSequence)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_ArenaIntroduction",
    ReferenceJoint = "ArenaIntroduction_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare"
  })
  seq:ActorSync(kraActor, {
    Branch = "BRA_ArenaIntroduction",
    ReferenceJoint = "ArenaIntroduction_SynchJoint"
  })
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StartSequence()
end
function CameraAreaAnnounceSequence()
  cameraCineEnterArea000:Start()
  timers.StartLevelTimer(4, function()
    cameraCineEnterArea005:Start()
  end)
  timers.StartLevelTimer(6, function()
    cameraCineEnterArea010:Start()
  end)
  timers.StartLevelTimer(15, function()
    game.SubObject.Sleep(thisObj)
  end)
end
function OnUpdate(level, obj)
  if cameraCineEnterArea000 ~= nil then
    cameraCineEnterArea000:Update()
  end
  if cameraCineEnterArea005 ~= nil then
    cameraCineEnterArea005:Update()
  end
  if cameraCineEnterArea010 ~= nil then
    cameraCineEnterArea010:Update()
  end
end
