local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, brokActor
local firstDrainedOrb = false
local drainHintTimer
local targetHintPlaying = false
local cameraCineEnter_DrainAcquire
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  SetupActor()
  if game.Level.GetVariable("HEL_DrainAcquired") and not game.Level.GetVariable("HEL_FirstDrainTransfered") then
    SpawnBrokForTutorialSeq()
  end
end
function OnUpdate()
  if cameraCineEnter_DrainAcquire ~= nil then
    cameraCineEnter_DrainAcquire:Update()
  end
end
function SpawnBrok()
  return ND.SpawnAIAtJoint(thisLevel, "POI_DrainAcquire", "Brok_StartJoint", "CRT_Brok00", "BRA_DrainAcquire", "Brok")
end
function SetupActor()
  kraActor = actor.Actor.New("DRAIN ACQUIRE: Kratos Actor", game.Player.FindPlayer)
  brokActor = actor.Actor.New("DRAIN ACQUIRE: Brok Actor")
  brokActor:SetSpawnFunction(SpawnBrok)
end
function SetupPOISequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Drain Acquire Sequence")
  local slaveTab = {
    {Actor = brokActor}
  }
  cineSeq:SetPostSkipMusic("SND_MX_HEL_start_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:Do(HideKeeperDownBanterZone)
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(StartCineEnter_DrainAcquire)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_DrainAcquire",
    ReferenceJoint = "DrainAcquire_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.InteractStopDistance,
    weapon_state = "bare",
    strafe_distance = 1
  })
  cineSeq:SpawnActorAndWait(brokActor)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_DrainAcquire",
    ReferenceJoint = "DrainAcquire_SynchJoint"
  })
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:Do(StartTutorialSequence)
  cineSeq:Do(AcquireDrainAndStoreCheckpoint)
  cineSeq:StartSequence()
end
function StartTutorialSequence()
  local tutorialSeq = LD.CreateCineSequence(thisLevel, thisObj, "Drain Acquire Tutorial Sequence")
  local doneWithBanter = false
  drainHintTimer = timers.StartLevelTimer(30, DrainHint)
  drainHintTimer:Pause()
  tutorialSeq:Do(function()
    _G.Message1()
  end)
  tutorialSeq:Do(function()
    drainHintTimer:Restart()
  end)
  tutorialSeq:WaitForFunctionTrue(function()
    return game.Level.GetVariable("HEL_FirstDrainTransfered")
  end)
  tutorialSeq:Do(function()
    game.Audio.PlayBanter("hel_DrainAcquire03_Success", function()
      doneWithBanter = true
    end)
  end)
  tutorialSeq:WaitForFunctionTrue(function()
    return doneWithBanter
  end)
  tutorialSeq:Do(function()
    brokActor:GetCreature():TriggerMoveEvent("LE_DrainAcquireExit")
  end)
  tutorialSeq:WaitForActorFinishMove(brokActor, "MOV_DrainAcquireExit")
  tutorialSeq:StopPuppetingActor(brokActor)
  tutorialSeq:DespawnActor(brokActor)
  tutorialSeq:StartSequence()
end
function SpawnBrokForTutorialSeq()
  local spawnSeq = LD.CreateCineSequence(thisLevel, thisObj, "Drain Acquire Tutorial BrokSpawn Sequence")
  spawnSeq:SpawnActorAndWait(brokActor)
  spawnSeq:ActorSync(brokActor, {
    Branch = "BRA_DrainAcquireIdle",
    ReferenceJoint = "DrainAcquire_SynchJoint"
  })
  spawnSeq:Do(StartTutorialSequence)
  spawnSeq:Do(DrainHint)
  spawnSeq:StartSequence()
end
function HideKeeperDownBanterZone()
  GameObjects.Btr_KeeperDown_Door:HideEntityVolume()
end
function AcquireDrainAndStoreCheckpoint()
  game.Level.SetVariable("HEL_DrainAcquired", true)
  GameObjects.BifrostDrainCrystal_Arena01.LuaObjectScript.SetActive(true)
  game.World.StoreCheckpoint()
end
function DrainHint()
  if not game.Level.GetVariable("HEL_FirstDrainTransfered") then
    game.Audio.PlayBanter("hel_DrainAcquire02_Hint")
    if drainHintTimer ~= nil then
      drainHintTimer:Restart()
    end
  end
end
function GuardianCrystalDrained()
  if not game.Level.GetVariable("HEL_FirstDrainTransfered") then
    if not targetHintPlaying and game.Level.GetVariable("CompletedCineNumber") == 387 then
      if not firstDrainedOrb then
        firstDrainedOrb = true
        LD.CallFunctionAfterDelay(function()
          if not game.Level.GetVariable("HEL_FirstDrainTransfered") then
            game.Audio.PlayBanter("hel_DrainAcquire02_Success", TargetHintFinished)
          end
        end, 2)
      else
        LD.CallFunctionAfterDelay(function()
          if not game.Level.GetVariable("HEL_FirstDrainTransfered") then
            game.Audio.PlayBanter("hel_DrainAcquire03_Hint", TargetHintFinished)
          end
        end, 2)
      end
      targetHintPlaying = true
    end
    if drainHintTimer ~= nil then
      drainHintTimer:Pause()
    end
  end
end
function TargetHintFinished()
  LD.CallFunctionAfterDelay(function()
    targetHintPlaying = false
  end, 10)
end
function GuardianCrystalLit()
  if drainHintTimer ~= nil then
    drainHintTimer:Restart()
  end
end
function HelDrainComplete()
  if drainHintTimer ~= nil then
    drainHintTimer = nil
  end
end
function StartCineEnter_DrainAcquire()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_DrainAcquire = CCEC.CineEnterCamera.New("ENV_CineEnter_DrainAcquire", 7)
  cameraCineEnter_DrainAcquire:SetCallback(DestroyCineEnter_DrainAcquire)
  cameraCineEnter_DrainAcquire:Start()
end
function DestroyCineEnter_DrainAcquire()
  cameraCineEnter_DrainAcquire = nil
  game.SubObject.Sleep(thisObj)
end
