local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local actorlib = require("narrative.actor")
local stageDecrement = monitors.CreateLeftButtonMonitor()
local stageIncrement = monitors.CreateRightButtonMonitor()
local playPhaseAnim = monitors.CreateUpButtonMonitor()
local thisLevel, player, son, baldur, sequence
local stage = 0
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  stageDecrement:OnButtonDown(StageDecrementDebug)
  stageIncrement:OnButtonDown(StageIncrementDebug)
  playPhaseAnim:OnButtonDown(StageSetupDelayedDebug)
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") < 490 then
    SetupFlyoverSeq()
  end
end
function KillBaldur()
  if baldur ~= nil then
    baldur:Destroy()
  end
end
local kratosActor = actorlib.Actor.New("Kratos", game.Player.FindPlayer)
local sonActor = actorlib.Actor.New("Son", game.AI.FindSon)
local baldurActor = actorlib.Actor.New("Baldur", function()
  return baldur
end)
function SpawnBaldur()
  KillBaldur()
  local spawner = thisLevel:FindSingleGameObject("BaldurSpawner")
  baldur = spawner.LuaObjectScript.SpawnEnemy({spawnWad = thisLevel})
  baldur:MeterSetValue("Health", 800)
end
function SetupFlyoverSeq()
  sequence = LD.CreateCineSequence(thisLevel, GameObjects.BaldurSkySynch, "BaldurSky")
  sequence:SetPostSkipMusic("SND_MX_HEL_start_master")
  sequence:WaitForActorPlayingMove(kratosActor, "MOV_HengeDisruption")
  sequence:WaitUntilActorAnimPastPercentage(kratosActor, 0.997)
  sequence:Do(SpawnBaldur)
  sequence:WaitFrames(1)
  sequence:ActorSync(kratosActor, {
    Slaves = {
      {Actor = baldurActor},
      {Actor = sonActor}
    },
    Branch = "BRA_BaldurSkyEnter",
    ReferenceJoint = "joint1"
  })
  sequence:WaitUntilActorAnimPastPercentage(kratosActor, 0.9)
  sequence:Do(function()
    sequence:SetMaxSkipSpeedup(5)
  end)
  sequence:WaitUntilActorAnimPastPercentage(kratosActor, 0.99)
  sequence:WaitForLoadCheck("HelR100_Docks")
  sequence:WaitForLoadCheck("HelR050_Sound")
  sequence:WaitForLoadCheck("HelR075_Lights")
  sequence:WaitForLoadCheck("HelR000_Sky")
  sequence:WaitForLoadCheck("HelR300_HelShip")
  sequence:Do(function()
    sequence:EndSkipIfActive()
  end)
  sequence:WaitForActorPlayingMove(kratosActor, "MOV_BaldurSkyExitDone")
  sequence:Do(LandInHel2)
  sequence:WaitForActorMoveComplete(kratosActor)
  sequence:StopPuppetingActor(kratosActor)
  sequence:StopPuppetingActor(sonActor)
  sequence:StopPuppetingActor(baldurActor)
  sequence:StartSequence()
end
function SetSkipping(level, isAlreadySkipping)
  if sequence then
    sequence:MarkAbleToSkip({alreadySkipping = isAlreadySkipping})
    sequence:SetMaxSkipSpeedup(20)
  end
end
function StageIncrementDebug()
  if player.Pad.L1Down == true then
    StageIncrement()
  end
end
function StageDecrementDebug()
  if player.Pad.L1Down == true then
    StageDecrement()
  end
  print(stage)
end
function StageSetupDelayedDebug()
  if player.Pad.L1Down == true then
    StageSetupDelayed()
  end
end
function CompassOff()
  game.Compass.SetDesignerForcedHide(true)
end
function StageDecrement()
end
function StageIncrement()
end
function StageSetupDelayed()
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
local wat = false
function GetReadyToWarp()
  if wat == false then
    wat = true
    SpawnBaldur()
  end
end
function LandInHel2()
  player:TriggerMoveEvent("LE_ForceIdle")
  baldur:Destroy()
  stage = 9
end
function LoadCheckHelRDocks()
  game.UI.LoadCheck("HelR100_Docks", "HelR000_Sky", "HelR050_Sound")
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function Cal130_Bookmark_Baldur2_Flyover_Start()
  GetReadyToWarp()
end
