local LD = require("design.LevelDesignLibrary")
local inDrainZone, BoatEncountersDone
function OnFirstStart(level)
  GameObjects.SpeedControlZone:Hide()
end
function OnStart(level)
  GameObjects.FX_ZeusVignette:Hide()
end
function FirstEncounterDone()
  game.Audio.PlayBanter("040_PastHauntsSon_01")
  ZeusVoiceFX()
end
local doorProppedOpen = false
function AxeDoorJam()
  print("gear pinned")
  GameObjects.BanterTimedSequence_DrainDoor.LuaObjectScript.Pause()
  doorProppedOpen = true
end
function AxeDoorUnJam()
  print("gear unpinned")
  GameObjects.BanterTimedSequence_DrainDoor.LuaObjectScript.Resume()
end
function SolvedHelGateDrainEvent()
  doorProppedOpen = true
end
function HelGateDrainGearHint()
  if not doorProppedOpen and inDrainZone == true then
    game.Audio.PlayBanter("060_HelGateDrain_GearsHint", function()
      LD.CallFunctionAfterDelay(HelGateDrainGearHint, 150)
    end)
  end
end
function HelGateDrainFingersPlusGears()
  if not doorProppedOpen and inDrainZone == true then
    game.Audio.PlayBanter("060_HelGateDrain_Fingerless", HelGateDrainGearHint)
  end
end
function HelGateDrainHurryUp()
  if not doorProppedOpen and inDrainZone == true then
    game.Audio.PlayBanter("060_HelGateDrain_HurryUp", function()
      LD.CallFunctionAfterDelay(HelGateDrainFingersPlusGears, 35)
    end)
  end
end
function InDrainZone()
  print("Yes do drain dialog")
  inDrainZone = true
end
function OutOfDrainZone()
  print("Don't do drain dialog")
  inDrainZone = false
end
function CancelDrainBtr()
  GameObjects.BanterTimedSequence_DrainDoor.LuaObjectScript.Cancel()
end
function HelGateDrainStart()
  LD.CallFunctionAfterDelay(HelGateDrainHurryUp, 45)
end
local shouldPlayKratosHauntsForeshadow = true
function PreBoatEncounterDone()
  if shouldPlayKratosHauntsForeshadow then
    game.Audio.PlayBanter("100_KratosHauntsForeshadow")
  end
  ZeusVoiceFX()
  local helR300 = game.FindLevel("HelR300_HelShip")
  if helR300 ~= nil then
    local shipScript = helR300:FindSingleGameObject("HelheimShipScript")
    if shipScript ~= nil then
      shipScript:CallScript("DocksFightDone")
    end
  end
end
function KratosHauntsForeshadowCancel()
  shouldPlayKratosHauntsForeshadow = false
end
local solvedStuckAgainCrank = false
function ShipFreedLowerDeck()
  GameObjects.BanterTimedSequence_StuckBridge.LuaObjectScript.Cancel()
  GameObjects.Btr_TimedTower4:HideEntityVolume()
  solvedStuckAgainCrank = true
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("130_StuckAgain_CrankSuccess")
  end, 4)
end
function WitchFightEncounterDone()
  game.Audio.PlayBanter("132_OutOfOptions")
  GameObjects.BanterTimedSequence_StuckBridge.LuaObjectScript.Cancel()
  GameObjects.Btr_TimedTower4:HideEntityVolume()
end
function CrankSolved()
  GameObjects.BanterTimedSequence_StuckBridge.LuaObjectScript.Cancel()
  GameObjects.Btr_TimedTower4:HideEntityVolume()
  return solvedStuckAgainCrank
end
function ZeusVoiceFX()
  GameObjects.FX_ZeusVignette:JumpAnimToFrame(0)
  GameObjects.FX_ZeusVignette:Show()
  GameObjects.FX_ZeusVignette:PlayAnimToFrame(90)
  LD.CallFunctionAfterDelay(function()
    GameObjects.FX_ZeusVignette:PlayAnimToFrame(0, -1)
  end, 6)
end
