local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local thisLevel, player, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, A1_Enc2_monitor, Area_2_Encounter_1, Area_2_Encounter_2, Area_3_Encounter_1, HelR100_Traveler_Beserker
local TravelerFightRestart = false
local Area_3_Encounter_2, Area_3_Encounter_3, Area_3_Encounter_5, Area_3_Encounter_7, Area_4_Encounter_1, Area_4_Encounter_3, Area_4_StartPop_Path, A4_EncStartPop_monitor, A4_EncDespawnPop_monitor, Area_4B_Encounter_1, Area_4B_Encounter_2, Area_4B_Encounter_3, Area_4B_Encounter_4, Area_4B_Encounter_6, Area_5_Encounter_1, Enemy_HealthMonitor
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  Area_1_Fight_1()
  Area_1_Fight_2()
  Area_1_Fight_3()
  Area_2_Fight_1()
  Area_3_Fight_1()
  Area_3_Fight_2()
  Area_3_Fight_3()
  Area_3_Fight_5()
  Area_3_Fight_7()
  Area_4_Fight_1()
  Area_4_StartPop()
  Area_4B_Fight_6()
  Area_5_Fight_1()
end
function OnFirstStart(level, obj)
  Area_4_StartPop_Path:Start()
  GameObjects.EntZn_A1E2_AmbushTrigger:HideEntityVolume()
  GameObjects.EntZn_A4BE5_SpawnTest:HideEntityVolume()
  GameObjects.EntZn_A5E2_Spawn:HideEntityVolume()
  GameObjects.EntZn_A2E2__Spawn:HideEntityVolume()
  GameObjects.travelerFightCollision:HideCollision()
end
function OnStart(level, obj)
  GameObjects.EntZn_Area_3_Alert:HideEntityVolume()
  if Area_5_Encounter_1:WasRunning() then
    Area_5_Encounter_1:Start()
  end
  if Area_3_Encounter_1:WasRunning() then
    Area_3_Encounter_1:Start()
    if TravelerFightRestart == true then
      LD.CallFunctionAfterDelay(function()
        GameObjects.EntZn_Area_3_Alert:ShowEntityVolume()
      end, 3)
    end
  end
end
function OnUpdate(level, obj)
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  Area_4_StartPop_Path:DespawnEnemies()
  uiCalls.UI_Event_SendDesignerMessage(TravelerFightRestart, 4)
  if TravelerFightRestart == true then
    LD.CallFunctionAfterDelay(function()
      GameObjects.EntZn_Area_3_Alert:ShowEntityVolume()
    end, 3)
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    levelState = checkpoint.Save(),
    TravelerFightRestart = TravelerFightRestart
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  TravelerFightRestart = savedInfo.TravelerFightRestart
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Tower 01 climb Hel_R_100", {CheckpointOnComplete = true})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Helwalker_SH_PL2_SLVD",
      spawnLocators = "A1_U_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Attack)
  Area_1_Encounter_1:OnComplete(GameObjects.Btr_HelR100.LuaObjectScript.FirstEncounterDone)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Shield")
  end)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Tower 01 Chest Spawn Hel_R_100", {CheckpointOnComplete = true})
  A1_Enc2_monitor = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_A1E3_AmbushTrigger)
  A1_Enc2_monitor:SetTriggerCountLimit(1)
  A1_Enc2_monitor:OnEnter(function()
    GameObjects.EntZn_A1E2_AmbushTrigger:ShowEntityVolume()
  end)
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Helwalker_SH_PL2_SLVD",
      spawnLocators = "A1_U_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
end
function Area_1_Fight_3()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Tower 01 Ambush Hel_R_100", {CheckpointOnComplete = true})
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Helwalker_PL2_S_Sprint",
      spawnLocators = "A1_O_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0, 0}
    }
  })
  Area_1_Encounter_3:OnComplete(function()
    GameObjects.EntZn_A1E2_AmbushTrigger:ShowEntityVolume()
  end)
end
function Start_A1E3()
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Nav to Tower 02 Hel_R_100", {CheckpointOnComplete = true})
  Area_2_Encounter_1:AddWave({
    timeBeforeNextWave = 3,
    {
      spawners = "Fanatic_HB_PL3_SRFC",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.7
    },
    {
      spawners = "Fanatic_HB_PL3_SRFC",
      spawnLocators = "A2_O_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8
    },
    {
      spawners = "Flyer00_PL4_SFG",
      spawnLocators = "A2_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Fanatic_HB_PL2_SRPT",
      spawnLocators = "A2_B_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Helwalker_PL2_S_SRFL",
      spawnLocators = "A2_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_2_Attack)
  Area_2_Encounter_1:OnCombatStart(function()
    game.Audio.StartCheckpointedMusic("SND_MX_HEL_tower1_fight_in")
  end)
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Bomber")
    game.Audio.StartMusic("SND_MX_HEL_tower1_fight_out")
  end)
end
function ShowA2E2_StartZone()
  GameObjects.EntZn_A2E2__Spawn:ShowEntityVolume()
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:1 Gate Puzzle Hel_R_100", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_HEL_tower2_fight_in",
    StopMusic = "SND_MX_HEL_tower2_fight_out"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Traveler_Beserker_UIC",
      spawnLocators = "A3_O_Loc_1",
      markerID = "HelR100_Traveler_ID",
      spawnWad = "HelR100_AI_Docks01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_1:SetStartZone(GameObjects.EntZn_Area_3_Attack)
  Area_3_Encounter_1:SetAlertZone(GameObjects.EntZn_Area_3_Alert)
  Area_3_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Traveler")
  end)
  Area_3_Encounter_1:OnComplete(function()
    GameObjects.travelerFightCollision:HideCollision()
  end)
end
function Area_3_Fight_2()
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 3]EC:2 Secret Drop 1", {CheckpointOnComplete = true})
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Helwalker_PL2_S_SDBR2",
      spawnWad = "HelR100_AI_Docks01",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {1, 3}
    }
  })
  Area_3_Encounter_2:SetStartZone(GameObjects.EntZn_A3E2__Spawn)
  Area_3_Encounter_2:SetAlertZone(GameObjects.EntZn_A3E2__Alert)
end
function Area_3_Fight_3()
  Area_3_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 3]EC:3 Chest Protector", {CheckpointOnComplete = false})
  Area_3_Encounter_3:AddWave({
    {
      spawners = "Fanatic_HB_PL2_SRPT",
      spawnLocators = "A3_B_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0, 0}
    }
  })
end
function Area_3_Fight_5()
  Area_3_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 3]EC:5 Secret Chest", {CheckpointOnComplete = true})
  Area_3_Encounter_5:AddWave({
    {
      spawners = "Helwalker_N_SRFL",
      spawnLocators = "A3_C_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {1, 3}
    }
  })
  Area_3_Encounter_5:SetStartZone(GameObjects.EntZn_A3E5_Spawn)
end
function Area_3_Fight_7()
  Area_3_Encounter_7 = EC.NewEncounter(thisLevel, "[Area 3]EC:7 Secret Drop 2", {CheckpointOnComplete = true})
  Area_3_Encounter_7:AddWave({
    {
      spawners = "Helwalker_SH_PL3_SLVD",
      spawnLocators = "A3_B_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {1, 2},
      spawnCooldown = {1, 3}
    },
    {
      spawners = "Flyer00_PL2_SFG",
      spawnLocators = "A3_B_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks01",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {1, 2},
      spawnCooldown = {1, 3}
    }
  })
end
function Area_4_Fight_1()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 4]EC:1 Nav Path to Boat Hel_R_100", {CheckpointOnComplete = true, LockCombatState = true})
  Area_4_Encounter_1:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "Flyer00_PL4_SFG",
      spawnLocators = "A4_O_Loc_6",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Flyer00_PL4_SFG",
      spawnLocators = "A4_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Fanatic_HB_PL4_SRFC",
      spawnLocators = "A4_O_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBeforeNextWave = 15,
    {
      spawners = "Brawler_HW_PL5_SFG",
      spawnWad = "HelR100_AI_Docks02",
      markerID = "Brawler_A4E1_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Fanatic_HB_PL4_SRFC",
      spawnLocators = "A4_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    },
    {
      spawners = "Helwalker_SH_PL2_SCFL",
      spawnLocators = "A4_E_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR300_HelShip",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_4_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Brawler_HW_PL5_SRFE",
      spawnWad = "HelR100_AI_Docks02",
      markerID = "Brawler_A4E1_02",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
  Area_4_Encounter_1:SetStartZone(GameObjects.EntZn_A4E1__Spawn)
  Area_4_Encounter_1:SetAlertZone(GameObjects.EntZn_A4E1__Alert)
  Area_4_Encounter_1:OnEnemySpawn(Brawler_Health_Monitor01, {
    markerID = "Brawler_A4E1_01"
  })
  Area_4_Encounter_1:OnComplete(GameObjects.Btr_HelR100.LuaObjectScript.PreBoatEncounterDone)
  Area_4_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Brawler")
  end)
  Area_4_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Ice")
  end)
  Area_4_Encounter_1:OnCombatStart(function()
    local soundLevel = game.FindLevel("HelR050_Sound")
    if soundLevel ~= nil then
      soundLevel:CallScript("PlayDockExploreMusic")
    end
  end)
end
function Brawler_Health_Monitor01(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.85
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_4_Encounter_1:StartWave(4)
    end)
  end
end
function Area_4_StartPop()
  Area_4_StartPop_Path = EC.NewEncounter(thisLevel, "[Area 4]EC: Population Filler", {CheckpointOnComplete = false})
  A4_EncDespawnPop_monitor = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_A2E2__DeSpawn_A4PopFill)
  A4_EncDespawnPop_monitor:SetTriggerCountLimit(1)
  A4_EncDespawnPop_monitor:OnEnter(function()
    Area_4_StartPop_Path:DespawnEnemies()
  end)
  Area_4_StartPop_Path:AddWave({
    {
      spawners = "Helwalker_UIC_A4A_Path2",
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {1, 3}
    },
    {
      spawners = "Helwalker_S_UIC_A3_Path1",
      spawnWad = "HelR100_AI_Docks01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {1, 3}
    }
  })
end
function Area_4B_Fight_6()
  Area_4B_Encounter_6 = EC.NewEncounter(thisLevel, "[Area 4B]EC:6 Tripple Chest Triple Threat Ambush", {CheckpointOnComplete = true})
  Area_4B_Encounter_6:AddWave({
    {
      spawners = "Flyer00_PL4_SFG",
      spawnLocators = "A4B_O_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Flyer00_PL4_SFG",
      spawnLocators = "A4B_O_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Fanatic_HB_PL3_SRFC",
      spawnLocators = "A4B_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_4B_Encounter_6:SetStartZone(GameObjects.EntZn_A4BE5_SpawnTest)
end
function Area_4B_TripleChest_Enc_Start()
  GameObjects.EntZn_A4BE5_SpawnTest:ShowEntityVolume()
end
function Area_5_Fight_1()
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 5]EC:1 Dual Ice Witch", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_A5_WitchZone"
  })
  Area_5_Encounter_1:AddWave({
    pointMarkerID = "Enemy",
    {
      spawners = "Witch20_Ice_SRFC",
      spawnLocators = "A5_W_Loc1",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    },
    {
      spawners = "Witch20_Ice_SRFC",
      spawnLocators = "A5_W_Loc2",
      useSpawnLocatorsOnly = true,
      spawnWad = "HelR100_AI_Docks03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 16
    }
  })
  Area_5_Encounter_1:OnComplete(function()
    GameObjects.EntZn_A5E2_Spawn:ShowEntityVolume()
    GameObjects.Btr_HelR100.LuaObjectScript.WitchFightEncounterDone()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Ice")
  end)
  Area_5_Encounter_1:OnEnemyDeath(function(enemy)
    if enemy:InsideZone(GameObjects.ElevatorUnderZone) then
      _G.OnZoneExit()
      enemy:RemoveMarker("Enemy")
    end
  end, {markerID = "Enemy"})
end
function Start_A3E3()
  Area_3_Encounter_3:Start()
  Area_3_Encounter_3:AlertEnemies()
end
function Start_A3E2()
  Area_3_Encounter_2:Start()
end
function Alert_A3E1()
  TravelerFightRestart = true
  LD.CallFunctionAfterDelay(function()
    GameObjects.EntZn_Area_3_Alert:ShowEntityVolume()
  end, 3)
  GameObjects.travelerFightCollision:ShowCollision()
end
function Start_A4BE5()
end
function Start_IceWitch_Fight()
  Area_5_Encounter_1:Start()
end
function A3TraverlerDoorShowAlert()
  LD.CallFunctionAfterDelay(function()
    GameObjects.EntZn_Area_3_Alert:ShowEntityVolume()
  end, 1)
end
