local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, baldurActor, baldurGhostProp, freyaGhostProp, knifeProp, kraActor, cineSeq
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") < 494 then
    SetupActors()
  end
  game.SubObject.Sleep(thisObj)
end
function OnPreStart(level, obj)
  SetupProps()
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 494 and game.Player.FindPlayer():IsInsideEntityZone(thisObj) then
    SetupCineSequence()
  end
end
function SpawnBaldur01()
  local jointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex("Bldr01_StartJoint"))
  local jointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("Bldr01_StartJoint"))
  return game.AI.Spawn(thisLevel, jointPos, jointFace, "CRT_Baldur00", {AggroState = "NonHostile"})
end
function SetupActors()
  baldurActor = actor.Actor.New("PAST HAUNTS BALDUR: Baldur 01 Actor")
  kraActor = actor.Actor.New("PAST HAUNTS BALDUR: Kratos Actor", game.Player.FindPlayer)
  baldurActor:SetSpawnFunction(SpawnBaldur01)
end
function SetupProps()
  baldurGhostProp = thisObj:FindSingleGOByName("BaldurProp").Child
  freyaGhostProp = thisObj:FindSingleGOByName("FreyaProp").Child
  knifeProp = thisObj:FindSingleGOByName("baldurKnifeHallucinationProp").Child
  HideProps()
end
function HideProps()
  baldurGhostProp:Hide()
  freyaGhostProp:Hide()
  knifeProp:Hide()
end
function ShowProps()
  baldurGhostProp:Show()
  freyaGhostProp:Show()
  knifeProp:Show()
end
function AddVOMarkers()
  baldurGhostProp:AddMarker("GBaldur")
  freyaGhostProp:AddMarker("GFreya")
end
function SetupCineSequence()
  if not cineSeq then
    cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Past Haunts Baldur Sequence")
    local preSlaveTab = {
      {
        Obj = baldurGhostProp,
        Anim = "narHelPastHauntsBaldur000Idle"
      },
      {
        Obj = freyaGhostProp,
        Anim = "narHelPastHauntsBaldur000Idle"
      },
      {
        Obj = knifeProp,
        Anim = "narHelPastHauntsBaldur000Idle"
      }
    }
    local slaveTab = {
      {
        Obj = baldurGhostProp,
        Anim = "narHelPastHauntsBaldur010Cine"
      },
      {
        Obj = freyaGhostProp,
        Anim = "narHelPastHauntsBaldur010Cine"
      },
      {
        Obj = knifeProp,
        Anim = "narHelPastHauntsBaldur010Cine"
      }
    }
    cineSeq:SpawnActorAndWait(baldurActor)
    cineSeq:Do(ShowProps)
    cineSeq:WaitSeconds(0.2)
    cineSeq:Do(AddVOMarkers)
    cineSeq:ActorSync(baldurActor, {
      Slaves = preSlaveTab,
      Branch = "BRA_PastHauntsBaldurPreIdle",
      ReferenceJoint = "SynchJoint_PastHauntsBaldur"
    })
    cineSeq:WaitForActorInZone(kraActor, "CineZone_PastHauntsBaldur")
    cineSeq:ActorSync(baldurActor, {
      Slaves = slaveTab,
      Branch = "BRA_PastHauntsBaldurCine",
      ReferenceJoint = "SynchJoint_PastHauntsBaldur"
    })
    cineSeq:Do(function()
      game.Audio.PlayBanter("080_PastHauntsBaldur")
    end)
    cineSeq:WaitForFunctionTrue(function()
      return baldurActor:GetCreature():IsPlayingMove("MOV_PastHauntsBaldurPostIdle")
    end)
    cineSeq:Do(HideProps)
    cineSeq:WaitForActorInZone(kraActor, "DespawnZone_PastHauntsBaldur")
    cineSeq:DespawnActor(baldurActor)
    cineSeq:SetCompletedCineNumber(494)
    cineSeq:Do(function()
      BOOKMARK_28_HelheimR_015_AfterBaldurScene()
    end)
    cineSeq:StartSequence()
  end
end
function BOOKMARK_28_HelheimR_015_AfterBaldurScene()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "28_HelheimR_015_AfterBaldurScene"]
  tableEntry.OverrideObject = GameObjects.CO_AfterBaldurScene
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
