local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local thisObj, thisLevel, sonActor, sonProp, modiProp, knifeProp
local poiPlayed = false
local camState
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  camState = 1
end
function OnStart(level, obj)
  SetupProps()
  if not poiPlayed then
    SetupActor()
  end
  game.SubObject.Sleep(thisObj)
end
function OnUpdate(level)
  SubmitPastHauntsSonCamera()
end
function OnSaveCheckpoint(level, obj)
  return {played = poiPlayed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  poiPlayed = savedInfo.played
end
function SetupActor()
  sonActor = actor.Actor.New("PAST HAUNTS SON: Son Actor", game.AI.FindSon)
end
function SetupProps()
  modiProp = thisObj:FindSingleGOByName("modiHallucinationProp").Child
  sonProp = thisObj:FindSingleGOByName("sonHallucinationProp").Child
  knifeProp = thisObj:FindSingleGOByName("sonKnifeHallucinationProp").Child
  modiProp:StartAnimation({
    Animation = "poiHelRPastHauntsSon"
  })
  modiProp:JumpAnimationToFrame(0)
  modiProp:PauseAnimation()
  sonProp:StartAnimation({
    Animation = "poiHelRPastHauntsSon1"
  })
  sonProp:JumpAnimationToFrame(0)
  sonProp:PauseAnimation()
  knifeProp:StartAnimation({
    Animation = "poiHelRPastHauntsSon"
  })
  knifeProp:JumpAnimationToFrame(0)
  knifeProp:PauseAnimation()
  AddVOMarkers()
  HideProps()
end
function HideProps()
  modiProp:Hide()
  sonProp:Hide()
  knifeProp:Hide()
end
function ShowProps()
  modiProp:Show()
  sonProp:Show()
  knifeProp:Show()
end
function AddVOMarkers()
  modiProp:AddMarker("GModi")
  sonProp:AddMarker("GSon")
end
function SetupPOISequence()
  local poiSeq, slaveTab
  if not poiPlayed then
    poiSeq = ND.CreateCineSequence(thisLevel, thisObj, "Past Haunts Son Sequence")
    slaveTab = {
      {
        Obj = sonProp,
        Anim = "poiHelRPastHauntsSon1"
      },
      {
        Obj = modiProp,
        Anim = "poiHelRPastHauntsSon"
      },
      {
        Obj = knifeProp,
        Anim = "poiHelRPastHauntsSon"
      }
    }
    poiSeq:Do(InitializeDesignerCamera)
    poiSeq:StartPOIMoment(1.5)
    poiSeq:WaitForActorFinishMove(sonActor, "MOV_LiftDoor")
    poiSeq:WaitSeconds(1)
    poiSeq:ActorForceApproachAndWait(sonActor, {
      Branch = "BRA_PastHauntsSon",
      ReferenceJoint = "PastHauntsSon_SynchJoint",
      speed = ND.SonWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kRight,
      radius = ND.SonWalkArrivalRadius,
      ignore_navmesh = true
    })
    poiSeq:Do(ShowProps)
    poiSeq:Do(function()
      GameObjects.CA_LiftDoorHelper.LuaObjectScript.Disable()
    end)
    poiSeq:ActorSync(sonActor, {
      Slaves = slaveTab,
      Branch = "BRA_PastHauntsSon",
      ReferenceJoint = "PastHauntsSon_SynchJoint"
    })
    poiSeq:WaitForActorPuppeteerComplete(sonActor)
    poiSeq:EndPOIMoment()
    poiSeq:StopPuppetingActor(sonActor)
    poiSeq:Do(HideProps)
    poiSeq:Do(function()
      poiPlayed = true
      game.Compass.SetDesignerForcedHide(false)
      GameObjects.TraversePath16:ShowTraversePath()
      GameObjects.CD_HullsForPastHaunts:Hide()
      DisableOnUpdate()
      StartEncounter()
      BOOKMARK_28_HelheimR_005_AfterPastHauntsSon()
    end)
    poiSeq:StartSequence()
  end
end
function BOOKMARK_28_HelheimR_005_AfterPastHauntsSon()
  local checkpointParams = {}
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "28_HelheimR_005_AfterPastHauntsSon"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function DisableOnUpdate()
  game.SubObject.Sleep(thisObj)
end
function StartEncounter()
  GameObjects.Cbt_HelR100_Script.LuaObjectScript.ShowA2E2_StartZone()
end
function InitializeDesignerCamera()
  game.SubObject.Wake(thisObj)
  timers.StartLevelTimer(5.6, function()
    camState = 2
  end)
  timers.StartLevelTimer(19.3, function()
    camState = 3
  end)
end
function SubmitPastHauntsSonCamera()
  if camState == 1 then
    game.Camera.SubmitCameraByName("PLYR_NAR_PastHauntsSon_010_Base")
  elseif camState == 2 then
    game.Camera.SubmitCameraByName("PLYR_NAR_PastHauntsSon_010_Base")
    game.Camera.SubmitCameraByName("PLYR_NAR_PastHauntsSon_020_Base")
  elseif camState == 3 then
    game.Camera.SubmitCameraByName("PLYR_NAR_PastHauntsSon_020_Base")
    game.Camera.SubmitCameraByName("PLYR_NAR_PastHauntsSon_030_Base")
  end
end
