LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
local EC = require("design.Encounter")
monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
checkpoint = require("level.checkpoint")
player = nil
trollDeathMonitor = nil
local camFirstHookSequenceActive = false
local camSecondChainSlowdown = false
local camFirstHook = false
local camShowHookDisableDelayTimer = timer.StartLevelTimer(4)
camShowHookDisableDelayTimer:Stop()
local impactDelayTimer = timer.StartLevelTimer(0.9)
impactDelayTimer:Stop()
local camShowHookStartDelayTimer = timer.StartLevelTimer(2)
camShowHookStartDelayTimer:Stop()
impactCamShake = {
  EffectName = "FSE_shake_Temp_Generic_Giant",
  Duration = 1.4
}
impactRumble = {EffectName = "FFB_LARGE", Duration = 1.4}
local concussionParams, concussionParams2
local eagleInSecondPos = false
local shipScript
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  concussionParams = {
    Tweak = "CNC_GLOBAL_KNOCK_DOWN",
    WorldLocation = player.WorldPosition,
    Creature = player:GetCreature(),
    EnemyId = player:GetID()
  }
  concussionParams2 = {
    Tweak = "CNC_GLOBAL_KNOCK_DOWN_AI",
    WorldLocation = player.WorldPosition,
    Creature = player:GetCreature(),
    EnemyId = player:GetID()
  }
end
function OnStart(level)
  if eagleInSecondPos then
    SnapEagleToSecondPosition()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 498 then
    GameObjects.worldVisuals:JumpAnimToPercent(1)
    Teleport_Monolith(level)
  end
end
function OnFirstStart(level)
  GameObjects.MeshBreak.Child:PauseAnim()
  GameObjects.AnimateWind:PlayAnimToEnd()
  GameObjects.worldVisuals:PauseAnim()
  HideGhosts()
  GameObjects.FirstLoad_Caldera_Zone:HideEntityVolume()
end
function OnUpdate(level)
  if game.Level.GetVariable("InStopZone1") == true and camFirstHook == false then
    impactDelayTimer:Start()
    camShowHookDisableDelayTimer:Start()
    camShowHookStartDelayTimer:Start()
    camFirstHook = true
  end
  if impactDelayTimer.fired == true then
    game.Combat.PlayConcussion(concussionParams)
    game.Combat.PlayConcussion(concussionParams2)
    game.FX.SubmitEffect(impactCamShake)
    game.FX.SubmitEffect(impactRumble)
    game.Level.SetVariable("bImpactSlowdown", true)
    impactDelayTimer:Reset()
    impactDelayTimer:Stop()
  end
  if camShowHookStartDelayTimer.fired == true and camShowHookDisableDelayTimer.fired == false then
    if camSecondChainSlowdown == false then
      game.Level.SetVariable("bHighlightSlowdown", true)
      impactDelayTimer:Start()
      camSecondChainSlowdown = true
    end
    game.Camera.SubmitCameraByName("PLYR_Vista_HelChain_Intro")
  end
end
function AnimateFogFWD(level)
end
function AnimateFogRV(level)
end
function HitTower()
  GameObjects.FightPlatforms:PlayAnimToEnd()
  GameObjects.tower:PlayAnimToEnd()
end
function GoGhosts()
  GameObjects.anim_Section4_SlowDelay2:PlayAnimCycle()
end
function ShowGhosts()
  GameObjects.anim_Section4_SlowDelay2:Show()
end
function HideGhosts()
  GameObjects.anim_Section4_SlowDelay2:Hide()
end
function BreakBridge_01()
  GameObjects.MeshBreak.Child:PlayAnimToEnd()
  StaggerPlayer()
  AddScreenShakeAndControllerRumble()
  LD.CallFunctionAfterDelay(function()
    SnapEagleToSecondPosition()
  end, 8)
  GetShipScript():CallScript("PlayBridgeFogRemote")
  GetShipScript():CallScript("BridgeSmashRemote")
end
function StaggerPlayer()
  player:TriggerMoveEvent("kLE_HelheimShipCollision_Stagger")
end
function BreakGate_01()
  AddScreenShakeAndControllerRumble()
  GetShipScript():CallScript("PlaySoundShipImpact", "BIG")
  game.Audio.PlayBanter("180_LowBridge_Miss")
  GetShipScript():CallScript("GateSmashRemote")
end
function SnapEagleToSecondPosition()
  eagleInSecondPos = true
  local referenceJoint = GameObjects.Eagle_Background:GetJointIndex("pos_end")
  local refJointPos = GameObjects.Eagle_Background:GetWorldJointPosition(referenceJoint)
  local refJointFacing = GameObjects.Eagle_Background:GetWorldJointForward(referenceJoint)
  GameObjects.helheimEagle00_P:SetWorldPosition(refJointPos)
  GameObjects.helheimEagle00_P:SetWorldFacing(refJointFacing)
  GameObjects.helheimEagle00.LuaObjectScript.CycleIdleLoop()
end
function SnapEagleToPerch()
  eagleInSecondPos = false
  local referenceJoint = GameObjects.Eagle_Background:GetJointIndex("pos_start")
  local refJointPos = GameObjects.Eagle_Background:GetWorldJointPosition(referenceJoint)
  local refJointFacing = GameObjects.Eagle_Background:GetWorldJointForward(referenceJoint)
  GameObjects.helheimEagle00_P:SetWorldPosition(refJointPos)
  GameObjects.helheimEagle00_P:SetWorldFacing(refJointFacing)
  GameObjects.helheimEagle00.LuaObjectScript.CycleAwareLoop()
end
function BreakIce_01()
  LD.BreakObject(GameObjects.IceKnives)
  AnimateWorld_SlowdownLong()
  StaggerPlayer()
  print("Break the ice")
  AddScreenShakeAndControllerRumble()
  GetShipScript():CallScript("PlaySoundShipImpact", "BIG")
  GetShipScript():CallScript("StaggerEnemies")
end
function ShowFirstLoadZone()
  GameObjects.FirstLoad_Caldera_Zone:ShowEntityVolume()
end
function FogToBringEagleBack()
  LD.CallFunctionAfterDelay(function()
    SnapEagleToPerch()
  end, 15)
  GetShipScript():CallScript("FogToBringEagleBackRemote")
end
function GetShipScript()
  if shipScript == nil then
    local helR300 = game.FindLevel("HelR300_HelShip")
    if helR300 ~= nil then
      shipScript = helR300:FindSingleGameObject("HelheimShipScript")
    end
  end
  return shipScript
end
function AddScreenShakeAndControllerRumble()
  local shakeParams = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 0.5
  }
  game.FX.SubmitEffect(shakeParams)
  LD.AddControllerRumble({EffectName = "FFB_GIANT", Duration = 0.5})
  LD.AddControllerRumble({
    EffectName = "FFB_SMALLER",
    Duration = 1.5
  })
end
function ZoneReport_Sky()
  uiCalls.UI_Event_DiscoverLocation("Helheim Sky")
  print("Sky Zone Report")
end
function ShowFinalMonolith()
  GameObjects.FinalMonolithProxy:Show()
end
function HideMonolithProxy()
  GameObjects.FinalMonolithProxy:Hide()
end
function MonolithProxyAnim()
  GameObjects.FinalMonolithProxy:PlayAnimCycle()
end
function MonolithProxyAnimStop()
  GameObjects.FinalMonolithProxy:PlayAnimToFrame(1, -1)
end
function HideShips()
  GameObjects.ships:Hide()
end
function AnimateWorld_Pause(level)
  GameObjects.AnimateWind:PlayAnimToEnd(-1)
  GameObjects.worldVisuals:PauseAnim()
end
function AnimateWorld_Forward(level)
  GameObjects.AnimateWind:PlayAnimToEnd()
  GameObjects.worldVisuals:PlayAnimToEnd(0.25)
end
function AnimateWorld_ForwardFast(level)
  GameObjects.AnimateWind:PlayAnimToEnd()
  GameObjects.worldVisuals:PlayAnimToEnd(0.5)
end
function AnimateWorld_Slowdown(level)
  GameObjects.worldVisuals:PlayAnimToEnd(0.15)
  LD.CallFunctionAfterDelay(function()
    GameObjects.worldVisuals:PlayAnimToEnd(0.25)
  end, 5)
end
function AnimateWorld_SlowdownLong(level)
  GameObjects.worldVisuals:PlayAnimToEnd(0.1)
  LD.CallFunctionAfterDelay(function()
    GameObjects.worldVisuals:PlayAnimToEnd(0.25)
  end, 10)
end
function AnimateWorld_JumpToFrame(level, frame)
  GameObjects.worldVisuals:Show()
  GameObjects.AnimateWind:JumpAnimToFrame(frame)
  GameObjects.worldVisuals:JumpAnimToFrame(frame)
  GameObjects.worldVisuals:PlayAnimToEnd(0.25)
  GameObjects.AnimateWind:PlayAnimToEnd()
end
function Teleport_Monolith(Level)
  local finalWarpObject = GameObjects.WarpLocation_FinalBattle
  local xDistance = finalWarpObject:GetWorldPosition().x
  local zDistance = finalWarpObject:GetWorldPosition().z
  GameObjects.WorldVisuals_Art:Hide()
  local monolithPos = GameObjects.FinalMonolithProxy:GetWorldPosition()
  local newPos = engine.Vector.New(monolithPos.x + xDistance, monolithPos.y + 20, monolithPos.z + zDistance)
  GameObjects.FinalMonolithProxy:SetWorldPosition(newPos)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    eagleInSecondPos = eagleInSecondPos
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  eagleInSecondPos = savedInfo.eagleInSecondPos
end
