local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, kraActor, sonActor, zeusProp, kraProp
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  SetupActorsAndProps()
end
function SetupActorsAndProps()
  kraActor = actor.Actor.New("PAST HAUNTS KRATOS: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("PAST HAUNTS KRATOS: Son Actor", game.AI.FindSon)
  kraProp = thisObj:FindSingleGOByName("youngKratosProp").Child
  zeusProp = thisObj:FindSingleGOByName("zeusProp").Child
  kraProp:Hide()
  zeusProp:Hide()
end
function SetupCineSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Past Haunts Kratos Sequence")
  local slaveTab = {
    {Actor = sonActor}
  }
  cineSeq:Do(CinematicComplete_StartWorldAnimation)
  cineSeq:Do(function()
    print("Sequence Started")
  end)
  cineSeq:Do(function()
    kraProp:Show()
    kraProp:StartAnim("narHelPastHauntsKratos000CineScene")
    zeusProp:Show()
    zeusProp:StartAnim("narHelPastHauntsKratos000CineScene")
  end)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_PastHauntsKratos",
    ReferenceJoint = "PastHauntsKratos_SynchJoint"
  })
  cineSeq:WaitForActorPuppeteerComplete(kraActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(function()
    kraProp:Hide()
    zeusProp:Hide()
  end)
  cineSeq:SetCompletedCineNumber(496)
  cineSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  cineSeq:StartSequence()
end
function CinematicComplete_StartWorldAnimation()
  LD.CallFunctionAfterDelay(function()
    local helr200 = game.FindLevel("HelR200_BoatRide")
    if helr200 ~= nil then
      helr200:CallScript("AnimateWorld_Forward")
    end
  end, 30)
end
