local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
checkpoint = require("level.checkpoint")
actor = require("narrative.actor")
local thisLevel, player, debugCallback, kratosActor, sonActor
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
end
function OnPassiveSpawned(level, passive)
  GameObjects.HelheimShipScript.LuaObjectScript.OnPassiveSpawned(level, passive)
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_HelR200_BoatRide" and debugCallback ~= nil then
    debugCallback()
    debugCallback = nil
  end
  GameObjects.HelheimShipScript.LuaObjectScript.OnWadLoaded(level, newLevel)
end
function WatchForHel200Load(fn)
  debugCallback = fn
end
function OnFirstStart(level)
  GameObjects.FX_HelR100:PauseAnim()
  TurnFogOff()
end
function OnStart(level)
  DisableBoatMovingAmbience()
  FlyingBoatJumpCineInactive()
  GameObjects.FX_ZeusVignette:Hide()
  GameObjects.ShipToHideWarp:Hide()
end
function OnUpdate(level)
  CameraUpdate()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function CameraUpdate()
  if player:HasMarker("TnF") and game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_BuckleLookUp") then
    game.Camera.SubmitCameraByName("ENV_TnF_Hel_BuckleLookUp")
  end
end
function FlyingBoatJumpCineInactive()
  GameObjects.ZeusBlockProp.Child:Hide()
  GameObjects.Cine_Start_498:Hide()
end
function FlyingBoatJumpCineActive()
  GameObjects.ZeusBlockProp.Child:Show()
  GameObjects.Cine_Start_498:Show()
end
function RemoteBowBreak()
  LD.BreakObject(GameObjects.BowBreak_Breakable)
end
function TurnFogOn()
  GameObjects.FX_HelR100:ShowTriggerVolume()
  GameObjects.FX_HelR100:ShowEntityVolume()
  GameObjects.FX_HelR100:ShowParticles()
  GameObjects.FX_HelR100:ShowParticleEmitter()
end
function TurnFogOff()
  GameObjects.FX_HelR100:HideTriggerVolume()
  GameObjects.FX_HelR100:HideEntityVolume()
  GameObjects.FX_HelR100:HideParticles()
  GameObjects.FX_HelR100:HideParticleEmitter()
end
function FirstFog()
  GameObjects.FX_HelR100:PlayAnimToFrame(7)
  LD.CallFunctionAfterDelay(function()
    TurnFogOn()
  end, 1.65)
end
function Harpoon01_KratosSync()
  local refJoint, sonRefJoint, harpBranch, playerPosition
  if playerPosition == nil then
    playerPosition = player.WorldPosition
  end
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.4}
  })
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon01_010") then
    refJoint = "SyncJoint_Harpoon01_goTo_010"
    sonRefJoint = "SyncJoint_Harpoon01_goTo_030"
    harpBranch = "BRA_temp_HarpoonImpact_01"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon01_020") then
    refJoint = "SyncJoint_Harpoon01_goTo_020"
    sonRefJoint = "SyncJoint_Harpoon01_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_01"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon01_030") then
    refJoint = "SyncJoint_Harpoon01_goTo_030"
    sonRefJoint = "SyncJoint_Harpoon01_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_01"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon01_040") then
    refJoint = "SyncJoint_Harpoon01_goTo_040"
    sonRefJoint = "SyncJoint_Harpoon01_goTo_060"
    harpBranch = "BRA_temp_HarpoonImpact_01"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon01_050") then
    refJoint = "SyncJoint_Harpoon01_goTo_050"
    sonRefJoint = "SyncJoint_Harpoon01_goTo_060"
    harpBranch = "BRA_temp_HarpoonImpact_01_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon01_060") then
    refJoint = "SyncJoint_Harpoon01_goTo_060"
    sonRefJoint = "SyncJoint_Harpoon01_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_01_Far"
  end
  if refJoint ~= nil then
    kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
    sonActor = actor.Actor.New("Son", game.AI.FindSon)
    local seq = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_Harpoon01, "harpoon01_Stagger01_Seq")
    seq:ActorSync(kratosActor, {
      Branch = harpBranch,
      ReferenceJoint = refJoint,
      ReferenceJointOn = 0.01,
      ReferenceJointTweenTime = 0.6
    })
    seq:StartSequence()
    local seqSon = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_Harpoon01, "harpoon01_Stagger01_SeqSon")
    seqSon:ActorSync(sonActor, {
      Branch = "BRA_Son_Harpoon_Warp",
      ReferenceJoint = sonRefJoint,
      DampingLevel = game.Puppeteer.DampingLevel.kSlow
    })
    seqSon:WaitForActorFinishMove(sonActor, "MOV_Son_Harpoon_Warp")
    seqSon:StopPuppetingActor(sonActor)
    seqSon:StartSequence()
  end
  print("CAMERA: Harpoon1 Reference Joint: ", refJoint)
  print("CAMERA: Harpoon1 Son Reference Joint: ", sonRefJoint)
end
function Harpoon02_KratosSync()
  local refJoint, sonRefJoint, harpBranch, playerPosition
  if playerPosition == nil then
    playerPosition = player.WorldPosition
  end
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.4}
  })
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon02_000") then
    refJoint = "SyncJoint_Harpoon02_goTo_000"
    sonRefJoint = "SyncJoint_Harpoon02_goTo_010"
    harpBranch = "BRA_temp_HarpoonImpact_02"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon02_000")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon02_005") then
    refJoint = "SyncJoint_Harpoon02_goTo_005"
    sonRefJoint = "SyncJoint_Harpoon02_goTo_020"
    harpBranch = "BRA_temp_HarpoonImpact_02"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon02_005")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon02_010") then
    refJoint = "SyncJoint_Harpoon02_goTo_010"
    sonRefJoint = "SyncJoint_Harpoon02_goTo_030"
    harpBranch = "BRA_temp_HarpoonImpact_02"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon02_010")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon02_020") then
    refJoint = "SyncJoint_Harpoon02_goTo_020"
    sonRefJoint = "SyncJoint_Harpoon02_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_02"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon02_020")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon02_030") then
    refJoint = "SyncJoint_Harpoon02_goTo_030"
    sonRefJoint = "SyncJoint_Harpoon02_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon02_030")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon02_040") then
    refJoint = "SyncJoint_Harpoon02_goTo_040"
    sonRefJoint = "SyncJoint_Harpoon02_goTo_030"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon02_040")
  end
  if refJoint ~= nil then
    kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
    sonActor = actor.Actor.New("Son", game.AI.FindSon)
    local seq = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_Harpoon02, "harpoon02_Stagger01_Seq")
    seq:ActorSync(kratosActor, {
      Branch = harpBranch,
      ReferenceJoint = refJoint,
      ReferenceJointOn = 0.01,
      ReferenceJointTweenTime = 0.5
    })
    seq:StartSequence()
    local seqSon = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_Harpoon02, "harpoon02_Stagger01_SeqSon")
    seqSon:ActorSync(sonActor, {
      Branch = "BRA_Son_Harpoon_Warp",
      ReferenceJoint = sonRefJoint,
      DampingLevel = game.Puppeteer.DampingLevel.kSlow
    })
    seqSon:WaitForActorFinishMove(sonActor, "MOV_Son_Harpoon_Warp")
    seqSon:StopPuppetingActor(sonActor)
    seqSon:StartSequence()
  end
  print("CAMERA: Harpoon2 Reference Joint: ", refJoint)
  print("CAMERA: Harpoon2 Son Reference Joint: ", sonRefJoint)
end
function Harpoon03_KratosSync()
  local refJoint, harpBranch, sonRefJoint, playerPosition
  if playerPosition == nil then
    playerPosition = player.WorldPosition
  end
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.4}
  })
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_000") then
    refJoint = "SyncJoint_Harpoon03_goTo_000"
    sonRefJoint = "SyncJoint_Harpoon03_goTo_010"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon03_000")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_005") then
    refJoint = "SyncJoint_Harpoon03_goTo_005"
    sonRefJoint = "SyncJoint_Harpoon03_goTo_020"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon03_005")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_010") then
    refJoint = "SyncJoint_Harpoon03_goTo_010"
    sonRefJoint = "SyncJoint_Harpoon03_goTo_030"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon03_010")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_020") then
    refJoint = "SyncJoint_Harpoon03_goTo_020"
    sonRefJoint = "SyncJoint_Harpoon03_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon03_020")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_030") then
    refJoint = "SyncJoint_Harpoon03_goTo_030"
    sonRefJoint = "SyncJoint_Harpoon03_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon03_030")
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_040") then
    refJoint = "SyncJoint_Harpoon03_goTo_040"
    sonRefJoint = "SyncJoint_Harpoon03_goTo_030"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
    print("CAMERA: Harpoon Zone: CamZone_Harpoon03_040")
  end
  if refJoint ~= nil then
    kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
    sonActor = actor.Actor.New("Son", game.AI.FindSon)
    local seq = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_Harpoon03, "harpoon03_Stagger01_Seq")
    seq:ActorSync(kratosActor, {
      Branch = harpBranch,
      ReferenceJoint = refJoint,
      ReferenceJointOn = 0.01,
      ReferenceJointTweenTime = 0.5
    })
    seq:StartSequence()
    local seqSon = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_Harpoon03, "harpoon02_Stagger01_SeqSon")
    seqSon:ActorSync(sonActor, {
      Branch = "BRA_Son_Harpoon_Warp",
      ReferenceJoint = sonRefJoint,
      DampingLevel = game.Puppeteer.DampingLevel.kSlow
    })
    seqSon:WaitForActorFinishMove(sonActor, "MOV_Son_Harpoon_Warp")
    seqSon:StopPuppetingActor(sonActor)
    seqSon:StartSequence()
  end
  print("CAMERA: Harpoon2 Reference Joint: ", refJoint)
  print("CAMERA: Harpoon2 Son Reference Joint: ", sonRefJoint)
end
function Iceberg_KratosSync()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 2,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1},
    Priority = 2
  })
  game.Blender.Trigger({
    Name = "FSE_SHAKE_WATERWAKE_DRIFT_LEFT",
    Duration = 2,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1},
    Priority = 3
  })
  local refJoint, harpBranch, playerPosition
  if playerPosition == nil then
    playerPosition = player.WorldPosition
  end
  if game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_000") then
    refJoint = "SyncJoint_Iceberg_goTo_000"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_005") then
    refJoint = "SyncJoint_Iceberg_goTo_005"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_010") then
    refJoint = "SyncJoint_Iceberg_goTo_010"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_020") then
    refJoint = "SyncJoint_Iceberg_goTo_020"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_030") then
    refJoint = "SyncJoint_Iceberg_goTo_030"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_040") then
    refJoint = "SyncJoint_Iceberg_goTo_040"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_Harpoon03_050") then
    refJoint = "SyncJoint_Iceberg_goTo_050"
    harpBranch = "BRA_temp_HarpoonImpact_02_Far"
  end
  if refJoint ~= nil then
    kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
    local seq = LD.CreateCineSequence(thisLevel, GameObjects.SyncGroup_IceBerg, "Iceberg_Stagger01_Seq")
    seq:ActorSync(kratosActor, {
      Branch = harpBranch,
      ReferenceJoint = refJoint,
      ReferenceJointOn = 0.01,
      ReferenceJointTweenTime = 0.66
    })
    seq:StartSequence()
  end
  print("CAMERA: Reference Joint: ", refJoint)
end
function ZeusVoiceFX()
  GameObjects.FX_ZeusVignette:JumpAnimToFrame(0)
  GameObjects.FX_ZeusVignette:Show()
  GameObjects.FX_ZeusVignette:PlayAnimToFrame(90)
  LD.CallFunctionAfterDelay(function()
    GameObjects.FX_ZeusVignette:PlayAnimToFrame(0, -1)
  end, 6)
end
function ShipToHideWarp()
  GameObjects.ShipToHideWarp:Show()
  LD.CallFunctionAfterDelay(function()
    GameObjects.ShipToHideWarp:Hide()
  end, 1.2)
end
local HelR050
function EnableBoatMovingAmbience(level)
  CallScriptOnHelR050("HideSnowLightGrp")
  GameObjects.SNDSnowLightGrp:Show()
end
function DisableBoatMovingAmbience(level)
  CallScriptOnHelR050("ShowSnowLightGrp")
  GameObjects.SNDSnowLightGrp:Hide()
end
function CallScriptOnHelR050(func)
  if HelR050 == nil then
    HelR050 = game.FindLevel("HelR050_Sound")
  end
  if HelR050 ~= nil then
    HelR050:CallScript(func, thisLevel)
  end
end
