local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisObj, thisLevel, player, FightOne, FightTwo, FightThree, FightOne_Left, FightOne_Right, FightTwo_Left, FightTwo_Right, FightThree_Left, FightThree_Right, HarpoonFightOne, HarpoonFightTwo, HarpoonFightThree, Jotun_Reinforcements, allEncounters, Enemy_HealthMonitor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  FightOne()
  Harpoon_1()
  FightTwo()
  Harpoon_2()
  FightThree()
  Harpoon_3()
  allEncounters = {
    FightOne,
    FightTwo,
    FightThree,
    FightOne_Left,
    FightOne_Right,
    FightTwo_Left,
    FightTwo_Right,
    FightThree_Left,
    FightThree_Right,
    HarpoonFightOne,
    HarpoonFightTwo,
    HarpoonFightThree,
    Jotun_Reinforcements
  }
  SetupSyncSpawns()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function SetupSyncSpawns()
  for _, encounter in pairs(allEncounters) do
    encounter:OnEnemySpawn(SyncSpawn)
  end
end
function SyncSpawn(enemy, spawner, locator)
  local syncObject = locator or spawner
  local syncObjectName = syncObject.Parent:GetName()
  if string.find(syncObjectName, "ls_e_loc") or string.find(syncObjectName, "rs_e_loc") then
    LD.SyncAndPlayBranch(enemy, syncObject, spawner.LuaObjectScript.GetSpawnBranch(), true, "SpawnDirection")
  end
end
function OnStart(level)
  player = game.Player:FindPlayer()
  HandleEncounterStateOnReload()
end
function OnUpdate(level, obj)
  if Jotun_Reinforcements:IsRunning() == false then
    if player:IsPlayingMove("MOV_CSRageGrabJotunnEnter") then
      Jotun_Reinforcements:Start()
    end
  elseif player:IsPlayingMove("MOV_CSRageGrabJotunnExitReject") then
    Jotun_Reinforcements:Stop()
  end
end
function HandleEncounterStateOnReload()
  if FightOne:WasRunning() and HarpoonFightOne:IsComplete() == false then
    FightOne:Start()
  end
  if FightTwo:WasRunning() and HarpoonFightTwo:IsComplete() == false then
    FightTwo:Start()
  end
  if FightThree:WasRunning() and HarpoonFightThree:IsComplete() == false then
    FightThree:Start()
  end
end
function Temp_StaggerNearbyEnemies()
  local nearbyEnemies = game.Player.FindPlayer():FindEnemies(100)
  for _, enemy in pairs(nearbyEnemies) do
    local randomVal = math.random(0, 500) / 1000
    LD.CallFunctionAfterDelay(function()
      if enemy ~= nil then
        LD.PlayMove(enemy, thisObj, "MOV_HitGlobalStaggerF_Straight")
      end
    end, randomVal)
  end
end
function FindAndKillEnemies()
  local nearbyEnemies = game.Player.FindPlayer():FindEnemies(100)
  for _, enemy in pairs(nearbyEnemies) do
    enemy:Destroy()
  end
end
function FightOne()
  FightOne = EC.NewEncounter(thisLevel, "[HelShip] Phase 1 Opening Fight")
  FightOne_Left = EC.NewEncounter(thisLevel, "[HelShip] Phase 1 Left Fire Fighters")
  FightOne_Right = EC.NewEncounter(thisLevel, "[HelShip] Phase 1 Right Fire Fighters")
  FightOne:AddWave({
    prioritizeOnScreenSpawners = true,
    timeBeforeNextWave = 180,
    {
      spawners = "First_Fire_Fighter",
      spawnLocators = "A1_F_Loc_01*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7.3,
      powerLevel = 4
    },
    {
      spawners = "First_Fire_Fighter",
      spawnLocators = "A1_F_Loc_02*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15.2,
      powerLevel = 4
    },
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A1_F_Loc_03*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    }
  })
  FightOne:AddWave({
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "P_F_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 12.75
    },
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "P_F_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.95
    }
  })
  FightOne_Left:AddWave({
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.75
    },
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.75
    }
  })
  FightOne_Right:AddWave({
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "RS_E_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "RS_E_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.3
    }
  })
  FightOne:AddWave({
    recurring = true,
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "P_F_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.75
    },
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A2_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.3
    },
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A2_O_Loc_8",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 10.5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2.75
    },
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "P_B_Loc_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5.95,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3.5
    }
  })
  FightOne_Left:AddWave({
    recurring = true,
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.75
    }
  })
  FightOne_Right:AddWave({
    recurring = true,
    {
      spawners = "Fire_Fighters_1",
      spawnLocators = "FF_B_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  FightOne:OnStart(function()
    FightOne:StartRecurringWaves(3, 1)
    FightOne_Left:StartRecurringWaves(2, 2)
    FightOne_Right:StartRecurringWaves(2, 2)
  end)
  FightOne:OnStart(function()
    FightOne_Left:Start(1)
    FightOne_Right:Start(1)
  end, 2)
  FightOne:OnStart(function()
    FightOne_Left:SetComplete(1)
    FightOne_Right:SetComplete(1)
    FightOne_Left:StartWave(2)
    FightOne_Right:StartWave(2)
  end, 3)
  FightOne:OnComplete(function()
    FightOne:StartWave(2)
  end, 1)
end
function Harpoon_1()
  HarpoonFightOne = EC.NewEncounter(thisLevel, "[HelShip] Harpoon 1. Brawler", {
    CheckpointOnComplete = true,
    AutoResetOnReload = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_Fights.Child
  })
  HarpoonFightOne:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "Brawler_N_SHB",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_Brawler_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.8,
      powerLevel = 4
    }
  })
  HarpoonFightOne:AddWave({
    powerLevel = 3,
    {
      spawners = "Projection_S_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A1_H_Loc_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 13.2,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 3
    },
    {
      spawners = "Projection_S_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_O_Loc_",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 8.5,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 5
    },
    {
      spawners = "Projection_S_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_O_Loc_",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 18.5,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 8
    }
  })
end
function FightTwo()
  FightTwo = EC.NewEncounter(thisLevel, "[HelShip] Phase 2")
  FightTwo_Left = EC.NewEncounter(thisLevel, "[HelShip] Phase 2 Left Fire Fighters")
  FightTwo_Right = EC.NewEncounter(thisLevel, "[HelShip] Phase 2 Right Fire Fighters")
  FightTwo:AddWave({
    requiredWaveCompletion = 65,
    {
      spawners = "Fanatic_HAT_SFG",
      spawnLocators = "A2_PT_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Fanatic_HAT_SFG",
      spawnLocators = "A2_PT_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13.2
    },
    {
      spawners = "Fire_Fighters_1",
      spawnLocators = "A1_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 4.5,
      powerLevel = 3
    },
    {
      spawners = "Fire_Fighters_1",
      spawnLocators = "A3_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5.5
    }
  })
  FightTwo:AddWave({
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "P_F_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "RS_E_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.5
    },
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "P_F_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.8
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "RS_E_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.25
    }
  })
  FightTwo_Left:AddWave({
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_4",
      useSpawnLocatorsOnly = true,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    },
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  FightTwo_Right:AddWave({
    {
      spawners = "Fire_Fighters_1",
      spawnLocators = "A3_O_Loc_3",
      useSpawnLocatorsOnly = true,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "RS_E_Loc_9",
      useSpawnLocatorsOnly = true,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  FightTwo:OnStart(function()
    FightTwo:StartRecurringWaves(2, 1)
    FightTwo_Left:StartRecurringWaves(1, 2)
    FightTwo_Right:StartRecurringWaves(1, 2)
  end)
  FightTwo:OnStart(function()
    FightTwo_Left:Start()
    FightTwo_Right:Start()
  end, 2)
end
function Harpoon_2()
  HarpoonFightTwo = EC.NewEncounter(thisLevel, "[HelShip] Harpoon 2. Witch", {
    CheckpointOnComplete = true,
    AutoResetOnReload = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_Fights.Child
  })
  HarpoonFightTwo:AddWave({
    timeBeforeNextWave = 8,
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {8, 40},
    {
      spawners = "Witch_H_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      markerID = "Witch",
      spawnLocators = "A2_Hook",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.253,
      powerLevel = 5
    }
  })
  HarpoonFightTwo:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Witch_H_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      markerID = "Witch",
      spawnLocators = "A2_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.3,
      powerLevel = 4
    }
  })
  HarpoonFightTwo:AddWave({
    {
      spawners = "Flyer_I_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3.5,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 1.3,
      powerLevel = 4
    },
    {
      spawners = "Flyer_S_SFG",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5.5,
      maxActive = 1,
      totalSpawns = 5,
      spawnCooldown = 3.3,
      powerLevel = 4
    }
  })
  HarpoonFightTwo:OnEnemyDeath(function()
    HarpoonFightTwo:StartWave(3)
  end, {markerID = "Witch"})
  HarpoonFightTwo:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Ice")
  end)
  HarpoonFightTwo:OnComplete(function()
    if HarpoonFightTwo:WavesComplete(2) then
      HarpoonFightTwo:Stop()
      HarpoonFightTwo:SetComplete()
    end
  end, 1)
  HarpoonFightTwo:OnComplete(function()
    if HarpoonFightTwo:WavesComplete(1) then
      HarpoonFightTwo:Stop()
      HarpoonFightTwo:SetComplete()
    end
  end, 2)
end
function FightThree()
  FightThree = EC.NewEncounter(thisLevel, "[HelShip]EC:1 Phase 3")
  FightThree:AddWave({
    timeBeforeNextWave = 0.1,
    recurring = true,
    recurringCooldown = 23,
    {
      spawners = "Brawler_N_SHB",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_Brawler_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 20.8,
      powerLevel = 4
    },
    {
      spawners = "Brawler_N_SHB",
      spawnLocators = "A2_Brawler_X",
      spawnWad = "HelR300_AI_ShipFight",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2,
      powerLevel = 3
    }
  })
  FightThree:AddWave({
    recurring = true,
    recurringCooldown = 1,
    powerLevel = 3,
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.75
    },
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "RS_E_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    }
  })
  FightThree:AddWave({
    recurring = true,
    recurringCooldown = 1,
    powerLevel = 3,
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "LS_E_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Fire_Fighters_SFA",
      spawnLocators = "RS_E_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7.75
    }
  })
  FightThree:AddWave({
    recurring = true,
    recurringCooldown = 2,
    powerLevel = 3,
    {
      spawners = "Fanatic_HA_SRFC",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_O_Loc",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5.5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15.2
    }
  })
  FightThree:AddWave({
    recurring = true,
    recurringCooldown = 1,
    powerLevel = 3,
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A2_O_Loc",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 4,
      spawnCooldown = 2.5
    }
  })
  FightThree:AddWave({
    recurring = true,
    recurringCooldown = 1,
    powerLevel = 4,
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A3_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 0.1
    },
    {
      spawners = "Fire_Fighters_1",
      spawnLocators = "A3_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  FightThree:AddWave({
    requireCompletionOfAllPriorWaves = true,
    recurring = true,
    recurringCooldown = 1,
    powerLevel = 4,
    {
      spawners = "Helwalker_N_SRFC",
      spawnLocators = "A3_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Fire_Fighters_1",
      spawnLocators = "A3_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  FightThree:OnStart(function()
    LD.CallFunctionAfterDelay(function()
      FightThree:StartWave(2)
    end, 3)
    LD.CallFunctionAfterDelay(function()
      FightThree:StartWave(3)
    end, 13)
    LD.CallFunctionAfterDelay(function()
      FightThree:StartWave(4)
    end, 18)
    LD.CallFunctionAfterDelay(function()
      FightThree:StartWave(5)
    end, 26)
    LD.CallFunctionAfterDelay(function()
      FightThree:StartWave(6)
    end, 55)
    LD.CallFunctionAfterDelay(function()
      FightThree:StartWave(7)
    end, 60)
  end)
end
function Harpoon_3()
  Jotun_Reinforcements = EC.NewEncounter(thisLevel, "[HelShip] Harpoon 3, Jotun Reinforcements")
  Jotun_Reinforcements:AddWave({
    {
      spawners = "Projection",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 100,
      spawnCooldown = 0.5,
      powerLevel = 3
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A2_O",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 100,
      spawnCooldown = 2.2,
      powerLevel = 3
    }
  })
  HarpoonFightThree = EC.NewEncounter(thisLevel, "[HelShip] Harpoon 3, Jotun", {
    AutoResetOnReload = true,
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_Fights.Child
  })
  HarpoonFightThree:AddWave({
    timeBeforeNextWave = 5,
    {
      spawners = "Jotun_N_SFG",
      markerID = "Jotun_King",
      spawnWad = "HelR300_AI_ShipFight",
      spawnLocators = "A2_Loc_Custom_Jotunn",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  HarpoonFightThree:AddWave({
    powerLevel = 4,
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "LS_E_Loc_6",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldownType = "Sequential",
      initialSpawnCooldown = {
        0.3,
        10,
        15
      },
      maxActive = 3,
      totalSpawns = 5,
      spawnCooldown = 2.3
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "RS_E_Loc_7",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldownType = "Sequential",
      initialSpawnCooldown = {
        1.3,
        13,
        18
      },
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 2.5
    }
  })
  HarpoonFightThree:OnEnemySpawn(function(enemy)
    game.SubObject.Wake(thisObj)
  end, {markerID = "Jotun_King"})
  HarpoonFightThree:OnEnemyDeath(function(enemy)
    game.SubObject.Sleep(thisObj)
    HarpoonFightThree:SetComplete()
    Jotun_Reinforcements:SetComplete()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Ice")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Projection_HelBrood")
  end, {markerID = "Jotun_King"})
  HarpoonFightThree:OnComplete(function()
    GameObjects.HelheimShipScript.LuaObjectScript.MakeBowTNFAvailable()
  end)
end
function StartFightOne()
  FightOne:Start()
end
function FightOneStop()
  FightOne:StopRecurringWaves()
  FightOne:Stop()
end
function StartHarpoonFightOne()
  if FightOne:IsRunning() == true then
    FightOne_Left:StopRecurringWaves()
    FightOne_Right:StopRecurringWaves()
    FightOne:StopRecurringWaves()
    timers.StartLevelTimer(1, function()
      FightOne:DespawnEnemies()
      FightOne_Left:DespawnEnemies()
      FightOne_Right:DespawnEnemies()
      FightOne:SetComplete()
      FightOne_Left:SetComplete()
      FightOne_Right:SetComplete()
    end)
  end
  if HarpoonFightOne ~= nil then
    HarpoonFightOne:Start()
  end
end
function StartFightTwo()
  FightTwo:Start()
end
function StartHarpoonFightTwo_NextWave()
  if not HarpoonFightTwo:IsRunning() then
    HarpoonFightTwo:Start()
    HarpoonFightTwo:AlertEnemies()
  else
    HarpoonFightTwo:StartWave()
  end
end
function StartHarpoonFightTwo()
  if FightTwo:IsRunning() then
    FightTwo_Left:StopRecurringWaves()
    FightTwo_Right:StopRecurringWaves()
    FightTwo:StopRecurringWaves()
    timers.StartLevelTimer(1, function()
      FightTwo:DespawnEnemies()
      FightTwo_Left:DespawnEnemies()
      FightTwo_Right:DespawnEnemies()
      FightTwo:SetComplete()
      FightTwo_Left:SetComplete()
      FightTwo_Right:SetComplete()
    end)
  end
end
function HarpoonFightTwo_Stop()
  HarpoonFightTwo:Stop()
  HarpoonFightTwo:SetComplete()
end
function StartFightThree()
  FightThree:Start()
end
function StartHarpoonFightThree()
  if FightThree:IsRunning() then
    FightTwo_Left:StopRecurringWaves()
    FightTwo_Right:StopRecurringWaves()
    FightThree:StopRecurringWaves()
    timers.StartLevelTimer(1, function()
      FightThree:DespawnEnemies()
      FightThree:SetComplete()
      FightTwo_Left:DespawnEnemies()
      FightTwo_Left:SetComplete()
      FightTwo_Right:DespawnEnemies()
      FightTwo_Right:SetComplete()
    end)
  end
  if HarpoonFightThree ~= nil then
    HarpoonFightThree:Start()
  end
end
function HarpoonFightThree_Stop()
  HarpoonFightThree:Stop()
  HarpoonFightThree:SetComplete()
end
function Stop_Ship_Encounters()
  FightOne:Stop()
  FightTwo:Stop()
  FightThree:Stop()
end
function EncountersRunning()
  if FightOne ~= nil and FightOne:IsRunning() then
    return true
  end
  if FightThree ~= nil and FightThree:IsRunning() then
    return true
  end
  if FightTwo ~= nil and FightTwo:IsRunning() then
    return true
  end
end
function Brawler_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.75
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      FightTwo:StartWave()
    end)
  end
end
function Enable_Left_Spawners()
end
function Disable_Left_Spawners()
end
function Enable_Right_Spawners()
end
function Disable_Right_Spawners()
end
