local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local LM = require("level.loadmonitor")
local thisObj, thisLevel, kraActor, sonActor, shipActor, zeusProp, kraProp, barrelProp0, barrelProp1, barrelProp2, bladeProp0, bladeProp1
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function ShipPassiveSpawned(level, obj, passive)
  SetupActors_OnShipCreated(passive)
end
function SetupActors()
end
function SetupActors_OnShipCreated(shipReference)
  kraActor = actor.Actor.New("FLYING BOAT JUMP: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("FLYING BOAT JUMP: Son Actor", game.AI.FindSon)
  shipActor = actor.Actor.New("FLYING BOAT JUMP: Ship Actor", function()
    return shipReference
  end)
  zeusProp = thisObj:FindSingleGOByName("zeusProp").Child
  zeusProp:AddMarker("Zeus")
  kraProp = thisObj:FindSingleGOByName("kratosProp").Child
  kraProp:AddMarker("PKra")
  barrelProp0 = thisObj:FindSingleGOByName("helheimBarrel").Child
  barrelProp1 = thisObj:FindSingleGOByName("helheimBarrel1").Child
  barrelProp2 = thisObj:FindSingleGOByName("helheimBarrel2").Child
  bladeProp0 = thisObj:FindSingleGOByName("kratosBladesHallucinationProp").Child
  bladeProp1 = thisObj:FindSingleGOByName("kratosBladesHallucinationProp1").Child
  HideProps()
end
function HideProps()
  zeusProp:Hide()
  kraProp:Hide()
  barrelProp0:Hide()
  barrelProp1:Hide()
  barrelProp2:Hide()
  bladeProp0:Hide()
  bladeProp1:Hide()
end
function ShowProps()
  zeusProp:Show()
  kraProp:Show()
  barrelProp0:Show()
  barrelProp1:Show()
  barrelProp2:Show()
  bladeProp0:Show()
  bladeProp1:Show()
  local helR300 = game.FindLevel("HelR300_HelShip")
  if helR300 ~= nil then
    helR300:CallScript("FlyingBoatJumpCineActive")
  end
end
function SetupCineSequence(level, obj)
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Flying Boat Jump Sequence")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = shipActor},
    {
      Obj = kraProp,
      Anim = "narHelFlyingBoatJump010CineScene"
    },
    {
      Obj = zeusProp,
      Anim = "narHelFlyingBoatJump010CineScene"
    },
    {
      Obj = barrelProp0,
      Anim = "narHelFlyingBoatJump010CineScene"
    },
    {
      Obj = barrelProp1,
      Anim = "narHelFlyingBoatJump010CineScene1"
    },
    {
      Obj = barrelProp2,
      Anim = "narHelFlyingBoatJump010CineScene2"
    },
    {
      Obj = bladeProp0,
      Anim = "narHelFlyingBoatJump010CineScene"
    },
    {
      Obj = bladeProp1,
      Anim = "narHelFlyingBoatJump010CineScene1"
    },
    {
      Obj = game.FindLevel("HelR300_HelShip"):GetGameObject("Cine_Start_498"),
      Anim = "default"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_HEL_start_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:Do(game.Cinematics.EnableCinematicMode)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_FlyingBoatJump",
    ReferenceJoint = "FlyingBoatJump_SynchJoint"
  })
  cineSeq:Do(ShowProps)
  cineSeq:Do(SetupTempleCeilingBreakable)
  cineSeq:WaitForActorPuppeteerComplete(kraActor)
  cineSeq:Do(game.Cinematics.DisableCinematicMode)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(shipActor)
  cineSeq:Do(HideProps)
  cineSeq:WaitForLoadCheck("Cal130_TempleInt")
  cineSeq:Do(function()
    local helR300 = game.FindLevel("HelR300_HelShip")
    if helR300 ~= nil then
      helR300:CallScript("FlyingBoatJumpCineInactive")
    end
  end)
  cineSeq:SetCompletedCineNumber(498)
  cineSeq:Do(AwardTrophy)
  cineSeq:Do(SetHelheimMapState)
  cineSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "29_Caldera_010_OdinsLibrary"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  cineSeq:Do(function()
    game.Audio.PlayBanter("210_DustSettles")
  end)
  cineSeq:StartSequence()
end
function SetupTempleCeilingBreakable()
  local loadMonitor = LM.CreateLoadMonitor()
  loadMonitor:AddCallback({
    Wads = {
      "Cal170_Library1"
    },
    Functions = {
      StartTempleCeilingBreakableAnim
    }
  })
end
function StartTempleCeilingBreakableAnim(wads)
  wads.Cal170_Library1:CallScript("BreakRoof_Cal170")
end
function SetHelheimMapState()
  game.Level.SetVariable("Hel_MapState", 5)
end
function AwardTrophy()
  print("Trophy Awarded: Captain Kratos")
  game.UnlockTrophy(9)
end
