local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local son
local player = game.Player.FindPlayer()
local pad = player.Pad
local buttonMonitor, SonLookAtInteract_Exedus2, SonLookAtInteract_Exedus3, SonLookAtInteract_Exedus4, SonReadRune1
function OnScriptLoaded(level)
  son = game.AI.FindSon()
end
function OnStart(level)
  GameObjects.SpeedControl_BeforeStairs:HideEntityVolume()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 610 <= cineNum then
    TurnOffLoreMarkers()
  else
    GameObjects.SonReadRune1.LuaObjectScript.GetInteractZone():SetRequiresCriticalBanterComplete(true)
    SonLookAtInteract_Exedus2 = GameObjects.SonLookAtInteract_Exedus2.LuaObjectScript.GetInteractZone()
    SonLookAtInteract_Exedus2:SetXZRange(15)
    SonLookAtInteract_Exedus2:SetYRange(8)
    SonLookAtInteract_Exedus2:SetAngle(360)
    SonLookAtInteract_Exedus2:SetHintXZRange(22)
    SonLookAtInteract_Exedus2:SetHintAngle(360)
    SonLookAtInteract_Exedus2:SetHintYRange(8)
    SonLookAtInteract_Exedus3 = GameObjects.SonLookAtInteract_Exedus3.LuaObjectScript.GetInteractZone()
    SonLookAtInteract_Exedus3:SetXZRange(110)
    SonLookAtInteract_Exedus3:SetYRange(8)
    SonLookAtInteract_Exedus3:SetAngle(60)
    SonLookAtInteract_Exedus3:SetHintXZRange(22)
    SonLookAtInteract_Exedus3:SetHintAngle(360)
    SonLookAtInteract_Exedus3:SetHintYRange(8)
    local SonReadRune = GameObjects.SonReadRune.LuaObjectScript.GetInteractZone()
    SonReadRune:SetXZRange(14)
    SonReadRune:SetAngle(90)
    SonReadRune:SetHintXZRange(28)
    SonLookAtInteract_Exedus4 = GameObjects.SonLookAtInteract_Exedus4.LuaObjectScript.GetInteractZone()
    SonLookAtInteract_Exedus4:SetXZRange(16)
    SonLookAtInteract_Exedus4:SetYRange(10)
    SonLookAtInteract_Exedus4:SetAngle(90)
    SonLookAtInteract_Exedus4:SetHintXZRange(30)
    SonLookAtInteract_Exedus4:SetHintAngle(360)
    SonLookAtInteract_Exedus4:SetHintYRange(8)
    local SonReadRune1 = GameObjects.SonReadRune1.LuaObjectScript.GetInteractZone()
    SonReadRune1:SetXZRange(12)
    SonReadRune1:SetHintXZRange(26)
  end
  if 590 <= cineNum and cineNum < 610 then
    son:CallScript("ShowPouch")
  end
end
function OnFirstStart(level)
  GameObjects.AshesSingleBoost:HideTraverseLink()
  GameObjects.CreditsSpeedControlZone:HideEntityVolume()
  GameObjects.EntZn_DisablePostCineCA:HideEntityVolume()
  GameObjects.EntZn_EnablePostCineCA:HideEntityVolume()
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Disable_Cntxt_DeadGiants()
  GameObjects.Btr_DeadGiants:HideEntityVolume()
end
function POI_DeadGaints()
  return
end
function displayWarpMsg()
  TUT.Jot100_CalderaWarp_Tutorial()
end
function clearMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function syncExitEnable()
  GameObjects.syncExit.LuaObjectScript.Enable()
end
function SwapBoost()
  print("swap boosts to prevent son warping")
  LD.CallFunctionAfterDelay(function()
    GameObjects.AshesBuddyBoost:HideTraversePath()
    GameObjects.AshesSingleBoost:ShowTraverseLink()
  end, 2)
end
function TurnOffLoreMarkers()
  GameObjects.SonReadRune.LuaObjectScript.Disable()
  GameObjects.SonReadRune1.LuaObjectScript.Disable()
  GameObjects.SonLookAtInteract_Exedus2.LuaObjectScript.Disable()
  GameObjects.SonLookAtInteract_Exedus3.LuaObjectScript.Disable()
  GameObjects.SonLookAtInteract_Exedus4.LuaObjectScript.Disable()
end
function HideStairsZone()
  GameObjects.CA_Observe_Forward_Stairs.LuaObjectScript.Enable()
  GameObjects.Btr_ExodusShrine5:HideEntityVolume()
end
function HideCAStairs()
  GameObjects.CA_Observe_Forward_Stairs.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_Bottom.LuaObjectScript.Enable()
end
function TurnSpeedZoneOFF()
  GameObjects.SpeedControlZone:HideEntityVolume()
  GameObjects.YouShallNotPass_RopeBridge.LuaObjectScript.Enable()
end
function TurnSpeedZoneON()
  GameObjects.SpeedControlZone:ShowEntityVolume()
  GameObjects.YouShallNotPass_RopeBridge.LuaObjectScript.Disable()
end
function SwapCreditsZone()
  GameObjects.SpeedControlZone:HideEntityVolume()
  GameObjects.CreditsSpeedControlZone:ShowEntityVolume()
end
function LTW_Update_JotInteriorCloser()
  local jotIntParams = {}
  jotIntParams = {
    Speed = 4.5,
    LeaderDistance_Wait = 9,
    LeaderDistance_Continue = 7,
    LeaderDistance_Backtrack = 14,
    LeaderDistance_BacktrackDone = 10
  }
  GameObjects.LeadTheWay_Bottom.Child.LuaObjectScript.UpdateLeadTheWayParams(jotIntParams)
end
function LTW_Update_JotInteriorFar()
  local jotIntParams = {}
  jotIntParams = {
    Speed = 4.85,
    LeaderDistance_Wait = 26,
    LeaderDistance_Continue = 16,
    LeaderDistance_Backtrack = 32,
    LeaderDistance_BacktrackDone = 28
  }
  GameObjects.LeadTheWay_Bottom.Child.LuaObjectScript.UpdateLeadTheWayParams(jotIntParams)
end
function Jot100LoadCheck()
  game.UI.LoadCheck("Jot100_GiantsFingers", "Cal300_JotunheimLH")
end
function EndGameUI()
end
function LTWSwitchBottomSpline_Follow()
  GameObjects.LeadTheWay_Bottom.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_Bottom_Follow.LuaObjectScript.Enable()
  GameObjects.CA_EndUpPath.LuaObjectScript.Disable()
end
function LTWSwitchBottomSpline_Lead()
  GameObjects.LeadTheWay_Bottom_Follow.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_Bottom.LuaObjectScript.Enable()
  GameObjects.CA_EndUpPath.LuaObjectScript.Enable()
end
function LTWSwitchBottomSpline_Down()
  GameObjects.LeadTheWay_BottomDown.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_Bottom_Follow.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_BottomDown_Lead.LuaObjectScript.Enable()
end
function SetSonOccupied()
  local availabilityState = {AvailableForCombat = false, Unoccupied = false}
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  SonLookAtInteract_Exedus2:SetXZRange(0)
  SonLookAtInteract_Exedus3:SetXZRange(0)
end
function RemoveOccupied()
  local availabilityState = {AvailableForCombat = false, Unoccupied = true}
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  SonLookAtInteract_Exedus2:SetXZRange(15)
  SonLookAtInteract_Exedus3:SetXZRange(13.5)
end
function RemoveBanterSpeedControl()
  GameObjects.SpeedControl_BeforeStairs:HideEntityVolume()
  RemoveOccupied()
end
function OnExit_CA_NewEnvironment()
  RemoveOccupied()
  LTW_Update_JotInteriorCloser()
  GameObjects.CA_NewEnvironment.LuaObjectScript.Disable()
  GameObjects.CA_EndUpPath.LuaObjectScript.Enable()
end
function Btr_jotExodusShrine1()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("jotExodusShrine1")
  end, 4)
end
function ExedusInteract2()
  game.Audio.PlayBanter("jotExodusShrine2", RemoveOccupied)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Reaction_Interest_Low2.LuaObjectScript.Trigger()
  end, 0.25)
  SetSonOccupied()
end
function ExedusInteract3()
  game.Audio.PlayBanter("jotExodusShrine3", RemoveOccupied)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Reaction_Interest_Low3.LuaObjectScript.Trigger()
  end, 0.25)
  SetSonOccupied()
end
function ExedusInteract4()
  GameObjects.SpeedControl_BeforeStairs:ShowEntityVolume()
  game.Audio.PlayBanter("jotExodusShrine4", RemoveBanterSpeedControl)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Reaction_Interest_Low4.LuaObjectScript.Trigger()
  end, 0.25)
  SetSonOccupied()
end
function ExodusShrint5Done()
  GameObjects.SpeedControlStairs:HideEntityVolume()
end
function InScrollingCredits()
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  LD.CallFunctionAfterDelay(function()
    game.UI.Idle(true)
  end, 1)
  buttonMonitor = monitors.CreateCrossButtonMonitor()
  buttonMonitor:OnButtonDown(OnCreditsDone)
  buttonMonitor:OnButtonDown(ExitIdle)
end
function ExitIdle()
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickY)
  game.UI.Idle(false)
end
function OnCreditsDone()
end
function SonBanterInteract()
  game.Interact.DisableAll()
end
local creditmusStart = false
local creditmusEnd = false
function creditsMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 610 and creditmusStart == false then
    game.Audio.StartCheckpointedMusic("SND_MX_JOT_credits_01_in")
    creditmusStart = true
  end
end
