local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, cine_lights_600, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SetupActors()
end
function OnFirstStart(level, obj)
  GameObjects.Mural_SealedStone:PlayAnimToFrame(0, -1)
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("MOTHER'S SECRET REVEAL: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("MOTHER'S SECRET REVEAL: Son Actor", game.AI.FindSon)
  cine_lights_600 = GameObjects.Cine_Start_600
  HideCineLights()
end
function MothersSecretRevealSequence()
  if game.Level.GetVariable("CompletedCineNumber") >= 590 and game.Level.GetVariable("CompletedCineNumber") < 600 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Mother's Secret Reveal Sequence")
    local mothersSecretReveal_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_MothersSecretReveal"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_JOT_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(IncreaseKratosDeceleration)
    cineSeq:Do(StartCineEnter_MothersSecretReveal)
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_MothersSecretReveal",
      ReferenceJoint = "MothersSecretReveal_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.ArrivalRadius,
      weapon_state = "bare",
      strafe_distance = 0.5
    })
    cineSeq:Do(ClearKratosDeceleration)
    cineSeq:Do(PlayCineLights)
    cineSeq:Do(HideNoGoZone)
    cineSeq:Do(HideCineTriggerZone)
    cineSeq:Do(function()
      LD.BreakObject(GameObjects.ClothBanner_Panel3)
    end)
    cineSeq:Do(function()
      GameObjects.Mural_SealedStone:PlayAnimToEnd()
    end, function()
      GameObjects.Mural_SealedStone:JumpAnimToPercent(1)
    end)
    cineSeq:Do(function()
      GameObjects.CA_EndUpPath.LuaObjectScript.Disable()
    end)
    cineSeq:Do(function()
      game.AI.FindSon():RemoveAvailabilityRequest("SonInteraction")
    end)
    cineSeq:ActorSync(kraActor, {
      Slaves = mothersSecretReveal_ActorTable,
      Branch = "BRA_MothersSecretReveal",
      ReferenceJoint = "MothersSecretReveal_SynchJoint"
    })
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(Quest_Caldera_Objective910_Complete)
    cineSeq:SetCompletedCineNumber(600)
    cineSeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    cineSeq:Do(HideCineLights)
    cineSeq:StartSequence()
  end
end
function Quest_Caldera_Objective910_Complete()
  LD.CompleteQuest("Quest_Caldera_Objective910")
end
function HideCineTriggerZone()
  GameObjects.Cine_MothersSecretReveal:HideEntityVolume()
end
function HideNoGoZone()
  GameObjects.NoGo_MothersSecretReveal:HideNavObstacle()
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function PlayCineLights()
  cine_lights_600:Show()
  cine_lights_600:JumpAnimToFrame(0)
  cine_lights_600:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_600:Hide()
end
function StartCineEnter_MothersSecretReveal()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_MothersSecretReveal", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_MothersSecretReveal)
  cameraCineEnter:Start()
end
function DestroyCineEnter_MothersSecretReveal()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
