local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, pouchProp, cine_lights_610, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SetupProps()
  SetupActors()
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupProps()
  pouchProp = GameObjects.ashesPouch00Top1.Child
  pouchProp:Hide()
end
function ShowProps()
  pouchProp:Show()
end
function HideProps()
  pouchProp:Hide()
end
function SetupActors()
  kraActor = actor.Actor.New("RELEASE ASHES: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("RELEASE ASHES: Son Actor", game.AI.FindSon)
  cine_lights_610 = GameObjects.Cine_Start_610
  HideCineLights()
end
function ReleaseAshesSequence()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNum and cineNum < 610 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Release Ashes Sequence")
    local releaseAshes_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_ReleaseAshes"
      },
      {
        Obj = pouchProp,
        Anim = "narJtnReleaseAshes000"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_JOT_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(StartCineEnter_ReleaseAshes)
    cineSeq:Do(IncreaseKratosDeceleration)
    cineSeq:Do(DisableFaceSwapping)
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_ReleaseAshes",
      ReferenceJoint = "ReleaseAshes_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kRight,
      radius = ND.ArrivalRadius,
      weapon_state = "bare",
      strafe_distance = 1.5,
      ignore_navmesh = true
    })
    cineSeq:Do(ClearKratosDeceleration)
    cineSeq:Do(ShowProps)
    cineSeq:Do(PlayCineLights)
    cineSeq:ActorSync(kraActor, {
      Slaves = releaseAshes_ActorTable,
      Branch = "BRA_ReleaseAshes",
      ReferenceJoint = "ReleaseAshes_SynchJoint"
    })
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(EnableFaceSwapping)
    cineSeq:Do(HideProps)
    cineSeq:Do(HideCineLights)
    cineSeq:Do(HideCineTriggerZone)
    cineSeq:SetCompletedCineNumber(610)
    cineSeq:Do(function()
      GameObjects.ReleaseAshes_CA_Idle.LuaObjectScript.Disable()
      GameObjects.CA_Observe_MotherHand.LuaObjectScript.Disable()
      GameObjects.CA_Observe_Forward_LeaveJot.LuaObjectScript.Enable()
      GameObjects.CA_ObserveFar_PostCine.LuaObjectScript.Enable()
      GameObjects.EntZn_DisablePostCineCA:ShowEntityVolume()
      GameObjects.EntZn_EnablePostCineCA:ShowEntityVolume()
      _G.LTWSwitchBottomSpline_Down()
    end)
    cineSeq:Do(Quest_Caldera_Objective920_Complete)
    cineSeq:Do(AwardTrophy)
    cineSeq:Do(function()
      local cal300 = game.FindLevel("Cal300_JotunheimLH")
      if cal300 ~= nil then
        cal300:CallScript("EnableLTW_Down")
      end
    end)
    cineSeq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "36_Jotunheim_020_AshesReleased"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    cineSeq:StartSequence()
  end
end
function DisableFaceSwapping()
  if game.PhotoMode.SetFaceChangeEnabled then
    game.PhotoMode.SetFaceChangeEnabled(false)
  end
end
function EnableFaceSwapping()
  if game.PhotoMode.SetFaceChangeEnabled then
    game.PhotoMode.SetFaceChangeEnabled(true)
  end
end
function AwardTrophy()
  print("Award Trophy: Last Wish")
  game.UnlockTrophy(11)
end
function EnableCA()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 610 then
    GameObjects.ReleaseAshes_CA_Idle.LuaObjectScript.Enable()
  end
end
function Quest_Caldera_Objective920_Complete()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective920", "Complete")
  local player = game.Player.FindPlayer()
  if player:AttributeGetValue("Difficulty") == 4 then
    ShowImpossibleMedallion()
  else
    LD.ActivateQuest("Quest_ReturnHome_Parent")
  end
end
function ShowImpossibleMedallion()
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 20031,
    Body = 44247,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_CompleteSpecial
  })
  LD.ActivateQuest("Quest_ReturnHome_Parent")
end
function HideCineTriggerZone()
  GameObjects.Cine_ReleaseAshes:HideEntityVolume()
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function PlayCineLights()
  cine_lights_610:Show()
  cine_lights_610:JumpAnimToFrame(0)
  cine_lights_610:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_610:Hide()
end
function StartCineEnter_ReleaseAshes()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_ReleaseAshes", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_ReleaseAshes)
  cameraCineEnter:Start()
end
function DestroyCineEnter_ReleaseAshes()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
