local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, equippedWrist, kraActor, sonActor, pouchProp, longBandProp01, longBandProp02, cine_lights_590, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SetupProps()
  SetupActors()
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupProps()
  pouchProp = GameObjects.ashesPouch00Top.Child
  longBandProp01 = GameObjects.kratosLongBandage00Top.Child
  longBandProp02 = GameObjects.kratosLongBandage00Top1.Child
  HideProps()
end
function SetupActors()
  kraActor = actor.Actor.New("SON BOND: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SON BOND: Son Actor", game.AI.FindSon)
  cine_lights_590 = GameObjects.Cine_Start_590
  HideCineLights()
end
function SonBondSequence()
  if game.Level.GetVariable("CompletedCineNumber") >= 580 and game.Level.GetVariable("CompletedCineNumber") < 590 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Son Bond Sequence")
    local sonBond_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_SonBond"
      },
      {
        Obj = pouchProp,
        Anim = "narJtnSonBond000CineScene"
      },
      {
        Obj = longBandProp01,
        Anim = "narJtnSonBond000CineScene"
      },
      {
        Obj = longBandProp02,
        Anim = "narJtnSonBond000CineScene1"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_JOT_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(IncreaseKratosDeceleration)
    cineSeq:Do(StartCineEnter_SonBond)
    cineSeq:Do(DisableFaceSwapping)
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_SonBond",
      ReferenceJoint = "SonBond_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.ArrivalRadius,
      weapon_state = "bare",
      ignore_navmesh = false
    })
    cineSeq:ActorSync(kraActor, {
      Slaves = sonBond_ActorTable,
      Branch = "BRA_SonBond",
      ReferenceJoint = "SonBond_SynchJoint"
    })
    cineSeq:Do(ClearKratosDeceleration)
    cineSeq:Do(HideNoGoZone)
    cineSeq:Do(PlayCineLights)
    cineSeq:Do(PlayBandages)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.28)
    cineSeq:Do(DeactivateBracers)
    cineSeq:WaitUntilActorAnimPastFrame(kraActor, 1100)
    cineSeq:Do(ShowBandages)
    cineSeq:Do(function()
      LD.CallFunctionAfterDelay(ShowProps, 1)
    end)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.935)
    cineSeq:Do(ActivateBracers)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.974)
    cineSeq:Do(HideProps)
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(EnableFaceSwapping)
    cineSeq:Do(HideCineLights)
    cineSeq:Do(HideCineTriggerZone)
    cineSeq:SetCompletedCineNumber(590)
    cineSeq:Do(function()
      Quest_Caldera_Objective900_Start()
      if game.FindLevel("Cal300_JotunheimLH") ~= nil then
        game.FindLevel("Cal300_JotunheimLH"):CallScript("DisableWaitAtLightCA")
      end
      game.World.StoreCheckpoint()
    end)
    cineSeq:StartSequence()
  end
end
function DisableFaceSwapping()
  if game.PhotoMode.SetFaceChangeEnabled then
    game.PhotoMode.SetFaceChangeEnabled(false)
  end
end
function EnableFaceSwapping()
  if game.PhotoMode.SetFaceChangeEnabled then
    game.PhotoMode.SetFaceChangeEnabled(true)
  end
end
function PlayBandages()
  local bandages2 = GameObjects.template_v2
  bandages2:JumpAnimToFrame(0)
  bandages2:PlayAnimToEnd()
end
function ShowBandages()
  local bandages2 = GameObjects.template_v2
  bandages2:Show()
end
function ShowProps()
  pouchProp:Show()
  longBandProp01:Show()
  longBandProp02:Show()
end
function HideProps()
  local bandages2 = GameObjects.template_v2
  bandages2:Hide()
  pouchProp:Hide()
  longBandProp01:Hide()
  longBandProp02:Hide()
end
function HideCineTriggerZone()
  GameObjects.Cine_SonBond:HideEntityVolume()
end
function HideNoGoZone()
  GameObjects.NoGo_SonBond:HideNavObstacle()
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function PlayCineLights()
  cine_lights_590:Show()
  cine_lights_590:JumpAnimToFrame(0)
  cine_lights_590:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_590:Hide()
end
function DeactivateBracers()
  local player = game.Player.FindPlayer()
  equippedWrist = player:PickupGetPickupNameInSlot("ArmorWrist")
  if equippedWrist ~= "" then
    player:PickupDeactivate(equippedWrist)
  end
end
function ActivateBracers()
  if equippedWrist ~= "" then
    local player = game.Player.FindPlayer()
    player:PickupActivate(equippedWrist)
  end
end
function Quest_Caldera_Objective900_Start()
  local questState = game.QuestManager.GetQuestState("Quest_Caldera_Objective900")
  if questState ~= "Complete" and questState ~= "Active" then
    game.QuestManager.StartQuest("Quest_Caldera_Objective900")
  end
end
function StartCineEnter_SonBond()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_SonBond", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_SonBond)
  cameraCineEnter:Start()
end
function DestroyCineEnter_SonBond()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
