local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisObj, arenaGateEmitter
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  arenaGateEmitter = thisObj:FindSingleSoundEmitterByName("SNDArenaGateMedium")
end
function RaiseGate()
  LD.CallFunctionAfterDelay(PlayGateSound, 0.2)
  thisObj:PlayAnimToEnd(-5)
end
function LowerGate()
  PlayGateSound()
  thisObj:PlayAnimToEnd(5)
end
function FightComplete()
  LowerGate()
  thisObj:FindSingleGOByName("genGuide"):HideCollision()
end
function ShowGateCollision()
  thisObj:FindSingleGOByName("genGuide"):ShowCollision()
end
function HideGateCollision()
  thisObj:FindSingleGOByName("genGuide"):HideCollision()
end
function PlayGateSound()
  LD.PlaySound(arenaGateEmitter, "SND_MECH_Metal_Spike_Door_Muspelheim")
end
function StopGateSound()
  LD.StopSound(arenaGateEmitter, "SND_MECH_Metal_Spike_Door_Muspelheim")
end
