local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local thisLevel, EliteDarkOne_HealthMonitor, Area_2_Encounter_1, Area_2_Encounter_2, Area_2_Encounter_3, Area_2_Encounter_4, Area_2_Encounter_5, Area_2_Encounter_6
local A2_E1_C = false
local A2_E2_C = false
local A2_E3_C = false
local A2_Encounters = {}
local A2_Encounters_Index = 1
Challenge_Message = "NULL MESSAGE"
local Time_Attack_Started = false
local ecTimer, ec_TimeRequirement, timeRemaining
local SurviveTime = 300
local Challenge_Max_Time = 60
local Challenge_Additional_Time_Amount = 20
local Challenge_Duration_Time = 240
local Challenge_KillCount = 25
function OnScriptLoaded(level, obj)
  thisLevel = level
  Bronze_Challenge_Arena_2_Fight()
  Silver_Challenge_Arena_2_Fight()
  Gold_Challenge_Arena_2_Fight()
end
function OnUpdate(level, obj)
  if Time_Attack_Started then
    Encounter_Timer()
  end
  if Area_2_Encounter_1:IsRunning() then
    Survival_Timer()
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    temp_Start_A2_E1_C = A2_E1_C,
    temp_Start_A2_E2_C = A2_E2_C,
    temp_Start_A2_E3_C = A2_E3_C
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  A2_E1_C = savedInfo.temp_Start_A2_E1_C
  A2_E2_C = savedInfo.temp_Start_A2_E2_C
  A2_E3_C = savedInfo.temp_Start_A2_E3_C
end
function Arena_2_Finished()
  uiCalls.UI_Event_SendDesignerMessage("Arena 2 Finished!!!", -1)
  LD.CallFunctionAfterDelay(function()
    LD.CallFunctionAfterDelay(function()
      GameObjects.Arena02_Statue:PlayAnimToEnd(-1)
    end, 2)
    LD.CallFunctionAfterDelay(function()
      GameObjects.Arena02_Switch:PlayAnimToEnd(-1)
    end, 1.5)
  end, 2)
end
function Start_Area_2_Encounter_1()
  LD.CallFunctionAfterDelay(function()
    Area_2_Encounter_1:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_2_Encounter_2()
  LD.CallFunctionAfterDelay(function()
    Area_2_Encounter_2:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_2_Encounter_3()
  LD.CallFunctionAfterDelay(function()
    if Area_2_Encounter_3:IsComplete() then
      Area_2_Encounter_3:Restart()
    else
      Area_2_Encounter_3:Start()
    end
  end, _G.GetPreEncounterCooldown())
end
local Arena_2_OnEncounterComplete = function()
  game.World.StoreCheckpoint()
  A2_Encounters_Index = A2_Encounters_Index + 1
  if A2_Encounters[A2_Encounters_Index] ~= nil then
    A2_Encounters[A2_Encounters_Index]:Start()
  else
    Arena_2_Finished()
  end
end
function Time_Attack()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 2]EC:1 - Bronze --- Msp120", {
    CheckpointOnComplete = true,
    StartMusic = "SND_",
    StopMusic = "SND_"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Seidr_Bandit_SRFC",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2,
      powerLevel = 3
    }
  })
  Area_2_Encounter_1:AddWave({
    powerLevel = 3,
    {
      spawners = "Seidr_Brawler_N_SRFC",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_L*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 1
    },
    {
      spawners = "Seidr_Brawler_N_SRFC",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_R*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Seidr_Projection_S_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_L*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 3
    },
    {
      spawners = "Seidr_Projection_S_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_R*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 3
    }
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Seidr_Bandit_SRFC",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_*",
      markerID = "PL_4",
      useSpawnLocatorsOnly = true,
      maxActive = 5,
      totalSpawns = 5,
      spawnCooldown = 2,
      powerLevel = 4
    }
  })
  Area_2_Encounter_1:OnStart(function()
    Challenge_Duration_Time = 60
    Start_Timer()
  end)
  Area_2_Encounter_1:OnEnemyDeath(function()
    Challenge_KillCount = Challenge_KillCount - 1
  end)
  Area_2_Encounter_1:OnComplete(function()
    uiCalls.UI_Event_ClearAllDesignerMessages()
    EventComplete()
    A2_E1_C = true
  end)
  table.insert(A2_Encounters, Area_2_Encounter_1)
end
function Bronze_Challenge_Arena_2_Fight()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 2]EC:1 - Bronze Survive Msp120", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_MSP_trial_12_start",
    StopMusic = "SND_MX_MSP_trial_12_win"
  })
  Area_2_Encounter_1:AddWave({
    recurring = true,
    recurringCooldown = 5,
    {
      spawners = "Seidr_Bandit_SRFC",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 4,
      spawnCooldown = 1,
      powerLevel = 3
    }
  })
  Area_2_Encounter_1:AddWave({
    recurring = true,
    recurringCooldown = 8,
    {
      spawners = "Wolf_P_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3,
      powerLevel = 3
    }
  })
  Area_2_Encounter_1:AddWave({
    recurring = true,
    recurringCooldown = 20,
    {
      spawners = "Seidr_Bandit_SRFC",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 4,
      spawnCooldown = 3,
      powerLevel = 4
    }
  })
  Area_2_Encounter_1:AddWave({
    recurring = true,
    recurringCooldown = 16,
    {
      spawners = "Wolf_P_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_",
      markerID = "PL_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 4,
      spawnCooldown = 2,
      powerLevel = 4
    }
  })
  Area_2_Encounter_1:AddWave({
    recurring = true,
    recurringCooldown = 32,
    {
      spawners = "Seidr_Fanatic_B_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_BackEdge",
      markerID = "PL_4",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 10,
      powerLevel = 5
    }
  })
  Area_2_Encounter_1:AddWave({
    recurring = true,
    recurringCooldown = 20,
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "A2_Loc_BackEdge*",
      markerID = "PL_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 5
    },
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "A2_Loc_I_L*",
      markerID = "PL_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15,
      powerLevel = 5
    }
  })
  Area_2_Encounter_1:OnStart(function()
    Start_Survival_Timer()
    timers.StartLevelTimer(10, function()
      Area_2_Encounter_1:StartWave(2)
    end)
    timers.StartLevelTimer(20, function()
      Area_2_Encounter_1:StartWave(3)
    end)
    timers.StartLevelTimer(30, function()
      Area_2_Encounter_1:StartWave(4)
    end)
    timers.StartLevelTimer(50, function()
      Area_2_Encounter_1:StartWave(5)
    end)
    timers.StartLevelTimer(80, function()
      Area_2_Encounter_1:StartWave(6)
    end)
  end)
  Area_2_Encounter_1:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end)
  Area_2_Encounter_1:OnComplete(function()
    uiCalls.DisableMechanicText()
    EventComplete()
    A2_E1_C = true
  end)
  table.insert(A2_Encounters, Area_2_Encounter_1)
end
function Silver_Challenge_Arena_2_Fight()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Arena 2]EC:2 - Silver - Regeneration - Msp120", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_MSP_trial_22_start",
    StopMusic = "SND_MX_MSP_trial_22_win"
  })
  Area_2_Encounter_2:AddWave({
    powerLevel = 3,
    timeBetweenWaves = 2.1,
    {
      spawners = "Helwalker_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 1,
      maxActive = 4,
      totalSpawns = 6,
      spawnCooldown = 3
    }
  })
  Area_2_Encounter_2:AddWave({
    powerLevel = 3,
    timeBetweenWaves = 2.1,
    {
      spawners = "Fanatic_B_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 2
    },
    {
      spawners = "Wolf_N_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 1,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 8
    }
  })
  Area_2_Encounter_2:AddWave({
    powerLevel = 4,
    timeBetweenWaves = 2.1,
    {
      spawners = "H_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A2_Loc_B*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A2_Loc_B*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    }
  })
  Area_2_Encounter_2:AddWave({
    timeBetweenWaves = 2.1,
    powerLevel = 4,
    {
      spawners = "Draugr_P_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A2_Loc_B*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.78,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 8
    },
    {
      spawners = "Helwalker_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_B*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.5,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 10
    }
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Draugr_EL_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A2_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 3.1,
      powerLevel = 3
    },
    {
      spawners = "SH_Helwalker_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 0.9,
      powerLevel = 3
    },
    {
      spawners = "SH_Helwalker_SFG",
      spawnWad = "Msp120_Arena02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 1.8,
      powerLevel = 4
    }
  })
  Area_2_Encounter_2:OnStart(function()
    A2_Encounters_Index = 2
  end)
  Area_2_Encounter_2:OnStart(function()
    uiCalls.EnableMechanicText(37433, {
      #Area_2_Encounter_2.waves
    })
  end, 1)
  Area_2_Encounter_2:OnComplete(function()
    uiCalls.DisableMechanicText()
  end)
  Area_2_Encounter_2:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      if enemy ~= nil then
        enemy:PickupAcquire("MuspelheimHealthRegenChallenge")
      end
    end)
  end)
  Area_2_Encounter_2:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      if enemy ~= nil then
        enemy:ForceMove("BRA_SetDropHealthFlag_On")
      end
    end)
  end, {wave = 3})
  table.insert(A2_Encounters, Area_2_Encounter_2)
end
function Gold_Challenge_Arena_2_Fight()
  Area_2_Encounter_3 = EC.NewEncounter(thisLevel, "[Arena 2]EC:3 - Gold -Poison Horde Msp120", {CheckpointOnComplete = true})
  Area_2_Encounter_3:AddWave({
    powerLevel = 6,
    timeBetweenWaves = 2.1,
    {
      spawners = "Witch_F_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_L*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5,
      powerLevel = 6
    },
    {
      spawners = "Seidr_Projection_S_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_L*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = 2,
      maxActive = 3,
      totalSpawns = 8,
      spawnCooldown = 3.5,
      powerLevel = 5
    },
    {
      spawners = "Seidr_Projection_S_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_R*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 3,
      totalSpawns = 8,
      spawnCooldown = 2.25,
      powerLevel = 6
    }
  })
  Area_2_Encounter_3:AddWave({
    timeBetweenWaves = 3.2,
    {
      spawners = "Witch_F_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_B*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "Seidr_Brawler_N_SRFC",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2.78,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 8
    }
  })
  Area_2_Encounter_3:AddWave({
    powerLevel = 7,
    timeBetweenWaves = 5.3,
    {
      spawners = "E_Crawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_L*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "E_Crawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_R*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_2_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Witch_F_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_L*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.55,
      powerLevel = 7
    },
    {
      spawners = "E_Seidr_Brawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_O_R*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.55,
      powerLevel = 6
    },
    {
      spawners = "Seidr_Bandit_SRFC",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A2_Loc_I_MiddleGate_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3.78,
      maxActive = 4,
      totalSpawns = 8,
      spawnCooldown = 5,
      powerLevel = 6
    }
  })
  Area_2_Encounter_3:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      if enemy ~= nil then
        enemy:ForceMove("BRA_SetDontDropLootFlag_On")
      end
    end)
  end)
  Area_2_Encounter_3:OnStart(function()
    Challenge_Duration_Time = 240
    A2_Encounters_Index = 3
    Start_Timer()
  end)
  Area_2_Encounter_3:OnCombatStart(A2_E3_Music_StartMusic)
  Area_2_Encounter_3:OnComplete(function()
    uiCalls.DisableMechanicText()
    ecTimer:Stop()
    ecTimer:Reset()
    Time_Attack_Started = false
    A2_E3_Music_WinMusic()
  end)
  table.insert(A2_Encounters, Area_2_Encounter_3)
end
function AddOnCompleteCallback(encounterIndex, callback)
  if A2_Encounters and A2_Encounters[encounterIndex] then
    A2_Encounters[encounterIndex]:OnComplete(callback)
  end
end
function Encounter_Timer()
  timeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = timeRemaining % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37906, {minutes, seconds})
end
function Survival_Timer()
  timeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = timeRemaining % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37912, {minutes, seconds})
end
function Start_Survival_Timer()
  local startDelay = 5
  uiCalls.DisableMechanicText()
  ec_TimeRequirement = SurviveTime
  ecTimer = StartLevelTimer(ec_TimeRequirement, function()
    ecTimer:Stop()
    _G.MSP_Despawn_Enemy_VFX(Area_2_Encounter_1)
    Area_2_Encounter_1:StopRecurringWaves()
    Area_2_Encounter_1:SetComplete()
    Area_2_Encounter_1:Stop()
  end)
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  local seconds = ec_TimeRequirement % 60
  local minutes = ec_TimeRequirement / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function Add_Time()
  ec_TimeRequirement = ec_TimeRequirement - ecTimer.time + Challenge_Additional_Time_Amount
  ecTimer:Stop()
  ecTimer = nil
  if ec_TimeRequirement > Challenge_Max_Time then
    ec_TimeRequirement = Challenge_Max_Time + 1
    ecTimer = StartLevelTimer(ec_TimeRequirement, function()
      EventFailed_TimeElapsed()
    end)
    ecTimer:Start()
  else
    ecTimer = StartLevelTimer(ec_TimeRequirement, function()
      EventFailed_TimeElapsed()
    end)
    ecTimer:Start()
  end
end
function Start_Timer()
  local startDelay = 5
  Time_Attack_Started = true
  ec_TimeRequirement = Challenge_Duration_Time
  ecTimer = StartLevelTimer(ec_TimeRequirement, function()
    EventFailed_TimeElapsed()
  end)
  ecTimer:Stop()
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  local seconds = ec_TimeRequirement % 60
  local minutes = ec_TimeRequirement / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function EventFailed_TimeElapsed()
  uiCalls.DisableMechanicText()
  local seconds = Challenge_Duration_Time % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.SendBottomDesignerMessage({Text = 37911, Critical = true})
  Area_2_OnEncounterFailed()
  ecTimer:Stop()
  ecTimer:Reset()
  Time_Attack_Started = false
  A2_E3_Music_FailMusic()
end
function Set_Encounter_Timer(timeRequirement)
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, EventFailed_TimeElapsed)
  ecTimer:Stop()
end
function Area_2_OnEncounterFailed()
  _G.MSP_Despawn_Enemy_VFX(A2_Encounters[A2_Encounters_Index])
  A2_Encounters[A2_Encounters_Index]:Reset()
  A2_Encounters[A2_Encounters_Index]:Stop()
  GameObjects.Muspelheim_Arena_Marker_02.LuaObjectScript.ChallengeFailed()
end
function EventComplete()
  Time_Attack_Started = false
  ecTimer:Stop()
  ecTimer = nil
end
local A2_E3_Music_IsActive = false
function A2_E3_Music_StartMusic()
  game.Audio.StartMusic("SND_MX_MSP_trial_32_start")
  A2_E3_Music_IsActive = true
end
function A2_E3_Music_FailMusic()
  if A2_E3_Music_IsActive then
    game.Audio.StartMusic("SND_MX_MSP_trial_32_fail")
  end
  A2_E3_Music_IsActive = false
end
function A2_E3_Music_WinMusic()
  game.Audio.StartMusic("SND_MX_MSP_trial_32_win")
  A2_E3_Music_IsActive = false
end
