local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local EncounterSM = require("boss.statemachine")
local thisObj, thisLevel, E_HealthMonitor, Area_3_Encounter_1, Area_3_Encounter_2, Area_3_Encounter_3
local Challenge_1 = EncounterSM:AddStage("DarkOne Elite - Invulnerable with Support ", true)
local Challenge_2 = EncounterSM:AddStage("Ice Troll - Invulnerable with Support", true)
local Challenge_3 = EncounterSM:AddStage("Invulnerable with Support", true)
local A3_Encounters = {}
local A3_Encounters_Index = 1
Invulnerable_AI = nil
Invulnerable_Support_Challenge = false
Time_Attack_Started = false
local ecTimer, ec_TimeRequirement, timeRemaining
local Challenge_Duration_Time = 120
local eventComplete
local eventFailed = false
local numKilled = 0
local requiredNumKilled = 0
local zoneID = 3
local zone_List = {
  GameObjects.EntZn_Arena_2_Death_Zone_1,
  GameObjects.EntZn_Arena_2_Death_Zone_2,
  GameObjects.EntZn_Arena_2_Death_Zone_3
}
zone_1_FX = nil
zone_2_FX = nil
zone_3_FX = nil
local OtherActiveWaves, arenaObject
Additional_Text = ""
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  Bronze_Challenge_Arena_3_Fight_1()
  Silver_Challenge_Arena_3_Fight()
  Gold_Challenge_Arena_3_Fight()
  zone_1_FX = level:GetGameObject("Arena03_Death_Zone_1_Fx")
  zone_2_FX = level:GetGameObject("Arena03_Death_Zone_2_Fx")
  zone_3_FX = level:GetGameObject("Arena03_Death_Zone_3_Fx")
end
function OnStart(level, obj)
  GameObjects.EntZn_Arena_2_Death_Zone_1:Hide()
  GameObjects.EntZn_Arena_2_Death_Zone_2:Hide()
  GameObjects.EntZn_Arena_2_Death_Zone_3:Hide()
  LD.HideFX(zone_1_FX)
  LD.HideFX(zone_2_FX)
  LD.HideFX(zone_3_FX)
end
function OnUpdate(level, obj)
  if Time_Attack_Started then
    Encounter_Timer()
  end
  if Invulnerable_Support_Challenge then
    print("shield")
    uiCalls.EnableMechanicText(37914, {
      #A3_Encounters[A3_Encounters_Index]:GetActiveEnemies() - 1
    })
  elseif Area_3_Encounter_1 ~= nil and Area_3_Encounter_1:IsRunning(6) then
    Add_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Arena_3_Finished()
  LD.CallFunctionAfterDelay(function()
    LD.CallFunctionAfterDelay(function()
      GameObjects.Arena02_Statue:PlayAnimToEnd(-1)
    end, 2)
    LD.CallFunctionAfterDelay(function()
      GameObjects.Arena02_Switch:PlayAnimToEnd(-1)
    end, 1.5)
  end, 2)
end
function Start_Area_3_Encounter_1()
  LD.CallFunctionAfterDelay(function()
    Area_3_Encounter_1:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_3_Encounter_2()
  LD.CallFunctionAfterDelay(function()
    Area_3_Encounter_2:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_3_Encounter_3()
  LD.CallFunctionAfterDelay(function()
    if Area_3_Encounter_3:IsComplete() then
      Area_3_Encounter_3:Restart()
    else
      Area_3_Encounter_3:Start()
    end
  end, _G.GetPreEncounterCooldown())
end
local Arena_3_OnEncounterComplete = function()
  A3_Encounters_Index = A3_Encounters_Index + 1
  if A3_Encounters[A3_Encounters_Index] ~= nil then
    A3_Encounters[A3_Encounters_Index]:Start()
  else
    Arena_3_Finished()
  end
end
function Bronze_Challenge_Arena_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 3]EC:1 - Bronze Invulnerable with Support Msp130", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_MSP_trial_13_start",
    StopMusic = "SND_MX_MSP_trial_13_win"
  })
  Area_3_Encounter_1:AddWave({
    timeBeforeNextWave = 8,
    {
      spawners = "E_DrakOne_SFA",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_I_M*",
      markerID = "Invulnerable_AI",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      powerLevel = 5
    }
  })
  Area_3_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Flyer_N_SABU",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.8,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 3
    }
  })
  Area_3_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.8,
      initialSpawnAmount = 1,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 5,
      powerLevel = 4
    }
  })
  Area_3_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "H_DrakOne_SFA",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.8,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 13,
      powerLevel = 5
    }
  })
  Area_3_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Witch_P_SFG",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.03,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 3
    }
  })
  Area_3_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.8,
      initialSpawnAmount = 2,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2,
      powerLevel = 4
    },
    {
      spawners = "H_DrakOne_SFA",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.8,
      initialSpawnAmount = 1,
      maxActive = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3
    }
  })
  Area_3_Encounter_1:OnStart(function()
    uiCalls.EnableMechanicText(37914, {
      #A3_Encounters[A3_Encounters_Index]:GetActiveEnemies() - 1
    })
  end, 2)
  Area_3_Encounter_1:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      if enemy ~= nil then
        enemy:ForceMove("BRA_SetDropHealthFlag_On")
      end
    end)
  end, {wave = 3})
  Area_3_Encounter_1:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      if enemy ~= nil then
        enemy:ForceMove("BRA_SetDropHealthFlag_On")
      end
    end)
  end, {wave = 5})
  Area_3_Encounter_1:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      enemy:ForceMove("BRA_SetDropHealthFlag_On")
    end)
  end, {wave = 6})
  Area_3_Encounter_1:OnEnemySpawn(function(enemy)
    Invulnerable_AI = enemy
    Encounter_HealthMonitor(enemy, Area_3_Encounter_1)
  end, {
    markerID = "Invulnerable_AI"
  })
  Area_3_Encounter_1:OnEnemyDeath(function(enemy)
    uiCalls.UI_Event_ClearAllDesignerMessages()
    Invulnerable_Support_Challenge = false
    Area_3_Encounter_1:StopRecurringWaves()
    if Area_3_Encounter_1 then
      Area_3_Encounter_1:SetComplete()
    end
  end, {
    markerID = "Invulnerable_AI"
  })
  Area_3_Encounter_1:OnStart(function()
    timers.StartLevelTimer(0.3, function()
      Add_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
      Invulnerable_Support_Challenge = true
    end)
  end, 2)
  Area_3_Encounter_1:OnComplete(function()
    EncounterActiveWaves()
    if OtherActiveWaves == false then
      Invulnerable_Support_Challenge = false
      timers.StartLevelTimer(0.03, function()
        Remove_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
        uiCalls.DisableMechanicText()
      end)
    end
  end, 2)
  Area_3_Encounter_1:OnStart(function()
    timers.StartLevelTimer(0.3, function()
      Add_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
      Invulnerable_Support_Challenge = true
    end)
  end, 3)
  Area_3_Encounter_1:OnComplete(function()
    EncounterActiveWaves()
    if OtherActiveWaves == false then
      Invulnerable_Support_Challenge = false
      timers.StartLevelTimer(0.03, function()
        Remove_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
        uiCalls.DisableMechanicText()
      end)
    end
  end, 3)
  Area_3_Encounter_1:OnStart(function()
    timers.StartLevelTimer(0.3, function()
      Add_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
      Invulnerable_Support_Challenge = true
    end)
  end, 4)
  Area_3_Encounter_1:OnComplete(function()
    EncounterActiveWaves()
    if OtherActiveWaves == false then
      Invulnerable_Support_Challenge = false
      timers.StartLevelTimer(0.03, function()
        Remove_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
        uiCalls.DisableMechanicText()
      end)
    end
  end, 4)
  Area_3_Encounter_1:OnStart(function()
    timers.StartLevelTimer(0.3, function()
      Add_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
      Invulnerable_Support_Challenge = true
    end)
  end, 5)
  Area_3_Encounter_1:OnComplete(function()
    EncounterActiveWaves()
    if OtherActiveWaves == false then
      Invulnerable_Support_Challenge = false
      timers.StartLevelTimer(0.03, function()
        Remove_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
        uiCalls.DisableMechanicText()
      end)
    end
  end, 5)
  Area_3_Encounter_1:OnStart(function()
    timers.StartLevelTimer(0.3, function()
      Add_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
      Invulnerable_Support_Challenge = true
    end)
  end, 6)
  Area_3_Encounter_1:OnComplete(function()
    EncounterActiveWaves()
    if OtherActiveWaves == false then
      Invulnerable_Support_Challenge = false
      timers.StartLevelTimer(0.03, function()
        Remove_Invincible_Pickup(LD.FindSingleAIByMarker("Invulnerable_AI"))
        uiCalls.DisableMechanicText()
      end)
    end
  end, 6)
  Area_3_Encounter_1:OnComplete(function()
    uiCalls.DisableMechanicText()
    A3_Encounters[A3_Encounters_Index]:StopRecurringWaves()
    A3_Encounters[A3_Encounters_Index]:StopRecurringWaves(6)
    A3_Encounters[A3_Encounters_Index]:Stop()
    Invulnerable_Support_Challenge = false
    Area_3_Encounter_1:SetComplete()
    Area_3_Encounter_1 = nil
    timers.StartLevelTimer(2, function()
      uiCalls.UI_Event_TurnOffDesignerMessage()
    end)
  end)
  table.insert(A3_Encounters, Area_3_Encounter_1)
end
function Silver_Challenge_Arena_3_Fight()
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Arena 3]EC:2 - Silver - Light Rings - Msp130", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_MSP_trial_23_start",
    StopMusic = "SND_MX_MSP_trial_23_win"
  })
  Area_3_Encounter_2:AddWave({
    powerLevel = 3,
    timeBetweenWaves = 8.1,
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_I",
      markerID = "Draugr3",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 1.3,
      maxActive = 3,
      totalSpawns = 8,
      spawnCooldown = 15
    },
    {
      spawners = "DW_Draugr_L_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_B",
      markerID = "Draugr3",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 8,
      spawnCooldown = 7
    }
  })
  Area_3_Encounter_2:AddWave({
    timeBetweenWaves = 10.1,
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_O*",
      useSpawnLocatorsOnly = true,
      markerID = "DrakOne3",
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2.3,
      maxActive = 3,
      totalSpawns = 4,
      spawnCooldown = 5,
      powerLevel = 2
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_B",
      markerID = "Draugr4",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 10,
      maxActive = 3,
      totalSpawns = 5,
      spawnCooldown = 10,
      powerLevel = 3
    }
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 10,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 8,
      powerLevel = 4
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_I",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = 3,
      powerLevel = 5
    },
    {
      spawners = "H_DrakOne_SFG",
      spawnWad = "Msp130_Arena03",
      spawnLocators = "A3_Loc_B*",
      useSpawnLocatorsOnly = true,
      markerID = "DrakOne3",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 5,
      powerLevel = 3
    }
  })
  Area_3_Encounter_2:OnStart(function()
    eventFailed = false
    A3_Encounters_Index = 2
    Set_Encounter_Timer(120)
    Start_Timer()
    Area_3_Encounter_2:StartInfiniteSpawning(1)
    GameObjects.EntZn_Arena_2_Death_Zone_1:Show()
    LD.ShowFX(zone_1_FX, {cycle = true})
    requiredNumKilled = 5
    numKilled = 0
  end, 1)
  Area_3_Encounter_2:OnComplete(function()
    Reset_Timer()
    GameObjects.EntZn_Arena_2_Death_Zone_1:Hide()
    LD.HideFX(zone_1_FX)
  end, 1)
  Area_3_Encounter_2:OnStart(function()
    Set_Encounter_Timer(180)
    Start_Timer()
    Area_3_Encounter_2:StartInfiniteSpawning(2)
    GameObjects.EntZn_Arena_2_Death_Zone_2:Show()
    LD.ShowFX(zone_2_FX, {cycle = true})
    requiredNumKilled = 5
    numKilled = 0
  end, 2)
  Area_3_Encounter_2:OnComplete(function()
    uiCalls.UI_Event_TurnOffDesignerMessage()
    numKilled = 0
    Reset_Timer()
    GameObjects.EntZn_Arena_2_Death_Zone_2:Hide()
    LD.HideFX(zone_2_FX)
  end, 2)
  Area_3_Encounter_2:OnStart(function()
    Set_Encounter_Timer(240)
    Start_Timer()
    Area_3_Encounter_2:StartInfiniteSpawning(3)
    GameObjects.EntZn_Arena_2_Death_Zone_3:Show()
    LD.ShowFX(zone_3_FX, {cycle = true})
    requiredNumKilled = 5
    numKilled = 0
  end, 3)
  Area_3_Encounter_2:OnEnemyDeath(function(enemy)
    EnemyKilledInZone(Area_3_Encounter_2, 1, enemy, GameObjects.EntZn_Arena_2_Death_Zone_1)
  end, {wave = 1})
  Area_3_Encounter_2:OnEnemyDeath(function(enemy)
    EnemyKilledInZone(Area_3_Encounter_2, 2, enemy, GameObjects.EntZn_Arena_2_Death_Zone_2)
  end, {wave = 2})
  Area_3_Encounter_2:OnEnemyDeath(function(enemy)
    if not Area_3_Encounter_2:IsComplete() then
      EnemyKilledInZone(Area_3_Encounter_2, 3, enemy, zone_List[zoneID])
      LD.CallFunctionAfterDelay(function()
        SwitchKillZone()
      end, 1)
    end
  end, {wave = 3})
  Area_3_Encounter_2:OnComplete(function()
    uiCalls.DisableMechanicText()
    timers.StartLevelTimer(1.5, function()
      uiCalls.UI_Event_TurnOffDesignerMessage()
      uiCalls.DisableMechanicText()
    end)
    numKilled = 0
    Reset_Timer()
    timers.StartLevelTimer(2, function()
      GameObjects.EntZn_Arena_2_Death_Zone_1:Hide()
      GameObjects.EntZn_Arena_2_Death_Zone_2:Hide()
      GameObjects.EntZn_Arena_2_Death_Zone_3:Hide()
      LD.HideFX(zone_1_FX)
      LD.HideFX(zone_2_FX)
      LD.HideFX(zone_3_FX)
    end)
    Time_Attack_Started = false
  end, 3)
  table.insert(A3_Encounters, Area_3_Encounter_2)
  Area_3_Encounter_2:OnStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_23_wave2")
  end, 2)
  Area_3_Encounter_2:OnStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_23_wave3")
  end, 3)
end
function Gold_Challenge_Arena_3_Fight()
  Area_3_Encounter_3 = EC.NewEncounter(thisLevel, "[Arena 3]EC:1 - Gold - Vicious Beasts Msp130", {CheckpointOnComplete = true})
  Area_3_Encounter_3:AddWave({
    timeBetweenWaves = 3,
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_I*",
      markerID = "S",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 0.5,
      powerLevel = 6
    },
    {
      spawners = "Wolf_N_SFG",
      spawnWad = "Msp100_Gold_03",
      spawnLocators = "A3_Loc_I*",
      markerID = "S",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.8,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 5,
      powerLevel = 4
    },
    {
      spawners = "E_Wulver_P_SFG",
      spawnWad = "Msp100_Gold_03",
      spawnLocators = "A3_Loc_I*",
      markerID = "M",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 6.8,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 5
    }
  })
  Area_3_Encounter_3:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "Crawler_N_SFG",
      spawnWad = "Msp100_Gold_03",
      spawnLocators = "A3_Loc_I*",
      markerID = "M",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 10.8,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2,
      powerLevel = 5
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_I*",
      markerID = "M",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 0.5,
      powerLevel = 6
    },
    {
      spawners = "EH_Draugr_L_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_O*",
      markerID = "L",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 13.8,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 5
    }
  })
  Area_3_Encounter_3:AddWave({
    {
      spawners = "E_Jotunn_SFG",
      spawnWad = "Msp100_Gold_03",
      spawnLocators = "A3_Loc_BackEdge_2*",
      markerID = "L",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15,
      powerLevel = 6
    },
    {
      spawners = "Draugr_E_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_BackEdge_*",
      markerID = "S",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 21.8,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2.3,
      powerLevel = 6
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A3_Loc_I*",
      markerID = "M",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 0.5,
      powerLevel = 6
    }
  })
  Area_3_Encounter_3:OnCombatStart(A3_E3_Music_StartMusic)
  Area_3_Encounter_3:OnStart(function()
    eventFailed = false
    A3_Encounters_Index = 3
    Set_Encounter_Timer(120)
    Start_Timer()
    Area_3_Encounter_3:StartInfiniteSpawning(1)
    GameObjects.EntZn_Arena_2_Death_Zone_3:Show()
    LD.ShowFX(zone_3_FX, {cycle = true})
    requiredNumKilled = 5
    numKilled = 0
  end, 1)
  Area_3_Encounter_3:OnEnemyDeath(function(enemy)
    EnemyKilledInZone(Area_3_Encounter_3, 1, enemy, GameObjects.EntZn_Arena_2_Death_Zone_3, 1)
  end, {wave = 1})
  Area_3_Encounter_3:OnComplete(function()
    Reset_Timer()
    GameObjects.EntZn_Arena_2_Death_Zone_3:Hide()
    LD.HideFX(zone_3_FX)
  end, 1)
  Area_3_Encounter_3:OnStart(function()
    Set_Encounter_Timer(180)
    Start_Timer()
    Area_3_Encounter_3:StartInfiniteSpawning(2)
    GameObjects.EntZn_Arena_2_Death_Zone_2:Show()
    LD.ShowFX(zone_2_FX, {cycle = true})
    requiredNumKilled = 5
    numKilled = 0
  end, 2)
  Area_3_Encounter_3:OnEnemyDeath(function(enemy)
    EnemyKilledInZone(Area_3_Encounter_3, 2, enemy, GameObjects.EntZn_Arena_2_Death_Zone_2, 1)
  end, {wave = 2})
  Area_3_Encounter_3:OnComplete(function()
    Reset_Timer()
    GameObjects.EntZn_Arena_2_Death_Zone_2:Hide()
    LD.HideFX(zone_2_FX)
  end, 2)
  Area_3_Encounter_3:OnStart(function()
    Set_Encounter_Timer(300)
    Start_Timer()
    Area_3_Encounter_3:StartInfiniteSpawning(3)
    GameObjects.EntZn_Arena_2_Death_Zone_1:Show()
    LD.ShowFX(zone_1_FX, {cycle = true})
    requiredNumKilled = 8
    numKilled = 0
  end, 3)
  Area_3_Encounter_3:OnEnemyDeath(function(enemy)
    EnemyKilledInZone(Area_3_Encounter_3, 3, enemy, GameObjects.EntZn_Arena_2_Death_Zone_1, 1)
  end, {wave = 3})
  Area_3_Encounter_3:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {wave = 2, element = 1})
  Area_3_Encounter_3:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {wave = 3, element = 4})
  Area_3_Encounter_3:OnComplete(function()
    Reset_Timer()
    uiCalls.DisableMechanicText()
    uiCalls.UI_Event_TurnOffDesignerMessage()
    A3_E3_Music_WinMusic()
  end)
  table.insert(A3_Encounters, Area_3_Encounter_3)
end
function AddOnCompleteCallback(encounterIndex, callback)
  if A3_Encounters and A3_Encounters[encounterIndex] then
    A3_Encounters[encounterIndex]:OnComplete(callback)
  end
end
function Arena_3_Finished()
  uiCalls.DisableMechanicText()
  LD.CallFunctionAfterDelay(function()
    uiCalls.UI_Event_SendDesignerMessage("Arena 3 Finished", -1)
  end, 4.3)
end
function Encounter_Timer()
  timeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = timeRemaining % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37901, {
    minutes,
    seconds,
    numKilled,
    requiredNumKilled
  })
end
function Reset_Timer()
  ecTimer:Stop()
  ecTimer:Reset()
end
function Start_Timer()
  local startDelay = 5
  Time_Attack_Started = true
  ec_TimeRequirement = Challenge_Duration_Time
  ecTimer = timers.StartLevelTimer(ec_TimeRequirement, function()
    EventFailed_TimeElapsed()
  end)
  ecTimer:Stop()
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  local seconds = ec_TimeRequirement % 60
  local minutes = ec_TimeRequirement / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function EventFailed_TimeElapsed()
  local seconds = ec_TimeRequirement % 60
  local minutes = ec_TimeRequirement / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  eventFailed = true
  timers.StartLevelTimer(0.5, function()
    uiCalls.SendBottomDesignerMessage({Text = 37911, Critical = true})
    uiCalls.DisableMechanicText()
  end)
  _G.MSP_Despawn_Enemy_VFX(A3_Encounters[A3_Encounters_Index])
  A3_Encounters[A3_Encounters_Index]:Reset()
  A3_Encounters[A3_Encounters_Index]:Stop()
  GameObjects.Muspelheim_Arena_Marker_03.LuaObjectScript.ChallengeFailed()
  ecTimer:Stop()
  ecTimer:Reset()
  Time_Attack_Started = false
  zoneID = 3
  GameObjects.EntZn_Arena_2_Death_Zone_1:Hide()
  GameObjects.EntZn_Arena_2_Death_Zone_2:Hide()
  GameObjects.EntZn_Arena_2_Death_Zone_3:Hide()
  LD.HideFX(zone_1_FX)
  LD.HideFX(zone_2_FX)
  LD.HideFX(zone_3_FX)
  A3_E3_Music_FailMusic()
end
function Set_Encounter_Timer(timeRequirement)
  ec_TimeRequirement = timeRequirement
  Challenge_Duration_Time = timeRequirement
  ecTimer = timers.StartLevelTimer(timeRequirement, EventFailed_TimeElapsed)
  ecTimer:Stop()
end
function Area_3_OnEncounterFailed()
  _G.MSP_Despawn_Enemy_VFX(A3_Encounters[A3_Encounters_Index])
  A3_Encounters[A3_Encounters_Index]:Reset()
  A3_Encounters[A3_Encounters_Index]:Stop()
  GameObjects.Muspelheim_Arena_Marker_03.LuaObjectScript.ChallengeFailed()
end
function Add_Invincible_Pickup(ai)
  if ai == nil then
    return
  end
  if ai:PickupIsAcquired("DarkOne_Elite_Invincible") then
    print("DarkOne_Elite_Invincible ")
  else
    ai:PickupAcquire("DarkOne_Elite_Invincible")
  end
  if ai:PickupIsAcquired("Invincible") then
    return
  else
    ai:PickupAcquire("Invincible")
  end
end
function Remove_Invincible_Pickup(ai)
  if ai == nil then
    return
  end
  if ai:PickupIsAcquired("DarkOne_Elite_Invincible") then
    ai:PickupRelinquish("DarkOne_Elite_Invincible")
  end
  if ai:PickupIsAcquired("Invincible") then
    ai:PickupRelinquish("Invincible")
  else
    return
  end
end
function InvulnerableSupport(Encounter, TargetWave, SupportWave)
  local enemies
  if Encounter:GetNumEnemiesAlive(SupportWave) >= 1 then
    enemies = Encounter:GetActiveEnemies(TargetWave)
    for _, enemy in pairs(enemies) do
      Add_Invincible_Pickup(enemy)
    end
  else
    enemies = Encounter:GetActiveEnemies(TargetWave)
    for _, enemy in pairs(enemies) do
      Remove_Invincible_Pickup(enemy)
    end
  end
end
function SwitchKillZone()
  if eventFailed then
    return
  end
  if zoneID == 3 then
    zoneID = 1
    GameObjects.EntZn_Arena_2_Death_Zone_3:Hide()
    LD.HideFX(zone_3_FX)
    GameObjects.EntZn_Arena_2_Death_Zone_1:Show()
    LD.ShowFX(zone_1_FX, {cycle = true})
  elseif zoneID == 1 then
    zoneID = 2
    GameObjects.EntZn_Arena_2_Death_Zone_1:Hide()
    LD.HideFX(zone_1_FX)
    GameObjects.EntZn_Arena_2_Death_Zone_2:Show()
    LD.ShowFX(zone_2_FX, {cycle = true})
  elseif zoneID == 2 then
    zoneID = 3
    GameObjects.EntZn_Arena_2_Death_Zone_2:Hide()
    LD.HideFX(zone_2_FX)
    GameObjects.EntZn_Arena_2_Death_Zone_3:Show()
    LD.ShowFX(zone_3_FX, {cycle = true})
  end
end
function EnemyKilledInZone(encounter, wave, enemy, zone, value)
  if value == nil then
    value = 1
  end
  if enemy:InsideZone(zone) then
    numKilled = numKilled + value
    if numKilled >= requiredNumKilled then
      Time_Attack_Started = false
      if encounter:IsRunning() then
        encounter:StopInfiniteSpawning(wave)
        uiCalls.EnableMechanicText("[MSG:38167]")
      end
      LD.HideFX(zone_1_FX)
      LD.HideFX(zone_2_FX)
      LD.HideFX(zone_3_FX)
      _G.MSP_Despawn_Enemy_VFX(encounter)
      encounter:SetComplete(wave)
    end
  end
end
function SpawnHealth(location)
  local spawnArgs = {
    SpawnObject = "goHealthRune_large",
    OffsetPosition = location,
    CullDistance = 100
  }
  thisObj:SpawnGameObject(spawnArgs)
end
function Encounter_HealthMonitor(Enemy, Encounter)
  if Enemy ~= nil then
    local Enemy_Health = Enemy:GetHitPoints()
    E_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Enemy_Health * 0.75
    local Health_Phase_2 = Enemy_Health * 0.5
    local Health_Phase_3 = Enemy_Health * 0.25
    local Health_Phase_4 = Enemy_Health * 0.1
    E_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Encounter:StartWave(3)
    end)
    E_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Encounter:StartWave(4)
    end)
    E_HealthMonitor:OnHealthLessThan(Health_Phase_3, function()
      Encounter:StartWave(5)
    end)
    E_HealthMonitor:OnHealthLessThan(Health_Phase_4, function()
      Encounter:StartWave(6)
    end)
  end
end
function SpawnHealthIndividual(healthLoc)
  local spawnArgs1 = {
    SpawnObject = "goHealthRune_Small",
    HookName = "CallScript_OnHealthSpawned",
    OffsetPosition = LD.GetMarkerPosition(thisLevel, healthLoc),
    Level = thisLevel
  }
  local enemy = LD.FindAllAIByMarker("Invulnerable_AI")
  enemy:SpawnGameObject(spawnArgs1)
end
function EncounterActiveWaves()
  OtherActiveWaves = false
  if Area_3_Encounter_1:IsRunning(2) then
    OtherActiveWaves = true
    return
  end
  if Area_3_Encounter_1:IsRunning(3) then
    OtherActiveWaves = true
    return
  end
  if Area_3_Encounter_1:IsRunning(4) then
    OtherActiveWaves = true
    return
  end
  if Area_3_Encounter_1:IsRunning(5) then
    OtherActiveWaves = true
    return
  end
  if Area_3_Encounter_1:IsRunning(6) then
    OtherActiveWaves = true
    return
  end
end
local A3_E3_Music_IsActive = false
function A3_E3_Music_StartMusic()
  game.Audio.StartMusic("SND_MX_MSP_trial_33_start")
  A3_E3_Music_IsActive = true
end
function A3_E3_Music_FailMusic()
  if A3_E3_Music_IsActive then
    game.Audio.StartMusic("SND_MX_MSP_trial_33_fail")
  end
  A3_E3_Music_IsActive = false
end
function A3_E3_Music_WinMusic()
  game.Audio.StartMusic("SND_MX_MSP_trial_33_win")
  A3_E3_Music_IsActive = false
end
