local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local thisLevel, son, Area_4_Encounter_1, Area_4_Encounter_2, Area_4_Encounter_3
Challenge_Message = nil
local A4_Encounters = {}
local A4_Encounters_Index = 1
Time_Attack_Started = false
local ecTimer, ec_TimeRequirement, timeRemaining
local Son_Capture_Count = 0
local Son_Capture_Count_Max = 3
local Mov_Played = false
local Challenge_Protection = false
local KillCount = 100
local DraugrChallenge_KillCount = KillCount
local Challenge_Duration_Time = 60
Challenge_Airborne = false
local numKilled, requiredNumKilled, Enemy_Health_Monitor
local area4_2Mus = false
airborne = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  son = game.AI.FindSon()
  Bronze_Challenge_Arena_4_Fight()
  Silver_Challenge_Arena_4_Fight()
  Gold_Challenge_Arena_4_Fight()
end
function OnUpdate(level, obj)
  if Time_Attack_Started then
    Encounter_Timer()
  end
  if Challenge_Protection then
    Capture_Son_Check()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Arena_4_Finished()
  uiCalls.UI_Event_SendDesignerMessage("Arena 4 Finished!!!", -1)
end
function Start_Area_4_Encounter_1()
  LD.CallFunctionAfterDelay(function()
    Area_4_Encounter_1:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_4_Encounter_2()
  LD.CallFunctionAfterDelay(function()
    Area_4_Encounter_2:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_4_Encounter_3()
  LD.CallFunctionAfterDelay(function()
    if Area_4_Encounter_3:IsComplete() then
      Area_4_Encounter_3:Restart()
    else
      Area_4_Encounter_3:Start()
    end
  end, _G.GetPreEncounterCooldown())
end
local Arena_4_OnEncounterComplete = function()
  game.World.StoreCheckpoint()
  A4_Encounters_Index = A4_Encounters_Index + 1
  if A4_Encounters[A4_Encounters_Index] ~= nil then
    A4_Encounters[A4_Encounters_Index]:Start()
  else
    Arena_4_Finished()
  end
end
function Airborne_Fight()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 4]EC:1 - Bronze - Juggle to death Fight Msp140", {CheckpointOnComplete = true})
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_I_MiddleGate_1",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.08,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 200,
      powerLevel = 2
    }
  })
  Area_4_Encounter_1:OnStart(function()
    GameObjects.ContextAction_Son_ShootFromPoint.LuaObjectScript.Enable()
    Challenge_Airborne = false
    uiCalls.UI_Event_SendDesignerMessage("Defeat the enemy with a single airborne combo  ", 0)
  end)
  Area_4_Encounter_1:OnComplete(function()
    GameObjects.ContextAction_Son_ShootFromPoint.LuaObjectScript.Disable()
    Challenge_Airborne = false
    Enemy_Health_Monitor:Stop()
    Enemy_Health_Monitor = nil
  end)
  Area_4_Encounter_1:OnEnemySpawn(function(enemy)
    local EnemyHealth = enemy:MeterGetValue("Health")
    Enemy_Health_Monitor = monitors.CreateHealthMonitor(enemy)
    local Health_Phase_1 = EnemyHealth - 1
    Enemy_Health_Monitor:OnHealthLessThan(Health_Phase_1, function()
      LD.CallFunctionAfterDelay(function()
        if enemy.GroundLevel ~= nil then
          Area_4_OnEncounterFailed()
        end
      end, 0.5)
    end)
    LD.CallFunctionAfterDelay(function()
      Challenge_Airborne = true
    end, 2.5)
  end)
  Area_4_Encounter_1:OnEnemyDeath(function(enemy)
    if enemy.GroundLevel == nil then
      Area_4_Encounter_1:SetComplete()
      Arena_4_Finished()
    else
      Area_4_OnEncounterFailed()
    end
  end)
  table.insert(A4_Encounters, Area_4_Encounter_1)
end
function Bronze_Challenge_Arena_4_Fight()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 4]EC:1 - Bronze - 100 Man Msp140", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_MSP_trial_14_start",
    StopMusic = "SND_MX_MSP_trial_14_win"
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 4,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 8
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 4,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 5
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A4_Loc_Open*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 5
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 4,
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 5
    },
    {
      spawners = "Traveler_B_SFG",
      spawnLocators = "A4_Loc_I*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 6
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 5,
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 4,
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 8
    },
    {
      spawners = "Draugr_S_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2.8,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 5
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 4,
    {
      spawners = "H_Draugr_B_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8
    },
    {
      spawners = "Draugr_E_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = 2
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 5,
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 8
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 3.23,
    {
      spawners = "Traveler_B_SFG",
      spawnLocators = "A4_Loc_I*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      powerLevel = 6,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 4
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 10,
      maxActive = 4,
      totalSpawns = 6,
      spawnCooldown = 5,
      powerLevel = 3
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 5,
    {
      spawners = "H_Draugr_L_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8
    },
    {
      spawners = "Draugr_PL_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 2
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 5,
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "Fanatic_A_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2.8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 5
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 5.23,
    powerLevel = 4,
    {
      spawners = "Jotunn_C_SFG",
      spawnLocators = "A4_Loc_BackEdge_1",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Jotunn_SCS",
      spawnLocators = "A4_Loc_I_MiddleGate_1",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Jotunn_SFG",
      spawnLocators = "A4_Loc_BackEdge_3",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 4,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 6,
      totalSpawns = 8,
      spawnCooldown = 2
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 5,
    {
      spawners = "SH_Draugr_E_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 8
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 2
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 5,
    {
      spawners = "H_Draugr_P_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 8
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 3,
      totalSpawns = 4,
      spawnCooldown = 3
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5.8,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 5,
    {
      spawners = "Jotunn_C_SFG",
      spawnLocators = "A4_Loc_BackEdge_*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    },
    {
      spawners = "Traveler_S_SFG",
      spawnLocators = "A4_Loc_I*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 5,
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2.2,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 8
    },
    {
      spawners = "Draugr_PL_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 1.6,
      maxActive = 4,
      totalSpawns = 4,
      spawnCooldown = 5
    }
  })
  Area_4_Encounter_1:AddWave({
    timeBetweenWaves = 2.23,
    {
      spawners = "Traveler_B_SFG",
      spawnLocators = "A4_Loc_I*",
      spawnWad = "Msp140_Arena04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 5
    },
    {
      spawners = "Draugr_E_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.8,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 8,
      powerLevel = 4
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 1.3,
      maxActive = 3,
      totalSpawns = 6,
      spawnCooldown = 3,
      powerLevel = 4
    }
  })
  Area_4_Encounter_1:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.03, function()
      if enemy ~= nil then
        enemy:ForceMove("BRA_SetDontDropLootFlag_On")
      end
    end)
  end)
  Area_4_Encounter_1:OnStart(function()
    uiCalls.EnableMechanicText("[MSG:37422]")
  end)
  Area_4_Encounter_1:OnEnemyDeath(function()
    DraugrChallenge_KillCount = DraugrChallenge_KillCount - 1
    if 0 < DraugrChallenge_KillCount and 0 < KillCount then
      uiCalls.EnableMechanicText(37922, {DraugrChallenge_KillCount})
    end
  end)
  Area_4_Encounter_1:OnComplete(function()
    uiCalls.DisableMechanicText()
  end)
  Area_4_Encounter_1:OnStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_14_wave2")
  end, 8)
  Area_4_Encounter_1:OnStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_14_wave3")
  end, 13)
  table.insert(A4_Encounters, Area_4_Encounter_1)
end
function Silver_Challenge_Arena_4_Fight()
  Area_4_Encounter_2 = EC.NewEncounter(thisLevel, "[Arena 4]EC:2 - Silver avoid son capture Msp140", {CheckpointOnComplete = true})
  Area_4_Encounter_2:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "SK_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      markerID = "SK",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = {
        20,
        15,
        10
      },
      powerLevel = 4
    },
    {
      spawners = "Draugr_PL_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_B",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 2.7,
      initialSpawnAmount = 2,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = {
        21,
        13,
        8,
        5,
        3
      },
      powerLevel = 6
    }
  })
  Area_4_Encounter_2:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "SK_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_O",
      markerID = "SK",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = {
        21,
        13,
        8,
        5
      },
      powerLevel = 4
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_B",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 18,
      initialSpawnAmount = 2,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 10,
      powerLevel = 6
    },
    {
      spawners = "Jotunn_C_SFG",
      spawnWad = "Msp140_Arena04",
      spawnLocators = "A4_Loc_B",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 30,
      powerLevel = 6
    }
  })
  Area_4_Encounter_2:AddWave({
    {
      spawners = "SK_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_O",
      markerID = "SK",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 5,
      powerLevel = 4
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnWad = "Msp140_Arena04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 2.7,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "Traveler_B_SFG",
      spawnWad = "Msp140_Arena04",
      spawnLocators = "A4_Loc_B",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 5
    }
  })
  Area_4_Encounter_2:OnComplete(function()
    uiCalls.EnableMechanicText("[MSG:38167]")
  end, 1)
  Area_4_Encounter_2:OnComplete(function()
    uiCalls.EnableMechanicText("[MSG:38167]")
  end, 2)
  Area_4_Encounter_2:OnComplete(function()
    uiCalls.EnableMechanicText("[MSG:38167]")
  end, 3)
  Area_4_Encounter_2:OnComplete(function()
    uiCalls.DisableMechanicText()
    Area4_2Music()
  end)
  Area_4_Encounter_2:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_24_start")
    area4_2Mus = false
  end)
  Area_4_Encounter_2:OnStart(function()
    son:PickupAcquire("MuspelheimSonGrab")
    A4_Encounters_Index = 2
    Challenge_Protection = true
    uiCalls.EnableMechanicText("[MSG:37917]")
  end, 1)
  Area_4_Encounter_2:OnStart(function()
    Son_Capture_Count = 0
    timers.StartLevelTimer(1, function()
      uiCalls.EnableMechanicText(37918, {Son_Capture_Count, Son_Capture_Count_Max})
    end)
  end, 2)
  Area_4_Encounter_2:OnStart(function()
    Son_Capture_Count = 0
    timers.StartLevelTimer(1, function()
      uiCalls.EnableMechanicText(37918, {Son_Capture_Count, Son_Capture_Count_Max})
    end)
  end, 3)
  Area_4_Encounter_2:OnEnemySpawn(function(enemy)
    enemy:PickupAcquire("MuspelheimSonGrab")
  end, {markerID = "SK"})
  Area_4_Encounter_2:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {wave = 2, element = 2})
  Area_4_Encounter_2:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {wave = 3, element = 2})
  Area_4_Encounter_2:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {wave = 3, element = 3})
  table.insert(A4_Encounters, Area_4_Encounter_2)
end
function Gold_Challenge_Arena_4_Fight()
  Area_4_Encounter_3 = EC.NewEncounter(thisLevel, "[Arena 4]EC:3 - Gold - Light Regeneration - Msp140", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_MSP_trial_34_start",
    StopMusic = "SND_MX_MSP_trial_34_win"
  })
  Area_4_Encounter_3:AddWave({
    timeBetweenWaves = 2.3,
    powerLevel = 8,
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 1,
      powerLevel = 6
    },
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 6
    },
    {
      spawners = "H_Projection_S_SFG",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_I_M*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 8.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = 0.85,
      powerLevel = 7
    },
    {
      spawners = "H_Projection_S_SFG",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_I_M*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 8.5,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 0.85,
      powerLevel = 7
    }
  })
  Area_4_Encounter_3:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "E_Crawler_P_SFG",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 21.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 5
    },
    {
      spawners = "DW_Draugr_L_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 7
    }
  })
  Area_4_Encounter_3:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "EH_DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 7
    },
    {
      spawners = "EH_DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 6
    },
    {
      spawners = "Seidr_Bandit_SFG",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 5,
      spawnCooldown = 2.5,
      powerLevel = 6
    }
  })
  Area_4_Encounter_3:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "H_Draugr_P_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 0.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 6
    },
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3,
      powerLevel = 6
    },
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 7
    }
  })
  Area_4_Encounter_3:AddWave({
    timeBetweenWaves = 5,
    powerLevel = 6,
    {
      spawners = "Draugr_E_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 0.5
    },
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp100_Gold_04",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 21.5,
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = 1
    },
    {
      spawners = "Draugr_L_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A4_Loc_O",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 5
    }
  })
  Area_4_Encounter_3:OnStart(function()
    A4_Encounters_Index = 3
    uiCalls.EnableMechanicText(37433, {
      #Area_4_Encounter_3.waves
    })
  end)
  Area_4_Encounter_3:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.5, function()
      enemy:PickupAcquire("MuspelheimHealthRegenChallenge")
    end)
  end)
  Area_4_Encounter_3:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {
    wave = 4,
    element = 1,
    count = 3
  })
  Area_4_Encounter_3:OnComplete(function()
    uiCalls.DisableMechanicText()
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end)
  table.insert(A4_Encounters, Area_4_Encounter_3)
end
function AddOnCompleteCallback(encounterIndex, callback)
  if A4_Encounters and A4_Encounters[encounterIndex] then
    A4_Encounters[encounterIndex]:OnComplete(callback)
  end
end
function Encounter_Timer()
  timeRemaining = math.floor(ecTimer:GetRemainingTime())
  local seconds = timeRemaining % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.UI_Event_ClearAllDesignerMessages()
  uiCalls.SendStandardDesignerMessage({
    Text = 37907,
    DisplayTime = 0.05,
    FadeInTime = 0,
    formattedArgs = {
      1,
      minutes,
      seconds
    },
    Critical = true
  })
end
function Start_Timer()
  local startDelay = 5
  Time_Attack_Started = true
  ec_TimeRequirement = Challenge_Duration_Time
  ecTimer = StartLevelTimer(ec_TimeRequirement, function()
    EventFailed_TimeElapsed()
  end)
  ecTimer:Stop()
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  local seconds = ec_TimeRequirement % 60
  local minutes = ec_TimeRequirement / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function EventFailed_TimeElapsed()
  local seconds = ec_TimeRequirement % 60
  local minutes = ec_TimeRequirement / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.SendBottomDesignerMessage({Text = 37911, Critical = true})
  Area_4_OnEncounterFailed()
  ecTimer:Stop()
  ecTimer:Reset()
  Time_Attack_Started = false
end
function Capture_Son_Check()
  if son:IsPlayingMove("MOV_CSAttGrabSonIdle") and Mov_Played ~= true then
    local movepercentage = son:GetActiveMovePercent()
    if 0.97 <= movepercentage then
      Mov_Played = true
      Son_Capture_Count = Son_Capture_Count + 1
      uiCalls.EnableMechanicText(37918, {Son_Capture_Count, Son_Capture_Count_Max})
      if Son_Capture_Count >= Son_Capture_Count_Max then
        Son_Capture_Count = 0
        _G.MSP_Despawn_Enemy_VFX(Area_4_Encounter_2)
        Area_4_Encounter_2:Reset()
        Area_4_Encounter_2:Stop()
        uiCalls.SendBottomDesignerMessage({Text = 37911, Critical = true})
        uiCalls.DisableMechanicText()
        Area_4_OnEncounterFailed()
        Area4_2MusicFail()
        if son:PickupIsAcquired("MuspelheimSonGrab") then
          son:PickupRelinquish("MuspelheimSonGrab")
        end
        Challenge_Protection = false
      end
    end
  elseif not son:IsPlayingMove("MOV_CSAttGrabSonIdle") and Mov_Played == true then
    Mov_Played = false
  end
end
function Set_Encounter_Timer(timeRequirement)
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, EventFailed_TimeElapsed)
  ecTimer:Stop()
end
function Area_4_OnEncounterFailed()
  GameObjects.ContextAction_Son_ShootFromPoint.LuaObjectScript.Disable()
  _G.MSP_Despawn_Enemy_VFX(A4_Encounters[A4_Encounters_Index])
  A4_Encounters[A4_Encounters_Index]:Reset()
  A4_Encounters[A4_Encounters_Index]:Stop()
  GameObjects.Muspelheim_Arena_Marker_04.LuaObjectScript.ChallengeFailed()
end
function Add_Invincible_Pickup(ai)
  if ai == nil then
    return
  end
  if ai:PickupIsAcquired("Invincible") then
    return
  else
    ai:PickupAcquire("Invincible")
  end
end
function Remove_Invincible_Pickup(ai)
  if ai == nil then
    return
  end
  if ai:PickupIsAcquired("Invincible") then
    ai:PickupRelinquish("Invincible")
  else
    return
  end
end
function Area4_2Music()
  if area4_2Mus == false then
    game.Audio.StartMusic("SND_MX_MSP_trial_24_win")
  end
end
function Area4_2MusicFail()
  game.Audio.StartMusic("SND_MX_MSP_trial_24_fail")
  area4_2Mus = true
end
