local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local delayTimers = require("level.timer")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local thisLevel, player, Area_5_Encounter_1, Area_5_Encounter_2, Area_5_Encounter_3
local area5_1Mus = false
local area5_2Mus = false
local AirborneKills = 3
local AirborneChallenge_KillCount = 0
local A5_Encounters = {}
local A5_Encounters_Index = 1
local Time_Attack_Started = false
local ecTimer, ec_TimeRequirement, timeRemaining
local Challenge_Additional_Time_Amount = 20
local Challenge_Duration_Time = 60
local Challenge_Max_Time = 90
local Challenge_KillCount = 15
local ONE_HIT = false
local numKilled, requiredNumKilled
local startTimeDelay = 5.3
local OneHitCallMonitor
local KillCount = 20
local DraugrChallenge_KillCount = KillCount
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  Bronze_Challenge_Arena_5_Fight()
  Silver_Challenge_Arena_5_Fight()
  Gold_Challenge_Arena_5_Fight()
end
function OnStart(level, obj)
  GameObjects.EntZn_Arena_5_Death_Zone_1:Hide()
  GameObjects.EntZn_Arena_5_Death_Zone_2:Hide()
end
function OnUpdate(level, obj)
  if Time_Attack_Started then
    Encounter_Timer()
  end
  if ONE_HIT and not player:PickupIsAcquired("MuspelheimSingleHitChallenge") then
    EventFailed_OneHit()
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Arena_5_Finished()
  uiCalls.UI_Event_ClearAllDesignerMessages()
  ecTimer:Stop()
  ecTimer:Reset()
  Time_Attack_Started = false
end
function Start_Area_5_Encounter_1()
  LD.CallFunctionAfterDelay(function()
    Area_5_Encounter_1:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_5_Encounter_2()
  LD.CallFunctionAfterDelay(function()
    Area_5_Encounter_2:Start()
  end, _G.GetPreEncounterCooldown())
end
function Start_Area_5_Encounter_3()
  LD.CallFunctionAfterDelay(function()
    if Area_5_Encounter_3:IsComplete() then
      Area_5_Encounter_3:Restart()
    else
      Area_5_Encounter_3:Start()
    end
  end, _G.GetPreEncounterCooldown())
end
local Arena_5_OnEncounterComplete = function()
  game.World.StoreCheckpoint()
  A5_Encounters_Index = A5_Encounters_Index + 1
  if A5_Encounters[A5_Encounters_Index] ~= nil then
    A5_Encounters[A5_Encounters_Index]:Start()
  else
    Arena_5_Finished()
  end
end
function Bronze_Challenge_Arena_5_Fight()
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 5]EC:1 - Bronze - Extra Time Msp150", {CheckpointOnComplete = true})
  Area_5_Encounter_1:AddWave({
    timeBetweenWaves = 3.5,
    {
      spawners = "Traveler_S_SFG",
      spawnWad = "Msp150_Arena05",
      markerID = "Traveler",
      spawnLocators = "A5_Loc_I_L*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = 6
    },
    {
      spawners = "Helwalker_SRFC",
      spawnWad = "Msp150_Arena05",
      markerID = "Helwalker",
      initialSpawnCooldown = 0.08,
      initialSpawnAmount = 2,
      spawnLocators = "A5_Loc_I_*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 6,
      spawnCooldown = 6,
      powerLevel = 4
    }
  })
  Area_5_Encounter_1:AddWave({
    timeBetweenWaves = 3.5,
    {
      spawners = "Wulver_S_SFG",
      spawnWad = "Msp150_Arena05",
      spawnLocators = "A5_Loc_I_L*",
      markerID = "Wulver",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10,
      powerLevel = 6
    },
    {
      spawners = "Flyer_B_SABU",
      spawnWad = "Msp150_Arena05",
      markerID = "Flyer",
      initialSpawnCooldown = 2.08,
      initialSpawnAmount = 1,
      spawnLocators = "A5_Loc_O_",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 6,
      spawnCooldown = 5,
      powerLevel = 5
    },
    {
      spawners = "Wulver_S_SFG",
      spawnWad = "Msp150_Arena05",
      spawnLocators = "A5_Loc_I_R*",
      markerID = "Wulver",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13,
      powerLevel = 6
    }
  })
  Area_5_Encounter_1:AddWave({
    {
      spawners = "Golem_S_SFG",
      spawnWad = "Msp150_Arena05",
      spawnLocators = "A5_Loc_I_L*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = 5
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      initialSpawnCooldown = 0.08,
      initialSpawnAmount = 2,
      spawnLocators = "A5_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 5,
      spawnCooldown = 6,
      powerLevel = 4
    }
  })
  Area_5_Encounter_1:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_15_start")
    area5_1Mus = false
  end)
  Area_5_Encounter_1:OnStart(function()
    Start_Timer()
    A5_Encounters_Index = 1
  end)
  Area_5_Encounter_1:OnEnemyDeath(Add_Time)
  Area_5_Encounter_1:OnComplete(function()
    uiCalls.EnableMechanicText("[MSG:38167]")
    ecTimer:Stop()
    Time_Attack_Started = false
    timers.StartLevelTimer(3, function()
      Time_Attack_Started = true
      ec_TimeRequirement = 40
      Add_Time()
    end)
  end, 1)
  Area_5_Encounter_1:OnComplete(function()
    uiCalls.EnableMechanicText("[MSG:38167]")
    ecTimer:Stop()
    Time_Attack_Started = false
    timers.StartLevelTimer(3, function()
      Time_Attack_Started = true
      ec_TimeRequirement = 40
      Add_Time()
    end)
  end, 2)
  Area_5_Encounter_1:OnComplete(function()
    uiCalls.DisableMechanicText()
    Arena_5_Finished()
    Area5_1MusicWin()
  end)
  table.insert(A5_Encounters, Area_5_Encounter_1)
end
function Silver_Challenge_Arena_5_Fight()
  Area_5_Encounter_2 = EC.NewEncounter(thisLevel, "[Arena 5]EC:2 - Silver - No Hit Msp150", {CheckpointOnComplete = true})
  Area_5_Encounter_2:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 5,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A5_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 5
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A5_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_5_Encounter_2:AddWave({
    powerLevel = 5,
    {
      spawners = "Flyer_N_SABU",
      spawnLocators = "A5_Loc_O*",
      spawnWad = "Msp150_Arena05",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8
    },
    {
      spawners = "U_Draugr_P_SFG",
      spawnLocators = "A5_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 10
    },
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A5_Loc_BackEdge_",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15
    }
  })
  Area_5_Encounter_2:AddWave({
    requiredWaveCompletion = 75,
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "A5_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 5
    },
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "A5_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 5
    }
  })
  Area_5_Encounter_2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A5_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 6,
      powerLevel = 6
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A5_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 4,
      totalSpawns = 4,
      spawnCooldown = 8,
      powerLevel = 6
    }
  })
  Area_5_Encounter_2:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_MSP_trial_25_start")
    area5_2Mus = false
  end)
  Area_5_Encounter_2:OnStart(function()
    A5_Encounters_Index = 2
    One_Hit_Challenge()
    uiCalls.EnableMechanicText(37922, {DraugrChallenge_KillCount})
  end, 1)
  Area_5_Encounter_2:OnEnemySpawn(function(enemy)
    enemy:ForceMove("MOV_SetDontDropLootFlag_On")
  end)
  Area_5_Encounter_2:OnEnemyDeath(function()
    if DraugrChallenge_KillCount == nil then
      return
    end
    DraugrChallenge_KillCount = DraugrChallenge_KillCount - 1
    if 0 < DraugrChallenge_KillCount and 0 < KillCount then
      uiCalls.EnableMechanicText(37922, {DraugrChallenge_KillCount})
    end
  end)
  Area_5_Encounter_2:OnComplete(function()
    uiCalls.DisableMechanicText()
    ONE_HIT = false
    Clear_One_Hit_Challenge()
    onehitMusicWin()
  end)
  table.insert(A5_Encounters, Area_5_Encounter_2)
end
function Gold_Challenge_Arena_5_Fight()
  Area_5_Encounter_3 = EC.NewEncounter(thisLevel, "[Arena 5]EC:3 - Gold - Stone Cold Death Msp150 ", {CheckpointOnComplete = true})
  Area_5_Encounter_3:AddWave({
    timeBetweenWaves = 1.1,
    {
      spawners = "Draugr_E_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A5_Loc_O*",
      markerID = "ADD_TIME",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A5_Loc_O*",
      markerID = "ADD_TIME",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 3.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "E_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A5_Loc_O*",
      useSpawnLocatorsOnly = true,
      markerID = "ADD_LARGE_TIME",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A5_Loc_O*",
      markerID = "ADD_LARGE_TIME",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 13,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 7
    }
  })
  Area_5_Encounter_3:AddWave({
    timeBetweenWaves = 1.13,
    {
      spawners = "E_Witch_F_SFG",
      spawnWad = "Msp100_Gold_05",
      spawnLocators = "A5_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.3,
      markerID = "ADD_LARGE_TIME",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.3,
      powerLevel = 7
    },
    {
      spawners = "Wulver_P_SFG",
      spawnWad = "Msp100_Gold_05",
      spawnLocators = "A5_Loc_O_*",
      useSpawnLocatorsOnly = true,
      markerID = "ADD_TIME",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 7
    }
  })
  Area_5_Encounter_3:AddWave({
    timeBetweenWaves = 1.35,
    {
      spawners = "E_Traveler_S_SFG",
      spawnWad = "Msp100_Gold_05",
      spawnLocators = "A5_Loc_I_LeftGate_2",
      markerID = "ADD_LARGE_TIME",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1,
      powerLevel = 7
    },
    {
      spawners = "Traveler_B_SFG",
      spawnWad = "Msp100_Gold_05",
      spawnLocators = "A5_Loc_I_MiddleGate_2",
      markerID = "ADD_LARGE_TIME",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3,
      powerLevel = 7
    },
    {
      spawners = "DW_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A5_Loc_O",
      markerID = "ADD_TIME",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5.52,
      powerLevel = 7
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A5_Loc_O",
      useSpawnLocatorsOnly = true,
      markerID = "ADD_LARGE_TIME",
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 7
    }
  })
  Area_5_Encounter_3:OnComplete(function()
    uiCalls.DisableMechanicText()
    Arena_5_Finished()
    A5_E3_Music_WinMusic()
  end)
  Area_5_Encounter_3:OnCombatStart(A5_E3_Music_StartMusic)
  Area_5_Encounter_3:OnStart(function()
    A5_Encounters_Index = 3
    Challenge_Additional_Time_Amount = 10
    Challenge_Duration_Time = 60
    Challenge_Max_Time = 90
    Set_Encounter_Timer(Challenge_Duration_Time)
    Start_Timer()
  end)
  Area_5_Encounter_3:OnEnemyDeath(function(enemy)
    Add_Time()
  end, {markerID = "ADD_TIME"})
  Area_5_Encounter_3:OnEnemyDeath(function(enemy)
    Add_Large_Time()
  end, {
    markerID = "ADD_LARGE_TIME"
  })
  Area_5_Encounter_3:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {wave = 3, element = 1})
  table.insert(A5_Encounters, Area_5_Encounter_3)
end
function AddOnCompleteCallback(encounterIndex, callback)
  if A5_Encounters and A5_Encounters[encounterIndex] then
    A5_Encounters[encounterIndex]:OnComplete(callback)
  end
end
function Encounter_Timer()
  timeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = timeRemaining % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37920, {minutes, seconds})
end
function Add_Time()
  ec_TimeRequirement = ec_TimeRequirement - ecTimer.time + Challenge_Additional_Time_Amount
  ecTimer:Stop()
  ecTimer = nil
  if ec_TimeRequirement > Challenge_Max_Time then
    ec_TimeRequirement = Challenge_Max_Time
    ecTimer = StartLevelTimer(ec_TimeRequirement, function()
      EventFailed_TimeElapsed()
    end)
    ecTimer:Start()
  else
    ecTimer = StartLevelTimer(ec_TimeRequirement, function()
      EventFailed_TimeElapsed()
    end)
    ecTimer:Start()
  end
end
function Add_Large_Time()
  ec_TimeRequirement = ec_TimeRequirement - ecTimer.time + Challenge_Additional_Time_Amount + 20
  ecTimer:Stop()
  ecTimer = nil
  if ec_TimeRequirement > Challenge_Max_Time then
    ec_TimeRequirement = Challenge_Max_Time
    ecTimer = StartLevelTimer(ec_TimeRequirement, function()
      EventFailed_TimeElapsed()
    end)
    ecTimer:Start()
  else
    ecTimer = StartLevelTimer(ec_TimeRequirement, function()
      EventFailed_TimeElapsed()
    end)
    ecTimer:Start()
  end
end
function Start_Timer()
  local startDelay = 5
  Time_Attack_Started = true
  ec_TimeRequirement = Challenge_Duration_Time
  ecTimer = StartLevelTimer(ec_TimeRequirement, function()
    EventFailed_TimeElapsed()
  end)
  ecTimer:Stop()
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  timeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = ec_TimeRequirement % 60
  local minutes = (timeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function EventFailed_TimeElapsed()
  local seconds = Challenge_Duration_Time % 60
  local minutes = Challenge_Duration_Time / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.SendBottomDesignerMessage({Text = 37911, Critical = true})
  uiCalls.DisableMechanicText()
  _G.MSP_Despawn_Enemy_VFX(A5_Encounters[A5_Encounters_Index])
  A5_Encounters[A5_Encounters_Index]:Reset()
  A5_Encounters[A5_Encounters_Index]:Stop()
  Area_5_OnEncounterFailed()
  ecTimer:Stop()
  ecTimer:Reset()
  Time_Attack_Started = false
  Area5_1MusicFail()
  A5_E3_Music_FailMusic()
end
function Set_Encounter_Timer(timeRequirement)
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, EventFailed_TimeElapsed)
  ecTimer:Stop()
end
function Area_5_OnEncounterFailed()
  _G.MSP_Despawn_Enemy_VFX(A5_Encounters[A5_Encounters_Index])
  A5_Encounters[A5_Encounters_Index]:Reset()
  A5_Encounters[A5_Encounters_Index]:Stop()
  GameObjects.Muspelheim_Arena_Marker_05.LuaObjectScript.ChallengeFailed()
end
function One_Hit_Challenge()
  ONE_HIT = true
  player:PickupAcquire("MuspelheimSingleHitChallenge")
end
function Clear_One_Hit_Challenge()
  uiCalls.UI_Event_ClearAllDesignerMessages()
  if player:PickupIsAcquired("MuspelheimSingleHitChallenge") then
    player:PickupRelinquish("MuspelheimSingleHitChallenge")
  end
end
function EventFailed_OneHit()
  ONE_HIT = false
  timers.StartLevelTimer(1.2, function()
    uiCalls.SendBottomDesignerMessage({Text = 37911, Critical = true})
  end)
  DraugrChallenge_KillCount = nil
  timers.StartLevelTimer(1, function()
    uiCalls.DisableMechanicText()
    Area_5_OnEncounterFailed()
    DraugrChallenge_KillCount = KillCount
  end)
  _G.MSP_Despawn_Enemy_VFX(A5_Encounters[A5_Encounters_Index])
  A5_Encounters[A5_Encounters_Index]:Reset()
  A5_Encounters[A5_Encounters_Index]:Stop()
  onehitMusicFail()
end
function InsideDeathZone()
  for i = 1, #Area_5_Encounter_2 do
    if Area_5_Encounter_2[i]:InsideZone(GameObjects.EntZn_Arena_5_Death_Zone_1) or Area_5_Encounter_2[i]:InsideZone(GameObjects.EntZn_Arena_5_Death_Zone_2) then
      uiCalls.UI_Event_SendTutorialMessage("In", 0)
      if Area_5_Encounter_2[i]:PickupIsAcquired("Invincible") then
        return
      else
        Area_5_Encounter_2[i]:PickupAcquire("Invincible")
      end
    else
      return
    end
  end
end
function OutsideDeathZone()
  for i = 1, #Area_5_Encounter_2 do
    if not Area_5_Encounter_2[i]:InsideZone(GameObjects.EntZn_Arena_5_Death_Zone_1) and not Area_5_Encounter_2[i]:InsideZone(GameObjects.EntZn_Arena_5_Death_Zone_2) then
      if Area_5_Encounter_2[i]:PickupIsAcquired("Invincible") then
        Area_5_Encounter_2[i]:PickupRelinquish("Invincible")
      else
        return
      end
    else
      return
    end
  end
end
function Area5_1MusicWin()
  if area5_1Mus == false then
    game.Audio.StartMusic("SND_MX_MSP_trial_15_win")
  end
end
function Area5_1MusicFail()
  game.Audio.StartMusic("SND_MX_MSP_trial_15_fail")
  area5_1Mus = true
end
function onehitMusicWin()
  if area5_2Mus == false then
    game.Audio.StartMusic("SND_MX_MSP_trial_25_win")
  end
end
function onehitMusicFail()
  game.Audio.StartMusic("SND_MX_MSP_trial_25_fail")
  area5_2Mus = true
end
local A5_E3_Music_IsActive = false
function A5_E3_Music_StartMusic()
  game.Audio.StartMusic("SND_MX_MSP_trial_35_start")
  A5_E3_Music_IsActive = true
end
function A5_E3_Music_FailMusic()
  if A5_E3_Music_IsActive then
    game.Audio.StartMusic("SND_MX_MSP_trial_35_fail")
  end
  A5_E3_Music_IsActive = false
end
function A5_E3_Music_WinMusic()
  game.Audio.StartMusic("SND_MX_MSP_trial_35_win")
  A5_E3_Music_IsActive = false
end
