local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local thisLevel, Area_6_Valkyrie_Encounter, Area_6_Encounter_2
local A6_Encounters = {}
local A6_Encounters_Index = 1
local Area_6_Gold_Challenge_1, Area_6_Gold_Challenge_2, Area_6_Gold_Challenge_3, Area_6_Gold_Challenge_4
local A6_Challenge_Encounters = {}
local managerScript, onStartCallbacks
function OnScriptLoaded(level, obj)
  thisLevel = level
  managerScript = GameObjects.MSP_Arena06ChallengeManager.LuaObjectScript
  Silver_Challenge_Arena_6_Fight()
  Gold_Challenge_Arena_6_Fight_1()
  Gold_Challenge_Arena_6_Fight_2()
  Gold_Challenge_Arena_6_Fight_3()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  FireQueuedOnStartCallbacks()
end
function AddOnCompleteCallback(encounterIndex, callback)
  if A6_Encounters and A6_Encounters[encounterIndex] ~= nil then
    A6_Encounters[encounterIndex]:OnComplete(callback)
  end
end
function Start_Area_6_Encounter_2()
  Area_6_Valkyrie_Encounter:Start()
end
function Silver_Challenge_Arena_6_Fight()
  Area_6_Valkyrie_Encounter = EC.NewEncounter(thisLevel, "[Arena 6]EC:0 Valkyrie Msp160", {
    CheckpointOnComplete = true,
    AutoResetOnReload = true,
    LeashZone = "LshZn_MSP160"
  })
  Area_6_Valkyrie_Encounter:AddWave({
    {
      spawners = "Valkyrie_Fire_Cocoon",
      spawnWad = "Msp160_Arena06",
      spawnLocators = "A6_Loc_O_MiddleGate_1*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_6_Valkyrie_Encounter:SetAlertZone(GameObjects.EntZn_Valkyrie_Alert)
  Area_6_Valkyrie_Encounter:OnComplete(function()
    GameObjects.Arena6_AIWall:HideCollision()
  end)
  Area_6_Valkyrie_Encounter:OnCombatStart(function()
    GameObjects.Arena6_AIWall:ShowCollision()
    game.Audio.StartMusic("SND_MX_MSP_valkyrie_fight_in")
  end)
  table.insert(A6_Encounters, Area_6_Valkyrie_Encounter)
end
function GetChallengeEncounters()
  return A6_Challenge_Encounters
end
function GetChallengeTypes()
  return managerScript.GetAllChallengeInfo().types
end
function AddToStartQueue(fn)
  if onStartCallbacks == nil then
    onStartCallbacks = {}
  end
  onStartCallbacks[#onStartCallbacks + 1] = fn
end
function FireQueuedOnStartCallbacks()
  if onStartCallbacks ~= nil then
    for _, fn in pairs(onStartCallbacks) do
      fn()
    end
  end
end
function Start_Area_6_Encounter_3()
  LD.CallFunctionAfterDelay(function()
    if A6_Challenge_Encounters[managerScript.GetAllChallengeInfo().currentID]:IsComplete() then
      A6_Challenge_Encounters[managerScript.GetAllChallengeInfo().currentID]:Restart()
    else
      A6_Challenge_Encounters[managerScript.GetAllChallengeInfo().currentID]:Start()
    end
  end, _G.GetPreEncounterCooldown())
end
function Gold_Challenge_Arena_6_Fight_1()
  Area_6_Gold_Challenge_1 = EC.NewEncounter(thisLevel, "[Arena 6]EC:1 Gold 50 Man Challenge", {CheckpointOnComplete = true})
  Area_6_Gold_Challenge_1:AddWave({
    powerLevel = 4,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.1,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    powerLevel = 5,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.1,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2
    },
    {
      spawners = "SH_Draugr_E_SFG",
      spawnLocators = "A6_Loc_Open*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.83,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 2
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    powerLevel = 5,
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.2,
      maxActive = 4,
      totalSpawns = 4,
      spawnCooldown = 1
    },
    {
      spawners = "Traveler_B_SFG",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 4
    },
    {
      spawners = "H_Draugr_B_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 6,
      powerLevel = 5
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    {
      spawners = "Jotunn_C_SFG",
      spawnLocators = "A6_Loc_BackEdge_*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 5
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    {
      spawners = "E_SH_Draugr_L_SFG",
      spawnLocators = "A6_Loc_O",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      powerLevel = 6,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = 5
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    {
      spawners = "Flyer_I_SABU",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 0.1,
      powerLevel = 5
    },
    {
      spawners = "Wulver_P_SFG",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    {
      spawners = "Traveler_S_SFG",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 13.1,
      powerLevel = 6
    },
    {
      spawners = "DW_Draugr_L_SPRINT",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    powerLevel = 6,
    {
      spawners = "Draugr_EL_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "H_Draugr_P_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3.8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    powerLevel = 5,
    {
      spawners = "Jotunn_SFG",
      spawnLocators = "A6_Loc_BackEdge_1*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Wulver_S_SFG",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 10
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    powerLevel = 7,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3,
      powerLevel = 6
    },
    {
      spawners = "SH_Draugr_EL_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 3,
      powerLevel = 5
    }
  })
  Area_6_Gold_Challenge_1:AddWave({
    {
      spawners = "Traveler_B_SFG",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      powerLevel = 6,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 2,
      powerLevel = 6
    },
    {
      spawners = "E_Draugr_N_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 10,
      maxActive = 3,
      totalSpawns = 5,
      spawnCooldown = 3,
      powerLevel = 5
    },
    {
      spawners = "Seidr_Fanatic_B_SFG",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 10,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3,
      powerLevel = 7
    }
  })
  AddToStartQueue(function()
    local player = game.Player.FindPlayer()
    local goldRequirement = "8:00"
    if player ~= nil then
      local difficulty = player:AttributeGetValue("Difficulty")
      if difficulty == 3 then
        goldRequirement = "9:00"
      elseif difficulty == 4 then
        goldRequirement = "11:00"
      end
    end
    managerScript.SetupChallenge(Area_6_Gold_Challenge_1, {
      challengeType = GetChallengeTypes().gauntlet,
      loadGroup = "AI_Gold_01",
      bronze = "32:00",
      silver = "16:00",
      gold = goldRequirement
    })
  end)
end
function Gold_Challenge_Arena_6_Fight_2()
  Area_6_Gold_Challenge_2 = EC.NewEncounter(thisLevel, "[Arena 6]EC:2 Gold Timed Challenge", {CheckpointOnComplete = true})
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "Helwalker_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 0.2,
      powerLevel = 5
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "Helwalker_SRFC",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = 0.1,
      maxActive = 4,
      totalSpawns = 8,
      spawnCooldown = 2,
      powerLevel = 5
    },
    {
      spawners = "Flyer_B_SABU",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = {6, 10},
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "Helwalker_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = 2,
      powerLevel = 6
    },
    {
      spawners = "E_Helwalker_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 0.4,
      powerLevel = 5
    },
    {
      spawners = "Flyer_F_SABU",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = 2,
      powerLevel = 6
    },
    {
      spawners = "E_Witch_F_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    requiredWaveCompletion = 20,
    {
      spawners = "Projection_S_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 4,
      initialSpawnCooldown = 0.5,
      maxActive = 6,
      totalSpawns = 13,
      spawnCooldown = 1.5,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    timeBeforeNextWave = 20,
    {
      spawners = "E_DW_Draugr_L_SPRINT",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.5,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 1.5,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "E_Brawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5,
      powerLevel = 7
    },
    {
      spawners = "E_Brawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 16.5,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "E_Crawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 18.5,
      powerLevel = 6
    },
    {
      spawners = "Seidr_Bandit_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 3.78,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 2,
      powerLevel = 5
    },
    {
      spawners = "Seidr_SH_Bandit_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "E_Draugr_EP_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.5,
      powerLevel = 5
    },
    {
      spawners = "E_Draugr_EP_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 0.1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 4,
      powerLevel = 5
    },
    {
      spawners = "EH_Draugr_P_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 1,
      powerLevel = 5
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    requiredWaveCompletion = 75,
    {
      spawners = "E_Seidr_Brawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5,
      powerLevel = 7
    },
    {
      spawners = "E_Seidr_Brawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13.5,
      powerLevel = 7
    },
    {
      spawners = "Flyer_I_SABU",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 3,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "E_Seidr_Bandit_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.1,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 3.5,
      powerLevel = 6
    },
    {
      spawners = "SH_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 10.5,
      powerLevel = 7
    },
    {
      spawners = "E_Helwalker_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.5,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 2,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    {
      spawners = "E_Witch_F_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5,
      powerLevel = 7
    },
    {
      spawners = "E_Crawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3,
      powerLevel = 8
    },
    {
      spawners = "E_Helwalker_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 1.5,
      powerLevel = 8
    },
    {
      spawners = "E_Helwalker_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5,
      powerLevel = 8
    }
  })
  Area_6_Gold_Challenge_2:OnStart(function()
    Area_6_Gold_Challenge_2:StartInfiniteSpawning(11, 1)
  end)
  AddToStartQueue(function()
    local tmpTimeLimit
    if game.GetNewGamePlus() then
      tmpTimeLimit = "4:00"
    else
      tmpTimeLimit = "8:00"
    end
    local tmpGold = 0
    if game.GetNewGamePlus() then
      tmpGold = 50
    else
      tmpGold = 70
    end
    managerScript.SetupChallenge(Area_6_Gold_Challenge_2, {
      challengeType = GetChallengeTypes().time_attack,
      loadGroup = "AI_Gold_02",
      timeLimit = tmpTimeLimit,
      bronze = 20,
      silver = 35,
      gold = tmpGold
    })
  end)
end
function Gold_Challenge_Arena_6_Fight_3()
  Area_6_Gold_Challenge_3 = EC.NewEncounter(thisLevel, "[Arena 6]EC:3 Gold No Damage Challenge", {CheckpointOnComplete = true})
  Area_6_Gold_Challenge_3:AddWave({
    powerLevel = 5,
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = {0, 3}
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    timeBetweenWaves = 3.23,
    powerLevel = 5,
    {
      spawners = "DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 5
    },
    {
      spawners = "H_DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    {
      spawners = "Wolf_N_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 5
    },
    {
      spawners = "U_Draugr_P_SFG*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 10,
      powerLevel = 6
    },
    {
      spawners = "Draugr_PT_SFG*",
      spawnLocators = "A6_Loc_BackEdge_*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 5
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    requiredWaveCompletion = 75,
    {
      spawners = "Wulver_P_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 5
    },
    {
      spawners = "Draugr_E_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "H_DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 16,
      powerLevel = 6
    },
    {
      spawners = "H_Draugr_N_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = 8,
      powerLevel = 6
    },
    {
      spawners = "Draugr_N_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 8,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    timeBetweenWaves = 2.23,
    powerLevel = 6,
    {
      spawners = "DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 5
    },
    {
      spawners = "E_Jotunn_SFG*",
      spawnLocators = "A6_Loc_BackEdge_1*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    {
      spawners = "Crawler_N_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 6
    },
    {
      spawners = "SH_Draugr_N_SFG*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.8,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 8,
      powerLevel = 6
    },
    {
      spawners = "Draugr_N_SFG*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    {
      spawners = "DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 5,
      powerLevel = 6
    },
    {
      spawners = "EH_DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    requiredWaveCompletion = 75,
    {
      spawners = "E_Wolf_P_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 15,
      powerLevel = 7
    },
    {
      spawners = "H_Draugr_N_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 13,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "H_DrakOne_SFA*",
      spawnLocators = "A6_Loc_O*",
      spawnWad = "Msp100_Gold_03",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 16,
      powerLevel = 8
    },
    {
      spawners = "E_Draugr_N_SFG*",
      spawnLocators = "A6_Loc_I*",
      spawnWad = "Msp100_Base",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 8,
      powerLevel = 7
    }
  })
  AddToStartQueue(function()
    managerScript.SetupChallenge(Area_6_Gold_Challenge_3, {
      loadGroup = "AI_Gold_03",
      challengeType = GetChallengeTypes().no_damage,
      bronze = 8,
      silver = 20,
      gold = 35
    })
  end)
end
function Gold_Challenge_Arena_6_Fight_4()
  Area_6_Gold_Challenge_4 = EC.NewEncounter(thisLevel, "[Arena 6]EC:4 Gold Timed Challenge", {CheckpointOnComplete = true})
  Area_6_Gold_Challenge_4:AddWave({
    {
      spawners = "DrakOne_SFA",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = {1, 2.5},
      powerLevel = 6
    },
    {
      spawners = "E_DrakOne_SFA",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 3,
      spawnCooldown = {0, 2},
      powerLevel = 7
    },
    {
      spawners = "Flyer_F_SABU",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 15,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = {3, 8},
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_4:AddWave({
    powerLevel = 7,
    {
      spawners = "E_DW_Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.78,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 2
    }
  })
  Area_6_Gold_Challenge_4:AddWave({
    powerLevel = 7,
    timeBetweenWaves = 2.1,
    {
      spawners = "S_Witch_P_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5,
      powerLevel = 8
    },
    {
      spawners = "Helwalker_SRFC",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 3.78,
      maxActive = 4,
      totalSpawns = 5,
      spawnCooldown = 2,
      powerLevel = 6
    }
  })
  Area_6_Gold_Challenge_4:AddWave({
    requiredWaveCompletion = 50,
    {
      spawners = "Seidr_Projection_S_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 5,
      totalSpawns = 10,
      spawnCooldown = 1.5,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_2:AddWave({
    timeBetweenWaves = 3.2,
    {
      spawners = "H_Draugr_L_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 1.5,
      powerLevel = 7
    },
    {
      spawners = "Draugr_P_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      powerLevel = 7
    }
  })
  Area_6_Gold_Challenge_4:AddWave({
    timeBetweenWaves = 3.2,
    {
      spawners = "Seidr_Bandit_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 1.5,
      powerLevel = 7
    },
    {
      spawners = "E_Seidr_Bandit_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "S_Witch_P_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5,
      powerLevel = 8
    }
  })
  Area_6_Gold_Challenge_4:AddWave({
    timeBetweenWaves = 3.2,
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 1.5,
      powerLevel = 7
    },
    {
      spawners = "Crawler_N_SFG",
      spawnWad = "Msp100_Gold_02",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5,
      powerLevel = 7
    },
    {
      spawners = "Draugr_E_SFG",
      spawnWad = "Msp100_Base",
      spawnLocators = "A6_Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 1.5,
      powerLevel = 8
    }
  })
  AddToStartQueue(function()
    managerScript.SetupChallenge(Area_6_Gold_Challenge_3, {
      challengeType = GetChallengeTypes().no_damage,
      loadGroup = "AI_Gold_03",
      bronze = 8,
      silver = 10,
      gold = 12
    })
  end)
end
