local LD = require("design.LevelDesignLibrary")
local banter = {}
banter.challengeSuccess = {
  "MuspelChallengeSucceed_Subsequent01",
  "MuspelChallengeSucceed_Subsequent02",
  "MuspelChallengeSucceed_Subsequent03",
  "MuspelChallengeSucceed_Subsequent04",
  "MuspelChallengeSucceed_Subsequent05",
  "MuspelChallengeSucceed_Subsequent06",
  "MuspelChallengeSucceed_Subsequent07",
  "MuspelChallengeSucceed_Subsequent_Mimir"
}
banter.challengeFailed = {
  "MuspelChallengeFail_Subsequent01",
  "MuspelChallengeFail_Subsequent02",
  "MuspelChallengeFail_Subsequent03",
  "MuspelChallengeFail_Subsequent04",
  "MuspelChallengeFail_Subsequent05",
  "MuspelChallengeFail_Subsequent06"
}
banter.challengeAccepted = {
  "MuspelSwordEngage_accept_01",
  "MuspelSwordEngage_accept_02",
  "MuspelSwordEngage_accept_03",
  "MuspelSwordEngage_accept_04",
  "MuspelSwordEngage_accept_05",
  "MuspelSwordEngage_accept_06",
  "MuspelSwordEngage_accept_05_Mimir"
}
banter.challengeCancelled = {
  "MuspelSwordEngage_refuse_01",
  "MuspelSwordEngage_refuse_02",
  "MuspelSwordEngage_refuse_03",
  "MuspelSwordEngage_refuse_01_Mimir"
}
banter.challengeRetry = {
  "MuspelSwordEngage_retry_01",
  "MuspelSwordEngage_retry_02",
  "MuspelSwordEngage_retry_03",
  "MuspelSwordEngage_retry_04"
}
banter.gatesLowered = {
  "MuspelGatesLowered_Subsequent01",
  "MuspelGatesLowered_Subsequent02",
  "MuspelGatesLowered_Subsequent03",
  "MuspelGatesLowered_Subsequent04"
}
banter.swordReturns = {
  "MuspelSwordReturns_Subsequent01",
  "MuspelSwordReturns_Subsequent02",
  "MuspelSwordReturns_Subsequent03",
  "MuspelSwordReturns_Subsequent04"
}
banter.firstSilverEngaged = false
banter.firstGoldEngaged = false
banter.firstChallengeCancelled = false
banter.firstChallengeFailed = false
banter.firstChallengeSucceeded = false
banter.firstLootReward = false
banter.firstGatesLowered = false
banter.firstAllBronzeCleared = false
banter.firstAllGoldCleared = false
banter.firstSwordReturned = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function Btr_ChallengeEngaged(difficulty)
  LD.CallFunctionAfterDelay(function()
    if difficulty == 1 then
      if not banter.firstSilverEngaged then
        banter.firstSilverEngaged = true
        PlayBanter("MuspelSwordEngage_Silver", true)
      end
    elseif difficulty == 2 and not banter.firstGoldEngaged then
      banter.firstGoldEngaged = true
      PlayBanter("MuspelSwordEngage_Gold", true)
    end
  end, 1.5)
end
function Btr_ChallengeAccepted(attempts)
  LD.CallFunctionAfterDelay(function()
    if attempts == 0 then
      PlayBanter(GetNextLineFromTable("challengeAccepted"), true)
    else
      Btr_ChallengeRetry()
    end
  end, 4)
end
function Btr_ChallengeRetry()
  PlayBanter(GetNextLineFromTable("challengeRetry"), true)
end
function Btr_ChallengeCancelled()
  PlayBanter(GetNextLineFromTable("challengeCancelled"))
end
function Btr_ChallengeFailed()
  LD.CallFunctionAfterDelay(function()
    if not banter.firstChallengeFailed and not MimirAcquired() then
      banter.firstChallengeFailed = true
      PlayBanter("MuspelChallengeFail_FirstTime", true)
    elseif not banter.firstChallengeFailed and MimirAcquired() then
      banter.firstChallengeFailed = true
      PlayBanter("MuspelChallengeFail_FirstTime_Mimir", true)
    else
      PlayBanter(GetNextLineFromTable("challengeFailed"))
    end
  end, 1.5)
end
function Btr_ChallengeSuccess(difficulty, arena)
  LD.CallFunctionAfterDelay(function()
    if not banter.firstChallengeSucceeded then
      banter.firstChallengeSucceeded = true
      PlayBanter("MuspelChallengeSucceed_FirstTime", true, Btr_RewardAvailable)
    elseif not banter.firstAllBronzeCleared and difficulty == 0 and arena == 6 then
      banter.firstAllBronzeCleared = true
      PlayBanter("MuspelMastery_Arena06_Bronze", true)
    elseif not banter.firstAllGoldCleared and difficulty == 2 and arena == 6 then
      banter.firstAllGoldCleared = true
      PlayBanter("MuspelMastery_FirstTime", true)
    elseif not banter.firstAllGoldCleared and difficulty == 3 and arena == 6 then
      PlayBanter("MuspelMastery_Complete", true)
    else
      PlayBanter(GetNextLineFromTable("challengeSuccess"))
    end
  end, 1)
end
function Btr_RewardAvailable()
  if not banter.firstLootReward then
    banter.firstLootReward = true
    if not MimirAcquired() then
      PlayBanter("MuspelChallengeReward_FirstTime", true)
    else
      local random = math.random(1, 2)
      if random == 1 then
        PlayBanter("MuspelChallengeReward_FirstTime_Mimir01", true)
      else
        PlayBanter("MuspelChallengeReward_FirstTime_Mimir02", true)
      end
    end
  end
end
function Btr_LootAcquired(difficulty)
  if 2 <= difficulty then
    LD.CallFunctionAfterDelay(function()
      Btr_GatesLowered()
    end, 11)
  end
end
function Btr_SwordReturns(difficulty, arena)
  if difficulty == 1 and arena < 6 then
    if not banter.firstSwordReturned then
      PlayBanter("MuspelSwordReturns_FirstTime")
      banter.firstSwordReturned = true
    else
      PlayBanter(GetNextLineFromTable("swordReturns"))
    end
  end
end
function Btr_GatesLowered()
  PlayBanter(GetNextLineFromTable("gatesLowered"), true)
end
function GetNextLineFromTable(tableName)
  local maxElement = #banter[tableName]
  if MimirAcquired() == false and LineRequiresMimir(banter[tableName][#banter[tableName]]) then
    maxElement = #banter[tableName] - 1
  end
  local countVarName = tableName .. "Count"
  if banter[countVarName] == nil or maxElement <= banter[countVarName] then
    banter[countVarName] = 0
  end
  banter[countVarName] = banter[countVarName] + 1
  return banter[tableName][banter[countVarName]]
end
function MimirAcquired()
  if game.Level.GetVariable("CompletedCineNumber") >= 330 then
    return true
  end
  return false
end
function LineRequiresMimir(Btr)
  if string.find(string.lower(Btr), "mimir") then
    return true
  else
    return false
  end
end
function PlayBanter(Btr, Critical, CallbackFn)
  Critical = Critical or false
  if Critical then
    game.Audio.PlayBanter(Btr, CallbackFn)
  else
    game.Audio.PlayBanterNonCritical(Btr, CallbackFn)
  end
end
function OnSaveCheckpoint(level, obj)
  return {banter = banter}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banter = savedInfo.banter
end
