local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, player, son
local gateRaised = false
local ExtinguishZone, luaCallbacks_GateReachedTop, luaCallbacks_GateReachedBottom, gateEmitter
function OnScriptLoaded(level, obj)
  thisObj = obj
  gateEmitter = thisObj:FindSingleSoundEmitterByName("SNDGateGroup")
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  thisObj:OnAnimationDone(thisObj, "GateAnimationDone", {Force = true})
end
function GateAnimationDone()
  if thisObj.AnimFrame == 0 then
    GateReachedTop()
  else
    GateReachedBottom()
  end
end
function RaiseGate()
  if gateRaised == false then
    PlayGateSound(749, "backward")
    thisObj:PlayAnimToEnd(-5)
    thisObj:OnAnimationDone(thisObj, "GateReachedTop", {Force = true})
    StopGateSound(600, "backward")
    gateRaised = true
  end
end
function LowerGate()
  if gateRaised == true then
    PlayGateSound(601, "forward")
    thisObj:PlayAnimToEnd(2)
    thisObj:OnAnimationDone(thisObj, "GateReachedBottom", {Force = true})
    StopGateSound(750, "forward")
    gateRaised = false
  end
end
function GateReachedTop()
  FireGateReachedTopCallbacks()
end
function GateReachedBottom()
  FireGateReachedBottomCallbacks()
end
function PlayGateSound(frame, direction)
  LD.PlaySoundOnFrame(gateEmitter, thisObj, "SND_MECH_Metal_Gate_Muspelheim_LP", frame, direction)
end
function StopGateSound(frame, direction)
  LD.StopSoundOnFrame(gateEmitter, thisObj, "SND_MECH_Metal_Gate_Muspelheim_LP", frame, direction)
end
function RaiseGateImmediate()
  gateRaised = true
  thisObj:JumpAnimToFrame(0)
  thisObj:PauseAnim()
end
function LowerGateImmediate()
  gateRaised = false
  thisObj:JumpAnimToFrame(750)
  thisObj:PauseAnim()
end
function OnGateReachedTop(fn)
  if luaCallbacks_GateReachedTop == nil then
    luaCallbacks_GateReachedTop = {}
  end
  luaCallbacks_GateReachedTop[#luaCallbacks_GateReachedTop + 1] = fn
end
function FireGateReachedTopCallbacks()
  if luaCallbacks_GateReachedTop ~= nil then
    for _, fn in pairs(luaCallbacks_GateReachedTop) do
      fn()
    end
  end
end
function OnGateReachedBottom(fn)
  if luaCallbacks_GateReachedBottom == nil then
    luaCallbacks_GateReachedBottom = {}
  end
  luaCallbacks_GateReachedBottom[#luaCallbacks_GateReachedBottom + 1] = fn
end
function FireGateReachedBottomCallbacks()
  if luaCallbacks_GateReachedBottom ~= nil then
    for _, fn in pairs(luaCallbacks_GateReachedBottom) do
      fn()
    end
  end
end
function IsGateRaised()
  return gateRaised
end
function OnSaveCheckpoint(level, obj)
  return {gateRaised = gateRaised}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  gateRaised = savedInfo.gateRaised
end
