local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local MSP_Zone_Check = false
local MSP_Zone_Counter = 0
function OnScriptLoaded(level)
end
function OnFirstStart(level)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    MSP_Zone_Check = MSP_Zone_Check,
    MSP_Zone_Counter = MSP_Zone_Counter
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  MSP_Zone_Check = savedInfo.MSP_Zone_Check
  MSP_Zone_Counter = savedInfo.MSP_Zone_Counter
end
function MspCipherComplete()
  local questStateObjective = game.QuestManager.GetQuestState("Quest_SonLanguage_Muspelheim_Travel")
  if questStateObjective == "Active" then
    game.QuestManager.ProposeQuestState("Quest_SonLanguage_Muspelheim_Travel", "Complete")
  end
end
function PlayBTR_MuspelBridge()
  if game.Level.GetVariable("MUS_EntryBanterTriggered") == false then
    game.Audio.PlayBanter("MuspelBridge")
    game.Level.SetVariable("MUS_EntryBanterTriggered", true)
  end
end
function AirlockCheck()
  local arenaCheck = game.Level.GetVariable("MUS_Arena1Rank")
  if 1 <= arenaCheck then
    if MSP_Zone_Check == false and 1 < MSP_Zone_Counter then
      GameObjects.CA_MuspelAirlock.LuaObjectScript.Enable()
      MSP_Zone_Check = true
    end
    if MSP_Zone_Counter < 3 then
      MSP_Zone_Counter = MSP_Zone_Counter + 1
    end
  end
end
function ExitMspCheck()
  if MSP_Zone_Check == true then
    MSP_Zone_Check = false
  end
end
