local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local thisLevel, thisObj, SelectedAIMix, Selected_SpawnSet, Encounter_01, EncounterName, LeashZoneName, EncounterStartZone, Selected_Fight, LastFight, LastFightVarName
local FodderAI_01 = {
  "Spawn_Fodder_01_0*",
  "Spawn_Fodder_01_1*"
}
local FodderAI_02 = {
  "Spawn_Fodder_02_0*"
}
local FodderAI_03 = {
  "Spawn_Fodder_03_0*",
  "Spawn_Fodder_03_1*"
}
local FodderAI_01_SpawnWad = "Nid999_MazeAI_Fodder_01"
local FodderAI_02_SpawnWad = "Nid999_MazeAI_Fodder_02"
local FodderAI_03_SpawnWad = "Nid999_MazeAI_Fodder_03"
local FodderAI_SpawnPOSs = "SpawnPOS_Fodder_01_0*"
local BasicAI_01 = {
  "Spawn_Basic_01_0*"
}
local BasicAI_02 = {
  "Spawn_Basic_02_0*"
}
local BasicAI_03 = {
  "Spawn_Basic_03_0*"
}
local BasicAI_01_SpawnWad = "Nid999_MazeAI_Basic_01"
local BasicAI_02_SpawnWad = "Nid999_MazeAI_Basic_02"
local BasicAI_03_SpawnWad = "Nid999_MazeAI_Basic_03"
local BasicAI_SpawnPOSs = "SpawnPOS_Basic_01_0*"
local MidAI_01 = {
  "Spawn_Mid_01_0*"
}
local MidAI_02 = {
  "Spawn_Mid_02_0*"
}
local MidAI_03 = {
  "Spawn_Mid_03_0*"
}
local MidAI_01_SpawnWad = "Nid999_MazeAI_Mid_01"
local MidAI_02_SpawnWad = "Nid999_MazeAI_Mid_02"
local MidAI_03_SpawnWad = "Nid999_MazeAI_Mid_03"
local MidAI_SpawnPOSs = "SpawnPOS_Mid_01_0*"
local HeavyAI_01 = {
  "Spawn_Heavy_01_0*"
}
local HeavyAI_02 = {
  "Spawn_Heavy_02_0*"
}
local HeavyAI_03 = {
  "Spawn_Heavy_03_0*"
}
local HeavyAI_01_SpawnWad = "Nid999_MazeAI_Heavy_01"
local HeavyAI_02_SpawnWad = "Nid999_MazeAI_Heavy_02"
local HeavyAI_03_SpawnWad = "Nid999_MazeAI_Heavy_03"
local HeavyAI_SpawnPOSs = "SpawnPOS_Heavy_01_0*"
local AILoadGroup_1111 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1112 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1121 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1122 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1123 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1131 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1132 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1133 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1211 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1212 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1213 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1221 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1222 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1223 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1231 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1232 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1233 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1311 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1312 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1313 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1321 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1322 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1323 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_1331 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_1332 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_1333 = {
  HeavyAI = HeavyAI_01,
  HeavyAIWad = HeavyAI_01_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2111 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2112 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2121 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2122 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2123 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2131 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2132 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2133 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2211 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2212 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2213 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2221 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2222 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2223 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2231 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2232 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2233 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2311 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2312 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2313 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2321 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2322 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2323 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_2331 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_2332 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_2333 = {
  HeavyAI = HeavyAI_02,
  HeavyAIWad = HeavyAI_02_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3111 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3112 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3121 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3122 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3123 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3131 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3132 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3133 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_01,
  MidAIWad = MidAI_01_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3211 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3212 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3213 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3221 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3222 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3223 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3231 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3232 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3233 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_02,
  MidAIWad = MidAI_02_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3311 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3312 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3313 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_01,
  BasicAIWad = BasicAI_01_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3321 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3322 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3323 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_02,
  BasicAIWad = BasicAI_02_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroup_3331 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_01,
  FodderAIWad = FodderAI_01_SpawnWad
}
local AILoadGroup_3332 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_02,
  FodderAIWad = FodderAI_02_SpawnWad
}
local AILoadGroup_3333 = {
  HeavyAI = HeavyAI_03,
  HeavyAIWad = HeavyAI_03_SpawnWad,
  MidAI = MidAI_03,
  MidAIWad = MidAI_03_SpawnWad,
  BasicAI = BasicAI_03,
  BasicAIWad = BasicAI_03_SpawnWad,
  FodderAI = FodderAI_03,
  FodderAIWad = FodderAI_03_SpawnWad
}
local AILoadGroups = {
  AILoadGroup_1111,
  AILoadGroup_1121,
  AILoadGroup_1131,
  AILoadGroup_1211,
  AILoadGroup_1221,
  AILoadGroup_1231,
  AILoadGroup_1311,
  AILoadGroup_1321,
  AILoadGroup_1331,
  AILoadGroup_2111,
  AILoadGroup_2121,
  AILoadGroup_2131,
  AILoadGroup_2211,
  AILoadGroup_2221,
  AILoadGroup_2231,
  AILoadGroup_2311,
  AILoadGroup_2321,
  AILoadGroup_2331,
  AILoadGroup_3111,
  AILoadGroup_3121,
  AILoadGroup_3131,
  AILoadGroup_3211,
  AILoadGroup_3221,
  AILoadGroup_3231,
  AILoadGroup_3311,
  AILoadGroup_3321,
  AILoadGroup_3331,
  AILoadGroup_1112,
  AILoadGroup_1122,
  AILoadGroup_1132,
  AILoadGroup_1212,
  AILoadGroup_1222,
  AILoadGroup_1232,
  AILoadGroup_1312,
  AILoadGroup_1322,
  AILoadGroup_1332,
  AILoadGroup_2112,
  AILoadGroup_2122,
  AILoadGroup_2132,
  AILoadGroup_2212,
  AILoadGroup_2222,
  AILoadGroup_2232,
  AILoadGroup_2312,
  AILoadGroup_2322,
  AILoadGroup_2332,
  AILoadGroup_3112,
  AILoadGroup_3122,
  AILoadGroup_3132,
  AILoadGroup_3212,
  AILoadGroup_3222,
  AILoadGroup_3232,
  AILoadGroup_3312,
  AILoadGroup_3322,
  AILoadGroup_3332,
  AILoadGroup_1123,
  AILoadGroup_1133,
  AILoadGroup_1213,
  AILoadGroup_1223,
  AILoadGroup_1233,
  AILoadGroup_1313,
  AILoadGroup_1323,
  AILoadGroup_1333,
  AILoadGroup_2123,
  AILoadGroup_2133,
  AILoadGroup_2213,
  AILoadGroup_2223,
  AILoadGroup_2233,
  AILoadGroup_2313,
  AILoadGroup_2323,
  AILoadGroup_2333,
  AILoadGroup_3123,
  AILoadGroup_3133,
  AILoadGroup_3213,
  AILoadGroup_3223,
  AILoadGroup_3233,
  AILoadGroup_3313,
  AILoadGroup_3323,
  AILoadGroup_3333
}
local Selected_AISet
local Selected_HeavyAI = {}
local Selected_MidAI = {}
local Selected_BasicAI = {}
local Selected_FodderAI = {}
local EncounterRolled = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  local stIdentifier = tostring(thisObj:GetLuaTableAttribute("WadName"))
  EncounterName = stIdentifier .. ": Random Maze Encounter"
  LeashZoneName = stIdentifier .. "_LshZn_01"
  FodderAI_SpawnPOSs = stIdentifier .. "_SpawnPOS_Fodder_01_0*"
  BasicAI_SpawnPOSs = stIdentifier .. "_SpawnPOS_Basic_01_0*"
  MidAI_SpawnPOSs = stIdentifier .. "_SpawnPOS_Mid_01_0*"
  HeavyAI_SpawnPOSs = stIdentifier .. "_SpawnPOS_Heavy_01_0*"
  EncounterStartZone = thisLevel:GetGameObject(stIdentifier .. "_EncounterTrigger")
  LastFightVarName = "Nif_" .. tostring(stIdentifier) .. "_LastFight"
  LastFight = LD.GetEntityVariable(LastFightVarName)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function RollEncounter(level, go, size, AISet)
  if Encounter_01 ~= nil and Encounter_01:WasRunning() == true then
    Encounter_01:DespawnEnemies()
    Encounter_01 = nil
  end
  EncounterReset()
  LD.CallFunctionAfterDelay(function()
    if size == nil then
      size = 1
    end
    Encounter_01 = EC.NewEncounter(thisLevel, EncounterName, {
      CheckpointOnComplete = false,
      LoadCheck = false,
      LeashZone = LeashZoneName,
      LodLow = 25,
      LodHigh = 35
    })
    SetupAI(AISet)
    if LD.GetEntityVariable("NIF_SimpleFights") == false then
      if size == 1 then
        if game.FindLevel(tostring(Selected_AISet.MidAIWad)) == nil then
          Selected_Fight = RollFightMix(0, 2)
        else
          Selected_Fight = RollFightMix(0, 4)
        end
        if Selected_Fight == 0 then
          SetupEncounter(0, 0, 2, 2)
        elseif Selected_Fight == 1 then
          SetupEncounter(0, 0, 1, 3)
        elseif Selected_Fight == 2 then
          SetupEncounter(0, 0, 3, 0)
        elseif Selected_Fight == 3 then
          SetupEncounter(0, 1, 0, 2)
        elseif Selected_Fight == 4 then
          SetupEncounter(0, 2, 0, 0)
        elseif Selected_Fight == 5 then
          SetupEncounter(0, 1, 2, 0)
        end
      elseif size == 2 then
        Selected_Fight = RollFightMix(0, 3)
        if Selected_Fight == 0 then
          SetupEncounter(0, 1, 1, 3)
        elseif Selected_Fight == 1 then
          SetupEncounter(0, 2, 2, 0)
        elseif Selected_Fight == 2 then
          SetupEncounter(0, 2, 0, 3)
        elseif Selected_Fight == 3 then
          SetupEncounter(0, 3, 0, 0)
        end
      elseif size == 3 then
        Selected_Fight = RollFightMix(0, 3)
        if Selected_Fight == 0 then
          SetupEncounter(1, 1, 2, 0)
        elseif Selected_Fight == 1 then
          SetupEncounter(1, 0, 2, 2)
        elseif Selected_Fight == 2 then
          SetupEncounter(1, 1, 0, 2)
        elseif Selected_Fight == 3 then
          SetupEncounter(1, 2, 0, 0)
        end
      end
    else
      SetupEncounter(0, 0, 0, 1)
    end
    if size ~= 0 then
      Encounter_01:SetStartZone(EncounterStartZone)
    end
  end, 1)
end
function SetupAI(AISet)
  SelectedAIMix = AISet
  Selected_AISet = AILoadGroups[SelectedAIMix]
  Selected_FodderAI = Selected_AISet.FodderAI
  Selected_BasicAI = Selected_AISet.BasicAI
  Selected_MidAI = Selected_AISet.MidAI
  Selected_HeavyAI = Selected_AISet.HeavyAI
end
function RollFightMix(Min, Max)
  local selected = math.random(Min, Max)
  while selected == LastFight do
    selected = math.random(Min, Max)
  end
  LD.SetEntityVariable(LastFightVarName, selected)
  return selected
end
function RerollEncounter()
  Encounter_01:SetComplete()
  Encounter_01:DespawnEnemies()
  Encounter_01 = nil
end
function EncounterCleanUp()
  if Encounter_01 ~= nil and Encounter_01:IsRunning() == true then
    EncounterExplodeAI()
    Encounter_01:EnableAllSpawners()
    Encounter_01:DespawnEnemies()
    Encounter_01:Reset()
  end
end
function EncounterExplodeAI()
  local minTime = 0
  local maxTime = 0.2
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies1 = Encounter_01:GetActiveEnemies()
  for _, enemy in pairs(enemies1) do
    if enemy ~= nil then
      local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
      timers.StartLevelTimer(randomFn(), function()
        local enemyVFX = game.FX.Spawn("BloodExplode", nil, {
          AutoDelete = true,
          EffectCreator = enemy,
          Scale = 1.5
        })
        enemyVFX:SetWorldPosition(enemyLastPos)
      end)
    end
  end
end
function EncounterReset()
  if Encounter_01 ~= nil then
    Encounter_01:ForceClearEncounter()
  end
end
function SetupEncounter(HeavyCount, MidCount, BasicCount, FodderCount)
  local FodderAI_AltToUse = Selected_FodderAI[math.random(1, #Selected_FodderAI)]
  local BasicAI_AltToUse = Selected_BasicAI[math.random(1, #Selected_BasicAI)]
  local MidAI_AltToUse = Selected_MidAI[math.random(1, #Selected_MidAI)]
  local HeavyAI_AltToUse = Selected_HeavyAI[math.random(1, #Selected_HeavyAI)]
  if 0 < HeavyCount then
    Encounter_01:AddWave({
      prioritizeSpawnersInRange = {16, 50},
      timeBeforeNextWave = 0.5,
      {
        spawners = HeavyAI_AltToUse,
        spawnLocators = HeavyAI_SpawnPOSs,
        spawnWad = Selected_AISet.HeavyAIWad,
        useSpawnLocatorsOnly = true,
        disableSpawnerPostSpawn = true,
        spawnPattern = "Random",
        maxActive = HeavyCount,
        totalSpawns = HeavyCount,
        spawnCooldown = {0, 0.25}
      }
    })
  end
  if 0 < MidCount then
    Encounter_01:AddWave({
      prioritizeSpawnersInRange = {16, 50},
      timeBeforeNextWave = 0.5,
      {
        spawners = MidAI_AltToUse,
        spawnLocators = MidAI_SpawnPOSs,
        spawnWad = Selected_AISet.MidAIWad,
        useSpawnLocatorsOnly = true,
        disableSpawnerPostSpawn = true,
        spawnPattern = "Random",
        maxActive = MidCount,
        totalSpawns = MidCount,
        spawnCooldown = {0, 0.25}
      }
    })
  end
  if 0 < BasicCount then
    Encounter_01:AddWave({
      prioritizeSpawnersInRange = {16, 50},
      timeBeforeNextWave = 0.5,
      {
        spawners = BasicAI_AltToUse,
        spawnLocators = BasicAI_SpawnPOSs,
        spawnWad = Selected_AISet.BasicAIWad,
        useSpawnLocatorsOnly = true,
        disableSpawnerPostSpawn = true,
        spawnPattern = "Random",
        maxActive = BasicCount,
        totalSpawns = BasicCount,
        spawnCooldown = {0, 0.25}
      }
    })
  end
  if 0 < FodderCount then
    Encounter_01:AddWave({
      prioritizeSpawnersInRange = {16, 50},
      timeBeforeNextWave = 0.5,
      {
        spawners = FodderAI_AltToUse,
        spawnLocators = FodderAI_SpawnPOSs,
        spawnWad = Selected_AISet.FodderAIWad,
        useSpawnLocatorsOnly = true,
        disableSpawnerPostSpawn = true,
        spawnPattern = "Random",
        maxActive = FodderCount,
        totalSpawns = FodderCount,
        spawnCooldown = {0, 0.25}
      }
    })
  end
end
