local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, wadManager, HallLayout_Anim, Bonus, Sides
local DeadEnd = false
local Wall_1_Horz_L, Wall_1_Horz_LC, Wall_1_Horz_C, Wall_1_Horz_RC, Wall_1_Horz_R, Wall_2_Horz_L, Wall_2_Horz_LC, Wall_2_Horz_C, Wall_2_Horz_RC, Wall_2_Horz_RM, Wall_2_Horz_R, Wall_3_Horz_L, Wall_3_Horz_LC, Wall_3_Horz_C, Wall_3_Horz_RC, Wall_3_Horz_RM, Wall_3_Horz_R, Wall_4_Horz_L, Wall_4_Horz_LC, Wall_4_Horz_C, Wall_4_Horz_RC, Wall_4_Horz_RM, Wall_4_Horz_R, Wall_5_Horz_L, Wall_5_Horz_LC, Wall_5_Horz_C, Wall_5_Horz_RC, Wall_5_Horz_RM, Wall_5_Horz_R, Wall_6_Horz_L, Wall_6_Horz_LC, Wall_6_Horz_C, Wall_6_Horz_RC, Wall_6_Horz_RM, Wall_6_Horz_R, Wall_7_Horz_L, Wall_7_Horz_LC, Wall_7_Horz_C, Wall_7_Horz_RC, Wall_7_Horz_R, EndCap_01, EndCap_02
local EndCap_POSFrames = {
  0,
  25,
  50
}
local EndCap_AnimGroup
local Crusher_POSFrames = {
  0,
  20,
  40,
  60,
  80
}
local Crusher_Left_AnimGroup, Crusher_Right_AnimGroup
local Crusher_Left_01 = {Crusher = nil, UpperEdge = nil}
local Crusher_Left_02 = {Crusher = nil, UpperEdge = nil}
local Crusher_Left_03 = {Crusher = nil, UpperEdge = nil}
local Crusher_Left_04 = {Crusher = nil, UpperEdge = nil}
local Crusher_Left_05 = {Crusher = nil, UpperEdge = nil}
local Crusher_Right_01 = {Crusher = nil, UpperEdge = nil}
local Crusher_Right_02 = {Crusher = nil, UpperEdge = nil}
local Crusher_Right_03 = {Crusher = nil, UpperEdge = nil}
local Crusher_Right_04 = {Crusher = nil, UpperEdge = nil}
local Crusher_Right_05 = {Crusher = nil, UpperEdge = nil}
local Crushers_All = {
  Crusher_Left_01,
  Crusher_Left_02,
  Crusher_Left_03,
  Crusher_Left_04,
  Crusher_Left_05,
  Crusher_Right_01,
  Crusher_Right_02,
  Crusher_Right_03,
  Crusher_Right_04,
  Crusher_Right_05
}
local Saws_POSFrames = {0, 20}
local Saws_Right_AnimGroup, Saws_Left_AnimGroup, Saws_AnimGroup, Saw_Left_01, Saw_Left_02, Saw_Left_03, Saw_Left_04, Saw_Left_05, Saw_Right_01, Saw_Right_02, Saw_Right_03, Saw_Right_04, Saw_Right_05
local Saws_All = {
  Saw_Left_01,
  Saw_Left_02,
  Saw_Left_03,
  Saw_Left_04,
  Saw_Left_05,
  Saw_Right_01,
  Saw_Right_02,
  Saw_Right_03,
  Saw_Right_04,
  Saw_Right_05
}
local Boost2_Layout_01_A1, Boost2_Layout_01_A2, Boost2_Layout_01_B, Boost2_Layout_01_C1, Boost2_Layout_01_C2, Boost2_Layout_01_D1, Boost2_Layout_02_A1, Boost2_Layout_02_A2, Boost2_Layout_02_B1, Boost2_Layout_02_B2, Boost2_Layout_02_C1, Boost2_Layout_02_C2, Boost2_Layout_02_C3, Boost2_Layout_02_C4, Boost2_Layout_02_C5, Boost2_Layout_03_A, Boost2_Layout_03_B
local Boosts = {
  Boost2_Layout_01_A1,
  Boost2_Layout_01_A2,
  Boost2_Layout_01_B,
  Boost2_Layout_01_C1,
  Boost2_Layout_01_C2,
  Boost2_Layout_01_D1,
  Boost2_Layout_02_A1,
  Boost2_Layout_02_A2,
  Boost2_Layout_02_B1,
  Boost2_Layout_02_B2,
  Boost2_Layout_02_C1,
  Boost2_Layout_02_C2,
  Boost2_Layout_02_C3,
  Boost2_Layout_02_C4,
  Boost2_Layout_03_A,
  Boost2_Layout_03_B
}
local BonusTreasurePOSs = {}
local BonusTreasureActivePOSs = {}
local Odds = {}
local BonusTreasure_Chest_01, BonusTreasure_Chest_02
local bonusTreasure_SaveData1 = {}
local bonusTreasure_SaveData2 = {}
local selectedSetup = 0
local selectedHallSet = 0
local Hall_Setups = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  HallLayout_Anim = thisObj:FindSingleGOByName("HallLayout_Anim")
  Wall_1_Horz_L = thisObj:FindSingleGOByName("Wall_1_Horz_L")
  Wall_1_Horz_LC = thisObj:FindSingleGOByName("Wall_1_Horz_LC")
  Wall_1_Horz_C = thisObj:FindSingleGOByName("Wall_1_Horz_C")
  Wall_1_Horz_RC = thisObj:FindSingleGOByName("Wall_1_Horz_RC")
  Wall_1_Horz_R = thisObj:FindSingleGOByName("Wall_1_Horz_R")
  Wall_2_Horz_L = thisObj:FindSingleGOByName("Wall_2_Horz_L")
  Wall_2_Horz_LC = thisObj:FindSingleGOByName("Wall_2_Horz_LC")
  Wall_2_Horz_C = thisObj:FindSingleGOByName("Wall_2_Horz_C")
  Wall_2_Horz_RC = thisObj:FindSingleGOByName("Wall_2_Horz_RC")
  Wall_2_Horz_RM = thisObj:FindSingleGOByName("Wall_2_Horz_RM")
  Wall_2_Horz_R = thisObj:FindSingleGOByName("Wall_2_Horz_R")
  Wall_3_Horz_L = thisObj:FindSingleGOByName("Wall_3_Horz_L")
  Wall_3_Horz_LC = thisObj:FindSingleGOByName("Wall_3_Horz_LC")
  Wall_3_Horz_C = thisObj:FindSingleGOByName("Wall_3_Horz_C")
  Wall_3_Horz_RC = thisObj:FindSingleGOByName("Wall_3_Horz_RC")
  Wall_3_Horz_RM = thisObj:FindSingleGOByName("Wall_3_Horz_RM")
  Wall_3_Horz_R = thisObj:FindSingleGOByName("Wall_3_Horz_R")
  Wall_4_Horz_L = thisObj:FindSingleGOByName("Wall_4_Horz_L")
  Wall_4_Horz_LC = thisObj:FindSingleGOByName("Wall_4_Horz_LC")
  Wall_4_Horz_C = thisObj:FindSingleGOByName("Wall_4_Horz_C")
  Wall_4_Horz_RC = thisObj:FindSingleGOByName("Wall_4_Horz_RC")
  Wall_4_Horz_RM = thisObj:FindSingleGOByName("Wall_4_Horz_RM")
  Wall_4_Horz_R = thisObj:FindSingleGOByName("Wall_4_Horz_R")
  Wall_5_Horz_L = thisObj:FindSingleGOByName("Wall_5_Horz_L")
  Wall_5_Horz_LC = thisObj:FindSingleGOByName("Wall_5_Horz_LC")
  Wall_5_Horz_C = thisObj:FindSingleGOByName("Wall_5_Horz_C")
  Wall_5_Horz_RC = thisObj:FindSingleGOByName("Wall_5_Horz_RC")
  Wall_5_Horz_RM = thisObj:FindSingleGOByName("Wall_5_Horz_RM")
  Wall_5_Horz_R = thisObj:FindSingleGOByName("Wall_5_Horz_R")
  Wall_6_Horz_L = thisObj:FindSingleGOByName("Wall_6_Horz_L")
  Wall_6_Horz_LC = thisObj:FindSingleGOByName("Wall_6_Horz_LC")
  Wall_6_Horz_C = thisObj:FindSingleGOByName("Wall_6_Horz_C")
  Wall_6_Horz_RC = thisObj:FindSingleGOByName("Wall_6_Horz_RC")
  Wall_6_Horz_RM = thisObj:FindSingleGOByName("Wall_6_Horz_RM")
  Wall_6_Horz_R = thisObj:FindSingleGOByName("Wall_6_Horz_R")
  Wall_7_Horz_L = thisObj:FindSingleGOByName("Wall_7_Horz_L")
  Wall_7_Horz_LC = thisObj:FindSingleGOByName("Wall_7_Horz_LC")
  Wall_7_Horz_C = thisObj:FindSingleGOByName("Wall_7_Horz_C")
  Wall_7_Horz_RC = thisObj:FindSingleGOByName("Wall_7_Horz_RC")
  Wall_7_Horz_R = thisObj:FindSingleGOByName("Wall_7_Horz_R")
  EndCap_01 = thisObj:FindSingleGOByName("EndCap_101")
  EndCap_02 = thisObj:FindSingleGOByName("EndCap_102")
  EndCap_AnimGroup = thisObj:FindSingleGOByName("EndCap_Anim")
  Crusher_Left_AnimGroup = thisObj:FindSingleGOByName("Hazard_Crushers_Left")
  Crusher_Right_AnimGroup = thisObj:FindSingleGOByName("Hazard_Crushers_Right")
  Crusher_Left_01.Crusher = thisObj:FindSingleGOByName("Crusher_Left_01")
  Crusher_Left_02.Crusher = thisObj:FindSingleGOByName("Crusher_Left_02")
  Crusher_Left_03.Crusher = thisObj:FindSingleGOByName("Crusher_Left_03")
  Crusher_Left_04.Crusher = thisObj:FindSingleGOByName("Crusher_Left_04")
  Crusher_Left_05.Crusher = thisObj:FindSingleGOByName("Crusher_Left_05")
  Crusher_Right_01.Crusher = thisObj:FindSingleGOByName("Crusher_Right_01")
  Crusher_Right_02.Crusher = thisObj:FindSingleGOByName("Crusher_Right_02")
  Crusher_Right_03.Crusher = thisObj:FindSingleGOByName("Crusher_Right_03")
  Crusher_Right_04.Crusher = thisObj:FindSingleGOByName("Crusher_Right_04")
  Crusher_Right_05.Crusher = thisObj:FindSingleGOByName("Crusher_Right_05")
  Crusher_Left_01.UpperEdge = thisObj:FindSingleGOByName("Crusher_Left_01_UpperEdge")
  Crusher_Left_02.UpperEdge = thisObj:FindSingleGOByName("Crusher_Left_02_UpperEdge")
  Crusher_Left_03.UpperEdge = thisObj:FindSingleGOByName("Crusher_Left_03_UpperEdge")
  Crusher_Left_04.UpperEdge = thisObj:FindSingleGOByName("Crusher_Left_04_UpperEdge")
  Crusher_Left_05.UpperEdge = thisObj:FindSingleGOByName("Crusher_Left_05_UpperEdge")
  Crusher_Right_01.UpperEdge = thisObj:FindSingleGOByName("Crusher_Right_01_UpperEdge")
  Crusher_Right_02.UpperEdge = thisObj:FindSingleGOByName("Crusher_Right_02_UpperEdge")
  Crusher_Right_03.UpperEdge = thisObj:FindSingleGOByName("Crusher_Right_03_UpperEdge")
  Crusher_Right_04.UpperEdge = thisObj:FindSingleGOByName("Crusher_Right_04_UpperEdge")
  Crusher_Right_05.UpperEdge = thisObj:FindSingleGOByName("Crusher_Right_05_UpperEdge")
  Crushers_All = {
    Crusher_Left_01,
    Crusher_Left_02,
    Crusher_Left_03,
    Crusher_Left_04,
    Crusher_Left_05,
    Crusher_Right_01,
    Crusher_Right_02,
    Crusher_Right_03,
    Crusher_Right_04,
    Crusher_Right_05
  }
  Saws_Right_AnimGroup = thisObj:FindSingleGOByName("Hazard_Saws_Right")
  Saws_Left_AnimGroup = thisObj:FindSingleGOByName("Hazard_Saws_Left")
  Saw_Left_01 = thisObj:FindSingleGOByName("Saw_Left_01")
  Saw_Left_02 = thisObj:FindSingleGOByName("Saw_Left_02")
  Saw_Left_03 = thisObj:FindSingleGOByName("Saw_Left_03")
  Saw_Left_04 = thisObj:FindSingleGOByName("Saw_Left_04")
  Saw_Left_05 = thisObj:FindSingleGOByName("Saw_Left_05")
  Saw_Right_01 = thisObj:FindSingleGOByName("Saw_Right_01")
  Saw_Right_02 = thisObj:FindSingleGOByName("Saw_Right_02")
  Saw_Right_03 = thisObj:FindSingleGOByName("Saw_Right_03")
  Saw_Right_04 = thisObj:FindSingleGOByName("Saw_Right_04")
  Saw_Right_05 = thisObj:FindSingleGOByName("Saw_Right_05")
  Saws_All = {
    Saw_Left_01,
    Saw_Left_02,
    Saw_Left_03,
    Saw_Left_04,
    Saw_Left_05,
    Saw_Right_01,
    Saw_Right_02,
    Saw_Right_03,
    Saw_Right_04,
    Saw_Right_05
  }
  Boost2_Layout_01_A1 = thisObj:FindSingleGOByName("Boost2_Layout_01_A1")
  Boost2_Layout_01_A2 = thisObj:FindSingleGOByName("Boost2_Layout_01_A2")
  Boost2_Layout_01_B = thisObj:FindSingleGOByName("Boost2_Layout_01_B")
  Boost2_Layout_01_C1 = thisObj:FindSingleGOByName("Boost2_Layout_01_C1")
  Boost2_Layout_01_C2 = thisObj:FindSingleGOByName("Boost2_Layout_01_C2")
  Boost2_Layout_01_D1 = thisObj:FindSingleGOByName("Boost2_Layout_01_D1")
  Boost2_Layout_02_A1 = thisObj:FindSingleGOByName("Boost2_Layout_02_A1")
  Boost2_Layout_02_A2 = thisObj:FindSingleGOByName("Boost2_Layout_02_A2")
  Boost2_Layout_02_B1 = thisObj:FindSingleGOByName("Boost2_Layout_02_B1")
  Boost2_Layout_02_B2 = thisObj:FindSingleGOByName("Boost2_Layout_02_B2")
  Boost2_Layout_02_C1 = thisObj:FindSingleGOByName("Boost2_Layout_02_C1")
  Boost2_Layout_02_C2 = thisObj:FindSingleGOByName("Boost2_Layout_02_C2")
  Boost2_Layout_02_C3 = thisObj:FindSingleGOByName("Boost2_Layout_02_C3")
  Boost2_Layout_02_C4 = thisObj:FindSingleGOByName("Boost2_Layout_02_C4")
  Boost2_Layout_02_C5 = thisObj:FindSingleGOByName("Boost2_Layout_02_C5")
  Boost2_Layout_03_A = thisObj:FindSingleGOByName("Boost2_Layout_03_A")
  Boost2_Layout_03_B = thisObj:FindSingleGOByName("Boost2_Layout_03_B")
  Boosts = {
    Boost2_Layout_01_A1,
    Boost2_Layout_01_A2,
    Boost2_Layout_01_B,
    Boost2_Layout_01_C1,
    Boost2_Layout_01_C2,
    Boost2_Layout_01_D1,
    Boost2_Layout_02_A1,
    Boost2_Layout_02_A2,
    Boost2_Layout_02_B1,
    Boost2_Layout_02_B2,
    Boost2_Layout_02_C1,
    Boost2_Layout_02_C2,
    Boost2_Layout_02_C3,
    Boost2_Layout_02_C4,
    Boost2_Layout_02_C5,
    Boost2_Layout_03_A,
    Boost2_Layout_03_B
  }
  local indexTable = {
    "01",
    "02",
    "03",
    "04",
    "05",
    "06",
    "07",
    "08",
    "09",
    "10",
    "11",
    "12"
  }
  for i = 1, #indexTable do
    BonusTreasurePOSs[i] = thisObj:FindSingleGOByName("BonusTreasure_" .. indexTable[i])
    if BonusTreasurePOSs[i].IsRefNode then
      BonusTreasurePOSs[i] = BonusTreasurePOSs[i].Child
    end
    BonusTreasurePOSs[i]:Hide()
  end
  BonusTreasure_Chest_01 = Treasure_OnScriptLoaded(thisObj:FindSingleGOByName("BonusTreasure_Chest_01"))
  BonusTreasure_Chest_02 = Treasure_OnScriptLoaded(thisObj:FindSingleGOByName("BonusTreasure_Chest_02"))
  wadManager = level:GetGameObject("WadManager_root")
  Odds[1] = wadManager.LuaObjectScript.Chance_LootLegendary()
  Odds[2] = 70
  Odds[3] = wadManager.LuaObjectScript.Chance_LootChest()
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {bonusTreasure_SaveData1 = bonusTreasure_SaveData1, bonusTreasure_SaveData2 = bonusTreasure_SaveData2}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  local RestoreBonusChests = function(saveData, bonusTreasureTable)
    if saveData then
      bonusTreasureTable.obj:SetWorldPosition(saveData.pos)
      bonusTreasureTable.obj:SetWorldFacing(saveData.facing)
    end
    return saveData
  end
  bonusTreasure_SaveData1 = RestoreBonusChests(savedInfo.bonusTreasure_SaveData1, BonusTreasure_Chest_01)
  bonusTreasure_SaveData2 = RestoreBonusChests(savedInfo.bonusTreasure_SaveData2, BonusTreasure_Chest_02)
end
function SetupHall(newHallSetup, globalLevelVars, doReRoll)
  Hall_Setups = newHallSetup
  local SelectedLayout = Hall_Setups.Layout
  local AllowFlip = Hall_Setups.Flip
  Cursher_DisableSet(Crushers_All)
  Saw_DisableSet(Saws_All)
  Boost_DisableSet(Boosts)
  if doReRoll then
    EndCap_01.LuaObjectScript.SelectEndCap()
    EndCap_02.LuaObjectScript.SelectEndCap()
  end
  if AllowFlip == false then
    HallLayout_Anim:JumpAnimToFrame(10)
    HallLayout_Anim:PauseAnim()
  else
    HallLayout_Anim:JumpAnimToFrame(20)
    HallLayout_Anim:PauseAnim()
  end
  if DeadEnd == true then
    HallLayout_DeadEnd()
  elseif SelectedLayout == 1 then
    HallLayout_01(doReRoll)
  elseif SelectedLayout == 2 then
    HallLayout_02(doReRoll)
  else
    HallLayout_03(doReRoll)
  end
  DeadEnd = false
end
function Set_DeadEnd(state)
  DeadEnd = state
end
function Crushers_SetPOS(HazardSet, num)
  local CrusherSetToMove = HazardSet:FindSingleGOByName("Crusher_POS_Anim")
  CrusherSetToMove:JumpAnimToFrame(Crusher_POSFrames[num])
  CrusherSetToMove:PauseAnim()
end
function Cursher_DisableSet(HazardSet)
  for i = 1, #HazardSet do
    Crusher_Disable(HazardSet[i])
  end
end
function Crusher_Disable(Hazard)
  Hazard.Crusher:Hide()
  Hazard.Crusher.LuaObjectScript.ForceOpenCrusher()
  Hazard.Crusher.LuaObjectScript.Disable()
  Hazard.Crusher:SetInhibitSave()
  Hazard.UpperEdge:Hide()
end
function Crushers_EnableSet(HazardSet, delay)
  for i = 1, #HazardSet do
    if delay == nil then
      Crusher_Enable(HazardSet[i])
    else
      timers.StartLevelTimer(delay * i, function()
        Crusher_Enable(HazardSet[i])
      end)
    end
  end
end
function Crusher_Enable(Hazard)
  Hazard.Crusher.LuaObjectScript.ResetTrap()
  Hazard.Crusher.LuaObjectScript.Enable()
  Hazard.Crusher:Show()
  Hazard.UpperEdge:Show()
end
function Saws_SetPOS(HazardSet, num)
  local SawSetToMove = HazardSet:FindSingleGOByName("Saws_POS_Anim")
  SawSetToMove:JumpAnimToFrame(Saws_POSFrames[num])
  SawSetToMove:PauseAnim()
end
function Saw_DisableSet(HazardSet)
  for i = 1, #HazardSet do
    Saw_Disable(HazardSet[i])
  end
end
function Saw_Disable(Hazard)
  Hazard:Hide()
  Hazard.LuaObjectScript.Disable()
end
function Saw_EnableSet(HazardSet, frame, delay)
  for i = 1, #HazardSet do
    if delay == nil then
      Saw_Enable(HazardSet[i], frame)
    else
      timers.StartLevelTimer(delay * i, function()
        Saw_Enable(HazardSet[i], frame, 0)
      end)
    end
  end
end
function Saw_Enable(Hazard, frame, delay)
  Hazard:Show()
  Hazard.LuaObjectScript.Enable(frame, delay)
end
function Boost_DisableSet(BoostSet)
  for i = 1, #BoostSet do
    Boost_Disable(BoostSet[i])
  end
end
function Boost_Disable(Boost)
  Boost:HideTraverseLink()
end
function Boost_Enable(Boost)
  Boost:ShowTraverseLink()
end
function Treasure_OnScriptLoaded(obj)
  if obj.IsRefNode then
    obj = obj.Child
  end
  local chestRefs = {
    obj:FindSingleGOByName("Legendary"),
    obj:FindSingleGOByName("Coffin"),
    obj:FindSingleGOByName("Chest")
  }
  for i = 1, #chestRefs do
    if chestRefs[i].IsRefNode then
      chestRefs[i] = chestRefs[i].Child
    end
  end
  return {
    obj = obj,
    objOrigin = obj:GetWorldPosition(),
    objFacing = obj:GetWorldForward(),
    Chests = chestRefs,
    selectedChest = -1
  }
end
function Treasure_Disable()
  local ResetBonusTreasure = function(bonusTreasure)
    bonusTreasure.obj:SetWorldPosition(bonusTreasure.objOrigin)
    bonusTreasure.obj:SetWorldFacing(bonusTreasure.objFacing)
    bonusTreasure.selectedChest = -1
    for i = 1, #bonusTreasure.Chests do
      bonusTreasure.Chests[i].LuaObjectScript.ForceStateDisabled()
      bonusTreasure.Chests[i].LuaObjectScript.HideChest()
    end
    return {
      pos = bonusTreasure.objOrigin,
      facing = bonusTreasure.objFacing,
      selectedChest = -1
    }
  end
  bonusTreasure_SaveData1 = ResetBonusTreasure(BonusTreasure_Chest_01)
  bonusTreasure_SaveData2 = ResetBonusTreasure(BonusTreasure_Chest_02)
  if LD.GetEntityVariable("Debug_ShowChestLocations") == true then
    for i = 1, #BonusTreasureActivePOSs do
      BonusTreasureActivePOSs[i]:Hide()
    end
  end
  BonusTreasureActivePOSs = {}
end
function Place_Treasure(bonusTreasure, location)
  local hideChests
  bonusTreasure.selectedChest = 3
  if math.random(1, 100) <= Odds[1] then
    bonusTreasure.selectedChest = 1
    hideChests = {2, 3}
  elseif math.random(1, 100) <= Odds[2] then
    bonusTreasure.selectedChest = 2
    hideChests = {1, 3}
  end
  if hideChests == nil then
    hideChests = {1, 2}
  end
  for i = 1, #hideChests do
    bonusTreasure.Chests[hideChests[i]].LuaObjectScript.ForceStateDisabled()
    bonusTreasure.Chests[hideChests[i]].LuaObjectScript.HideChest()
  end
  bonusTreasure.obj:SetWorldPosition(location:GetWorldPosition())
  bonusTreasure.obj:SetWorldFacing(location:GetWorldForward())
  local selectedChestObj = bonusTreasure.Chests[bonusTreasure.selectedChest]
  selectedChestObj.LuaObjectScript.ShowChest()
  selectedChestObj.LuaObjectScript.Reset()
  selectedChestObj.LuaObjectScript.ResetLootObjectLocation()
  table.insert(BonusTreasureActivePOSs, location)
  if LD.GetEntityVariable("Debug_ShowChestLocations") == true then
    location:Show()
  end
  bonusTreasure.locationName = location:GetName()
  return {
    pos = location:GetWorldPosition(),
    facing = location:GetWorldForward(),
    selectedChest = bonusTreasure.selectedChest
  }
end
function Hide_DebugChestLocations()
  for i = 1, #BonusTreasurePOSs do
    BonusTreasurePOSs[i]:Hide()
  end
end
function Show_DebugChestLocations()
  for i = 1, #BonusTreasureActivePOSs do
    BonusTreasureActivePOSs[i]:Show()
  end
end
function EndCaps_SetPOS(num)
  EndCap_AnimGroup:JumpAnimToFrame(EndCap_POSFrames[num])
  EndCap_AnimGroup:PauseAnim()
end
function HallLayout_01(doReRoll)
  EndCaps_SetPOS(1)
  Wall_1_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_R.LuaObjectScript.GoTo_HideHeight()
  local SelectVariant = Hall_Setups.Varient
  if SelectVariant ~= 0 and doReRoll then
    HallLayout_01_Bonus(SelectVariant)
  end
  if Hall_Setups.Hazard == 1 then
    HallLayout_01_Cushers(SelectVariant)
  else
    HallLayout_01_Saws(SelectVariant)
  end
end
function HallLayout_01_Bonus(SelectVariant)
  if SelectVariant == 1 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[1])
    bonusTreasure_SaveData2 = Place_Treasure(BonusTreasure_Chest_02, BonusTreasurePOSs[2])
  elseif SelectVariant == 2 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[4])
  elseif SelectVariant == 3 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[3])
  end
end
function HallLayout_01_Cushers(SelectVariant)
  Crushers_SetPOS(Crusher_Left_AnimGroup, 1)
  Crushers_SetPOS(Crusher_Right_AnimGroup, 1)
  Sides = Hall_Setups.Sides
  if Sides == 1 then
    EndCaps_SetPOS(2)
    Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    if SelectVariant ~= 3 then
      Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    end
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  end
  if SelectVariant == 1 then
    Wall_4_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_3_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_C1)
    if Sides ~= 1 then
      Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
      Boost_Enable(Boost2_Layout_01_C2)
    end
  elseif SelectVariant == 2 then
    Wall_1_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_B)
    EndCap_01.LuaObjectScript.HideEndCaps()
  elseif SelectVariant == 3 then
    Wall_5_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_D1)
  end
  timers.StartLevelTimer(0.5, function()
    Crusher_Enable(Crusher_Left_01)
  end)
  timers.StartLevelTimer(0.25, function()
    Crusher_Enable(Crusher_Left_02)
  end)
  timers.StartLevelTimer(0, function()
    Crusher_Enable(Crusher_Left_03)
  end)
  timers.StartLevelTimer(0.25, function()
    Crusher_Enable(Crusher_Left_04)
  end)
  timers.StartLevelTimer(0.5, function()
    Crusher_Enable(Crusher_Left_05)
  end)
  if 1 < Sides then
    timers.StartLevelTimer(0.5, function()
      Crusher_Enable(Crusher_Right_01)
    end)
    timers.StartLevelTimer(0.25, function()
      Crusher_Enable(Crusher_Right_02)
    end)
    timers.StartLevelTimer(0, function()
      Crusher_Enable(Crusher_Right_03)
    end)
    timers.StartLevelTimer(0.25, function()
      Crusher_Enable(Crusher_Right_04)
    end)
    timers.StartLevelTimer(0.5, function()
      Crusher_Enable(Crusher_Right_05)
    end)
  end
end
function HallLayout_01_Saws(SelectVariant)
  Saws_SetPOS(Saws_Right_AnimGroup, 1)
  Saws_SetPOS(Saws_Left_AnimGroup, 1)
  Wall_2_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Sides = Hall_Setups.Sides
  local selection = Hall_Setups.Selection
  if Sides == 1 then
    EndCaps_SetPOS(2)
    Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  else
    Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  end
  if selection == 1 then
    Saw_Enable(Saw_Left_01, 180, 0)
    Saw_Enable(Saw_Left_02, 180, 0)
    Saw_Enable(Saw_Left_03, 0, 0)
    Saw_Enable(Saw_Left_04, 0, 0)
    if 1 < Sides then
      Saw_Enable(Saw_Right_01, 180, 0)
      Saw_Enable(Saw_Right_02, 180, 0)
      Saw_Enable(Saw_Right_03, 0, 0)
      Saw_Enable(Saw_Right_04, 0, 0)
    end
  elseif selection == 2 then
    Saw_Enable(Saw_Left_01, 0, 0)
    Saw_Enable(Saw_Left_02, 10, 0)
    Saw_Enable(Saw_Left_03, 20, 0)
    Saw_Enable(Saw_Left_04, 30, 0)
    if 1 < Sides then
      Saw_Enable(Saw_Right_01, 180, 0)
      Saw_Enable(Saw_Right_02, 170, 0)
      Saw_Enable(Saw_Right_03, 160, 0)
      Saw_Enable(Saw_Right_04, 150, 0)
    end
  end
  if SelectVariant == 1 or selection ~= 1 then
    Wall_4_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_C.LuaObjectScript.GoTo_HideHeight()
    if 1 < Sides then
      Wall_4_Horz_RC.LuaObjectScript.GoTo_HideHeight()
    end
  end
  if SelectVariant == 1 then
    Wall_5_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_3_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_A1)
    Boost_Enable(Boost2_Layout_01_A2)
  elseif SelectVariant == 2 then
    Wall_1_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_B)
    EndCap_01.LuaObjectScript.HideEndCaps()
  elseif SelectVariant == 3 then
    Wall_5_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_D1)
  end
end
function HallLayout_02(doReRoll)
  Wall_1_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_1_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_1_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  EndCaps_SetPOS(3)
  local SelectVariant = Hall_Setups.Varient
  if SelectVariant ~= 0 and doReRoll then
    HallLayout_02_Bonus(SelectVariant)
  end
  if Hall_Setups.Hazard == 1 then
    HallLayout_02_Cushers(SelectVariant)
  else
    HallLayout_02_Saws(SelectVariant)
  end
end
function HallLayout_02_Bonus(SelectVariant)
  if SelectVariant == 1 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[6])
  elseif SelectVariant == 2 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[7])
  elseif SelectVariant == 3 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[12])
  end
end
function HallLayout_02_Cushers(SelectVariant)
  Crushers_SetPOS(Crusher_Left_AnimGroup, 2)
  Crushers_SetPOS(Crusher_Right_AnimGroup, 4)
  if SelectVariant == 0 then
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
  end
  if SelectVariant == 1 then
    Wall_2_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Boost_Enable(Boost2_Layout_02_A1)
  end
  if SelectVariant == 2 then
    Boost_DisableSet(Boosts)
    Boost_Enable(Boost2_Layout_03_B)
    Wall_1_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_7_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  end
  if SelectVariant == 3 then
    Boost_Enable(Boost2_Layout_02_C1)
    Boost_Enable(Boost2_Layout_02_C2)
    Boost_Enable(Boost2_Layout_02_C3)
    Boost_Enable(Boost2_Layout_02_C4)
    Boost_Enable(Boost2_Layout_02_C5)
    Boost_Enable(Boost2_Layout_01_C2)
    Boost_Enable(Boost2_Layout_01_B)
    Crushers_SetPOS(Crusher_Left_AnimGroup, 1)
    Crushers_SetPOS(Crusher_Right_AnimGroup, 1)
    Wall_1_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_1_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_6_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_7_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  end
  if SelectVariant == 4 then
    Crushers_SetPOS(Crusher_Left_AnimGroup, 1)
    Crushers_SetPOS(Crusher_Right_AnimGroup, 1)
    Boost_Enable(Boost2_Layout_02_C1)
    Boost_Enable(Boost2_Layout_02_C2)
    Boost_Enable(Boost2_Layout_02_C3)
    Boost_Enable(Boost2_Layout_02_C4)
    Boost_Enable(Boost2_Layout_02_C5)
    Boost_Enable(Boost2_Layout_01_B)
    Wall_1_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_1_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_LC.LuaObjectScript.GoTo_BoostHeight()
    Wall_6_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_7_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  end
  if SelectVariant == 0 then
    Crusher_Enable(Crusher_Left_01)
    Crusher_Enable(Crusher_Left_02)
    Crusher_Enable(Crusher_Left_03)
    Crusher_Enable(Crusher_Left_04)
    Crusher_Enable(Crusher_Left_05)
    Crusher_Enable(Crusher_Right_01)
    Crusher_Enable(Crusher_Right_02)
    Crusher_Enable(Crusher_Right_03)
    Crusher_Enable(Crusher_Right_04)
    Crusher_Enable(Crusher_Right_05)
  end
  if SelectVariant == 1 then
    Crusher_Enable(Crusher_Left_03)
    Crusher_Enable(Crusher_Left_04)
    Crusher_Enable(Crusher_Left_05)
    Crusher_Enable(Crusher_Right_03)
    Crusher_Enable(Crusher_Right_04)
    Crusher_Enable(Crusher_Right_05)
  end
  if SelectVariant == 2 then
    Crusher_Enable(Crusher_Left_01)
    Crusher_Enable(Crusher_Left_02)
    Crusher_Enable(Crusher_Left_03)
    Crusher_Enable(Crusher_Left_04)
    Crusher_Enable(Crusher_Left_05)
    Crusher_Enable(Crusher_Right_01)
    Crusher_Enable(Crusher_Right_05)
  end
  if SelectVariant == 3 then
    Crusher_Enable(Crusher_Left_01)
    Crusher_Enable(Crusher_Left_02)
    Crusher_Enable(Crusher_Left_03)
    Crusher_Enable(Crusher_Left_04)
    Crusher_Enable(Crusher_Left_05)
    Crusher_Enable(Crusher_Right_01)
    Crusher_Enable(Crusher_Right_02)
    Crusher_Enable(Crusher_Right_03)
    Crusher_Enable(Crusher_Right_04)
    Crusher_Enable(Crusher_Right_05)
  end
  if SelectVariant == 4 then
    Crusher_Enable(Crusher_Left_01)
    Crusher_Enable(Crusher_Left_02)
    Crusher_Enable(Crusher_Left_03)
    Crusher_Enable(Crusher_Left_04)
    Crusher_Enable(Crusher_Left_05)
    Crusher_Enable(Crusher_Right_01)
    Crusher_Enable(Crusher_Right_02)
    Crusher_Enable(Crusher_Right_03)
    Crusher_Enable(Crusher_Right_04)
    Crusher_Enable(Crusher_Right_05)
  end
end
function HallLayout_02_Saws(SelectVariant)
  Saws_SetPOS(Saws_Right_AnimGroup, 2)
  Saws_SetPOS(Saws_Left_AnimGroup, 1)
  Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  if SelectVariant ~= 1 then
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  end
  if SelectVariant ~= 2 then
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  end
  if SelectVariant == 1 then
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_02_A1)
  elseif SelectVariant == 2 then
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_02_B1)
  elseif SelectVariant == 3 then
    Boost_Enable(Boost2_Layout_02_C1)
    Boost_Enable(Boost2_Layout_02_C2)
    Boost_Enable(Boost2_Layout_02_C3)
    Boost_Enable(Boost2_Layout_02_C4)
    Boost_Enable(Boost2_Layout_02_C5)
    Boost_Enable(Boost2_Layout_01_C2)
    Boost_Enable(Boost2_Layout_01_B)
  end
  local selection = Hall_Setups.Selection
  if selection == 0 then
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_02_A1)
    Boost_Enable(Boost2_Layout_02_B1)
    Boost_Enable(Boost2_Layout_02_B2)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_01, 0, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_02, 10, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_03, 20, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_04, 30, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_05, 40, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_01, 90, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_02, 80, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_03, 70, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_04, 60, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_05, 50, 0)
    end)
  elseif selection == 1 then
    Saw_Enable(Saw_Left_01, 180, 0)
    Saw_Enable(Saw_Left_02, 180, 0)
    Saw_Enable(Saw_Left_03, 0, 0)
    Saw_Enable(Saw_Left_04, 0, 0)
    Saw_Enable(Saw_Left_05, 180, 0)
    Saw_Enable(Saw_Right_01, 180, 0)
    Saw_Enable(Saw_Right_02, 180, 0)
    Saw_Enable(Saw_Right_03, 0, 0)
    Saw_Enable(Saw_Right_04, 0, 0)
    Saw_Enable(Saw_Right_05, 180, 0)
  elseif selection == 2 then
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_01, 0, 0)
    end)
    timers.StartLevelTimer(1, function()
      Saw_Enable(Saw_Left_02, 0, 0)
    end)
    timers.StartLevelTimer(2, function()
      Saw_Enable(Saw_Left_03, 0, 0)
    end)
    timers.StartLevelTimer(3, function()
      Saw_Enable(Saw_Left_04, 0, 0)
    end)
    timers.StartLevelTimer(4, function()
      Saw_Enable(Saw_Left_05, 0, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_01, 180, 0)
    end)
    timers.StartLevelTimer(1, function()
      Saw_Enable(Saw_Right_02, 180, 0)
    end)
    timers.StartLevelTimer(2, function()
      Saw_Enable(Saw_Right_03, 180, 0)
    end)
    timers.StartLevelTimer(3, function()
      Saw_Enable(Saw_Right_04, 180, 0)
    end)
    timers.StartLevelTimer(4, function()
      Saw_Enable(Saw_Right_05, 180, 0)
    end)
  end
end
function HallLayout_03(doReRoll)
  Wall_1_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_RC.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_C.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  EndCaps_SetPOS(3)
  local SelectVariant = Hall_Setups.Varient
  if SelectVariant ~= 0 and doReRoll then
    HallLayout_03_Bonus(SelectVariant)
  end
  if Hall_Setups.Hazard == 1 then
    HallLayout_03_Cushers(SelectVariant)
  else
    HallLayout_03_Saws(SelectVariant)
  end
end
function HallLayout_03_Bonus(SelectVariant)
  if SelectVariant == 1 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[8])
  elseif SelectVariant == 2 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[7])
  elseif SelectVariant == 3 then
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[5])
  end
end
function HallLayout_03_Cushers(SelectVariant)
  Crushers_SetPOS(Crusher_Left_AnimGroup, 1)
  Crushers_SetPOS(Crusher_Right_AnimGroup, 3)
  if SelectVariant == 0 then
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
  end
  if SelectVariant == 1 then
    Wall_1_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_L.LuaObjectScript.GoTo_HideHeight()
    Wall_2_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_L.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_L.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_L.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_L.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    Wall_7_Horz_L.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
    EndCap_02.LuaObjectScript.HideEndCaps()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_7_Horz_R.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_03_A)
  end
  if SelectVariant == 2 then
    Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_R.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Boost_Enable(Boost2_Layout_02_B1)
  end
  if SelectVariant == 3 then
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
    Boost_Enable(Boost2_Layout_01_A1)
  end
  timers.StartLevelTimer(0, function()
    Crusher_Enable(Crusher_Left_01)
  end)
  timers.StartLevelTimer(0.25, function()
    Crusher_Enable(Crusher_Left_02)
  end)
  timers.StartLevelTimer(0.5, function()
    Crusher_Enable(Crusher_Left_03)
  end)
  timers.StartLevelTimer(0.25, function()
    Crusher_Enable(Crusher_Left_04)
  end)
  timers.StartLevelTimer(0, function()
    Crusher_Enable(Crusher_Left_05)
  end)
  if SelectVariant == 0 then
    timers.StartLevelTimer(0.5, function()
      Crusher_Enable(Crusher_Right_01)
    end)
    timers.StartLevelTimer(0.25, function()
      Crusher_Enable(Crusher_Right_02)
    end)
    timers.StartLevelTimer(0, function()
      Crusher_Enable(Crusher_Right_03)
    end)
    timers.StartLevelTimer(0.25, function()
      Crusher_Enable(Crusher_Right_04)
    end)
    timers.StartLevelTimer(0.5, function()
      Crusher_Enable(Crusher_Right_05)
    end)
  elseif SelectVariant == 1 then
    Crushers_SetPOS(Crusher_Left_AnimGroup, 3)
  elseif SelectVariant == 2 then
    Crusher_Enable(Crusher_Right_01)
    Crusher_Enable(Crusher_Right_05)
  elseif SelectVariant == 3 then
    timers.StartLevelTimer(0.5, function()
      Crusher_Enable(Crusher_Right_01)
    end)
    timers.StartLevelTimer(0.25, function()
      Crusher_Enable(Crusher_Right_02)
    end)
    timers.StartLevelTimer(0, function()
      Crusher_Enable(Crusher_Right_03)
    end)
  end
end
function HallLayout_03_Saws(SelectVariant)
  Saws_SetPOS(Saws_Right_AnimGroup, 2)
  Saws_SetPOS(Saws_Left_AnimGroup, 1)
  Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  local selection = Hall_Setups.Selection
  if SelectVariant == 1 then
    EndCap_02.LuaObjectScript.HideEndCaps()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Wall_7_Horz_R.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_03_A)
  end
  if SelectVariant == 2 then
    Wall_4_Horz_RC.LuaObjectScript.GoTo_BoostHeight()
    Wall_4_Horz_RM.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_02_B1)
    if selection == 1 then
      Wall_3_Horz_LC.LuaObjectScript.GoTo_HideHeight()
      Wall_5_Horz_LC.LuaObjectScript.GoTo_HideHeight()
    end
  elseif selection == 1 then
    Wall_4_Horz_LC.LuaObjectScript.GoTo_HideHeight()
  end
  if SelectVariant == 3 then
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_7_Horz_C.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Wall_5_Horz_C.LuaObjectScript.GoTo_BoostHeight()
    Boost_Enable(Boost2_Layout_01_A1)
  end
  if SelectVariant ~= 1 then
    Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_2_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_5_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
    Wall_6_Horz_RM.LuaObjectScript.GoTo_BlockHeight()
  end
  if selection == 1 then
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_01, 0, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_02, 15, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_03, 30, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Left_04, 45, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_01, 180, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_02, 165, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_03, 150, 0)
    end)
    timers.StartLevelTimer(0, function()
      Saw_Enable(Saw_Right_04, 135, 0)
    end)
  elseif selection == 2 then
    Saw_Enable(Saw_Left_01, 180, 0)
    Saw_Enable(Saw_Left_02, 180, 0)
    Saw_Enable(Saw_Left_03, 0, 0)
    Saw_Enable(Saw_Left_04, 0, 0)
    Saw_Enable(Saw_Right_01, 180, 0)
    Saw_Enable(Saw_Right_02, 180, 0)
    Saw_Enable(Saw_Right_03, 0, 0)
    Saw_Enable(Saw_Right_04, 0, 0)
  end
end
function HallLayout_DeadEnd()
  EndCaps_SetPOS(1)
  Wall_1_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_1_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_2_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_2_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_3_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_3_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_4_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_4_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_5_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_5_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_L.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_6_Horz_RM.LuaObjectScript.GoTo_HideHeight()
  Wall_6_Horz_R.LuaObjectScript.GoTo_HideHeight()
  Wall_7_Horz_L.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_LC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_C.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_RC.LuaObjectScript.GoTo_BlockHeight()
  Wall_7_Horz_R.LuaObjectScript.GoTo_BlockHeight()
  HallLayout_DeadEnd_Bonus()
end
function HallLayout_DeadEnd_Bonus()
  local selection = Hall_Setups.Selection
  if selection == 1 then
    EndCap_01.LuaObjectScript.SelectEndCap()
    EndCap_02.LuaObjectScript.SelectEndCap()
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[9])
    bonusTreasure_SaveData2 = Place_Treasure(BonusTreasure_Chest_02, BonusTreasurePOSs[11])
  else
    EndCap_02.LuaObjectScript.HideEndCaps()
    bonusTreasure_SaveData1 = Place_Treasure(BonusTreasure_Chest_01, BonusTreasurePOSs[10])
  end
end
function DebugTrapHallText()
  local color = require("core.color")
  if engine.IsDebug then
    local bonusTables = {BonusTreasure_Chest_01, BonusTreasure_Chest_02}
    local chestNames = {
      "Legend",
      "Coffin",
      "Chest"
    }
    for i = 1, #bonusTables do
      local selectedChest = bonusTables[i].selectedChest or "N/A"
      local debugText = "BonusTreasure_Chest_0" .. tostring(i)
      if bonusTables.locationName then
        debugText = debugText .. [[

 LocatorName = ]] .. bonusTables.locationName
      end
      for x = 1, #chestNames do
        local chestPos = bonusTables[i].Chests[x]:GetWorldPosition()
        debugText = debugText .. "\n"
        if x == selectedChest then
          debugText = debugText .. "Selected >>>"
        end
        debugText = debugText .. chestNames[x] .. " Pos= " .. tostring(chestPos)
      end
      engine.DrawTextInWorld(bonusTables[i].obj:GetWorldPosition() + engine.Vector.New(0, 1, 0), debugText, color.red)
    end
  end
end
function GetTrapHallDebugInfo()
  local treasure
  local chestNames = {
    "Legend",
    "Coffin",
    "Common"
  }
  if bonusTreasure_SaveData1 and bonusTreasure_SaveData1.selectedChest and bonusTreasure_SaveData1.selectedChest > 0 then
    treasure = "[ " .. chestNames[bonusTreasure_SaveData1.selectedChest] .. "]"
  end
  if bonusTreasure_SaveData2 and bonusTreasure_SaveData2.selectedChest and bonusTreasure_SaveData2.selectedChest > 0 then
    treasure = treasure .. " [ " .. chestNames[bonusTreasure_SaveData2.selectedChest] .. "]"
  end
  return treasure
end
