local LD = require("design.LevelDesignLibrary")
local color = require("core.color")
local monitors = require("level.MonitorLibrary")
local thisObj, thisLevel, GoalObject, EndCap, Target_01, Target_02, Target_03
local Target_01_Fakes = {}
local Target_02_Fakes = {}
local Target_03_Fakes = {}
local tripleChestSaveData = {}
local Debug_ShowTripleChestTargetLocations, Goal_POSMarker, Goal_HidePOSMarker, keyType
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  Debug_ShowTripleChestTargetLocations = monitors.CreateEntityVariableMonitor("Debug_ShowTripleTargetLocations")
  Debug_ShowTripleChestTargetLocations:OnValue(true, ShowTargetLocations)
  Debug_ShowTripleChestTargetLocations:OnValue(false, HideTargetLocations)
  Goal_POSMarker = thisLevel:GetGameObject("RunicGoal_POSMarker_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
  Goal_POSMarker:Hide()
  Goal_HidePOSMarker = thisLevel:GetGameObject("WadManager")
  GoalObject = thisLevel:GetGameObject("RunicGoal_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
  Target_01 = thisLevel:GetGameObject("Target_A_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
  Target_02 = thisLevel:GetGameObject("Target_B_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
  Target_03 = thisLevel:GetGameObject("Target_C_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
  keyType = GoalObject:FindSingleGOByName("Chest_Locked_Parent"):GetLuaTableAttribute("KeyType")
  for i = 1, 5 do
    Target_01_Fakes[i] = thisLevel:GetGameObject("Fake_Target_A_0" .. i .. "_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
    Target_01_Fakes[i]:Hide()
  end
  for i = 1, 5 do
    Target_02_Fakes[i] = thisLevel:GetGameObject("Fake_Target_B_0" .. i .. "_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
    Target_02_Fakes[i]:Hide()
  end
  for i = 1, 5 do
    Target_03_Fakes[i] = thisLevel:GetGameObject("Fake_Target_C_0" .. i .. "_Setup_0" .. thisObj:FindLuaTableAttribute("SetupNumber"))
    Target_03_Fakes[i]:Hide()
  end
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {tripleChestSaveData = tripleChestSaveData}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  tripleChestSaveData = savedInfo.tripleChestSaveData
  GoalObject:SetWorldPosition(tripleChestSaveData.goalObj)
  Target_01:SetWorldPosition(tripleChestSaveData.targetObj1.pos)
  Target_01:SetWorldFacing(tripleChestSaveData.targetObj1.facing)
  Target_02:SetWorldPosition(tripleChestSaveData.targetObj2.pos)
  Target_02:SetWorldFacing(tripleChestSaveData.targetObj2.facing)
  Target_03:SetWorldPosition(tripleChestSaveData.targetObj3.pos)
  Target_03:SetWorldFacing(tripleChestSaveData.targetObj3.facing)
end
function GetKeyType()
  return keyType
end
function Enable(isReRoll)
  local selectedTarget
  GoalObject:SetWorldPosition(Goal_POSMarker:GetWorldPosition())
  GoalObject.LuaObjectScript.ShowChest()
  GoalObject.LuaObjectScript.Reset()
  tripleChestSaveData.goalObj = GoalObject:GetWorldPosition()
  local SetupTripleChestKeyObject = function(keyObj, fakeObjTable, isReRoll)
    local randomKeyTarget = math.random(1, 5)
    keyObj:SetWorldPosition(fakeObjTable[randomKeyTarget]:GetWorldPosition())
    keyObj:SetWorldFacing(fakeObjTable[randomKeyTarget]:GetWorldForward())
    if keyType == "Bell" then
      keyObj.LuaObjectScript.ShowBellTarget()
      if isReRoll then
        keyObj.LuaObjectScript.ResetBellTarget()
      end
    end
    return {
      pos = fakeObjTable[randomKeyTarget]:GetWorldPosition(),
      facing = fakeObjTable[randomKeyTarget]:GetWorldForward(),
      randomKeyTarget = randomKeyTarget
    }
  end
  HideTargetLocations()
  tripleChestSaveData.targetObj1 = SetupTripleChestKeyObject(Target_01, Target_01_Fakes, isReRoll)
  tripleChestSaveData.targetObj2 = SetupTripleChestKeyObject(Target_02, Target_02_Fakes, isReRoll)
  tripleChestSaveData.targetObj3 = SetupTripleChestKeyObject(Target_03, Target_03_Fakes, isReRoll)
  local EndCapString = thisObj:FindLuaTableAttribute("EndCap")
  if EndCapString ~= "" then
    EndCap = thisLevel:GetGameObject(EndCapString)
    if EndCap ~= nil then
      EndCap.LuaObjectScript.HideEndCaps()
    end
  end
  return tripleChestSaveData
end
function Disable()
  local HideTripleChestKeyObject = function(keyObj)
    if keyType == "Bell" then
      keyObj.LuaObjectScript.HideBellTarget()
    else
      keyObj:SetWorldPosition(Goal_HidePOSMarker:GetWorldPosition())
    end
    return {
      pos = keyObj:GetWorldPosition(),
      facing = keyObj:GetWorldForward(),
      randomKeyTarget = nil
    }
  end
  HideTargetLocations()
  GoalObject.LuaObjectScript.ForceStateDisabled()
  GoalObject.LuaObjectScript.HideChest()
  GoalObject.LuaObjectScript.Disable()
  tripleChestSaveData.goalObj = GoalObject:GetWorldPosition()
  tripleChestSaveData.targetObj1 = HideTripleChestKeyObject(Target_01)
  tripleChestSaveData.targetObj2 = HideTripleChestKeyObject(Target_02)
  tripleChestSaveData.targetObj3 = HideTripleChestKeyObject(Target_03)
  local EndCapString = thisObj:FindLuaTableAttribute("EndCap")
  if EndCapString ~= "" then
    EndCap = thisLevel:GetGameObject(EndCapString)
    if EndCap ~= nil then
      EndCap.LuaObjectScript.SelectEndCap()
    end
  end
end
function HideTargetLocations()
  for i = 1, #Target_01_Fakes do
    Target_01_Fakes[i]:Hide()
  end
  for i = 1, #Target_02_Fakes do
    Target_02_Fakes[i]:Hide()
  end
  for i = 1, #Target_03_Fakes do
    Target_03_Fakes[i]:Hide()
  end
  Goal_POSMarker:Hide()
end
function ShowTargetLocations()
  for i = 1, #Target_01_Fakes do
    Target_01_Fakes[i]:Show()
  end
  for i = 1, #Target_02_Fakes do
    Target_02_Fakes[i]:Show()
  end
  for i = 1, #Target_03_Fakes do
    Target_03_Fakes[i]:Show()
  end
  Goal_POSMarker:Show()
end
function Debug_DrawTargetLocators()
  engine.DrawTextInWorld(Target_01:GetWorldPosition(), keyType .. "_Target_01", color.blue)
  engine.DrawTextInWorld(Target_02:GetWorldPosition(), keyType .. "_Target_02", color.blue)
  engine.DrawTextInWorld(Target_03:GetWorldPosition(), keyType .. "_Target_03", color.blue)
end
function GetDebugTargetLocationName()
  if tripleChestSaveData and tripleChestSaveData.targetObj1.randomKeyTarget and tripleChestSaveData.targetObj2.randomKeyTarget and tripleChestSaveData.targetObj3.randomKeyTarget then
    return {
      Target_01_Fakes[tripleChestSaveData.targetObj1.randomKeyTarget]:GetName(),
      Target_02_Fakes[tripleChestSaveData.targetObj2.randomKeyTarget]:GetName(),
      Target_03_Fakes[tripleChestSaveData.targetObj3.randomKeyTarget]:GetName()
    }
  else
    return {
      "--",
      "--",
      "--"
    }
  end
end
