local LD = require("design.LevelDesignLibrary")
local color = require("core.color")
local monitors = require("level.MonitorLibrary")
local thisObj, thisLevel, Nid000_Level
local Global_levelVars = {
  chance_lootChest = 50,
  chance_lootCoffin = 25,
  chance_lootLegendary = 5,
  chance_runeTransition = 0
}
local guaranteeLegendaryChest
local wadSetupSaveData = {}
local Halls = {}
local TripleChests = {}
local RuneReads = {}
local ChestPOSs = {}
local CommonChest, CoffinChest, LegendaryChest
local chestPosSaveData = {}
local hasValkyrie = false
local VariantSelection = 1
local LayoutSelection = 1
local LayoutVariantCount = {
  14,
  20,
  8,
  12,
  8,
  12
}
local Hall_Setup_110011 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_111011 = {
  Layout = 1,
  Hazard = 1,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_110111 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_111111 = {
  Layout = 1,
  Hazard = 1,
  Flip = true,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_110211 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_111211 = {
  Layout = 1,
  Hazard = 1,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_110311 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 3,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_111311 = {
  Layout = 1,
  Hazard = 1,
  Flip = true,
  Varient = 3,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_110012 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_110112 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_110212 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_111212 = {
  Layout = 1,
  Hazard = 1,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_110312 = {
  Layout = 1,
  Hazard = 1,
  Flip = false,
  Varient = 3,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_111312 = {
  Layout = 1,
  Hazard = 1,
  Flip = true,
  Varient = 3,
  Selection = 1,
  Sides = 2
}
local Hall_Layout1_CrusherSetups = {
  Hall_Setup_110011,
  Hall_Setup_111011,
  Hall_Setup_110111,
  Hall_Setup_111111,
  Hall_Setup_110211,
  Hall_Setup_111211,
  Hall_Setup_110311,
  Hall_Setup_111311,
  Hall_Setup_110012,
  Hall_Setup_110112,
  Hall_Setup_110212,
  Hall_Setup_111212,
  Hall_Setup_110312,
  Hall_Setup_111312
}
local Hall_Setup_120011 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_121011 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_120111 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_121111 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_120211 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_121211 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_120021 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_121021 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_120121 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_121121 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 1,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_120221 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_121221 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_120012 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_120112 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_120212 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_121212 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 2
}
local Hall_Setup_120022 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 2,
  Sides = 2
}
local Hall_Setup_120122 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 2,
  Sides = 2
}
local Hall_Setup_120222 = {
  Layout = 1,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 2,
  Sides = 2
}
local Hall_Setup_121222 = {
  Layout = 1,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 2,
  Sides = 2
}
local Hall_Layout1_SawSetups = {
  Hall_Setup_120011,
  Hall_Setup_121011,
  Hall_Setup_120111,
  Hall_Setup_121111,
  Hall_Setup_120211,
  Hall_Setup_121211,
  Hall_Setup_120021,
  Hall_Setup_121021,
  Hall_Setup_120121,
  Hall_Setup_121121,
  Hall_Setup_120221,
  Hall_Setup_121221,
  Hall_Setup_120012,
  Hall_Setup_120112,
  Hall_Setup_120212,
  Hall_Setup_121212,
  Hall_Setup_120022,
  Hall_Setup_120122,
  Hall_Setup_120222,
  Hall_Setup_121222
}
local Hall_Setup_210011 = {
  Layout = 2,
  Hazard = 1,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_211011 = {
  Layout = 2,
  Hazard = 1,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_210111 = {
  Layout = 2,
  Hazard = 1,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_210211 = {
  Layout = 2,
  Hazard = 1,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_211211 = {
  Layout = 2,
  Hazard = 1,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_210311 = {
  Layout = 2,
  Hazard = 1,
  Flip = false,
  Varient = 3,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_211311 = {
  Layout = 2,
  Hazard = 1,
  Flip = true,
  Varient = 3,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_210411 = {
  Layout = 2,
  Hazard = 1,
  Flip = false,
  Varient = 4,
  Selection = 1,
  Sides = 1
}
local Hall_Layout2_CrusherSetups = {
  Hall_Setup_210011,
  Hall_Setup_211011,
  Hall_Setup_210111,
  Hall_Setup_210211,
  Hall_Setup_211211,
  Hall_Setup_210311,
  Hall_Setup_211311,
  Hall_Setup_210411
}
local Hall_Setup_220011 = {
  Layout = 2,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_221011 = {
  Layout = 2,
  Hazard = 2,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_220111 = {
  Layout = 2,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_221111 = {
  Layout = 2,
  Hazard = 2,
  Flip = true,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_220211 = {
  Layout = 2,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_221211 = {
  Layout = 2,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_220021 = {
  Layout = 2,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_221021 = {
  Layout = 2,
  Hazard = 2,
  Flip = true,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_220121 = {
  Layout = 2,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_221121 = {
  Layout = 2,
  Hazard = 2,
  Flip = true,
  Varient = 1,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_220221 = {
  Layout = 2,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_221221 = {
  Layout = 2,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 2,
  Sides = 1
}
local Hall_Layout2_SawSetups = {
  Hall_Setup_220011,
  Hall_Setup_221011,
  Hall_Setup_220111,
  Hall_Setup_221111,
  Hall_Setup_220211,
  Hall_Setup_221211,
  Hall_Setup_220021,
  Hall_Setup_221021,
  Hall_Setup_220121,
  Hall_Setup_221121,
  Hall_Setup_220221,
  Hall_Setup_221221
}
local Hall_Setup_310011 = {
  Layout = 3,
  Hazard = 1,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_311011 = {
  Layout = 3,
  Hazard = 1,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_310111 = {
  Layout = 3,
  Hazard = 1,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_311111 = {
  Layout = 3,
  Hazard = 1,
  Flip = true,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_310211 = {
  Layout = 3,
  Hazard = 1,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_311211 = {
  Layout = 3,
  Hazard = 1,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_310311 = {
  Layout = 3,
  Hazard = 1,
  Flip = false,
  Varient = 3,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_311311 = {
  Layout = 3,
  Hazard = 1,
  Flip = true,
  Varient = 3,
  Selection = 1,
  Sides = 1
}
local Hall_Layout3_CrusherSetups = {
  Hall_Setup_310011,
  Hall_Setup_311011,
  Hall_Setup_310111,
  Hall_Setup_311111,
  Hall_Setup_310211,
  Hall_Setup_311211,
  Hall_Setup_310311,
  Hall_Setup_311311
}
local Hall_Setup_320011 = {
  Layout = 3,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_321011 = {
  Layout = 3,
  Hazard = 2,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_320111 = {
  Layout = 3,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_321111 = {
  Layout = 3,
  Hazard = 2,
  Flip = true,
  Varient = 1,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_320211 = {
  Layout = 3,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_321211 = {
  Layout = 3,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_320021 = {
  Layout = 3,
  Hazard = 2,
  Flip = false,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_321021 = {
  Layout = 3,
  Hazard = 2,
  Flip = true,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_320121 = {
  Layout = 3,
  Hazard = 2,
  Flip = false,
  Varient = 1,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_321121 = {
  Layout = 3,
  Hazard = 2,
  Flip = true,
  Varient = 1,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_320221 = {
  Layout = 3,
  Hazard = 2,
  Flip = false,
  Varient = 2,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_321221 = {
  Layout = 3,
  Hazard = 2,
  Flip = true,
  Varient = 2,
  Selection = 2,
  Sides = 1
}
local Hall_Layout3_SawSetups = {
  Hall_Setup_320011,
  Hall_Setup_321011,
  Hall_Setup_320111,
  Hall_Setup_321111,
  Hall_Setup_320211,
  Hall_Setup_321211,
  Hall_Setup_320021,
  Hall_Setup_321021,
  Hall_Setup_320121,
  Hall_Setup_321121,
  Hall_Setup_320221,
  Hall_Setup_321221
}
local Hall_Setup_410011 = {
  Layout = 4,
  Hazard = 1,
  Flip = false,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_411011 = {
  Layout = 4,
  Hazard = 1,
  Flip = true,
  Varient = 0,
  Selection = 1,
  Sides = 1
}
local Hall_Setup_410021 = {
  Layout = 4,
  Hazard = 1,
  Flip = false,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Setup_411021 = {
  Layout = 4,
  Hazard = 1,
  Flip = true,
  Varient = 0,
  Selection = 2,
  Sides = 1
}
local Hall_Layout4_DeadEnds = {
  Hall_Setup_410011,
  Hall_Setup_411011,
  Hall_Setup_410021,
  Hall_Setup_411021
}
local Hall_Setups = {}
local Debug_DisplayChestLocations, Debug_TrapHallText_monitor
local debug_enableMonitors = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  guaranteeLegendaryChest = thisObj:GetLuaTableAttribute("GuarantyLegendaryChest")
  if thisObj:GetLuaTableAttribute("isValkyrie") == true and game.Wallets.GetResourceValue("HERO", "ValkyrieLoot07") == -1 then
    hasValkyrie = true
  end
  local HallSetups = obj:GetLuaTableAttribute("Hall_Setups")
  if HallSetups ~= nil or HallSetups ~= "" then
    local HallSetupsTable = LD.ConvertStringListToTable(HallSetups)
    for _, HallSetupsName in ipairs(HallSetupsTable) do
      table.insert(Halls, level:GetGameObject(HallSetupsName))
    end
  end
  local TripleChestSetups = obj:GetLuaTableAttribute("TripleChest_Setups")
  if TripleChestSetups ~= nil and TripleChestSetups ~= "" then
    local TripleChestTable = LD.ConvertStringListToTable(TripleChestSetups)
    for _, TripleChestName in ipairs(TripleChestTable) do
      table.insert(TripleChests, level:GetGameObject(TripleChestName))
    end
  end
  local CommonChestStr = obj:GetLuaTableAttribute("CommonChest")
  if CommonChestStr ~= "" and CommonChestStr ~= nil then
    CommonChest = GameObjects[CommonChestStr]
    if CommonChest.IsRefNode then
      CommonChest = CommonChest.Child
    end
  end
  local CoffinChestStr = obj:GetLuaTableAttribute("CoffinChest")
  if CoffinChestStr ~= "" and CoffinChestStr ~= nil then
    CoffinChest = GameObjects[CoffinChestStr]
    if CoffinChest.IsRefNode then
      CoffinChest = CoffinChest.Child
    end
  end
  local LegendaryChestStr = obj:GetLuaTableAttribute("LegendaryChest")
  if LegendaryChestStr ~= "" and LegendaryChestStr ~= nil then
    LegendaryChest = GameObjects[LegendaryChestStr]
    if LegendaryChest.IsRefNode then
      LegendaryChest = LegendaryChest.Child
    end
  end
  local ChestPOSsList = obj:GetLuaTableAttribute("ChestLocations")
  if ChestPOSsList ~= nil and ChestPOSsList ~= "" then
    local ChestPOSsTable = LD.ConvertStringListToTable(ChestPOSsList)
    for i = 1, #ChestPOSsTable do
      table.insert(ChestPOSs, GameObjects[ChestPOSsTable[i]])
    end
  end
  for i = 1, 3 do
    chestPosSaveData[i] = {
      pos = nil,
      facing = nil,
      enable = false
    }
  end
  wadSetupSaveData.RepopulateSetup = true
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("Debug_ShowChestLocations") == false then
    HideChestLocations()
  end
  Nid000_Level = game.FindLevel("Nid000_LevelGlobal")
end
function OnSaveCheckpoint(level, obj)
  if engine.IsDebug then
    engine.Print("WadManager @" .. level.Name .. ": OnSaveCheckpoint fired " .. tostring(game.GetGameTime()) .. "---------------------------------------------------------------------------")
    local tempChestTable = {
      LegendaryChest,
      CoffinChest,
      CommonChest
    }
    local debugChestNames = {
      "LegendaryChest",
      "CoffinChest",
      "CommonChest"
    }
    for i = 1, #tempChestTable do
      if tempChestTable[i] then
        engine.Print("WadManager @" .. level.Name .. ": " .. debugChestNames[i] .. " Save Data - Pos = " .. tostring(chestPosSaveData[i].pos) .. " Facing = " .. tostring(chestPosSaveData[i].facing) .. " Enable = " .. tostring(chestPosSaveData[i].enable))
      end
    end
  end
  return {wadSetupSaveData = wadSetupSaveData, chestPosSaveData = chestPosSaveData}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if engine.IsDebug then
    engine.Print("WadManager @" .. level.Name .. ": OnRestoreCheckpoint fired " .. tostring(game.GetGameTime()) .. "---------------------------------------------------------------------------")
  end
  wadSetupSaveData = savedInfo.wadSetupSaveData
  chestPosSaveData = savedInfo.chestPosSaveData
  if chestPosSaveData then
    if engine.IsDebug then
      engine.Print("WadManager @" .. level.Name .. ": Restoring - ChestLayouts " .. tostring(game.GetGameTime()))
    end
    local tempChestTable = {
      LegendaryChest,
      CoffinChest,
      CommonChest
    }
    local debugChestNames = {
      "LegendaryChest",
      "CoffinChest",
      "CommonChest"
    }
    for i = 1, #tempChestTable do
      if tempChestTable[i] then
        if chestPosSaveData[i].enable then
          tempChestTable[i]:SetWorldPosition(chestPosSaveData[i].pos)
          tempChestTable[i]:SetWorldFacing(chestPosSaveData[i].facing)
        end
        if engine.IsDebug then
          engine.Print("WadManager @" .. level.Name .. ": " .. debugChestNames[i] .. " Save Data - Pos = " .. tostring(chestPosSaveData[i].pos) .. " Facing = " .. tostring(chestPosSaveData[i].facing) .. " Enable = " .. tostring(chestPosSaveData[i].enable))
        end
      end
    end
  end
  for i = 1, #TripleChests do
    TripleChests[i].LuaObjectScript.Disable()
  end
  if wadSetupSaveData.TripleChest then
    engine.Print("WadManager @" .. level.Name .. ": Restoring - TripleChestLayouts " .. tostring(game.GetGameTime()))
    TripleChests[wadSetupSaveData.TripleChestSelected].LuaObjectScript.Enable()
  end
  if wadSetupSaveData == nil then
    engine.Error("OnRestoreCheckpoint : wadSetupSaveData is nil for " .. tostring(thisLevel.Name) .. " |" .. tostring(game.GetGameTime()))
    return
  end
  if 0 < #Halls and wadSetupSaveData.LayoutSelection == nil and wadSetupSaveData.RepopulateSetup == false then
    engine.Error("OnRestoreCheckpoint : wadSetupSaveData.LayoutSelection is nil for " .. tostring(thisLevel.Name) .. " |" .. tostring(game.GetGameTime()))
  end
  if 0 < #Halls and wadSetupSaveData.VariantSelection == nil and wadSetupSaveData.RepopulateSetup == false then
    engine.Error("OnRestoreCheckpoint : wadSetupSaveData.VariantSelection is nil for " .. tostring(thisLevel.Name) .. " |" .. tostring(game.GetGameTime()))
  end
end
local Debug_InitalizeMonitors = function()
  if engine.IsDebug() and debug_enableMonitors == false then
    debug_enableMonitors = true
    Debug_DisplayChestLocations = monitors.CreateEntityVariableMonitor("Debug_ShowChestLocations")
    Debug_DisplayChestLocations:SetPrintsEnabled(false)
    Debug_DisplayChestLocations:OnValue(true, ShowChestLocations)
    Debug_DisplayChestLocations:OnValue(false, HideChestLocations)
    Debug_TrapHallText_monitor = monitors.CreateEntityVariableMonitor("Debug_ShowTrapHall_Text")
    Debug_TrapHallText_monitor:SetPrintsEnabled(false)
    Debug_TrapHallText_monitor:OnValue(true, function()
      game.SubObject.Wake(thisObj)
    end)
    Debug_TrapHallText_monitor:OnValue(false, function()
      game.SubObject.Sleep(thisObj)
    end)
    if LD.GetEntityVariable("Debug_ShowTrapHall_Text") == true then
      game.SubObject.Wake(thisObj)
    end
  end
end
function OnUpdate(level, obj)
  if engine.IsDebug() then
    Debug_InitalizeMonitors()
    Debug_TrapHallInfo()
  end
end
function Chance_LootChest()
  return Global_levelVars.chance_lootChest
end
function Chance_LootCoffin()
  return Global_levelVars.chance_lootCoffin
end
function Chance_LootLegendary()
  return Global_levelVars.chance_lootLegendary
end
function Chance_RuneTransition()
  return Global_levelVars.chance_runeTransition
end
function UpdateWad(level, obj, wadSetup, otherLevel)
  engine.Print("WadManager @" .. level.Name .. ": UpdateWad fired--------------------------------------------------------------------------- ")
  Nid000_Level = otherLevel
  local doReRoll = wadSetup.RepopulateSetup == true
  if doReRoll == true then
    HideChestLocations()
    engine.Print("WadManager @" .. level.Name .. ": Starting ReRoll starting ")
    wadSetupSaveData = {
      commonChest = false,
      coffin = false,
      legendaryChest = false,
      LayoutSelection = {},
      VariantSelection = {}
    }
    wadSetup.DebugTripleLocations = {
      "--",
      "--",
      "--"
    }
    wadSetup.DebugKeyType = {"--"}
    wadSetup.TripleChestSelected = nil
    wadSetup.BonusTreasure_Chest = {}
    wadSetup.LayoutSelection = {}
    wadSetup.VariantSelection = {}
    for i = 1, #TripleChests do
      TripleChests[i].LuaObjectScript.Disable()
    end
    if wadSetup.TripleChest == true then
      engine.Print("WadManager @" .. level.Name .. ": Choosing TripleChest ")
      wadSetupSaveData.TripleChest = true
      wadSetupSaveData.TripleChestSelected = math.random(1, #TripleChests)
      TripleChests[wadSetupSaveData.TripleChestSelected].LuaObjectScript.Enable(true)
      wadSetup.DebugTripleLocations = TripleChests[wadSetupSaveData.TripleChestSelected].LuaObjectScript.GetDebugTargetLocationName()
      wadSetup.DebugKeyType = TripleChests[wadSetupSaveData.TripleChestSelected].LuaObjectScript.GetKeyType()
    end
    HideChest(LegendaryChest, 1)
    HideChest(CoffinChest, 2)
    HideChest(CommonChest, 3)
    if hasValkyrie == false then
      LayoutChests()
    end
    wadSetup.commonChest = wadSetupSaveData.commonChest
    wadSetup.coffin = wadSetupSaveData.coffin
    wadSetup.legendaryChest = wadSetupSaveData.legendaryChest
    wadSetup.TripleChestSelected = wadSetupSaveData.TripleChestSelected
  end
  if doReRoll == true then
    for i = 1, #Halls do
      Halls[i].LuaObjectScript.Set_DeadEnd(false)
    end
    if wadSetup.Deadend == true then
      wadSetupSaveData.Deadend = math.random(1, #Halls)
      Halls[wadSetupSaveData.Deadend].LuaObjectScript.Set_DeadEnd(true)
    end
  end
  local enableDebugTrap = LD.GetEntityVariable("Debug_EnableTrapDebug")
  for i = 1, #Halls do
    if enableDebugTrap == false and doReRoll == true then
      LayoutSelection = math.random(1, #LayoutVariantCount - 1)
      VariantSelection = math.random(1, LayoutVariantCount[LayoutSelection])
      Halls[i].LuaObjectScript.Treasure_Disable()
      Halls[i].LuaObjectScript.Hide_DebugChestLocations()
    elseif enableDebugTrap == true then
      LayoutSelection = LD.GetEntityVariable("Debug_Set_TrapLayout")
      VariantSelection = LD.GetEntityVariable("Debug_Set_TrapVariant")
      Halls[i].LuaObjectScript.Set_DeadEnd(wadSetup.Deadend)
    else
      LayoutSelection = wadSetupSaveData.LayoutSelection[i]
      VariantSelection = wadSetupSaveData.VariantSelection[i]
      Halls[i].LuaObjectScript.Set_DeadEnd(wadSetup.Deadend)
    end
    if LayoutSelection then
      wadSetup.LayoutSelection[i] = LayoutSelection
      wadSetupSaveData.LayoutSelection[i] = LayoutSelection
    end
    if VariantSelection then
      wadSetup.VariantSelection[i] = VariantSelection
      wadSetupSaveData.VariantSelection[i] = VariantSelection
    end
    LayoutHall(Halls[i], doReRoll)
    wadSetup.BonusTreasure_Chest[i] = Halls[i].LuaObjectScript.GetTrapHallDebugInfo()
  end
  wadSetup.RepopulateSetup = false
  wadSetupSaveData.RepopulateSetup = wadSetup.RepopulateSetup
  Nid000_Level:CallScript("DeliverWadInfoComplete", wadSetup)
end
function LayoutHall(Hall, doReRoll)
  if LayoutSelection == 1 then
    Hall_Setups = Hall_Layout1_CrusherSetups
  elseif LayoutSelection == 2 then
    Hall_Setups = Hall_Layout1_SawSetups
  elseif LayoutSelection == 3 then
    Hall_Setups = Hall_Layout2_CrusherSetups
  elseif LayoutSelection == 4 then
    Hall_Setups = Hall_Layout2_SawSetups
  elseif LayoutSelection == 5 then
    Hall_Setups = Hall_Layout3_CrusherSetups
  elseif LayoutSelection == 6 then
    Hall_Setups = Hall_Layout3_SawSetups
  elseif LayoutSelection == 7 then
    Hall_Setups = Hall_Layout4_DeadEnds
  end
  if LayoutSelection == 7 then
    for i = 1, #Halls do
      Halls[i].LuaObjectScript.Set_DeadEnd(true)
    end
  end
  if VariantSelection == nil then
    engine.Error(" VariantSelection is nil for " .. tostring(thisLevel.Name))
  end
  if Hall_Setups[VariantSelection] == nil then
    engine.Error(" Hall_Setups[VariantSelection] is nil for " .. tostring(thisLevel.Name))
  end
  Hall.LuaObjectScript.SetupHall(Hall_Setups[VariantSelection], Global_levelVars, doReRoll)
end
function LayoutChests()
  local availablePOSs = {}
  local LocationToUse
  for i = 1, #ChestPOSs do
    table.insert(availablePOSs, ChestPOSs[i])
  end
  for i = 1, 3 do
    chestPosSaveData[i] = {
      pos = nil,
      facing = nil,
      enable = false
    }
  end
  if 0 < #availablePOSs and (guaranteeLegendaryChest or math.random(1, 100) <= Global_levelVars.chance_lootLegendary) or LD.GetEntityVariable("Debug_Set_AlwaysLegend") then
    availablePOSs = ShowChest(LegendaryChest, availablePOSs, "LegendaryChest_Locator", 1)
    wadSetupSaveData.legendaryChest = true
  else
    if LegendaryChest ~= nil then
      LegendaryChest.LuaObjectScript.ForceStateDisabled()
    end
    HideChest(LegendaryChest, 1)
  end
  if 0 < #availablePOSs and math.random(1, 100) <= Global_levelVars.chance_lootCoffin or LD.GetEntityVariable("Debug_Set_AlwaysCoffin") then
    availablePOSs = ShowChest(CoffinChest, availablePOSs, "CoffinChest_Locator", 2)
    wadSetupSaveData.coffin = true
  else
    if CoffinChest ~= nil then
      CoffinChest.LuaObjectScript.ForceStateDisabled()
    end
    HideChest(CoffinChest, 2)
  end
  if 0 < #availablePOSs and math.random(1, 100) <= Global_levelVars.chance_lootChest or LD.GetEntityVariable("Debug_Set_AlwaysCommon") then
    availablePOSs = ShowChest(CommonChest, availablePOSs, "CommonChest_Locator", 3)
    wadSetupSaveData.commonChest = true
  else
    if CommonChest ~= nil then
      CommonChest.LuaObjectScript.ForceStateDisabled()
    end
    HideChest(CommonChest, 3)
  end
end
function HideChest(chest, index)
  if chest == nil then
    return
  end
  chest.LuaObjectScript.HideChest()
  chest.LuaObjectScript.Disable()
  chestPosSaveData[index].pos = nil
  chestPosSaveData[index].facing = nil
  chestPosSaveData[index].enable = false
end
function ShowChest(chest, availablePOSs, locatorName, index)
  if chest == nil or #availablePOSs < 1 then
    return
  end
  local selectNub = math.random(1, #availablePOSs)
  local chestPOS = availablePOSs[selectNub]:FindSingleGOByName(locatorName)
  table.remove(availablePOSs, selectNub)
  chest.LuaObjectScript.ShowChest()
  chest.LuaObjectScript.Enable()
  chest.LuaObjectScript.Reset()
  chest:SetWorldPosition(chestPOS:GetWorldPosition())
  chest:SetWorldFacing(chestPOS:GetWorldForward())
  chestPosSaveData[index].pos = chestPOS:GetWorldPosition()
  chestPosSaveData[index].facing = chestPOS:GetWorldForward()
  chestPosSaveData[index].enable = true
  engine.Print("WadManager @" .. thisLevel.Name .. ": ShowChest " .. locatorName .. " @ " .. tostring(chestPosSaveData[index].pos))
  return availablePOSs
end
function HideChestLocations()
  for i = 1, #ChestPOSs do
    ChestPOSs[i]:Hide()
  end
  for i = 1, #Halls do
    Halls[i].LuaObjectScript.Hide_DebugChestLocations()
  end
end
function ShowChestLocations()
  for i = 1, #ChestPOSs do
    ChestPOSs[i]:Show()
  end
  for i = 1, #Halls do
    Halls[i].LuaObjectScript.Show_DebugChestLocations()
  end
end
function DebugTable(wadName)
  if engine.IsDebug() and thisLevel.Name == wadName then
    local debugTable = {}
    debugTable.Title = thisLevel.Name .. " WadManager"
    debugTable.X = 170
    debugTable.Y = 10
    debugTable.TitleColor = engine.Vector.New(255, 0, 128)
    debugTable[#debugTable + 1] = {
      "CommonChest ",
      CommonChest or "nil"
    }
    debugTable[#debugTable + 1] = {
      "CoffinChest ",
      CoffinChest or "nil"
    }
    debugTable[#debugTable + 1] = {
      "LegendaryChest ",
      LegendaryChest or "nil"
    }
    for i = 1, #ChestPOSs do
      debugTable[#debugTable + 1] = {
        "ChestPOSs " .. tostring(i),
        ChestPOSs[i] or "nil"
      }
    end
    engine.DrawDebugTable(debugTable)
  end
end
function ShowDebugText()
  if engine.IsDebug() then
    local debugText = ""
    for i = 1, #ChestPOSs do
      debugText = debugText .. [[

 ChestPOSs: ]]
      debugText = debugText .. "\n" .. ChestPOSs[i]
    end
    if chestPosSaveData then
      debugText = debugText .. [[

 chestPosSaveData: ]]
      for i = 1, 3 do
        debugText = debugText .. "\n" .. chestPosSaveData[i].pos
        debugText = debugText .. "\n" .. chestPosSaveData[i].facing
        debugText = debugText .. "\n" .. chestPosSaveData[i].enable
      end
    end
    engine.DrawTextInWorld(thisObj:GetWorldPosition() + engine.Vector.New(0, 2, 0), debugText, color.green)
  end
end
function Debug_TripleChestText()
  TripleChests[wadSetupSaveData.TripleChestSelected].LuaObjectScript.Debug_DrawTargetLocators()
end
function Debug_TrapHallInfo()
  if LD.GetEntityVariable("Debug_ShowTrapHall_Text") == true then
    for i = 1, #Halls do
      Halls[i].LuaObjectScript.DebugTrapHallText()
    end
  end
end
