local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, HazardAnimation
local SpeedInSeconds = 6
local sawObj
local LongDistance = true
local GO_CombatCollision
function OnScriptLoaded(level, obj)
  thisObj = obj
  sawObj = thisObj:FindSingleGOByName("sawBlade00").Child
  GO_CombatCollision = thisObj:FindSingleGOByName("CombatCollision")
  HazardAnimation = thisObj:FindSingleGOByName("anim_Hazard_GroundSaw")
  SpeedInSeconds = SpeedInSeconds * 30 / 180
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  thisObj:SetInhibitSave()
end
function OnStart(level, obj)
  sawObj:PlayAnimationCycle({
    Animation = "bladeRotate",
    Rate = 1
  })
  GO_CombatCollision.LuaObjectScript.Enable()
  SoundOnStart()
end
function OnUpdate(level, obj)
  print(SpeedInSeconds)
end
function Enable(InitialFrame, Delay)
  HazardAnimation:PauseAnim()
  HazardAnimation:JumpAnimToFrame(InitialFrame)
  timers.StartLevelTimer(Delay, function()
    HazardAnimation:PlayAnimOscillate(SpeedInSeconds)
  end)
  timers.StartLevelTimer(Delay, function()
    sawObj:PlayAnimationCycle({
      Animation = "bladeRotate",
      Rate = 1
    })
    GO_CombatCollision.LuaObjectScript.Enable()
    PlayBladeSound()
  end)
end
function Disable()
  HazardAnimation:PauseAnim()
end
local soundEmitter
local soundEvents = {SNDBlades = nil}
function SoundOnStart()
  soundEmitter = thisObj:FindSingleGOByName("anim_Hazard_GroundSaw"):FindSingleSoundEmitterByName("SNDSawBlade")
  soundEvents.SNDBlades = "SND_TRAP_Saw_Blades_LP"
end
function PlayBladeSound()
  LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.SNDBlades)
end
function StopBladeSound()
  LD.StopRestartableSoundLoop(soundEmitter, soundEvents.SNDBlades)
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = sounds.SoundEmitter
    end
    for key, value in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(value))
    end
  end
end
