local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local thisObj, isRift
local ResourceGate_Opened = false
local ResourceGate_LockedObj, ResourceGate_Cost
local ResourceKey_Cost = -1
local ResourceGate_ChestVFX
local displayMistCounter = false
local displayMistCounter_Dec = 13
local ButtonMonitor_Accept, ButtonMonitor_Cancel
local currencyCountUI = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  ResourceGate_LockedObj = level:GetGameObject(tostring(obj:GetLuaTableAttribute("LockedObject")))
  ResourceGate_Cost = obj:GetLuaTableAttribute("ResourceCost")
  ResourceGate_ChestVFX = obj:FindSingleGOByName("ChestHightligh_VFX")
  isRift = obj:GetLuaTableAttribute("isRift")
  if isRift == true then
    ResourceKey_Cost = 1
  end
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if ResourceGate_Opened == false then
    if ResourceGate_LockedObj.LuaObjectScript.IsOpen() then
      ResourceGate_Opened = true
    elseif isRift == false then
      ResourceGate_LockedObj.LuaObjectScript.LockChest()
    else
      ResourceGate_LockedObj.LuaObjectScript.Enable()
      ResourceGate_LockedObj.LuaObjectScript.Lock()
    end
  end
  ResourceGate_LockedObj.LuaObjectScript.RegisterOnInteractStartCallback(OnOpenStart)
  thisObj:SetWorldPosition(ResourceGate_LockedObj:GetWorldPosition())
  thisObj:SetWorldFacing(ResourceGate_LockedObj:GetWorldForward())
  ResourceGate_ChestVFX:SetWorldPosition(ResourceGate_LockedObj:GetWorldPosition())
  ResourceGate_ChestVFX:SetWorldFacing(ResourceGate_LockedObj:GetWorldForward())
  SetupChest()
end
function OnUpdate(level, obj)
  if displayMistCounter == true then
    local currencyCountActual = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
    if currencyCountActual < currencyCountUI then
      currencyCountUI = currencyCountUI - displayMistCounter_Dec
      if currencyCountActual >= currencyCountUI then
        currencyCountUI = currencyCountActual
      end
      TUT.Nif_ResourceGate_Notification(isRift, ResourceGate_Cost, currencyCountUI, game.Wallets.GetResourceValue("HERO", "NiflheimTearKey"))
    else
      displayMistCounter = false
      uiCalls.DisableMechanicText()
      game.SubObject.Sleep(thisObj)
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {ResourceGate_Opened = ResourceGate_Opened}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  ResourceGate_Opened = savedInfo.ResourceGate_Opened
end
function SetupChest()
  if ResourceGate_Opened == false then
    local currentResourceCount = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
    local currentTearKeyCount = game.Wallets.GetResourceValue("HERO", "NiflheimTearKey")
    if currentResourceCount < ResourceGate_Cost or currentTearKeyCount < ResourceKey_Cost then
      if isRift == false then
        ResourceGate_LockedObj.LuaObjectScript.LockChest()
      else
        ResourceGate_LockedObj.LuaObjectScript.Enable()
        ResourceGate_LockedObj.LuaObjectScript.Lock()
      end
    elseif isRift == false then
      ResourceGate_LockedObj.LuaObjectScript.UnlockChest()
      local ChestVFX = ResourceGate_LockedObj:FindSingleGOByName("AmbientFX").Child
      LD.ShowFX(ChestVFX)
    else
      ResourceGate_LockedObj.LuaObjectScript.Unlock()
    end
  end
end
function Begin_CostDisplay()
  if ResourceGate_Opened == false and not game.Combat.GetCombatStatus() then
    TUT.Nif_ResourceGate_Notification(isRift, ResourceGate_Cost, game.Wallets.GetResourceValue("HERO", "NiflheimCurrency"), game.Wallets.GetResourceValue("HERO", "NiflheimTearKey"))
  end
end
function End_CostDisplay()
  uiCalls.DisableMechanicText()
end
function OnAccept()
  displayMistCounter = false
  uiCalls.DisableMechanicText()
  ResourceGate_ChestVFX:Hide()
end
function OnOpenStart()
  if ResourceGate_Opened == false then
    ResourceGate_Opened = true
    displayMistCounter = true
    currencyCountUI = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
    LD.ConsumeNiflheimCurrency(ResourceGate_Cost)
    if isRift then
      displayMistCounter_Dec = math.floor(ResourceGate_Cost / 30)
      game.Wallets.RemoveResource("HERO", "NiflheimTearKey", 1)
      LD.CallFunctionAfterDelay(Update_CostDisplay, 0.1)
      game.World.StoreCheckpoint()
    else
      displayMistCounter_Dec = math.floor(ResourceGate_Cost / 60)
      local ChestVFX = ResourceGate_LockedObj:FindSingleGOByName("AmbientFX").Child
      timers.StartLevelTimer(1, function()
        LD.HideFX(ChestVFX)
      end)
      LD.CallFunctionAfterDelay(Update_CostDisplay, 1)
    end
  end
end
function Update_CostDisplay()
  game.SubObject.Wake(thisObj)
end
