local LD = require("design.LevelDesignLibrary")
local thisLevel, SelectedAISet
local AISets = {
  "AI_1111",
  "AI_1121",
  "AI_1131",
  "AI_1211",
  "AI_1221",
  "AI_1231",
  "AI_1311",
  "AI_1321",
  "AI_1331",
  "AI_2111",
  "AI_2121",
  "AI_2131",
  "AI_2211",
  "AI_2221",
  "AI_2231",
  "AI_2311",
  "AI_2321",
  "AI_2331",
  "AI_3111",
  "AI_3121",
  "AI_3131",
  "AI_3211",
  "AI_3221",
  "AI_3231",
  "AI_3311",
  "AI_3321",
  "AI_3331",
  "AI_1112",
  "AI_1122",
  "AI_1132",
  "AI_1212",
  "AI_1222",
  "AI_1232",
  "AI_1312",
  "AI_1322",
  "AI_1332",
  "AI_2112",
  "AI_2122",
  "AI_2132",
  "AI_2212",
  "AI_2222",
  "AI_2232",
  "AI_2312",
  "AI_2322",
  "AI_2332",
  "AI_3112",
  "AI_3122",
  "AI_3132",
  "AI_3212",
  "AI_3222",
  "AI_3232",
  "AI_3312",
  "AI_3322",
  "AI_3332",
  "AI_1123",
  "AI_1133",
  "AI_1213",
  "AI_1223",
  "AI_1233",
  "AI_1313",
  "AI_1323",
  "AI_1333",
  "AI_2123",
  "AI_2133",
  "AI_2213",
  "AI_2223",
  "AI_2233",
  "AI_2313",
  "AI_2323",
  "AI_2333",
  "AI_3123",
  "AI_3133",
  "AI_3213",
  "AI_3223",
  "AI_3233",
  "AI_3313",
  "AI_3323",
  "AI_3333"
}
local tripleChestRuneNumbers = {
  {
    chest = {
      3,
      21,
      34
    },
    flipper1 = {
      1,
      3,
      4
    },
    flipper2 = {
      24,
      21,
      20
    },
    flipper3 = {
      27,
      36,
      34
    }
  },
  {
    chest = {
      38,
      17,
      4
    },
    flipper1 = {
      2,
      20,
      38
    },
    flipper2 = {
      3,
      18,
      17
    },
    flipper3 = {
      37,
      4,
      19
    }
  },
  {
    chest = {
      7,
      11,
      28
    },
    flipper1 = {
      10,
      7,
      27
    },
    flipper2 = {
      25,
      11,
      5
    },
    flipper3 = {
      9,
      28,
      6
    }
  },
  {
    chest = {
      13,
      36,
      25
    },
    flipper1 = {
      37,
      13,
      15
    },
    flipper2 = {
      12,
      27,
      36
    },
    flipper3 = {
      15,
      34,
      25
    }
  },
  {
    chest = {
      33,
      37,
      9
    },
    flipper1 = {
      11,
      34,
      33
    },
    flipper2 = {
      6,
      9,
      37
    },
    flipper3 = {
      12,
      9,
      35
    }
  },
  {
    chest = {
      21,
      19,
      28
    },
    flipper1 = {
      26,
      21,
      17
    },
    flipper2 = {
      22,
      19,
      23
    },
    flipper3 = {
      9,
      26,
      28
    }
  }
}
local tripleChestSetup = {
  chest = nil,
  flippers = {},
  flipperAnims = {}
}
local Flipper1_POS = {}
local Flipper2_POS = {}
local Flipper3_POS = {}
function OnScriptLoaded(level)
  thisLevel = level
  tripleChestSetup.chest = GameObjects.memory_tripleChest
  for i = 1, 3 do
    tripleChestSetup.flippers[i] = GameObjects["BrokenStack_SpinBase" .. tostring(i)]
    tripleChestSetup.flipperAnims[i] = GameObjects["Flipper" .. tostring(i)]
    tripleChestSetup.flippers[i].LuaObjectScript.StoreFlipperObj(GameObjects["BrokenStack_Spinner" .. tostring(i)]:FindSingleGOByName("FlipperModule"))
  end
  SoundInit()
end
function OnPreStart(level)
  local chestGuts = GameObjects.memory_tripleChest:FindSingleGOByName("ChestScript_RN")
  chestGuts.LuaObjectScript.DisableCheckpointRequirement()
end
function OnStart(level)
  SoundOverrides()
  Randomize_MemoryChestRunes(level, false)
end
function Randomize_MemoryChestRunes(level, isReRoll)
  if isReRoll then
    local randomSelect = math.random(1, #tripleChestRuneNumbers)
    for index = 1, 3 do
      tripleChestSetup.chest.LuaObjectScript.OverrideRuneNumber(index, tripleChestRuneNumbers[randomSelect].chest[index])
      tripleChestSetup.flippers[index].LuaObjectScript.ResetRotateCW()
      tripleChestSetup.flippers[index].LuaObjectScript.OverrideRuneNumber(1, tripleChestRuneNumbers[randomSelect]["flipper" .. tostring(index)][1])
      tripleChestSetup.flippers[index].LuaObjectScript.OverrideRuneNumber(2, tripleChestRuneNumbers[randomSelect]["flipper" .. tostring(index)][2])
      tripleChestSetup.flippers[index].LuaObjectScript.OverrideRuneNumber(3, tripleChestRuneNumbers[randomSelect]["flipper" .. tostring(index)][3])
      tripleChestSetup.flippers[index].LuaObjectScript.RotateCW()
      tripleChestSetup.flippers[index].LuaObjectScript.RotateCCW()
      local randomInt = math.random(1, 5)
      tripleChestSetup.flipperAnims[index]:SetWorldPosition(thisLevel:GetGameObject("Flipper" .. tostring(index) .. "_POS_0" .. tostring(randomInt)):GetWorldPosition())
      tripleChestSetup.flipperAnims[index]:SetWorldFacing(thisLevel:GetGameObject("Flipper" .. tostring(index) .. "_POS_0" .. tostring(randomInt)):GetWorldForward())
    end
    Show_MemoryChestRunes()
  else
    Hide_MemoryChestRunes()
  end
end
function Hide_MemoryChestRunes()
  tripleChestSetup.chest.LuaObjectScript.ForceStateDisabled()
  tripleChestSetup.chest.LuaObjectScript.HideChest()
  tripleChestSetup.chest.LuaObjectScript.Disable()
  for index = 1, 3 do
    tripleChestSetup.flipperAnims[index]:JumpAnimToPercent(1)
  end
end
function Show_MemoryChestRunes()
  tripleChestSetup.chest.LuaObjectScript.ShowChest()
  tripleChestSetup.chest.LuaObjectScript.Enable()
  tripleChestSetup.chest.LuaObjectScript.Reset()
  for index = 1, 3 do
    tripleChestSetup.flipperAnims[index]:JumpAnimToPercent(0)
    tripleChestSetup.flipperAnims[index]:PauseAnim()
    tripleChestSetup.flippers[index].LuaObjectScript.ResetRotateCW()
  end
end
function SetMemoryChestAvaiable_False()
  LD.SetEntityVariable("NIF_MemoryChestAvaiable", false)
end
function OnEvaluateLoadGroup_LoadGroup_MazeAI()
  SelectedAISet = game.Level.GetVariable("NIF_SelectedAIMix")
  return tostring(AISets[SelectedAISet])
end
function openDoor()
  GameObjects.EntranceDoor:PlayAnimationToEnd()
  DoorOpenSound()
  Banter_UseKey()
  CompleteNif01Quest()
  game.Audio.StartMusic("SND_MX_NIF_unlock_central_arena")
  GameObjects.KeyLock.LuaObjectScript.FinishPedestalInteraction()
end
function CompleteNif01Quest()
  LD.CompleteQuest("Quest_Sindri_Niflheim_Objective01")
  LD.ActivateQuest("Quest_NiflheimArmorChest_Parent")
end
function Banter_GateApproach()
  game.Audio.PlayBanter("Nifl_MazeEntrance_GateApproach", Banter_GateQuest)
end
function Banter_GateQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Niflheim_Objective01a")
  if questState == "Inactive" then
    game.Audio.PlayBanter("Nifl_MazeEntrance_EnoughMist")
  end
end
function Banter_BackInTheMaze()
  local KeyStoneCount = game.Wallets.GetResourceValue("HERO", "EntryStoneNiflheim")
  if KeyStoneCount == 1 then
    game.Audio.PlayBanter("Nifl_BackInTheMaze")
    GameObjects.Banter_MazeReturn:HideEntityVolume()
  end
end
function Banter_UseKey()
  game.Audio.PlayBanter("Nifl_BackInTheMaze_UseKey")
end
function Banter_TheCenterChamber()
  game.Audio.PlayBanter("Nifl_TheCenterChamber")
end
function LoadCheck_100()
  game.UI.LoadCheck("Nid200_SWHallway", "Nid260_SEHallway")
end
function LoadCheck_300()
  game.UI.LoadCheck("Nid300_WRoom", "Nid220_NWHallway", "Nid200_SWHallway")
end
function LoadCheck_310()
  game.UI.LoadCheck("Nid310_NWRoom")
end
function LoadCheck_320()
  game.UI.LoadCheck("Nid320_NRoom", "Nid220_NWHallway", "Nid240_NEHallway")
end
function LoadCheck_330()
  game.UI.LoadCheck("Nid330_NERoom")
end
function LoadCheck_340()
  game.UI.LoadCheck("Nid340_ERoom", "Nid240_NEHallway", "Nid260_SEHallway")
end
local doorEmitter
local soundEvents = {
  soundPedestal = "SND_DOOR_Gate_Entrance_Nidavellir_Unlock"
}
function SoundInit()
  doorEmitter = GameObjects.EntranceDoor:FindSingleSoundEmitterByName("SNDEntranceDoor")
end
function SoundOverrides()
  GameObjects.KeyLock.LuaObjectScript.SoundSetup(soundEvents)
end
function DoorOpenSound()
  LD.PlaySound(doorEmitter, "SND_DOOR_Gate_Entrance_Nidavellir_Open")
end
