local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local player
local ArrivalQuestSetup = false
local FirstMist_BanterPlayed = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
end
function OnFirstStart(level)
end
function OnPreStart(level)
  GameObjects.coffin_tier1_nid150_2.LuaObjectScript.DisableCheckpointRequirement()
  GameObjects.chest_common_tier1_nid150_1.LuaObjectScript.DisableCheckpointRequirement()
  GameObjects.chest_common_tier1_nid150_2.LuaObjectScript.DisableCheckpointRequirement()
  GameObjects.chest_common_tier1_nid150_3.LuaObjectScript.DisableCheckpointRequirement()
  GameObjects.chest_common_tier1_nid150_4.LuaObjectScript.DisableCheckpointRequirement()
end
function OnStart(level)
  GameObjects.Banter_FirstCurse:HideEntityVolume()
  AddNiflheimRecipes()
  NifPatchFixup()
end
function NifPatchFixup()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Niflheim_Objective01")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneNiflheim")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneNiflheim", 1)
  end
  local rustedArmor = game.Wallets.GetResourceValue("HERO", "NifTankArmor_Chest_Pattern")
  local armorQuestState = game.QuestManager.GetQuestState("Quest_NiflheimArmorChest_01")
  if rustedArmor ~= -1 and armorQuestState == "Active" then
    LD.CompleteQuest("Quest_NiflheimArmorChest_01")
  end
end
function EnableBlight()
  if LD.GetEntityVariable("Debug_Disable_CurseFog") == false then
    player:CallScript("LuaHook_NiflheimBlightStart")
    uiCalls.EnableMechanicMeter("NiflheimBlightProtection", true)
    game.Compass.SetDesignerForcedHide(true)
  end
end
function DisableBlight()
  if LD.GetEntityVariable("Debug_Disable_CurseFog") == false then
    player:CallScript("LuaHook_NiflheimBlightEnd")
    uiCalls.DisableMechanicMeter()
    game.Compass.SetDesignerForcedHide(false)
    if player:IsDead() == false and player:IsDying() == false then
      player:MeterSetValue("Health", player:MeterGetMax("Health"))
    end
  end
end
function Banter_Arrival()
  game.Audio.PlayBanter("Nifl_EnterNifl", Enable_Banter_FirstCurse)
end
function Enable_Banter_FirstCurse()
  GameObjects.Banter_FirstCurse:ShowEntityVolume()
end
function Banter_FirstCurse()
  game.Audio.PlayBanter("Nifl_FirstCurse")
end
function Banter_FirstCurse_Remind()
  game.Audio.PlayBanter("Nifl_FirstCurse_Remind")
end
function Banter_FirstMistPickup()
  if FirstMist_BanterPlayed == false then
    FirstMist_BanterPlayed = true
    game.Audio.PlayBanterNonCritical("Nifl_FirstMistPickup")
  end
end
function Banter_FirstLoreMarker()
  game.Audio.PlayBanter("Nifl_FirstLoreMarker")
end
function Banter_CurseParticulars()
end
function DEBUG_TEXT_BOX_INT_40199()
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function AddNiflheimRecipes()
  if game.Wallets.HasResource("HERO", "NifRecipes") == false then
    game.Wallets.AddResource("HERO", "NifRecipes", 1)
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_NifTankSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_NifSpeedSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_NifDamageSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_NifTankSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_NifSpeedSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_NifDamageSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_NifTankSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_NifSpeedSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_NifDamageSet_Tier06")
    game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_NifleheimSpecial02")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_Niflheim")
    game.Wallets.AddRecipe("HERO", "Recipe_RuneCreator_RandomNif")
    if game.GetNewGamePlus() then
      game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_Niflheim_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_NifleheimSpecial02_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_NifTankSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_NifSpeedSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorChest_NifDamageSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_NifTankSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_NifSpeedSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorWrist_NifDamageSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_NifTankSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_NifSpeedSet_Tier06_NGP")
      game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorLegs_NifDamageSet_Tier06_NGP")
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    ArrivalQuestSetup = ArrivalQuestSetup,
    FirstMist_BanterPlayed = FirstMist_BanterPlayed
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  ArrivalQuestSetup = savedInfo.ArrivalQuestSetup
  FirstMist_BanterPlayed = savedInfo.FirstMist_BanterPlayed
end
